# IM360Viewer

## Description
   The IM360Viewer component allows you to create a 360 view with images on canvas.
   
## View Code
 
```html
<im-360-viewer class="view-360"
               config="{{ viewer.config }}"
               markers="{{dependencies.flagPositionConfig}}"
               data-model="viewer.id"
               im-class="visible: {{selectedModel}} === {{viewer.id}}">
</im-360-viewer>
```

## Attributes

The component needs different attributes to work correctly.

```json
{
    "viewer": {
        "id": "model",
        "config": {
            "flagConfigId": "model",
            "startImage": 12,
            "base": "assets/content/sites/L02/L02_01/02_01_s02/images/previousModel/",
            "count": 50,
            "extension": "jpg"
        }
    }
}
```

### id `string`

Unique `string` as ID.

### config `object`

JSON object for further properties:
 
#### flagConfigId `string`
Text ID for the flags information.

#### startImage `integer`
This attribute sets the start image.

#### base `string | URL`
Base contains the base URL of the images without data type ending. 

#### count `integer`
The count attribute sets the amount of images. 

#### extension `string`
The config.extension passes the data type ending. 
