# IMExerciseVideoPlayer

## Description
   The IMExerciseVideoPlayer component controls the video in combination with views.

## View Code
 
```html
<im-exercise-video-player auto-reset="false"
                          loop="true"
                          source="{{ videoPath }}"
                          controls="none">
</im-exercise-video-player>
```

## Attributes
The component needs different attributes and a cuepoints json file to work correctly. The cuepoints file should be a dependency of the containing site:

### config.json
```json
{
  "dependencies": [{
    "id": "cuepoints",
    "type": "json",
    "url": "{CONTENT_PATH}/cuepoints.json"
  }],
  "properties": {
    "videoPath": "assets/content/sites/L01/L01_02/01_02_s01/video/video.mp4",
    "showAnnotation": true
  }
}
```

### cuepoints.json
```json
[
  {
    "time": 2,
    "siteID": "01_02_s01_exercise_01"
  },
  {
    "time": 4,
    "siteID": "01_02_s01_exercise_02"
  },
  {
    "time": 6,
    "siteID": "01_02_s01_exercise_03"
  },
  {
    "time": 8,
    "siteID": "01_02_s01_exercise_04"
  },
  {
    "time": 10,
    "siteID": "01_02_s01_exercise_05"
  }
]
```

## cue points


#### time ` integer `
Time in second for stop the video and load the exercise view.

#### siteID ` string `
SiteID which would load on receive the cue point. 


