# FoxyText

## Description
   The FoxyText Component allows you to show XML loaded texts on HTML content,
   
   The text must be inserted in an XLIFF file in the language path of the project 
   "dev/language/`countrycode`", e.g. "dev/language/en" (country codes and language adaption are explained in the 
   Language Explanation Documentation).

```xml
<?xml version="1.0" encoding="utf-8"?>
 <xliff version="1.2">
   <file datatype="plaintext" original="01_01_s01" source-language="de">
     <header/>
     <body>
       <trans-unit id="content_text" resname="content_text">
         <source>This is an example</source>
       </trans-unit>
     </body>
   </file>
 </xliff>
```

## View Code
 
```html
   <foxy-text text-id="content_text" collection-id="01_01_s01"></foxy-text>
```

## Attributes
The component needs two attributes to work correctly.

#### text-id

The "text-id" attribute describes the transunit-id which is already defined in the XLIFF file.
 
#### collection-id

The "collection-id" attribute corresponds to the `original` property in the XLIFF file.
