# IMSlider

## Description
   The IMSlider Component allows you to control range of data. The code archicture contain different elements for sliding and also a evaluation dragger for exercises.
   The Slider-Scale-Line has also two elements for drag and for the correct value. 
## Template.Code
 
```html
   <template id="im-slider">
     <div class="im-slider-scala">
       <div class="im-slider-scala-main">
         <div im-loop="{{ scalaMarker }}" as="marker" class="im-slider-scala-marker" im-style="left: {# marker.left #}" im-class="{# marker.type #}"></div>
   
         <span im-loop="{{ scalaLabels }}" as="label" class="im-slider-scala-label" im-style="left: {# label.left #}">{# label.text #}</span>
   
         <a class="im-slider-dragger" im-style="left: {{ currentPosition }}" im-class="evaluated: {{ evaluated }}" touch-action="none">{{ currentPrintedValue }}</a>
         <a class="im-slider-dragger correct"  im-style="left: {{ correctPosition }}" visible="{{ evaluated }}">{{ correctPrintedValue }}</a>
   
         <span class="im-slider-scala-line" im-class="evaluated: {{ evaluated }}" im-style="width: {{ currentPosition }}"></span>
         <span class="im-slider-scala-line correct" im-style="width: {{ correctPosition }}" visible="{{ evaluated }}"></span>
       </div>
       <foxy-text class="unit" text-id="{# config.unit.textId #}" collection-id="{# config.unit.collectionId #}"></foxy-text>
     </div>
   </template>
```

## View.Code
 
```html
   <im-slider class="slider" config="{# slider #}"></im-slider>
```

## Attributes
The component needs different attributes to work correctly.

```json
{
"slider": {
      "steps": {
        "range": [0, 49],
        "step_size": 49,
        "value_step_size": 49
      },
      "values": {
        "correct": 50,
        "preset": 20,
        "tolerance": false
      }
    }
}
```

#### slider.steps

The attribute steps contain the range of the slider as an array with the first and last value on the scale.

#### range ``` array | integer ```

range contains the min and max steps of the slider.
 
#### step_size ``` integer ```

step_size describe the steps points on the slider.

#### value_step_size ``` integer ```

This attribute set the correct value on the scale-slider which is only important in exercises.

#### slider.values 

#### present ``` integer ```

Present contain the start point of the im-slider-dragger.

#### correct ``` integer ```

Correct is the value for the evaluation in exercises. (optional)

#### tolerance ``` boolean ```

With tolerance extend the correct value with +1 or -1. (optional)
