# IMExerciseVideoPlayer

## Description
   The IMExerciseVideoPlayer component controls the video in combination with views.
   
## Template Code
 
```html
<template id="im-dot-pagination">
  <a class="pagination-dot" im-loop="{{ source }}" as="dot" data-index="{# dot.index #}" im-class="active: {{ dot.active }}" on-pointerup="onPaginationDot()"></a>
</template>
```

## View Code
 
```html
<im-exercise-video-player auto-reset="false" loop="true" source="{{ videoPath }}" controls="none"></im-exercise-video-player>
```

## Attributes
The component needs different attributes and two json files to work correctly.

``` config.json
{
  "dependencies": [{
    "id": "cuepoints",
    "type": "json",
    "url": "{CONTENT_PATH}/cuepoints.json"
  }],
  "properties": {
    "videoPath": "assets/content/sites/L01/L01_02/01_02_s01/video/video.mp4",
    "showAnnotation": true
  }
}
```

#### ID ` string `
Cuepoints ` string ` as ID.

#### type ` string `
Type of the data, in this case ` json `.
 
#### url ` string `
URL contains the path with data type ending.


``` cuepoints.json
[
  {
    "time": 2,
    "siteID": "01_02_s01_exercise_01"
  },
  {
    "time": 4,
    "siteID": "01_02_s01_exercise_02"
  },
  {
    "time": 6,
    "siteID": "01_02_s01_exercise_03"
  },
  {
    "time": 8,
    "siteID": "01_02_s01_exercise_04"
  },
  {
    "time": 10,
    "siteID": "01_02_s01_exercise_05"
  }
]

```

## cue points
The component needs different attributes and two json files to work correctly.

#### time ` integer `
Time in second for stop the video and load the exercise view.

#### siteID ` string `
SiteID which would load on receive the cue point. 


