# FoxyText

## Description
   The FoxyText Component allows you to show XML loaded texts on HTML Content
   
   The Text must be inserted in an XLIFF File in the Language Path of the project 
   "dev/language/`countrycode`", e.g. "dev/language/en" (countrycodes and Language Adaption are explained in the 
   Language Explanation Documentation).

```xml
<?xml version="1.0" encoding="utf-8"?>
 <xliff version="1.2">
   <file datatype="plaintext" original="01_01_s01" source-language="de">
     <header/>
     <body>
       <trans-unit id="content-text" resname="content-text">
         <source>This is an example</source>
       </trans-unit>
     </body>
   </file>
 </xliff>
```
## Code
 
```html
   <foxy-text text-id="content-text" collection-id="xml_name"></foxy-text>
```

## Attributes
The Component needs two Attributes to work Correctly.

#### text-id

The "text-id" attribute describes the transunit-id which is allready defined in the XLIFF File.
 
#### collection-id

The "collection-id" attribute describes the filename of the XLIFF File.
