# IMCover

## Description
   The IMCover Component allows you to cover up the [IMExerciseVideoPlayer](components/im-exercise-video-player.md) and starts the exercise video. 
   The most impportant thing is that the cover image have the exact same size as the first video frame.
## Template.Code
 
```html
   <template id="im-cover">
       <div class="cover-image left" im-style="background-image: url({{ leftImage }})"></div>
       <div class="cover-image right" im-style="background-image: url({{ rightImage }})"></div>
       <div class="cover-fade-image" im-class="blur-effect: !!{{blurEffect}}" im-style="background-image: url({{ fadeImage }})"></div>
   
       <a class="ci-button shadow-box button-icon icon-large icon-audi-system-play-large round js-response play-button"></a>
   </template>
```

## View.Code
 
```html
   <im-cover on-open="startVideo()" left-image="{# dependencies.cover.src #}">
     <div class="exercise-text-container full-height">
       <div class="container full-height">
         <div class="row row-padding full-height">
           <div class="gr-4 gr-4@mobile full-height">
             <div class="scroll-container">
               <div class="scroll-wrapper">
                 <foxy-text class="h3 headline" text-id="{# siteID #}" collection-id="headlines"></foxy-text>
                 <foxy-text class="content-text" text-id="content_text" collection-id="{# siteID #}"></foxy-text>
               </div>
             </div>
           </div>
         </div>
       </div>
     </div>
     <button class="ci-button primary js-response next-button" on-pointerup="open()">
       <foxy-text class="content-text" text-id="btnStart" collection-id="globalTexts"></foxy-text>
     </button>
   </im-cover>
```

## Attributes
The component needs 3 attributes in the dependencies to work correctly.

```json
{
"dependencies": [{
    "id": "cover",
    "type": "jpeg",
    "url": "{CONTENT_PATH}/images/cover.jpg"
  }]
}
```

#### ID ``` string ```

Contain the string "cover"

#### type ``` string ```

Type of the data.
 
#### url ``` string ```

URL contains of the image with data type ending.

