# IMDotPagination

## Description
   The IMDotPagination Component allows you to create a 360 view with images on canvas.
   
## Template Code
 
```html
<template id="im-exercise-video-player">
    <div class="im-video-player--wrapper">
        <div class="im-video-player--container">
            <video playsinline>
                <source type="video/mp4"></source>
            </video>
        </div>
        <im-video-controls config="{{ controls }}" im-class="fade-out: {{ isExerciseActive }}"></im-video-controls>
    </div>
</template>
```

## View Code
 
```html
<im-exercise-video-player auto-reset="false" loop="true" source="{{ videoPath }}" controls="none"></im-exercise-video-player>
```

## Attributes
The component needs different attributes and two json files to work correctly.

``` config.json
{
  "dependencies": [{
    "id": "cuepoints",
    "type": "json",
    "url": "{CONTENT_PATH}/cuepoints.json"
  }],
  "properties": {
    "videoPath": "assets/content/sites/L01/L01_02/01_02_s01/video/video.mp4",
    "showAnnotation": true
  }
}
```

#### ID ` string `
Cuepoints ` string ` as ID.

#### type ` string `
Type of the data, in this case ` json `.
 
#### url ` string `
URL contains of the image with data type ending.


``` cuepoints.json
[
  {
    "time": 2,
    "siteID": "01_02_s01_exercise_01"
  },
  {
    "time": 4,
    "siteID": "01_02_s01_exercise_02"
  },
  {
    "time": 6,
    "siteID": "01_02_s01_exercise_03"
  },
  {
    "time": 8,
    "siteID": "01_02_s01_exercise_04"
  },
  {
    "time": 10,
    "siteID": "01_02_s01_exercise_05"
  }
]

```

## cue points
The component needs different attributes and two json files to work correctly.

#### time ` integer `
Time in second for stop the video and load the exercise view.

#### siteID ` string `
SiteID which would load on receive the cue point. 


