# IM360Viewer

## Description
   The IM360Viewer Component allows you to create a 360 view with images on canvas.
   
## Template Code
 
```html
    <template id="im-360-viewer">
        <canvas touch-action="none"></canvas>
    </template>
```

## View Code
 
```html
    <im-360-viewer class="view-360" config="{{ viewer.config }}"
                    markers="{{dependencies.flagPositionConfig}}"
                    data-model="viewer.id"
                    im-class="visible: {{selectedModel}} === {{viewer.id}}">
    </im-360-viewer>

```

## Attributes
The component needs different attributes to work correctly.

```json
{
    "viewer": {
        "id": "model",
        "config": {
            "flagConfigId": "model",
            "startImage": 12,
            "base": "assets/content/sites/L02/L02_01/02_01_s02/images/previousModel/",
            "count": 50,
            "extension": "jpg"
        }
    }
}

```

#### ID ``` string ```

Unique ``` string ``` as ID.
 
#### config.flagConfigId ``` string ```
Text ID for the flags information.

#### config.startImage ``` integer ``` 
This attribute set the start image showing first onLoad the page.

#### config.base ``` string | URL ``` 
Base contains the base URL of the images without data type ending. 

#### config.count ``` integer ```
The count attribute set the max number of the images. 

#### config.extension ``` string ```
The config.extension passes the data type ending. 

