# IMSlider

## Description
   The IMSlider component allows you to control range of values. The code architecture contains different elements for sliding and also an evaluation dragger for exercises.

## View.Code
 
```html
   <im-slider class="slider" config="{# slider #}"></im-slider>
```

## Attributes
The component needs different attributes to work correctly.

```json
{
"slider": {
      "steps": {
        "range": [0, 49],
        "step_size": 49,
        "value_step_size": 49
      },
      "values": {
        "correct": 50,
        "preset": 20,
        "tolerance": false
      }
    }
}
```

### slider.steps

The attribute steps contain the range of the slider as an array with the first and last value on the scale.

#### range `array | integer`

range contains the min and max steps of the slider.
 
#### step_size `integer`

step_size describes the steps points on the slider.

#### value_step_size `integer`

This attribute sets the correct value on the scale-slider which is only important in exercises.

### slider.values

#### preset `integer`

preset contains the start point of the im-slider-dragger.

#### correct `integer`

correct is the value for the evaluation in exercises. (optional)

#### tolerance `boolean | integer`

tolerance defines how far from the correct value the slider will be evaluated as correct. When this is set to `true` the tolerance is 1. (optional)
