/*!
 * 
 *      * @audi-ci/ci-2017-node18 - Audi WBT CI based on Audi Corporate Identity 2017
 *      * @version v1.4.4
 *      * @license MIT
 *      * @copyright 2023 Sascha Kurth <s.kurth@innovationmecom.de>
 *      * @link http://www.innovationmecom.de
 *
 *
 */
(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define("audi-ci", [], factory);
	else if(typeof exports === 'object')
		exports["audi-ci"] = factory();
	else
		root["audi-ci"] = factory();
})(self, () => {
return /******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./source/checkbox/checkbox.js":
/*!*************************************!*\
  !*** ./source/checkbox/checkbox.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Checkbox)
/* harmony export */ });
/* harmony import */ var _component_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../component/component */ "./source/component/component.js");
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var NAMESPACE = 'ciCheckbox';
var SELECTOR_COMPONENT = '.ci-js-checkbox';
var CLASS_INPUT = 'ci-checkbox-input';
var CLASS_LABEL = 'ci-checkbox-label';
var CLASS_BOX = 'ci-checkbox-box';
var CLASS_TICK = 'ci-checkbox-tick';
var CLASS_IS_FOCUS = 'is-focused';
var CLASS_IS_CHECKED = 'is-checked';
var CLASS_IS_DISABLED = 'is-disabled';
var _chechboxes = [];

/**
 * Class constructor for Checkbox AUI component.
 * Implements AUI component design pattern defined at:
 * https://github.com/...
 *
 * @param {HTMLElement} element The element that will be upgraded.
 */
var Checkbox = /*#__PURE__*/function (_Component) {
  _inherits(Checkbox, _Component);
  var _super = _createSuper(Checkbox);
  function Checkbox(element) {
    _classCallCheck(this, Checkbox);
    return _super.call(this, element, NAMESPACE);
  }
  _createClass(Checkbox, [{
    key: "init",
    value: function init() {
      var _this = this;
      _get(_getPrototypeOf(Checkbox.prototype), "init", this).call(this);
      this._input = this._element.querySelector(".".concat(CLASS_INPUT));
      this._input.addEventListener('change', this._changeHandler = function (event) {
        return _this._onChange(event);
      });
      this._input.addEventListener('focus', this._focusHandler = function (event) {
        return _this._onFocus(event);
      });
      this._input.addEventListener('blur', this._blurHandler = function (event) {
        return _this._onBlur(event);
      });

      // Insert box with tick after label element:
      this._label = this._element.querySelector(".".concat(CLASS_LABEL));
      var box = document.createElement('span');
      box.classList.add(CLASS_BOX);
      this._label.parentNode.insertBefore(box, this._label.nextSibling);
      var tick = document.createElement('span');
      tick.classList.add(CLASS_TICK);
      box.appendChild(tick);
      this.updateClasses();
    }
  }, {
    key: "updateClasses",
    value: function updateClasses() {
      this.checkDisabled();
      this.checkToggleState();
      this.checkFocus();
    }

    /**
     * Check the disabled state and update field accordingly.
     */
  }, {
    key: "checkDisabled",
    value: function checkDisabled() {
      if (this._input.disabled) {
        this._element.classList.add(CLASS_IS_DISABLED);
      } else {
        this._element.classList.remove(CLASS_IS_DISABLED);
      }
    }

    /**
     * Check the toggle state and update field accordingly.
     */
  }, {
    key: "checkToggleState",
    value: function checkToggleState() {
      if (this._input.checked) {
        this._element.classList.add(CLASS_IS_CHECKED);
      } else {
        this._element.classList.remove(CLASS_IS_CHECKED);
      }
    }

    /**
     * Check the focus state and update field accordingly.
     */
  }, {
    key: "checkFocus",
    value: function checkFocus() {
      if (Boolean(this._element.querySelector(':focus'))) {
        this._element.classList.add(CLASS_IS_FOCUS);
      } else {
        this._element.classList.remove(CLASS_IS_FOCUS);
      }
    }

    /**
     * Enable checkbox
     */
  }, {
    key: "enable",
    value: function enable() {
      this._input.disabled = false;
      this.updateClasses();
    }

    /**
     * Disable checkbox
     */
  }, {
    key: "disable",
    value: function disable() {
      this._input.disabled = true;
      this.updateClasses();
    }

    /**
     * Check checkbox
     */
  }, {
    key: "check",
    value: function check() {
      this._input.checked = true;
      console.log(this._input);
      this.updateClasses();
    }

    /**
     * Uncheck checkbox
     */
  }, {
    key: "uncheck",
    value: function uncheck() {
      this._input.checked = false;
      this.updateClasses();
    }

    /**
     * Uncheck checkbox
     */
  }, {
    key: "toggle",
    value: function toggle() {
      if (this._input.checked) {
        this.uncheck();
      } else {
        this.check();
      }
    }

    /**
     * Dispose component
     */
  }, {
    key: "dispose",
    value: function dispose() {
      _get(_getPrototypeOf(Checkbox.prototype), "dispose", this).call(this);
      this._input.removeEventListener('change', this._changeHandler);
      this._input.removeEventListener('focus', this._focusHandler);
      this._input.removeEventListener('blur', this._blurHandler);
      this._element.removeChild(this._element.querySelector(".".concat(CLASS_BOX)));
    }

    /**
     * Event Handler
     */
  }, {
    key: "_onChange",
    value: function _onChange(event) {
      this.updateClasses();

      // Since other radio buttons don't get change events, we need to look for
      // them to update their classes.
      for (var i = 0; i < _chechboxes.length; i++) {
        var button = _chechboxes[i];
        // Different name == different group, so no point updating those.
        if (button._input.getAttribute('name') === this.groupName) {
          button.updateClasses();
        }
      }
    }

    // TODO Find out why unfocus is triggered on mousedown
  }, {
    key: "_onFocus",
    value: function _onFocus(event) {
      this._element.classList.add(CLASS_IS_FOCUS);
    }
  }, {
    key: "_onBlur",
    value: function _onBlur(event) {
      this._element.classList.remove(CLASS_IS_FOCUS);
    }

    /**
     * Getter and Setter
     */
  }, {
    key: "input",
    get: function get() {
      return this._input;
    }
  }, {
    key: "checked",
    get: function get() {
      return this._input.checked = true;
    },
    set: function set(value) {
      if (value) {
        this.check();
      } else {
        this.uncheck();
      }
    }
  }, {
    key: "disabled",
    get: function get() {
      return this._input.disabled = true;
    },
    set: function set(value) {
      if (value) {
        this.disable();
      } else {
        this.enable();
      }
    }
  }], [{
    key: "upgradeElements",
    value:
    /**
     * Upgrades all Checkbox AUI components.
     * @returns {Array} Returns an array of all newly upgraded components.
     */
    function upgradeElements() {
      var components = [];
      Array.from(document.querySelectorAll(SELECTOR_COMPONENT)).forEach(function (element) {
        if (!_component_component__WEBPACK_IMPORTED_MODULE_0__["default"].isElementUpgraded(element)) {
          components.push(new Checkbox(element));
        }
      });
      _chechboxes = _chechboxes.concat(components);
      return components;
    }
  }, {
    key: "get",
    value:
    /**
     * Returns all AUI component instances within the given container
     * @param {HTMLElement} container The container element to search for components
     * @returns {Array} Returns an array of all newly upgraded components.
     */
    function get() {
      var container = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : document;
      var components = [];
      if (container) {
        Array.from(container.querySelectorAll(SELECTOR_COMPONENT)).forEach(function (element) {
          components.push(element.ciCheckbox);
        });
      }
      return components;
    }
  }]);
  return Checkbox;
}(_component_component__WEBPACK_IMPORTED_MODULE_0__["default"]);


/***/ }),

/***/ "./source/component/component.js":
/*!***************************************!*\
  !*** ./source/component/component.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Component)
/* harmony export */ });
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
var CLASS_IS_UPGRADED = 'is-upgraded';
var SVG_NS = 'http://www.w3.org/2000/svg';

/**
 * Class constructor for abstract AUI Component.
 * Implements AUI component design pattern defined at:
 * https://github.com/...
 *
 * @param {HTMLElement} element The element that will be upgraded.
 */
var Component = /*#__PURE__*/function () {
  /**
   * Constructor
   * @constructor
   * @param {HTMLElement} element The element of the AUI component.
   * @param {String} namespace The namespace of the AUI component, like `ciComponent`.
   */
  function Component(element, namespace) {
    _classCallCheck(this, Component);
    this._element = element;
    if (this._element) {
      if (namespace) {
        this._element[namespace] = this;
      }
      this.init();
    }
  }

  /**
   * Initialize component
   */
  _createClass(Component, [{
    key: "init",
    value: function init() {
      this._element.classList.add(CLASS_IS_UPGRADED);
    }

    /**
     * Dispose component
     */
  }, {
    key: "dispose",
    value: function dispose() {
      this._element.classList.remove(CLASS_IS_UPGRADED);
    }

    /**
     * Remove a child element from its parent.
     * @param {HTMLElement} childNode The element to remove.
     */
  }, {
    key: "removeChild",
    value: function removeChild(childNode) {
      if (childNode && childNode.parentNode) {
        childNode.remove();
      }
    }

    /**
     * Creates an HTML element and sets the given CSS classes and attributes.
     * @param {string} tagName is a string that specifies the type of element to be created.
     * @param {Array} classes is an array of class names to set, e.g. ['aui-class-1', 'aui-class-2'].
     * @param {Object} attributes is an object with attributes to set, e.g. {width: 100}.
     * @returns {HTMLElement} The created element.
     */
  }, {
    key: "createElement",
    value: function createElement(tagName, classes, attributes) {
      var element = document.createElement(tagName);
      if (classes && classes.length) {
        element.classList.add.apply(element.classList, classes);
      }
      for (var attr in attributes) {
        element.setAttribute(attr, attributes[attr]);
      }
      return element;
    }

    /**
     * Creates an SVG element and sets the given attributes.
     * @param {string} qualifiedName is a string that specifies the type of element to be created.
     * @param {Object} attributes is an object with attributes to set, e.g. {width: 100}.
     * @returns {SVGElement} The created element.
     */
  }, {
    key: "createSvgNode",
    value: function createSvgNode(qualifiedName, attributes) {
      var element = document.createElementNS(SVG_NS, qualifiedName);
      for (var attr in attributes) {
        element.setAttributeNS(null,
        // Replaces viewBox with view-box
        // attr.replace(/[A-Z]/g, function(match) {
        //   return '-' + match.toLowerCase();
        // }),
        attr, attributes[attr]);
      }
      return element;
    }

    /**
     * Returns the HTMLElement of component.
     */
  }, {
    key: "element",
    get: function get() {
      return this._element;
    }
  }], [{
    key: "isElementUpgraded",
    value:
    /**
     * Check if an element is upgraded.
     * @param {HTMLElement} element The element to test if its already be upgraded.
     * @returns {boolean} Returns true if element is already upgraded
     */
    function isElementUpgraded(element) {
      return element.classList.contains(CLASS_IS_UPGRADED);
    }
  }]);
  return Component;
}();


/***/ }),

/***/ "./source/dropdown/dropdown.js":
/*!*************************************!*\
  !*** ./source/dropdown/dropdown.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Dropdown)
/* harmony export */ });
/* harmony import */ var _component_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../component/component */ "./source/component/component.js");
/* harmony import */ var _checkbox_checkbox__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../checkbox/checkbox */ "./source/checkbox/checkbox.js");
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }


var SELECTOR_COMPONENT = '.ci-js-dropdown';
var SELECTOR_OPTION_INPUT = 'input';
var CLASS_ANIMATED_LIST_ITEMS = 'ci-dropdown-list-item--animate';
var CLASS_LABEL = 'ci-dropdown-label';
var CLASS_INPUT = 'ci-dropdown-input';
var CLASS_VALUE = 'ci-dropdown-value';
var CLASS_FOCUS_LINE = 'ci-dropdown-focus-line';
var CLASS_OPTION = 'ci-dropdown-option';
var CLASS_MULTIPLE = 'ci-dropdown--multiple';
var CLASS_IS_FOCUS = 'is-focused';
var CLASS_IS_DIRTY = 'is-dirty';
var CLASS_IS_DISABLED = 'is-disabled';
var CLASS_IS_ACTIVE = 'is-active';

/**
 * Class constructor for Dropdown AUI component.
 * Implements AUI component design pattern defined at:
 * https://github.com/...
 *
 * @param {HTMLElement} element The element that will be upgraded.
 */
var Dropdown = /*#__PURE__*/function (_Component) {
  _inherits(Dropdown, _Component);
  var _super = _createSuper(Dropdown);
  /**
   * Constructor
   * @constructor
   * @param {HTMLElement} element The element of the AUI component.
   */
  function Dropdown(element) {
    var _this;
    _classCallCheck(this, Dropdown);
    _this = _super.call(this, element);
    _this._element.addEventListener('click', _this._clickHandler = function (event) {
      return _this._onClick(event);
    });
    _this.multiple = _this._element.classList.contains(CLASS_MULTIPLE);
    _this._isActive = false;
    _this._valueField = _this._element.querySelector(".".concat(CLASS_VALUE));
    _this._input = _this._element.querySelector(".".concat(CLASS_INPUT));
    _this._input.addEventListener('input', _this._inputHandler = function (event) {
      return _this._onInput(event);
    });
    _this._input.addEventListener('focus', _this._focusHandler = function (event) {
      return _this._onFocus(event);
    });
    _this._input.addEventListener('blur', _this._blurHandler = function (event) {
      return _this._onBlur(event);
    });
    _this._input.addEventListener('reset', _this._resetHandler = function (event) {
      return _this._onReset(event);
    });
    var itemsAnimated = _this._element.querySelectorAll(".".concat(CLASS_ANIMATED_LIST_ITEMS));
    for (var i = 0; i < itemsAnimated.length; i++) {
      itemsAnimated[i].style.transitionDelay = itemsAnimated[i].style.webkitTransitionDelay = "".concat(.05 * i, "s");
    }

    // Insert thick focus line after label element:
    _this._label = _this._element.querySelector(".".concat(CLASS_LABEL));
    var focusLine = document.createElement('span');
    focusLine.classList.add(CLASS_FOCUS_LINE);
    _this._label.parentNode.insertBefore(focusLine, _this._label.nextSibling);
    _this.updateClasses();
    return _this;
  }
  _createClass(Dropdown, [{
    key: "optionClicked",
    value: function optionClicked(option) {
      if (this._valueField) {
        this._valueField.value = this._getOptionValue(option);
      }
      this.updateInput(option);
      if (!this.multiple) {
        this.close();
      }
    }
  }, {
    key: "updateInput",
    value: function updateInput(option) {
      var _this2 = this;
      var value = '';
      if (this.multiple) {
        var values = [];
        Array.from(this._element.querySelectorAll(".".concat(CLASS_OPTION))).forEach(function (element) {
          var input = element.querySelector(SELECTOR_OPTION_INPUT);
          if (input && input.checked) {
            values.push(_this2._getOptionTitle(element));
          }
        });
        value = values.length > 0 ? "(".concat(values.length, ") ").concat(values.join(', ')) : '';
      } else {
        value = this._getOptionTitle(option);
      }
      this._input.value = value;
      this.updateClasses();
    }
  }, {
    key: "_getOptionTitle",
    value: function _getOptionTitle(option) {
      var title = '';
      if (option) {
        title = option.hasAttribute('data-title') ? option.getAttribute('data-title') : '';
      }
      return title;
    }
  }, {
    key: "_getOptionValue",
    value: function _getOptionValue(option) {
      var value = '';
      if (option) {
        value = option.hasAttribute('data-value') ? option.getAttribute('data-value') : '';
      }
      return value;
    }
  }, {
    key: "open",
    value: function open() {
      var _this3 = this;
      if (!this._element.classList.contains(CLASS_IS_DISABLED)) {
        this._isActive = true;
        this._element.classList.add(CLASS_IS_ACTIVE);
        window.addEventListener('click', this._clickHandlerWindow = function (event) {
          return _this3._onClickOutside(event);
        });
      }
    }
  }, {
    key: "close",
    value: function close() {
      this._isActive = false;
      this._element.classList.remove(CLASS_IS_ACTIVE);
      window.removeEventListener('click', this.close);
    }
  }, {
    key: "toggleOpen",
    value: function toggleOpen() {
      if (this._isActive) {
        this.close();
      } else {
        this.open();
      }
    }
  }, {
    key: "updateClasses",
    value: function updateClasses() {
      this.checkDisabled();
      this.checkDirty();
      this.checkFocus();
    }

    /**
     * Check the disabled state and update field accordingly.
     */
  }, {
    key: "checkDisabled",
    value: function checkDisabled() {
      if (this._input.disabled) {
        this._element.classList.add(CLASS_IS_DISABLED);
      } else {
        this._element.classList.remove(CLASS_IS_DISABLED);
      }
    }

    /**
     * Check the dirty state and update field accordingly.
     */
  }, {
    key: "checkDirty",
    value: function checkDirty() {
      if (this._input.value && this._input.value.length > 0) {
        this._element.classList.add(CLASS_IS_DIRTY);
      } else {
        this._element.classList.remove(CLASS_IS_DIRTY);
      }
    }

    /**
     * Check the focus state and update field accordingly.
     */
  }, {
    key: "checkFocus",
    value: function checkFocus() {
      if (Boolean(this._element.querySelector(':focus'))) {
        this._element.classList.add(CLASS_IS_FOCUS);
      } else {
        this._element.classList.remove(CLASS_IS_FOCUS);
      }
    }

    /**
     * Disable text field.
     */
  }, {
    key: "disable",
    value: function disable() {
      this._input.disabled = true;
      this.updateClasses();
    }

    /**
     * Dispose component
     */
  }, {
    key: "dispose",
    value: function dispose() {
      _get(_getPrototypeOf(Dropdown.prototype), "dispose", this).call(this);
      this._input.removeEventListener('input', this._inputHandler);
      this._input.removeEventListener('focus', this._focusHandler);
      this._input.removeEventListener('blur', this._blurHandler);
      this._input.removeEventListener('reset', this._resetHandler);
      window.removeEventListener('click', this.close);
    }

    /**
     * Event Handler
     */
  }, {
    key: "_onClick",
    value: function _onClick(event) {
      var _this4 = this;
      var isOption = false;

      // Find closest action element
      var currentElement = event.target;
      while (currentElement !== event.currentTarget) {
        if (currentElement.classList.contains(CLASS_OPTION)) {
          isOption = true;
          break;
        }
        currentElement = currentElement.parentNode;
      }
      if (!isOption) {
        this.toggleOpen();
      } else {
        // Toggle the Checkbox contained
        _checkbox_checkbox__WEBPACK_IMPORTED_MODULE_1__["default"].get(currentElement).forEach(function (checkbox) {
          checkbox.toggle();
          _this4.optionClicked(currentElement);
        });
      }
    }
  }, {
    key: "_onClickOutside",
    value: function _onClickOutside(event) {
      if (!this._element.contains(event.target)) {
        this.close();
        this.updateClasses();
      }
    }
  }, {
    key: "_onInput",
    value: function _onInput(event) {
      this.updateClasses();
    }
  }, {
    key: "_onFocus",
    value: function _onFocus(event) {
      this._element.classList.add(CLASS_IS_FOCUS);
    }
  }, {
    key: "_onBlur",
    value: function _onBlur(event) {
      this._element.classList.remove(CLASS_IS_FOCUS);
    }
  }, {
    key: "_onReset",
    value: function _onReset(event) {
      this.updateClasses();
    }
  }], [{
    key: "upgradeElements",
    value:
    /**
     * Upgrades all Dropdown AUI components.
     * @returns {Array} Returns an array of all newly upgraded components.
     */
    function upgradeElements() {
      var components = [];
      Array.from(document.querySelectorAll(SELECTOR_COMPONENT)).forEach(function (element) {
        if (!_component_component__WEBPACK_IMPORTED_MODULE_0__["default"].isElementUpgraded(element)) {
          components.push(new Dropdown(element));
        }
      });
      return components;
    }
  }]);
  return Dropdown;
}(_component_component__WEBPACK_IMPORTED_MODULE_0__["default"]);


/***/ }),

/***/ "./source/flyout/flyout.js":
/*!*********************************!*\
  !*** ./source/flyout/flyout.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Flyout)
/* harmony export */ });
/* harmony import */ var _component_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../component/component */ "./source/component/component.js");
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var SELECTOR_COMPONENT = '.ci-js-flyout';
var CLASS_TOGGLE = 'ci-flyout-toggle';
var CLASS_TRIANGLE = 'ci-flyout-triangle';
var CLASS_HEADER = 'ci-flyout-header';
var CLASS_CLOSE_BUTTON = 'ci-flyout-close';
var CLASS_PANEL = 'ci-flyout-panel';
var CLASS_IS_UPGRADED = 'is-upgraded';
var CLASS_IS_ACTIVE = 'is-active';
var CLASS_FLYOUT_IS_OPEN = 'ci-flyout-is-open';
var TOGGLE_THRESHOLD = 250; // in ms

/**
 * Class constructor for Flyout AUI component.
 * Implements AUI component design pattern defined at:
 * https://github.com/...
 *
 * @param {HTMLElement} element The element that will be upgraded.
 */
var Flyout = /*#__PURE__*/function (_Component) {
  _inherits(Flyout, _Component);
  var _super = _createSuper(Flyout);
  function Flyout() {
    _classCallCheck(this, Flyout);
    return _super.apply(this, arguments);
  }
  _createClass(Flyout, [{
    key: "init",
    value:
    /**
     * Initialize component
     */
    function init() {
      var _this = this;
      _get(_getPrototypeOf(Flyout.prototype), "init", this).call(this);
      this._activationTime = 0;
      this._body = document.querySelector('body');
      this._toggle = this._element.querySelector(".".concat(CLASS_TOGGLE));
      this._panel = this._element.querySelector(".".concat(CLASS_PANEL));

      // Add triangle shape
      this._triangle = document.createElement('span');
      this._triangle.classList.add(CLASS_TRIANGLE);
      this._panel.appendChild(this._triangle);

      // Add panel header with close button
      this._header = document.createElement('div');
      this._header.classList.add(CLASS_HEADER);
      this._header.innerHTML = "<button class=\"".concat(CLASS_CLOSE_BUTTON, "\" type=\"button\"></button>");
      this._panel.appendChild(this._header);
      this._closeBtn = this._header.querySelector(".".concat(CLASS_CLOSE_BUTTON));
      this._closeBtn.addEventListener('click', this._boundClickClose = function (event) {
        return _this._onClickClose(event);
      });
      this._toggle.addEventListener('click', this._boundClickToggle = function (event) {
        return _this._onClickToggle(event);
      });
      if (this._element.classList.contains(CLASS_IS_ACTIVE)) {
        this.open();
      }
    }

    /**
     * Dispose component
     */
  }, {
    key: "dispose",
    value: function dispose() {
      this._toggle.removeEventListener('click', this._boundClickToggle);
      this._closeBtn.removeEventListener('click', this._boundClickClose);
      window.removeEventListener('click', this._boundClickWindow);
      window.removeEventListener('touchend', this._boundTouchendWindow);
      this._panel.removeChild(this._triangle);
      this._element.classList.remove(CLASS_IS_ACTIVE, CLASS_IS_UPGRADED);
      this._element.removeAttribute('style');
    }

    /**
     * Open Flyout
     */
  }, {
    key: "open",
    value: function open() {
      var _this2 = this;
      this._body.classList.add(CLASS_FLYOUT_IS_OPEN);
      this._activationTime = Date.now();
      this._isActive = true;
      this._element.classList.add(CLASS_IS_ACTIVE);
      window.addEventListener('click', this._boundClickWindow = function (event) {
        return _this2._onTouchOutside(event);
      }, true);
      window.addEventListener('touchend', this._boundTouchendWindow = function (event) {
        return _this2._onTouchOutside(event);
      }, true);
    }

    /**
     * Close Flyout
     */
  }, {
    key: "close",
    value: function close() {
      this._body.classList.remove(CLASS_FLYOUT_IS_OPEN);
      this._isActive = false;
      this._element.classList.remove(CLASS_IS_ACTIVE);
      window.removeEventListener('click', this._boundClickWindow, true);
      window.removeEventListener('touchend', this._boundTouchendWindow, true);
    }

    /**
     * Toggle open/close Flyout
     */
  }, {
    key: "toggle",
    value: function toggle() {
      var elapsed = Date.now() - this._activationTime;
      if (elapsed < TOGGLE_THRESHOLD) {
        return;
      }
      if (this._isActive) {
        this.close();
      } else {
        this.open();
      }
    }

    /**
     * Handle click of close button.
     * @param {Event} event that fired.
     */
  }, {
    key: "_onClickClose",
    value: function _onClickClose(event) {
      this.close();
    }

    /**
     * Handle click of toggle.
     * @param {Event} event that fired.
     */
  }, {
    key: "_onClickToggle",
    value: function _onClickToggle(event) {
      this.toggle();
    }

    /**
     * Handle mouseneter.
     * @param {Event} event that fired.
     */
  }, {
    key: "_onMouseEnter",
    value: function _onMouseEnter(event) {
      this.open(event.target, event.clientX);
    }

    /**
     * Handle mouseleave.
     * @param {Event} event that fired.
     */
  }, {
    key: "_onMouseLeave",
    value: function _onMouseLeave(event) {
      this.close();
    }

    /**
     * Handle touch.
     * @param {Event} event that fired.
     */
  }, {
    key: "_onTouch",
    value: function _onTouch(event) {
      event.stopPropagation();
      this.open();
    }

    /**
     * Handle touch outside.
     * @param {Event} event that fired.
     */
  }, {
    key: "_onTouchOutside",
    value: function _onTouchOutside(event) {
      if (!this._element.contains(event.target)) {
        this.close();
      }
    }
  }], [{
    key: "upgradeElements",
    value:
    /**
     * Upgrades all Flyout AUI components.
     * @returns {Array} Returns an array of all newly upgraded components.
     */
    function upgradeElements() {
      var components = [];
      Array.from(document.querySelectorAll(SELECTOR_COMPONENT)).forEach(function (element) {
        if (!_component_component__WEBPACK_IMPORTED_MODULE_0__["default"].isElementUpgraded(element)) {
          components.push(new Flyout(element));
        }
      });
      return components;
    }
  }]);
  return Flyout;
}(_component_component__WEBPACK_IMPORTED_MODULE_0__["default"]);


/***/ }),

/***/ "./source/modal/modal-default.js":
/*!***************************************!*\
  !*** ./source/modal/modal-default.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ModalDefault)
/* harmony export */ });
/* harmony import */ var _modal_modal_dialog__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../modal/modal-dialog */ "./source/modal/modal-dialog.js");
/* harmony import */ var _util_resize_observer__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/resize-observer */ "./source/util/resize-observer.js");
/* harmony import */ var _util_transition_end_event__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util/transition-end-event */ "./source/util/transition-end-event.js");
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }



var CLASS_MODAL_IS_OPEN = 'ci-modal-open';
var CLASS_WINDOW = 'ci-modal-dialog-window';
var CLASS_DIALOG_BODY = 'ci-modal-dialog-body';
var CLASS_IS_ACTIVE = 'is-active';

/**
 * Class constructor for ModalDefault AUI component.
 * Implements AUI component design pattern defined at:
 * https://github.com/...
 *
 * @param {HTMLElement} element The element that will be upgraded.
 */
var ModalDefault = /*#__PURE__*/function (_ModalDialog) {
  _inherits(ModalDefault, _ModalDialog);
  var _super = _createSuper(ModalDefault);
  function ModalDefault() {
    _classCallCheck(this, ModalDefault);
    return _super.apply(this, arguments);
  }
  _createClass(ModalDefault, [{
    key: "open",
    value:
    /**
     * Opens this modal.
     * @param {HTMLElement} trigger The element which opens the modal.
     */
    function open(trigger) {
      var _this = this;
      _get(_getPrototypeOf(ModalDefault.prototype), "open", this).call(this);
      this._trigger = trigger;

      // Make modal element visible
      this._element.classList.add(CLASS_IS_ACTIVE);
      this._element.scrollTop = 0;
      this._addBackdrop();

      // If dialog acts as window, we have to reposition the close button to
      // stick with the dialog.
      if (this._element.querySelector(".".concat(CLASS_WINDOW)) && this._closeButton) {
        if (this._resizeObserver === undefined) {
          this._resizeObserver = new _util_resize_observer__WEBPACK_IMPORTED_MODULE_1__["default"]();
          this._dialogBody = this._element.querySelector(".".concat(CLASS_DIALOG_BODY));
        }
        this._resizeObserver.resized.add(this._resizedHandler = function () {
          return _this._repositionCloseButton();
        });
        this._repositionCloseButton();
      }
      window.requestAnimationFrame(function () {
        return _this._prepareOpenTransition();
      });
    }

    /**
     * Prepare the open transition.
     */
  }, {
    key: "_prepareOpenTransition",
    value: function _prepareOpenTransition() {
      var _this2 = this;
      // Loops until modal is really visible.
      // That's required to make transitions work as aspected.
      if (this._element.offsetWidth > 0) {
        // Start opening animation
        this._body.classList.add(CLASS_MODAL_IS_OPEN);
      } else {
        window.requestAnimationFrame(function () {
          return _this2._prepareOpenTransition();
        });
      }
    }

    /**
     * Closes this modal.
     */
  }, {
    key: "close",
    value: function close() {
      var _this3 = this;
      if (this._backdrop) {
        this._backdrop.removeEventListener(_util_transition_end_event__WEBPACK_IMPORTED_MODULE_2__["default"], this._backdropCloseTransitionendHandler);
        _util_transition_end_event__WEBPACK_IMPORTED_MODULE_2__["default"] && this._backdrop.addEventListener(_util_transition_end_event__WEBPACK_IMPORTED_MODULE_2__["default"], this._backdropCloseTransitionendHandler = function (event) {
          return _this3._onBackdropCloseTransitionend(event);
        });
      }
      if (this._resizeObserver) {
        this._resizeObserver.resized.remove(this._resizedHandler);
      }
      this._body.classList.remove(CLASS_MODAL_IS_OPEN);
    }

    /**
     * Reposition close button with dialog
     */
  }, {
    key: "_repositionCloseButton",
    value: function _repositionCloseButton() {
      var rect = this._dialogBody.getBoundingClientRect();
      var right = rect.right - rect.width;
      // Only reposition if the window is positioned center, otherwise respect
      // CSS styling:
      if (right > 0) {
        this._closeButton.style.right = "".concat(right, "px");
      } else {
        this._closeButton.style.right = '';
      }
    }
  }]);
  return ModalDefault;
}(_modal_modal_dialog__WEBPACK_IMPORTED_MODULE_0__["default"]);


/***/ }),

/***/ "./source/modal/modal-dialog.js":
/*!**************************************!*\
  !*** ./source/modal/modal-dialog.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ModalDialog)
/* harmony export */ });
/* harmony import */ var _component_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../component/component */ "./source/component/component.js");
/* harmony import */ var _util_transition_end_event__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/transition-end-event */ "./source/util/transition-end-event.js");
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }


var CLOSE_BUTTON_SIZE_SMALL = 45;
var CLOSE_BUTTON_SIZE_LARGE = 81;
var CLOSE_ICON_SIZE_SMALL = 17;
var CLOSE_ICON_SIZE_LARGE = 31;
var CLASS_BACKDROP = 'ci-modal-backdrop';
var CLASS_CLOSE = 'ci-modal-dialog-close';
var CLASS_IS_ACTIVE = 'is-active';

/**
 * Class constructor for ModalDialog AUI component.
 * Implements AUI component design pattern defined at:
 * https://github.com/...
 *
 * @param {HTMLElement} element The element that will be upgraded.
 */
var ModalDialog = /*#__PURE__*/function (_Component) {
  _inherits(ModalDialog, _Component);
  var _super = _createSuper(ModalDialog);
  function ModalDialog() {
    _classCallCheck(this, ModalDialog);
    return _super.apply(this, arguments);
  }
  _createClass(ModalDialog, [{
    key: "init",
    value:
    /**
     * Initialize component
     */
    function init() {
      _get(_getPrototypeOf(ModalDialog.prototype), "init", this).call(this);
      this._body = document.querySelector('body');
      this._closeButton = this._element.querySelector(".".concat(CLASS_CLOSE));
      if (this._closeButton) {
        this._addCloseButton(this._closeButton);
      }
    }

    /**
     * Opens this modal.
     */
  }, {
    key: "open",
    value: function open() {
      if (this._element.parentNode !== this._body) {
        this._body.appendChild(this._element);
      }
    }

    /**
     * Handle transition end event
     * @param {Event} event which was fired.
     */
  }, {
    key: "_onBackdropCloseTransitionend",
    value: function _onBackdropCloseTransitionend(event) {
      if (event.target === event.currentTarget) {
        this._backdrop.removeEventListener(_util_transition_end_event__WEBPACK_IMPORTED_MODULE_1__["default"], this._backdropCloseTransitionendHandler);
        this._element.classList.remove(CLASS_IS_ACTIVE);
        this._removeBackdrop();
      }
    }

    /**
     * Adds a semi-transparent backdrop element behind the modal.
     */
  }, {
    key: "_addBackdrop",
    value: function _addBackdrop() {
      if (!this._backdrop) {
        this._backdrop = document.createElement('div');
        this._backdrop.classList.add(CLASS_BACKDROP);
        this._body.appendChild(this._backdrop);
      }
    }

    /**
     * Removes the backdrop element behind modal.
     */
  }, {
    key: "_removeBackdrop",
    value: function _removeBackdrop() {
      if (this._backdrop) {
        this._body.removeChild(this._backdrop);
        this._backdrop = null;
      }
    }

    /**
     * Adds close button
     * @param {HTMLElement} container to append close icon to.
     */
  }, {
    key: "_addCloseButton",
    value: function _addCloseButton(container) {
      var diagonalHalf = Math.sqrt(2) * CLOSE_ICON_SIZE_SMALL / 2;
      var btnSize = CLOSE_BUTTON_SIZE_SMALL;
      var small = this.createSvgNode('svg', {
        class: 'ci-modal-close-icon-small',
        viewBox: "0 0 ".concat(btnSize, " ").concat(btnSize)
      });
      var group = this.createSvgNode('g', {
        transform: "translate(".concat(btnSize / 2, ", ").concat(btnSize / 2, ")")
      });
      group.appendChild(this.createSvgNode('line', {
        x1: '0',
        y1: -diagonalHalf,
        x2: '0',
        y2: diagonalHalf,
        stroke: 'currentColor',
        transform: 'rotate(-45, 0, 0)'
      }));
      group.appendChild(this.createSvgNode('line', {
        x1: '0',
        y1: -diagonalHalf,
        x2: '0',
        y2: diagonalHalf,
        stroke: 'currentColor',
        transform: 'rotate(45, 0, 0)'
      }));
      small.appendChild(group);
      container.appendChild(small);
      diagonalHalf = Math.sqrt(2) * CLOSE_ICON_SIZE_LARGE / 2;
      btnSize = CLOSE_BUTTON_SIZE_LARGE;
      var large = this.createSvgNode('svg', {
        'class': 'ci-modal-close-icon-large',
        'viewBox': "0 0 ".concat(btnSize, " ").concat(btnSize)
      });
      group = this.createSvgNode('g', {
        transform: "translate(".concat(btnSize / 2, ", ").concat(btnSize / 2, ")")
      });
      group.appendChild(this.createSvgNode('line', {
        x1: '0',
        y1: -diagonalHalf,
        x2: '0',
        y2: diagonalHalf,
        stroke: 'currentColor',
        transform: 'rotate(-45, 0, 0)'
      }));
      group.appendChild(this.createSvgNode('line', {
        x1: '0',
        y1: -diagonalHalf,
        x2: '0',
        y2: diagonalHalf,
        stroke: 'currentColor',
        transform: 'rotate(45, 0, 0)'
      }));
      large.appendChild(group);
      container.appendChild(large);
    }
  }]);
  return ModalDialog;
}(_component_component__WEBPACK_IMPORTED_MODULE_0__["default"]);


/***/ }),

/***/ "./source/modal/modal-morph.js":
/*!*************************************!*\
  !*** ./source/modal/modal-morph.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ModalMorph)
/* harmony export */ });
/* harmony import */ var _modal_modal_dialog__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../modal/modal-dialog */ "./source/modal/modal-dialog.js");
/* harmony import */ var _util_transition_end_event__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/transition-end-event */ "./source/util/transition-end-event.js");
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }


var CLASS_MODAL_IS_OPEN = 'ci-modal-open';
var CLASS_CONTENT = 'ci-modal-dialog-content';
var CLASS_MORPH_DIALOG = 'ci-modal-morph';
var CLASS_IS_ACTIVE = 'is-active';
var CLASS_IS_MORPHING = 'is-morphing';

/**
 * Class constructor for ModalMorph AUI component.
 * Implements AUI component design pattern defined at:
 * https://github.com/...
 *
 * @param {HTMLElement} element The element that will be upgraded.
 */
var ModalMorph = /*#__PURE__*/function (_ModalDialog) {
  _inherits(ModalMorph, _ModalDialog);
  var _super = _createSuper(ModalMorph);
  function ModalMorph() {
    _classCallCheck(this, ModalMorph);
    return _super.apply(this, arguments);
  }
  _createClass(ModalMorph, [{
    key: "init",
    value:
    /**
     * Initialize component
     */
    function init() {
      _get(_getPrototypeOf(ModalMorph.prototype), "init", this).call(this);
      this._content = this._element.querySelector(".".concat(CLASS_CONTENT));
    }

    /**
     * Open modal
     * @param {HTMLElement} trigger The element which opens the modal.
     */
  }, {
    key: "open",
    value: function open(trigger) {
      var _this = this;
      console.log('Open morphing modal');
      _get(_getPrototypeOf(ModalMorph.prototype), "open", this).call(this);
      this._trigger = trigger;

      // Make modal element visible
      this._element.classList.add(CLASS_IS_ACTIVE);
      this._element.scrollTop = 0;
      this._addBackdrop();
      window.requestAnimationFrame(function () {
        return _this._prepareOpenTransition();
      });
    }
  }, {
    key: "_prepareOpenTransition",
    value: function _prepareOpenTransition() {
      var _this2 = this;
      var rect = this._trigger.getBoundingClientRect();

      // Apply bounding rect to start with to morphing element
      this._morph = this._getMorphElement(rect);

      // Start opening animation
      window.requestAnimationFrame(function () {
        return _this2._startOpenTransition();
      });
    }
  }, {
    key: "_startOpenTransition",
    value: function _startOpenTransition() {
      var _this3 = this;
      var rect = this._content.getBoundingClientRect();

      // Apply bounding rect to end on to morphing element
      this._applyBoundingRectToElement(this._morph, rect);
      _util_transition_end_event__WEBPACK_IMPORTED_MODULE_1__["default"] && this._element.addEventListener(_util_transition_end_event__WEBPACK_IMPORTED_MODULE_1__["default"], this._boundTransitionendElementIn = function (event) {
        return _this3._onTransitionendElementIn(event);
      });
      this._morph.classList.add(CLASS_IS_MORPHING);
      this._body.classList.add(CLASS_MODAL_IS_OPEN);
    }
  }, {
    key: "_onTransitionendElementIn",
    value: function _onTransitionendElementIn(event) {
      this._element.removeEventListener(_util_transition_end_event__WEBPACK_IMPORTED_MODULE_1__["default"], this._boundTransitionendElementIn);
      this._morph.classList.remove(CLASS_IS_MORPHING);
    }

    /**
     * Close modal
     */
  }, {
    key: "close",
    value: function close() {
      var _this4 = this;
      console.log('close');
      if (this._backdrop) {
        this._backdrop.removeEventListener(_util_transition_end_event__WEBPACK_IMPORTED_MODULE_1__["default"], this._backdropCloseTransitionendHandler);
        _util_transition_end_event__WEBPACK_IMPORTED_MODULE_1__["default"] && this._backdrop.addEventListener(_util_transition_end_event__WEBPACK_IMPORTED_MODULE_1__["default"], this._backdropCloseTransitionendHandler = function (event) {
          return _this4._onBackdropCloseTransitionend(event);
        });
      }
      this._element.removeEventListener(_util_transition_end_event__WEBPACK_IMPORTED_MODULE_1__["default"], this._boundTransitionendElementIn);
      var rect = this._content.getBoundingClientRect();
      this._applyBoundingRectToElement(this._morph, rect);
      this._morph.classList.add(CLASS_IS_MORPHING);
      _util_transition_end_event__WEBPACK_IMPORTED_MODULE_1__["default"] && this._morph.addEventListener(_util_transition_end_event__WEBPACK_IMPORTED_MODULE_1__["default"], this._boundTransitionendMorphOut = function (event) {
        return _this4._onTransitionendMorphOut(event);
      });
      window.requestAnimationFrame(function () {
        return _this4._startCloseTransition();
      });
    }
  }, {
    key: "_startCloseTransition",
    value: function _startCloseTransition() {
      var rect = this._trigger.getBoundingClientRect();
      this._applyBoundingRectToElement(this._morph, rect);
      this._body.classList.remove(CLASS_MODAL_IS_OPEN);
    }
  }, {
    key: "_onTransitionendMorphOut",
    value: function _onTransitionendMorphOut(event) {
      this._morph.removeEventListener(_util_transition_end_event__WEBPACK_IMPORTED_MODULE_1__["default"], this._boundTransitionendMorphOut);
      this.removeChild(this._morph);
      this._morph = null;
    }
  }, {
    key: "_onMorpBodyCloseTransitionend",
    value: function _onMorpBodyCloseTransitionend(event) {
      if (event.target === event.currentTarget) {
        this._morphBody.removeEventListener(_util_transition_end_event__WEBPACK_IMPORTED_MODULE_1__["default"], this._morpBodyCloseTransitionendHandler);
        this._morphBody.removeAttribute('style');
        this._content.classList.remove(CLASS_IS_MORPHING);
      }
    }
  }, {
    key: "_applyBoundingRectToElement",
    value: function _applyBoundingRectToElement(element, rect) {
      element.style.top = "".concat(Math.round(rect.top), "px");
      element.style.left = "".concat(Math.round(rect.left), "px");
      element.style.width = "".concat(Math.round(rect.width), "px");
      element.style.height = "".concat(Math.round(rect.height), "px");
    }
  }, {
    key: "_getMorphElement",
    value: function _getMorphElement(rect) {
      if (!this._morph) {
        this._morph = this.createElement('div', [CLASS_MORPH_DIALOG]);
        this._applyBoundingRectToElement(this._morph, rect);
        this._body.append(this._morph);
      }
      return this._morph;
    }
  }]);
  return ModalMorph;
}(_modal_modal_dialog__WEBPACK_IMPORTED_MODULE_0__["default"]);


/***/ }),

/***/ "./source/modal/modal.js":
/*!*******************************!*\
  !*** ./source/modal/modal.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Modal)
/* harmony export */ });
/* harmony import */ var _component_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../component/component */ "./source/component/component.js");
/* harmony import */ var _modal_modal_default__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../modal/modal-default */ "./source/modal/modal-default.js");
/* harmony import */ var _modal_modal_morph__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../modal/modal-morph */ "./source/modal/modal-morph.js");
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }



var SELECTOR_COMPONENT = '.ci-js-modal';
var CLASS_MORPH = 'ci-modal-morph';
var modalComponents;
var currentModal;

/**
 * Class constructor for Modal AUI component.
 * Implements AUI component design pattern defined at:
 * https://github.com/...
 *
 * @param {HTMLElement} element The element that will be upgraded.
 */
var Modal = /*#__PURE__*/function (_Component) {
  _inherits(Modal, _Component);
  var _super = _createSuper(Modal);
  function Modal() {
    _classCallCheck(this, Modal);
    return _super.apply(this, arguments);
  }
  _createClass(Modal, [{
    key: "init",
    value:
    /**
     * Initialize component
     */
    function init() {
      _get(_getPrototypeOf(Modal.prototype), "init", this).call(this);
      this._id = this._element.getAttribute('id');

      // Initialize with appropriate decorator depending on modifier,
      // represented by according CSS class:
      if (this._element.classList.contains(CLASS_MORPH)) {
        this._decorator = new _modal_modal_morph__WEBPACK_IMPORTED_MODULE_2__["default"](this._element);
      } else {
        this._decorator = new _modal_modal_default__WEBPACK_IMPORTED_MODULE_1__["default"](this._element);
      }
    }

    /**
     * Opens this modal.
     * @param {HTMLElement} trigger The element which opens the modal.
     */
  }, {
    key: "open",
    value: function open(trigger) {
      currentModal = this;
      this._decorator.open(trigger);
    }

    /**
     * Closes this modal.
     */
  }, {
    key: "close",
    value: function close() {
      currentModal = null;
      this._decorator.close();
    }

    /**
     * @returns {string} Returns the ID of the modal
     */
  }, {
    key: "id",
    get: function get() {
      return this._id;
    }
  }], [{
    key: "upgradeElements",
    value:
    /**
     * Upgrades all Modal AUI components.
     * @returns {Array} Returns an array of all newly upgraded components.
     */
    function upgradeElements() {
      var components = [];
      Array.from(document.querySelectorAll(SELECTOR_COMPONENT)).forEach(function (element) {
        if (!_component_component__WEBPACK_IMPORTED_MODULE_0__["default"].isElementUpgraded(element)) {
          components.push(new Modal(element));
        }
      });
      modalComponents = components;
      return components;
    }
  }, {
    key: "getModalById",
    value:
    /**
     * Get a modal component by element ID.
     * @param {string} id The id attribute of the components HTML element.
     * @returns {Modal} Returns a modal with the given ID.
     */
    function getModalById(id) {
      console.log("getModalById id: " + id);
      console.log(modalComponents);
      for (var i = 0; i < modalComponents.length; i++) {
        if (modalComponents[i].id === id) {
          return modalComponents[i];
        }
      }
    }

    /**
     * Close current modal.
     */
  }, {
    key: "closeCurrentModal",
    value: function closeCurrentModal() {
      if (currentModal) {
        currentModal.close();
        currentModal = null;
      }
    }

    /**
     * Returns modifier `morph`
     */
  }, {
    key: "MODIFIER_MORPH",
    get: function get() {
      return CLASS_MORPH;
    }

    /**
     * Returns modifier `default`
     */
  }, {
    key: "MODIFIER_DEFAULT",
    get: function get() {
      return '';
    }
  }]);
  return Modal;
}(_component_component__WEBPACK_IMPORTED_MODULE_0__["default"]);

if (!Array.from) {
  Array.from = function () {
    var toStr = Object.prototype.toString;
    var isCallable = function isCallable(fn) {
      return typeof fn === 'function' || toStr.call(fn) === '[object Function]';
    };
    var toInteger = function toInteger(value) {
      var number = Number(value);
      if (isNaN(number)) {
        return 0;
      }
      if (number === 0 || !isFinite(number)) {
        return number;
      }
      return (number > 0 ? 1 : -1) * Math.floor(Math.abs(number));
    };
    var maxSafeInteger = Math.pow(2, 53) - 1;
    var toLength = function toLength(value) {
      var len = toInteger(value);
      return Math.min(Math.max(len, 0), maxSafeInteger);
    };
    return function from(arrayLike) {
      var C = this;
      var items = Object(arrayLike);
      if (arrayLike === null) {
        throw new TypeError("Array.from requires an array-like object - not null or undefined");
      }
      var mapFn = arguments.length > 1 ? arguments[1] : void undefined;
      var T;
      if (typeof mapFn !== 'undefined') {
        if (!isCallable(mapFn)) {
          throw new TypeError('Array.from: when provided, the second argument must be a function');
        }
        if (arguments.length > 2) {
          T = arguments[2];
        }
      }
      var len = toLength(items.length);
      var A = isCallable(C) ? Object(new C(len)) : new Array(len);
      var k = 0;
      var kValue;
      while (k < len) {
        kValue = items[k];
        if (mapFn) {
          A[k] = typeof T === 'undefined' ? mapFn(kValue, k) : mapFn.call(T, kValue, k);
        } else {
          A[k] = kValue;
        }
        k += 1;
      }
      A.length = len;
      return A;
    };
  }();
}
/**
 * to open modal:
 */
Array.from(document.querySelectorAll('[data-toggle="modal"]')).forEach(function (element) {
  console.log("Modal erkannt");
  element.addEventListener('click', function (event) {
    console.log("klick auf modal opener");
    var modal = Modal.getModalById(element.getAttribute('data-target'));
    if (modal) {
      modal.open(event.currentTarget);
    }
  });
});
Array.from(document.querySelectorAll('[data-dismiss="modal"]')).forEach(function (element) {
  console.log("Modal-schließen-Btn erkannt");
  element.addEventListener('click', function (event) {
    console.log("Modal schließen Event");
    Modal.closeCurrentModal();
  });
});

/***/ }),

/***/ "./source/popover/popover.js":
/*!***********************************!*\
  !*** ./source/popover/popover.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Popover)
/* harmony export */ });
/* harmony import */ var _component_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../component/component */ "./source/component/component.js");
/* harmony import */ var _util_reflow__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/reflow */ "./source/util/reflow.js");
/* harmony import */ var _util_closest__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util/closest */ "./source/util/closest.js");
/* harmony import */ var _util_transition_end_event__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../util/transition-end-event */ "./source/util/transition-end-event.js");
/* harmony import */ var tether__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! tether */ "./node_modules/tether/dist/js/tether.esm.js");
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }





var SELECTOR_COMPONENT = '.ci-js-popover';
var SELECTOR_DISMISS = '[data-dismiss="popover"]';
var CLASS_ARROW = 'ci-popover-arrow';
var CLASS_ARROW_SHAPE = 'ci-popover-arrow-shape';
var CLASS_ACTIVE = 'is-active';
var CLASS_SHOWN = 'is-shown';
var CLASS_POPOVER_IS_OPEN = 'ci-popover-is-open';
var ARROW_SIZE = 20;
var AttachmentMap = {
  top: 'bottom center',
  right: 'middle left',
  bottom: 'top center',
  left: 'middle right'
};

/**
 * Class constructor for Popover AUI component.
 * Implements AUI component design pattern defined at:
 * https://github.com/...
 *
 * @param {HTMLElement} element The element that will be upgraded.
 */
var Popover = /*#__PURE__*/function (_Component) {
  _inherits(Popover, _Component);
  var _super = _createSuper(Popover);
  function Popover() {
    _classCallCheck(this, Popover);
    return _super.apply(this, arguments);
  }
  _createClass(Popover, [{
    key: "init",
    value:
    /**
     * Initialize component
     */
    function init() {
      var _this = this;
      _get(_getPrototypeOf(Popover.prototype), "init", this).call(this);
      this._body = document.querySelector('body');
      this._id = this._element.getAttribute('id');
      this._trigger = document.getElementById(this._element.getAttribute('for'));
      this._tether = null;
      var placement = this._element.hasAttribute('data-placement') ? this._element.getAttribute('data-placement') : 'top';
      this._attachement = AttachmentMap[placement.toLowerCase()];
      var content = this._element.querySelector('.ci-popover-content');
      var arrowColor = this._element.hasAttribute('data-arrow-color') ? this._element.getAttribute('data-arrow-color') : window.getComputedStyle(content).backgroundColor;
      this._arrow = this._addArrow(content, arrowColor);
      if (this._trigger) {
        this._trigger.addEventListener('click', this._boundClickHandler = function (event) {
          return _this.toggle(event);
        });
      }
    }

    /**
     * Dispose component
     */
  }, {
    key: "dispose",
    value: function dispose() {
      _get(_getPrototypeOf(Popover.prototype), "dispose", this).call(this);
      this.hide();
      this.removeChild(this._arrow);
      if (this._trigger) {
        this._trigger.removeEventListener('click', this._boundClickHandler);
      }
    }

    /**
     * Toggle show/hide Popover
     * @param {Event} event Click event of trigger element (optional)
     */
  }, {
    key: "toggle",
    value: function toggle(event) {
      var _this2 = this;
      var performToggle = function performToggle() {
        if (!_this2._element.classList.contains(CLASS_ACTIVE) && _this2._tether) {
          _this2.show();
        } else {
          _this2.hide();
        }
      };
      if (event) {
        event.preventDefault();
        if (this._tether === null) {
          this._tether = new tether__WEBPACK_IMPORTED_MODULE_4__["default"]({
            element: this._element,
            target: event.currentTarget,
            attachment: this._attachement,
            classPrefix: 'ci-tether',
            // NOTE We set an offset in CSS, because this offset wouln't be
            // flipped as it should:
            // https://github.com/HubSpot/tether/issues/106
            offset: '0 0',
            constraints: [{
              to: 'window',
              pin: ['left', 'right'],
              attachment: 'together'
            }],
            optimizations: {
              gpu: false
            }
          });
          (0,_util_reflow__WEBPACK_IMPORTED_MODULE_1__["default"])(this._element); // TODO Do we need this anymore?
          this._tether.position();
        }
        performToggle();
      } else {
        performToggle();
      }
    }

    /**
     * Show Popover
     */
  }, {
    key: "show",
    value: function show() {
      var _this3 = this;
      this._body.classList.add(CLASS_POPOVER_IS_OPEN);
      this._element.classList.add(CLASS_ACTIVE);
      this._element.classList.add(CLASS_SHOWN);
      setTimeout(function () {
        window.addEventListener('click', _this3._boundWindowClickHandler = function (event) {
          return _this3._onClickOutside(event);
        });
      });
    }

    /**
     * Hide Popover
     */
  }, {
    key: "hide",
    value: function hide() {
      var _this4 = this;
      this._element.classList.remove(CLASS_SHOWN);
      this._element.addEventListener(_util_transition_end_event__WEBPACK_IMPORTED_MODULE_3__["default"], this._boundAnimationendHandler = function (event) {
        return _this4._onHideComplete(event);
      });
      // this._cleanupTether();
      window.removeEventListener('click', this._boundWindowClickHandler);
    }

    /**
     * Clean up Tether instance
     * @private
     */
  }, {
    key: "_cleanupTether",
    value: function _cleanupTether() {
      if (this._tether) {
        this._tether.destroy();
        this._tether = null;
      }
      this._element.removeAttribute('style');
    }

    /**
     * Handle click of window.
     * @param {Event} event The event that fired.
     * @private
     */
  }, {
    key: "_onClickOutside",
    value: function _onClickOutside(event) {
      // Hide if target dismisses Popover
      if ((0,_util_closest__WEBPACK_IMPORTED_MODULE_2__["default"])(event.target, SELECTOR_DISMISS, this._element)) {
        this.hide();

        // Hide if target is not inside Popover and not trigger element
      } else if (!this._element.contains(event.target) && event.target !== this._trigger) {
        this.hide();
      }
    }

    /**
     * Handle hide transition complete.
     * @param {Event} event The event that fired.
     * @private
     */
  }, {
    key: "_onHideComplete",
    value: function _onHideComplete(event) {
      this._body.classList.remove(CLASS_POPOVER_IS_OPEN);
      this._element.classList.remove(CLASS_ACTIVE);
      this._element.removeEventListener(_util_transition_end_event__WEBPACK_IMPORTED_MODULE_3__["default"], this._boundAnimationendHandler);
      this._cleanupTether();
    }

    /**
     * Adds an arrow SVG element
     * <span class="…"><svg … ><path … /></svg></span>
     *
     * @param {HTMLElement} parent element to append arrow to.
     * @param {string} color used as value of fill property.
     * @returns {HTMLElement} the added arrow element.
     */
  }, {
    key: "_addArrow",
    value: function _addArrow(parent, color) {
      var element = document.createElement('span');
      element.classList.add(CLASS_ARROW);
      var svg = this.createSvgNode('svg', {
        class: CLASS_ARROW_SHAPE,
        width: ARROW_SIZE,
        height: ARROW_SIZE,
        viewBox: "0 0 ".concat(ARROW_SIZE, " ").concat(ARROW_SIZE)
      });
      // Draw a diamond square ◆
      var path = this.createSvgNode('path', {
        d: "M".concat(ARROW_SIZE / 2, " 0 L ").concat(ARROW_SIZE, " ").concat(ARROW_SIZE / 2, " L ").concat(ARROW_SIZE / 2, " ").concat(ARROW_SIZE, " L 0 ").concat(ARROW_SIZE / 2, " Z"),
        fill: color
      });
      svg.appendChild(path);
      element.appendChild(svg);
      parent.appendChild(element);
      return element;
    }
  }], [{
    key: "upgradeElements",
    value:
    /**
     * Upgrades all Popover AUI components.
     * @returns {Array} Returns an array of all newly upgraded components.
     */
    function upgradeElements() {
      var components = [];
      Array.from(document.querySelectorAll(SELECTOR_COMPONENT)).forEach(function (element) {
        if (!_component_component__WEBPACK_IMPORTED_MODULE_0__["default"].isElementUpgraded(element)) {
          components.push(new Popover(element));
        }
      });
      return components;
    }
  }]);
  return Popover;
}(_component_component__WEBPACK_IMPORTED_MODULE_0__["default"]);


/***/ }),

/***/ "./source/progress/progress.js":
/*!*************************************!*\
  !*** ./source/progress/progress.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Progress)
/* harmony export */ });
/* harmony import */ var _component_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../component/component */ "./source/component/component.js");
/* harmony import */ var _util_limit__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/limit */ "./source/util/limit.js");
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }


var SELECTOR_COMPONENT = '.ci-js-progress';
var CLASS_CONTINUOUS = 'ci-progress-continuous';
var CLASS_BAR = 'ci-progress-bar';
var CLASS_IS_PENDING = 'is-pending';
var CLASS_IS_LOADING = 'is-loading';
var CLASS_IS_COMPLETE = 'is-complete';

/**
 * Class constructor for Progress AUI component.
 * Implements AUI component design pattern defined at:
 * https://github.com/...
 *
 * @param {HTMLElement} element The element that will be upgraded.
 */
var Progress = /*#__PURE__*/function (_Component) {
  _inherits(Progress, _Component);
  var _super = _createSuper(Progress);
  function Progress(element) {
    _classCallCheck(this, Progress);
    return _super.call(this, element);
  }
  _createClass(Progress, [{
    key: "init",
    value: function init() {
      _get(_getPrototypeOf(Progress.prototype), "init", this).call(this);
      this._continuous = this._element.classList.contains(CLASS_CONTINUOUS);

      // Add bar elements:
      this._bar = document.createElement('span');
      this._bar.classList.add(CLASS_BAR);
      this._element.appendChild(this._bar);
      if (this._continuous) {
        this.progress(0);
      } else {
        this._progressvalue = this._element.getAttribute("data-progress-value");
        this.progress(this._progressvalue / 100);
      }
    }
  }, {
    key: "progress",
    value: function progress(ratio) {
      ratio = (0,_util_limit__WEBPACK_IMPORTED_MODULE_1__["default"])(ratio, 0, 1);
      this._progress = ratio;
      if (!this._continuous) {
        this._bar.style.width = "".concat(this._progress * 100, "%");
      }
      this.updateClasses();
    }
  }, {
    key: "updateClasses",
    value: function updateClasses() {
      if (this._progress === 0) {
        this._element.classList.add(CLASS_IS_PENDING);
      } else {
        this._element.classList.remove(CLASS_IS_PENDING);
      }
      if (this._progress > 0 && this._progress < 1) {
        this._element.classList.add(CLASS_IS_LOADING);
      } else {
        this._element.classList.remove(CLASS_IS_LOADING);
      }
      if (this._progress === 1) {
        this._element.classList.add(CLASS_IS_COMPLETE);
      } else {
        this._element.classList.remove(CLASS_IS_COMPLETE);
      }
    }
  }], [{
    key: "upgradeElements",
    value:
    /**
     * Upgrades all Progress AUI components.
     * @returns {Array} Returns an array of all newly upgraded components.
     */
    function upgradeElements() {
      var components = [];
      Array.from(document.querySelectorAll(SELECTOR_COMPONENT)).forEach(function (element) {
        if (!_component_component__WEBPACK_IMPORTED_MODULE_0__["default"].isElementUpgraded(element)) {
          components.push(new Progress(element));
        }
      });
      return components;
    }
  }]);
  return Progress;
}(_component_component__WEBPACK_IMPORTED_MODULE_0__["default"]);


/***/ }),

/***/ "./source/radio/radio.js":
/*!*******************************!*\
  !*** ./source/radio/radio.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Radio)
/* harmony export */ });
/* harmony import */ var _component_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../component/component */ "./source/component/component.js");
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var SELECTOR_COMPONENT = '.ci-js-radio';
var CLASS_INPUT = 'ci-radio-input';
var CLASS_LABEL = 'ci-radio-label';
var CLASS_BOX = 'ci-radio-box';
var CLASS_TICK = 'ci-radio-tick';
var CLASS_IS_FOCUS = 'is-focused';
var CLASS_IS_CHECKED = 'is-checked';
var CLASS_IS_DISABLED = 'is-disabled';
var _radios = [];

/**
 * Class constructor for Radio AUI component.
 * Implements AUI component design pattern defined at:
 * https://github.com/...
 *
 * @param {HTMLElement} element The element that will be upgraded.
 */
var Radio = /*#__PURE__*/function (_Component) {
  _inherits(Radio, _Component);
  var _super = _createSuper(Radio);
  function Radio() {
    _classCallCheck(this, Radio);
    return _super.apply(this, arguments);
  }
  _createClass(Radio, [{
    key: "init",
    value: function init() {
      var _this = this;
      _get(_getPrototypeOf(Radio.prototype), "init", this).call(this);
      this._input = this._element.querySelector(".".concat(CLASS_INPUT));
      this._input.addEventListener('change', this._changeHandler = function (event) {
        return _this._onChange(event);
      });
      this._input.addEventListener('focus', this._focusHandler = function (event) {
        return _this._onFocus(event);
      });
      this._input.addEventListener('blur', this._blurHandler = function (event) {
        return _this._onBlur(event);
      });

      // Insert box with tick after label element:
      this._label = this._element.querySelector(".".concat(CLASS_LABEL));
      var box = document.createElement('span');
      box.classList.add(CLASS_BOX);
      this._label.parentNode.insertBefore(box, this._label.nextSibling);
      var tick = document.createElement('span');
      tick.classList.add(CLASS_TICK);
      box.appendChild(tick);
      this.groupName = this._input.getAttribute('name');
      this.updateClasses();
    }
  }, {
    key: "updateClasses",
    value: function updateClasses() {
      this.checkDisabled();
      this.checkToggleState();
      this.checkFocus();
    }

    /**
     * Check the disabled state and update field accordingly.
     */
  }, {
    key: "checkDisabled",
    value: function checkDisabled() {
      if (this._input.disabled) {
        this._element.classList.add(CLASS_IS_DISABLED);
      } else {
        this._element.classList.remove(CLASS_IS_DISABLED);
      }
    }

    /**
     * Check the toggle state and update field accordingly.
     */
  }, {
    key: "checkToggleState",
    value: function checkToggleState() {
      if (this._input.checked) {
        this._element.classList.add(CLASS_IS_CHECKED);
      } else {
        this._element.classList.remove(CLASS_IS_CHECKED);
      }
    }

    /**
     * Check the focus state and update field accordingly.
     */
  }, {
    key: "checkFocus",
    value: function checkFocus() {
      if (Boolean(this._element.querySelector(':focus'))) {
        this._element.classList.add(CLASS_IS_FOCUS);
      } else {
        this._element.classList.remove(CLASS_IS_FOCUS);
      }
    }

    /**
     * Enable radio.
     */
  }, {
    key: "enable",
    value: function enable() {
      this._input.disabled = false;
      this.updateClasses();
    }

    /**
     * Disable radio.
     */
  }, {
    key: "disable",
    value: function disable() {
      this._input.disabled = true;
      this.updateClasses();
    }

    /**
     * Check radio.
     */
  }, {
    key: "check",
    value: function check() {
      this._input.checked = true;
      this.updateClasses();
    }

    /**
     * Uncheck radio.
     */
  }, {
    key: "uncheck",
    value: function uncheck() {
      this._input.checked = false;
      this.updateClasses();
    }

    /**
     * Dispose component
     */
  }, {
    key: "dispose",
    value: function dispose() {
      _get(_getPrototypeOf(Radio.prototype), "dispose", this).call(this);
      this._input.removeEventListener('change', this._changeHandler);
      this._input.removeEventListener('focus', this._focusHandler);
      this._input.removeEventListener('blur', this._blurHandler);
      this._element.removeChild(this._element.querySelector(".".concat(CLASS_BOX)));
    }

    /**
     * Handle change event.
     * @param {Event} event that fired.
     */
  }, {
    key: "_onChange",
    value: function _onChange(event) {
      this.updateClasses();
      // Since other radio buttons don't get change events, we need to look for
      // them to update their classes.
      for (var i = 0; i < _radios.length; i++) {
        var button = _radios[i];
        // Different name == different group, so no point updating those.
        if (button._input.getAttribute('name') === this.groupName) {
          button.updateClasses();
        }
      }
    }

    // TODO Find out why unfocus is triggered on mousedown
  }, {
    key: "_onFocus",
    value: function _onFocus(event) {
      this._element.classList.add(CLASS_IS_FOCUS);
    }
  }, {
    key: "_onBlur",
    value: function _onBlur(event) {
      this._element.classList.remove(CLASS_IS_FOCUS);
    }

    /**
     * Getter and Setter
     */
  }, {
    key: "input",
    get: function get() {
      return this._input;
    }
  }, {
    key: "checked",
    get: function get() {
      return this._input.checked = true;
    },
    set: function set(value) {
      if (value) {
        this.check();
      } else {
        this.uncheck();
      }
    }
  }, {
    key: "disabled",
    get: function get() {
      return this._input.disabled = true;
    },
    set: function set(value) {
      if (value) {
        this.disable();
      } else {
        this.enable();
      }
    }
  }], [{
    key: "upgradeElements",
    value:
    /**
     * Upgrades all Radio AUI components.
     * @returns {Array} Returns an array of all newly upgraded components.
     */
    function upgradeElements() {
      var components = [];
      Array.from(document.querySelectorAll(SELECTOR_COMPONENT)).forEach(function (element) {
        if (!_component_component__WEBPACK_IMPORTED_MODULE_0__["default"].isElementUpgraded(element)) {
          components.push(new Radio(element));
        }
      });
      _radios = _radios.concat(components);
      return components;
    }
  }]);
  return Radio;
}(_component_component__WEBPACK_IMPORTED_MODULE_0__["default"]);


/***/ }),

/***/ "./source/response/response.js":
/*!*************************************!*\
  !*** ./source/response/response.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Response)
/* harmony export */ });
/* harmony import */ var _component_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../component/component */ "./source/component/component.js");
/* harmony import */ var _util_animation_end_event__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/animation-end-event */ "./source/util/animation-end-event.js");
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }


var SELECTOR_COMPONENT = '.js-response';
var CLASS_BUTTON_PRIMARY = 'primary';
var CLASS_BUTTON_SECONDARY = 'secondary';
var CLASS_BUTTON_ICON = 'button-icon';
var CLASS_BUTTON_FLOATING = 'button-floating';
var CLASS_RESPONSE = 'response';
var CLASS_RESPONSE_MASKED = 'response-masked';
var CLASS_EFFECT = 'response-effect';
var CLASS_EFFECT_LARGE = 'response-effect-large';
var CLASS_IS_ANIMATING = 'animating';
var CLASS_IS_DISABLED = 'is-disabled';

/**
 * Class constructor for Response AUI component.
 * Implements AUI component design pattern defined at:
 * https://github.com/...
 *
 * @param {HTMLElement} element The element that will be upgraded.
 */
var Response = /*#__PURE__*/function (_Component) {
  _inherits(Response, _Component);
  var _super = _createSuper(Response);
  /**
   * Constructor
   * @constructor
   * @param {HTMLElement} element The element of the AUI component.
   */
  function Response(element) {
    _classCallCheck(this, Response);
    return _super.call(this, element);
  }

  /**
   * Initialize component
   */
  _createClass(Response, [{
    key: "init",
    value: function init() {
      var _this = this;
      _get(_getPrototypeOf(Response.prototype), "init", this).call(this);
      var boxedButton = this._element.classList.contains(CLASS_BUTTON_PRIMARY) || this._element.classList.contains(CLASS_BUTTON_SECONDARY) || this._element.classList.contains(CLASS_BUTTON_FLOATING);
      this._useTriggerX = boxedButton || !this._element.classList.contains(CLASS_BUTTON_ICON);
      this._useTriggerY = boxedButton;
      this._masked = boxedButton;
      this._large = boxedButton;
      this._responseContainer = document.createElement('span');
      this._responseContainer.classList.add(CLASS_RESPONSE);
      if (this._masked) {
        this._responseContainer.classList.add(CLASS_RESPONSE_MASKED);
      }
      this._element.appendChild(this._responseContainer);
      this._responseEffect = document.createElement('span');
      this._responseEffect.classList.add(CLASS_EFFECT);
      if (this._large) {
        this._responseEffect.classList.add(CLASS_EFFECT_LARGE);
      }
      this._responseContainer.appendChild(this._responseEffect);
      this._element.addEventListener('mousedown', this._mousedownHandler = function (event) {
        return _this._onMousedown(event);
      });
      _util_animation_end_event__WEBPACK_IMPORTED_MODULE_1__["default"] && this._responseEffect.addEventListener(_util_animation_end_event__WEBPACK_IMPORTED_MODULE_1__["default"], this._animationendHandler = function (event) {
        return _this._onAnimationend(event);
      });
    }

    /**
     * Dispose component
     */
  }, {
    key: "dispose",
    value: function dispose() {
      _get(_getPrototypeOf(Response.prototype), "dispose", this).call(this);
      this._element.removeEventListener('mousedown', this._mousedownHandler);
      if (_util_animation_end_event__WEBPACK_IMPORTED_MODULE_1__["default"] && this._responseEffect) {
        this._responseEffect.removeEventListener(_util_animation_end_event__WEBPACK_IMPORTED_MODULE_1__["default"], this._animationendHandler);
      }
      this._element.removeChild(this._responseContainer);
    }

    /**
     * Handle mousedown of element.
     * @param {Event} event The event that fired.
     * @private
     */
  }, {
    key: "_onMousedown",
    value: function _onMousedown(event) {
      // Get cross-browser offsetX, offsetY
      var target = event.currentTarget || event.srcElement,
        rect = target.getBoundingClientRect(),
        offsetX = event.clientX - rect.left,
        offsetY = event.clientY - rect.top;
      if (!target.classList.contains(CLASS_IS_DISABLED)) {
        this._responseEffect.style.left = this._useTriggerX ? "".concat(offsetX, "px") : '50%';
        this._responseEffect.style.top = this._useTriggerY ? "".concat(offsetY, "px") : '50%';
        this._responseContainer.classList.add(CLASS_IS_ANIMATING);
      }
    }

    /**
     * Handle animationend of element.
     * @param {Event} event The event that fired.
     * @private
     */
  }, {
    key: "_onAnimationend",
    value: function _onAnimationend(event) {
      this._responseContainer.classList.remove(CLASS_IS_ANIMATING);
    }
  }], [{
    key: "upgradeElements",
    value:
    /**
     * Upgrades all Response AUI components.
     * @returns {Array} Returns an array of all newly upgraded components.
     */
    function upgradeElements() {
      var components = [];
      Array.from(document.querySelectorAll(SELECTOR_COMPONENT)).forEach(function (element) {
        if (!_component_component__WEBPACK_IMPORTED_MODULE_0__["default"].isElementUpgraded(element)) {
          components.push(new Response(element));
        }
      });
      return components;
    }
  }]);
  return Response;
}(_component_component__WEBPACK_IMPORTED_MODULE_0__["default"]);


/***/ }),

/***/ "./source/select/select.js":
/*!*********************************!*\
  !*** ./source/select/select.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Select)
/* harmony export */ });
/* harmony import */ var _component_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../component/component */ "./source/component/component.js");
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var SELECTOR_COMPONENT = '.ci-js-select';
var CLASS_INPUT = 'ci-select-input';
var CLASS_LABEL = 'ci-select-label';
var CLASS_FOCUS_LINE = 'ci-select-focus-line';
var CLASS_IS_FOCUS = 'is-focused';
var CLASS_IS_DIRTY = 'is-dirty';
var CLASS_IS_DISABLED = 'is-disabled';

/**
 * Class constructor for Select AUI component.
 * Implements AUI component design pattern defined at:
 * https://github.com/...
 *
 * @param {HTMLElement} element The element that will be upgraded.
 */
var Select = /*#__PURE__*/function (_Component) {
  _inherits(Select, _Component);
  var _super = _createSuper(Select);
  function Select(element) {
    _classCallCheck(this, Select);
    return _super.call(this, element);
  }
  _createClass(Select, [{
    key: "init",
    value: function init() {
      var _this = this;
      _get(_getPrototypeOf(Select.prototype), "init", this).call(this);
      this._label = this._element.querySelector(".".concat(CLASS_LABEL));
      this._input = this._element.querySelector(".".concat(CLASS_INPUT));
      this._input.addEventListener('change', this._changeHandler = function (event) {
        return _this._onChange(event);
      });
      this._input.addEventListener('focus', this._focusHandler = function (event) {
        return _this._onFocus(event);
      });
      this._input.addEventListener('blur', this._blurHandler = function (event) {
        return _this._onBlur(event);
      });
      this._input.addEventListener('reset', this._resetHandler = function (event) {
        return _this._onReset(event);
      });

      // Insert thick focus line after select element:
      var focusLine = document.createElement('span');
      focusLine.classList.add(CLASS_FOCUS_LINE);
      this._label.parentNode.insertBefore(focusLine, this._label.nextSibling);
      this.updateClasses();
    }
  }, {
    key: "updateClasses",
    value: function updateClasses() {
      this.checkDisabled();
      this.checkDirty();
      this.checkFocus();
    }

    /**
     * Check the disabled state and update field accordingly.
     */
  }, {
    key: "checkDisabled",
    value: function checkDisabled() {
      if (this._input.disabled) {
        this._element.classList.add(CLASS_IS_DISABLED);
      } else {
        this._element.classList.remove(CLASS_IS_DISABLED);
      }
    }

    /**
     * Check the dirty state and update field accordingly.
     */
  }, {
    key: "checkDirty",
    value: function checkDirty() {
      // console.log('value', this._input.value, typeof this._input.value);
      // console.log('options', this._input.options[this._input.selectedIndex].disabled);
      if (!this._input.options[this._input.selectedIndex].disabled) {
        this._element.classList.add(CLASS_IS_DIRTY);
      } else {
        this._element.classList.remove(CLASS_IS_DIRTY);
      }
    }

    /**
     * Check the focus state and update field accordingly.
     */
  }, {
    key: "checkFocus",
    value: function checkFocus() {
      if (Boolean(this._element.querySelector(':focus'))) {
        this._element.classList.add(CLASS_IS_FOCUS);
      } else {
        this._element.classList.remove(CLASS_IS_FOCUS);
      }
    }

    /**
     * Disable text field.
     */
  }, {
    key: "disable",
    value: function disable() {
      this._input.disabled = true;
      this.updateClasses();
    }

    /**
     * Event Handler
     */
  }, {
    key: "_onChange",
    value: function _onChange(event) {
      this.updateClasses();
    }
  }, {
    key: "_onFocus",
    value: function _onFocus(event) {
      this._element.classList.add(CLASS_IS_FOCUS);
    }
  }, {
    key: "_onBlur",
    value: function _onBlur(event) {
      this._element.classList.remove(CLASS_IS_FOCUS);
    }
  }, {
    key: "_onReset",
    value: function _onReset(event) {
      this.updateClasses();
    }
  }], [{
    key: "upgradeElements",
    value:
    /**
     * Upgrades all Select AUI components.
     * @returns {Array} Returns an array of all newly upgraded components.
     */
    function upgradeElements() {
      var components = [];
      Array.from(document.querySelectorAll(SELECTOR_COMPONENT)).forEach(function (element) {
        if (!_component_component__WEBPACK_IMPORTED_MODULE_0__["default"].isElementUpgraded(element)) {
          components.push(new Select(element));
        }
      });
      return components;
    }
  }]);
  return Select;
}(_component_component__WEBPACK_IMPORTED_MODULE_0__["default"]);


/***/ }),

/***/ "./source/slider/slider.js":
/*!*********************************!*\
  !*** ./source/slider/slider.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Slider)
/* harmony export */ });
/* harmony import */ var _component_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../component/component */ "./source/component/component.js");
/* harmony import */ var _util_limit__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/limit */ "./source/util/limit.js");
/* harmony import */ var _util_map_linear__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util/map-linear */ "./source/util/map-linear.js");
/* harmony import */ var _util_resize_observer__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../util/resize-observer */ "./source/util/resize-observer.js");
/* harmony import */ var nouislider__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! nouislider */ "./node_modules/nouislider/distribute/nouislider.js");
/* harmony import */ var nouislider__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(nouislider__WEBPACK_IMPORTED_MODULE_4__);
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
/**
 * NOTE Slider AUI components rely on the 3rd party library noUiSlider.
 * @see https://github.com/leongersen/noUiSlider
 */






var SELECTOR_COMPONENT = '.ci-js-slider';
var SELECTOR_HIDDEN_FIELD = '.ci-slider-hidden-field';
var SELECTOR_OUTPUT = '.ci-slider-output';
var CLASS_COMPONENT = 'ci-slider';
var CLASS_IS_DISABLED = 'is-disabled';
var EVENT_NAMESPACE = CLASS_COMPONENT;

/**
 * Class constructor for Slider AUI component.
 * Implements AUI component design pattern defined at:
 * https://github.com/...
 *
 * @param {HTMLElement} element The element that will be upgraded.
 */
var Slider = /*#__PURE__*/function (_Component) {
  _inherits(Slider, _Component);
  var _super = _createSuper(Slider);
  function Slider() {
    _classCallCheck(this, Slider);
    return _super.apply(this, arguments);
  }
  _createClass(Slider, [{
    key: "init",
    value:
    /**
     * Initialize component
     */
    function init() {
      var _this = this;
      _get(_getPrototypeOf(Slider.prototype), "init", this).call(this);

      // Save reference to component elements
      this._hiddenField = this._element.querySelector(SELECTOR_HIDDEN_FIELD);
      this._output = this._element.querySelector(SELECTOR_OUTPUT);

      // Create slider container element
      this._slider = document.createElement('div');
      this._element.insertBefore(this._slider, this._element.firstChild);

      // Parse and save start and range values:
      this._value = this._parseData(this._hiddenField.value);
      this._rangeMin = this._parseData(this._element.getAttribute('data-min'));
      this._rangeMax = this._parseData(this._element.getAttribute('data-max'));

      // Create noUiSlider instance
      nouislider__WEBPACK_IMPORTED_MODULE_4___default().create(this._slider, {
        // Set the start value defined in the hidden field.
        // https://refreshless.com/nouislider/slider-options/#section-start
        start: this._value,
        // Set the range as defined in the data attributes
        // https://refreshless.com/nouislider/slider-values/#section-range
        range: {
          min: this._rangeMin,
          max: this._rangeMax
        },
        // If there are two handles, set the bar between the handles, but not
        // between the handles and the sliders edges. If there is only one handle,
        // set the bar from the slider edge to the handle.
        // https://refreshless.com/nouislider/slider-options/#section-Connect
        connect: this._value.length > 1 ? true : [true, false],
        // Define behaviour depending on number of handles
        // https://refreshless.com/nouislider/behaviour-option/
        behaviour: this._value.length > 1 ? 'tap-drag' : 'tap',
        // Use AUI namespace for css classes
        // https://refreshless.com/nouislider/more/#section-styling
        cssPrefix: "".concat(CLASS_COMPONENT, "-")
      });
      this._slider.noUiSlider.on("update.".concat(EVENT_NAMESPACE), function (values, handle, unencoded, tap, positions) {
        return _this._onUpdate(values, handle, unencoded, tap, positions);
      });
      if (this._output) {
        this._resizeObserver = new _util_resize_observer__WEBPACK_IMPORTED_MODULE_3__["default"]();
        this._resizeObserver.resized.add(this._resizedHandler = function () {
          return _this._centerOutput();
        });
      }
      if (this._element.classList.contains(CLASS_IS_DISABLED)) {
        this.disable();
      }
    }

    /**
     * Dispose component
     */
  }, {
    key: "dispose",
    value: function dispose() {
      if (this._slider) {
        this._slider.noUiSlider.off(".".concat(EVENT_NAMESPACE));
      }
      if (this._resizeObserver) {
        this._resizeObserver.resized.remove(this._resizedHandler);
        this._resizeObserver = null;
      }
    }

    /**
     * Enable component
     */
  }, {
    key: "enable",
    value: function enable() {
      this._element.classList.remove(CLASS_IS_DISABLED);
      this._slider.removeAttribute('disabled');
    }

    /**
     * Disable component
     */
  }, {
    key: "disable",
    value: function disable() {
      this._element.classList.add(CLASS_IS_DISABLED);
      this._slider.setAttribute('disabled', true);
    }

    /**
     * Handle on update
     * @param {Array} values Current slider values
     * @param {Integer} handle Handle that caused the event 0 or 1
     * @param {Array} unencoded Slider values without formatting
     * @param {boolean} tap Event was caused by the user tapping the slider
     * @param {Array} positions Left offset of the handles in relation to the slider
     */
  }, {
    key: "_onUpdate",
    value: function _onUpdate(values, handle, unencoded, tap, positions) {
      if (this._hiddenField) {
        this._hiddenField.value = unencoded;
      }

      // Position output to center of slider handles
      if (this._output) {
        this._output.innerHTML = values.length > 1 ? "".concat(values[0], " to ").concat(values[1]) : "".concat(values[0]);
        this._centerOutput();
      }
    }

    /**
     * Center output bewteen handles.
     */
  }, {
    key: "_centerOutput",
    value: function _centerOutput() {
      var unencoded = this._slider.noUiSlider.get();
      var sliderAverage = _typeof(unencoded) === 'object' ? unencoded.reduce(function (previousValue, currentValue) {
        return previousValue + parseFloat(currentValue);
      }, 0) / unencoded.length : parseFloat(unencoded);
      var maxRight = this._element.offsetWidth - this._output.offsetWidth;
      var handleSize = this._slider.offsetHeight;
      var position = (0,_util_map_linear__WEBPACK_IMPORTED_MODULE_2__["default"])(sliderAverage, this._rangeMin, this._rangeMax, 0, 1) * this._slider.offsetWidth - this._output.offsetWidth / 2 + handleSize / 2;
      this._output.style.left = "".concat((0,_util_limit__WEBPACK_IMPORTED_MODULE_1__["default"])(position, 0, maxRight), "px");
    }

    /**
     * Parse data to use with noUiSlider
     * Returns given value as array of floats
     * "0,100" => [0,100]
     * @param {string} value Current slider values
     * @returns {Array} values as floats
     */
  }, {
    key: "_parseData",
    value: function _parseData(value) {
      return value && value.split(',').map(function (element) {
        return parseFloat(element);
      });
    }
  }], [{
    key: "upgradeElements",
    value:
    /**
     * Upgrades all Slider AUI components.
     * @returns {Array} Returns an array of all newly upgraded components.
     */
    function upgradeElements() {
      var components = [];
      Array.from(document.querySelectorAll(SELECTOR_COMPONENT)).forEach(function (element) {
        if (!_component_component__WEBPACK_IMPORTED_MODULE_0__["default"].isElementUpgraded(element)) {
          components.push(new Slider(element));
        }
      });
      return components;
    }
  }]);
  return Slider;
}(_component_component__WEBPACK_IMPORTED_MODULE_0__["default"]);


/***/ }),

/***/ "./source/spinner/spinner.js":
/*!***********************************!*\
  !*** ./source/spinner/spinner.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Spinner)
/* harmony export */ });
/* harmony import */ var _component_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../component/component */ "./source/component/component.js");
/* harmony import */ var _util_object_resize__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/object-resize */ "./source/util/object-resize.js");
/* harmony import */ var _util_limit__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util/limit */ "./source/util/limit.js");
/* harmony import */ var bezier_easing__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! bezier-easing */ "./node_modules/bezier-easing/src/index.js");
/* harmony import */ var bezier_easing__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(bezier_easing__WEBPACK_IMPORTED_MODULE_3__);
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }




var SELECTOR_COMPONENT = '.ci-js-spinner';
var CLASS_CONTINUOUS = 'ci-spinner-continuous';
var CLASS_SHAPE = 'ci-spinner-svg';
var CLASS_PATH = 'ci-spinner-path';
var CLASS_PATH_PROGRESS = 'ci-spinner-path-progress';
var CLASS_GROUP = 'ci-spinner-group';
var CLASS_GROUP_BASE_PATH = 'ci-spinner-group-base';
var CLASS_GROUP_PROGRESS_PATH = 'ci-spinner-group-progress';
var CLASS_VALUE = 'ci-spinner-value';
var CLASS_IS_PENDING = 'is-pending';
var CLASS_IS_LOADING = 'is-loading';
var CLASS_IS_COMPLETE = 'is-complete';
var CLASS_HAS_SVG = 'has-svg';
var SIZE = 48;
var RADIUS = 22;
var STROKE_WIDTH = 3;
var LOOP_ANIMATION_DURATION = 1.5;
var LOOP_ANIMATION = [{
  dashLength: 0,
  dashOffset: 0,
  rotate: 0
}, {
  dashLength: 0.65,
  dashOffset: -1,
  rotate: 360
}];

/**
 * Class constructor for Spinner AUI component.
 * Implements AUI component design pattern defined at:
 * https://github.com/...
 *
 * @param {HTMLElement} element The element that will be upgraded.
 */
var Spinner = /*#__PURE__*/function (_Component) {
  _inherits(Spinner, _Component);
  var _super = _createSuper(Spinner);
  function Spinner(element) {
    _classCallCheck(this, Spinner);
    return _super.call(this, element);
  }
  _createClass(Spinner, [{
    key: "init",
    value: function init() {
      _get(_getPrototypeOf(Spinner.prototype), "init", this).call(this);
      this._objectResize = new _util_object_resize__WEBPACK_IMPORTED_MODULE_1__["default"](this._element, this.resize, this);
      this._continuous = this._element.classList.contains(CLASS_CONTINUOUS);

      // Add value element, if required:
      if (!this._continuous) {
        this._value = document.createElement('span');
        this._value.classList.add(CLASS_VALUE);
        this._element.appendChild(this._value);
        this._progressvalue = this._element.getAttribute("data-progress-value");
      }
      var shape, group, groupCircle1, groupCircle2, circle1, circle2;
      if (!this._element.classList.contains(CLASS_HAS_SVG)) {
        // Add SVG graphic:
        // <svg class="ci-spinner-shape" viewBox="0 0 200 200">
        //   <g class="ci-spinner-group">
        //     <circle class="ci-spinner-path" cx="0" cy="0" r="100" />
        //     <circle class="ci-spinner-path ci-spinner-path-progress" cx="0" cy="0" r="100" />
        //   </g>
        // </svg>
        shape = this.createSvgNode('svg', {
          class: CLASS_SHAPE,
          viewBox: "0 0 ".concat(SIZE, " ").concat(SIZE)
        });
        group = this.createSvgNode('g', {
          class: CLASS_GROUP
        });
        groupCircle1 = this.createSvgNode('g', {
          class: CLASS_GROUP_BASE_PATH
        });
        groupCircle2 = this.createSvgNode('g', {
          class: CLASS_GROUP_PROGRESS_PATH
        });
        circle1 = this.createSvgNode('circle', {
          class: CLASS_PATH,
          cx: 0,
          cy: 0,
          r: RADIUS
        });
        circle2 = this.createSvgNode('circle', {
          class: "".concat(CLASS_PATH, " ").concat(CLASS_PATH_PROGRESS),
          cx: 0,
          cy: 0,
          r: RADIUS,
          transform: 'rotate(-90)'
        });
        groupCircle1.appendChild(circle1);
        groupCircle2.appendChild(circle2);
        group.appendChild(groupCircle1);
        group.appendChild(groupCircle2);
        shape.appendChild(group);
        this._element.appendChild(shape);
      } else {
        // BENUTZE VORHANDENES SVG:
        shape = this._element.getElementsByTagName("svg")[0];
        group = shape.getElementsByTagName("g")[0];
        groupCircle1 = group.getElementsByTagName("g")[0];
        groupCircle2 = group.getElementsByTagName("g")[1];
        circle1 = groupCircle1.getElementsByTagName("circle")[0];
        circle2 = groupCircle2.getElementsByTagName("circle")[0];
      }
      this._shape = shape;
      this._group = group;
      this._progressPath = circle2;
      this._basePath = circle1;
      this._groupProgress = groupCircle2;
      this._easing = bezier_easing__WEBPACK_IMPORTED_MODULE_3___default()(0.75, 0.02, 0.5, 1);
      this._easingDasharray = bezier_easing__WEBPACK_IMPORTED_MODULE_3___default()(0.4, 0, 0, 1);
      this._progressPath.style.strokeOpacity = 0;
      this.resize();

      // TODO: nur zur show in den docs:
      // this.progress(0);
      if (this._continuous) this.progress(0);else this.progress(this._progressvalue / 100);
    }
  }, {
    key: "progress",
    value: function progress(ratio) {
      ratio = (0,_util_limit__WEBPACK_IMPORTED_MODULE_2__["default"])(ratio, 0, 1);
      this._progress = ratio;
      var pathLength = this._getCircleLength(this._progressPath);
      if (!this._continuous) {
        this._progressPath.style.strokeDasharray = this._progress === 1 ? 'none' : "".concat(this._progress * pathLength, ", ").concat(pathLength);
        this._progressPath.style.strokeOpacity = this._progress === 0 ? 0 : 1;
      } else {
        this.loop();
      }
      if (this._value) {
        this._value.innerHTML = "".concat(Math.round(this._progress * 100));
      }
      this._updateClasses();
    }
  }, {
    key: "loop",
    value: function loop() {
      var _this = this;
      if (this._continuous) {
        this._progressPath.style.strokeOpacity = 1;
        window.requestAnimationFrame(function (timestamp) {
          return _this._animateLoop(timestamp);
        });
      }
    }
  }, {
    key: "stop",
    value: function stop() {}
  }, {
    key: "resize",
    value: function resize() {
      var size = this._element.offsetWidth;
      var radius = (size - STROKE_WIDTH) / 2;
      this._shape.setAttributeNS(null, 'viewBox', "".concat(size / -2, " ").concat(size / -2, " ").concat(size, " ").concat(size));
      this._basePath.setAttributeNS(null, 'r', "".concat(radius));
      this._progressPath.setAttributeNS(null, 'r', "".concat(radius));
    }

    // TODO Optimize calculations; wording.
  }, {
    key: "_animateLoop",
    value: function _animateLoop(timestamp) {
      var _this2 = this;
      if (!this._loopStart) {
        this._loopStart = timestamp;
      }

      // The progress in seconds 0 <= progress <= LOOP_ANIMATION_DURATION
      var progress = (timestamp - this._loopStart) / 1000;
      // The progress ratio between 0 <= progressRatio <= 1
      var progressRatio = progress / LOOP_ANIMATION_DURATION;
      if (progressRatio > 1 || progressRatio === 0) {
        this._animationEndSet = false;
        progress = 0;
        progressRatio = 0;
        this._loopStart = timestamp;
        this._dashLengthStart = LOOP_ANIMATION[0].dashLength;
        this._dashOffsetStart = LOOP_ANIMATION[0].dashOffset;
        this._dashLengthEnd = LOOP_ANIMATION[1].dashLength;
        this._dashOffsetEnd = LOOP_ANIMATION[1].dashOffset;
      }
      var ease = this._easing(progressRatio);
      var pathLength = this._getCircleLength(this._progressPath);
      this._dashLengthRatio = this._dashLengthStart + (this._dashLengthEnd - this._dashLengthStart) * this._easingDasharray(progressRatio);
      this._dashOffsetRatio = this._dashOffsetStart + (this._dashOffsetEnd - this._dashOffsetStart) * ease;
      this._rotate = LOOP_ANIMATION[1].rotate * ease;
      var dashLength = pathLength * this._dashLengthRatio;
      var dashOffset = pathLength * this._dashOffsetRatio;
      this._progressPath.style.strokeDasharray = "".concat(dashLength, ", ").concat(pathLength);
      this._progressPath.style.strokeDashoffset = "".concat(dashOffset);
      // this._group.setAttributeNS(null, 'transform', `rotate(${this._rotate})`);
      this._groupProgress.setAttributeNS(null, 'transform', "rotate(".concat(this._rotate, ")"));
      window.requestAnimationFrame(function (timestamp) {
        return _this2._animateLoop(timestamp);
      });
    }
  }, {
    key: "_updateClasses",
    value: function _updateClasses() {
      if (this._progress === 0) {
        this._element.classList.add(CLASS_IS_PENDING);
      } else {
        this._element.classList.remove(CLASS_IS_PENDING);
      }
      if (this._progress > 0 && this._progress < 1) {
        this._element.classList.add(CLASS_IS_LOADING);
      } else {
        this._element.classList.remove(CLASS_IS_LOADING);
      }
      if (this._progress === 1) {
        this._element.classList.add(CLASS_IS_COMPLETE);
      } else {
        this._element.classList.remove(CLASS_IS_COMPLETE);
      }
    }
  }, {
    key: "_getCircleLength",
    value: function _getCircleLength(circle) {
      var r = circle.getAttribute('r');
      return 2 * Math.PI * r;
    }
  }], [{
    key: "upgradeElements",
    value:
    /**
     * Upgrades all Spinner AUI components.
     * @returns {Array} Returns an array of all newly upgraded components.
     */
    function upgradeElements() {
      var components = [];
      Array.from(document.querySelectorAll(SELECTOR_COMPONENT)).forEach(function (element) {
        if (!_component_component__WEBPACK_IMPORTED_MODULE_0__["default"].isElementUpgraded(element)) {
          components.push(new Spinner(element));
        }
      });
      return components;
    }
  }]);
  return Spinner;
}(_component_component__WEBPACK_IMPORTED_MODULE_0__["default"]);


/***/ }),

/***/ "./source/textfield/textfield.js":
/*!***************************************!*\
  !*** ./source/textfield/textfield.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Textfield)
/* harmony export */ });
/* harmony import */ var _component_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../component/component */ "./source/component/component.js");
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var SELECTOR_COMPONENT = '.ci-js-textfield';
var CLASS_FIELD = 'ci-textfield-field';
var CLASS_INPUT = 'ci-textfield-input';
var CLASS_LABEL = 'ci-textfield-label';
var CLASS_FOCUS_LINE = 'ci-textfield-focus-line';
var CLASS_COUNTER = 'ci-textfield-counter';
var CLASS_COUNTER_VALUE = 'ci-textfield-counter-value';
var CLASS_IS_FOCUS = 'is-focused';
var CLASS_IS_DIRTY = 'is-dirty';
var CLASS_IS_INVALID = 'is-invalid';
var CLASS_IS_DISABLED = 'is-disabled';
var CLASS_IS_EQUAL_MAX_CHARS = 'is-equal-max-length';
var CLASS_IS_GREATER_MAX_CHARS = 'is-greater-max-length';
var ATTR_AUTOSIZE = 'data-autosize';

/**
 * Class constructor for Textfield AUI component.
 * Implements AUI component design pattern defined at:
 * https://github.com/...
 *
 * @param {HTMLElement} element The element that will be upgraded.
 */
var Textfield = /*#__PURE__*/function (_Component) {
  _inherits(Textfield, _Component);
  var _super = _createSuper(Textfield);
  function Textfield(element) {
    _classCallCheck(this, Textfield);
    return _super.call(this, element);
  }
  _createClass(Textfield, [{
    key: "init",
    value: function init() {
      var _this = this;
      _get(_getPrototypeOf(Textfield.prototype), "init", this).call(this);
      this._input = this._element.querySelector(".".concat(CLASS_INPUT));
      this._input.addEventListener('input', this._inputHandler = function (event) {
        return _this._onInput(event);
      });
      //this._input.addEventListener('touchstart', this._touchHandler = (event) => this._onTouchStart(event));
      this._input.addEventListener('focus', this._focusHandler = function (event) {
        return _this._onFocus(event);
      });
      this._input.addEventListener('blur', this._blurHandler = function (event) {
        return _this._onBlur(event);
      });
      this._input.addEventListener('change', this._changeHandler = function (event) {
        return _this._onChange(event);
      });
      this._input.addEventListener('reset', this._resetHandler = function (event) {
        return _this._onReset(event);
      });

      // Insert counter if data attribute 'count' is present:
      if (this._element.getAttribute('data-count')) {
        this._maxChars = parseInt(this._element.getAttribute('data-count')) || 0;
        this._label = this._element.querySelector(".".concat(CLASS_FIELD));
        this._counter = document.createElement('span');
        this._counter.classList.add(CLASS_COUNTER);
        this._label.parentNode.insertBefore(this._counter, this._label.nextSibling);
        this._counterValue = document.createElement('span');
        this._counterValue.classList.add(CLASS_COUNTER_VALUE);
        this._counterValue.innerHTML = this._maxChars;
        this._counter.appendChild(this._counterValue);
        this._hasCounter = true;
      }

      // Insert thick focus line after label element:
      this._label = this._element.querySelector(".".concat(CLASS_LABEL));
      var focusLine = document.createElement('span');
      focusLine.classList.add(CLASS_FOCUS_LINE);
      this._label.parentNode.insertBefore(focusLine, this._label.nextSibling);

      // If textarea should adjust height to content
      if (this._element.hasAttribute(ATTR_AUTOSIZE) && this._element.getAttribute(ATTR_AUTOSIZE) !== 'false') {
        var style = window.getComputedStyle(this._input);
        this._inputPadding = parseInt(style.paddingTop) + parseInt(style.paddingBottom) || 0;
        this._inputBorder = parseInt(style.borderTop) + parseInt(style.borderBottom) || 0;
        this._input.addEventListener('keyup', this._keyupHandler = function (event) {
          return _this._onKeyup(event);
        });
        this._autosize = true;
      }
      this.updateClasses();
    }
  }, {
    key: "update",
    value: function update() {
      this.updateClasses();
      this.updateCounter();
      if (this._autosize) {
        this.adjustHeightToContent();
      }
    }
  }, {
    key: "updateClasses",
    value: function updateClasses() {
      this.checkDisabled();
      this.checkDirty();
      this.checkFocus();
    }
  }, {
    key: "updateCounter",
    value: function updateCounter() {
      if (this._counterValue) {
        var numChars = this._input.value.length;
        var remainingChars = this._maxChars - numChars;
        this._counterValue.innerHTML = remainingChars;
        if (remainingChars === 0) {
          this._element.classList.add(CLASS_IS_EQUAL_MAX_CHARS);
        } else {
          this._element.classList.remove(CLASS_IS_EQUAL_MAX_CHARS);
        }
        if (remainingChars < 0) {
          this._element.classList.add(CLASS_IS_GREATER_MAX_CHARS);
          this._element.classList.add(CLASS_IS_INVALID);
        } else {
          this._element.classList.remove(CLASS_IS_GREATER_MAX_CHARS);
          this._element.classList.remove(CLASS_IS_INVALID);
        }
      }
    }

    /**
     * Check the disabled state and update field accordingly.
     */
  }, {
    key: "checkDisabled",
    value: function checkDisabled() {
      if (this._input.disabled) {
        this._element.classList.add(CLASS_IS_DISABLED);
      } else {
        this._element.classList.remove(CLASS_IS_DISABLED);
      }
    }

    /**
     * Check the dirty state and update field accordingly.
     */
  }, {
    key: "checkDirty",
    value: function checkDirty() {
      if (this._input.value && this._input.value.length > 0) {
        this._element.classList.add(CLASS_IS_DIRTY);
      } else {
        this._element.classList.remove(CLASS_IS_DIRTY);
      }
    }

    /**
     * Check the focus state and update field accordingly.
     */
  }, {
    key: "checkFocus",
    value: function checkFocus() {
      var isFocused = false;
      var element = document.activeElement;
      while (element !== this._element && element !== null) {
        element = element.parentNode;
      }
      if (element === this._element) {
        isFocused = true;
        this._element.querySelector('input').focus();
      }
      if (Boolean(this._element.querySelector(':focus')) || isFocused) {
        this._element.classList.add(CLASS_IS_FOCUS);
      } else {
        this._element.classList.remove(CLASS_IS_FOCUS);
      }
    }

    /**
     * Resize textarea
     */
  }, {
    key: "adjustHeightToContent",
    value: function adjustHeightToContent() {
      var htmlTop = window.pageYOffset;
      var bodyTop = document.body.scrollTop;
      var originalHeight = this._input.style.height;
      this._input.style.height = 'auto';
      if (this._input.scrollHeight === 0) {
        // If the scrollHeight is 0, then the element probably has display:none or is detached from the DOM.
        this._input.style.height = originalHeight;
        return;
      }
      this._input.style.height = "".concat(this._input.scrollHeight + this._inputBorder, "px");

      // prevents scroll position jump
      document.documentElement.scrollTop = htmlTop;
      document.body.scrollTop = bodyTop;
    }

    /**
     * Disable text field.
     */
  }, {
    key: "disable",
    value: function disable() {
      this._input.disabled = true;
      this.updateClasses();
    }

    /**
     * Dispose component
     */
  }, {
    key: "dispose",
    value: function dispose() {
      _get(_getPrototypeOf(Textfield.prototype), "dispose", this).call(this);
      this._input.removeEventListener('input', this._inputHandler);
      this._input.removeEventListener('focus', this._focusHandler);
      //this._input.removeEventListener('touch', this._touchHandler);
      this._input.removeEventListener('blur', this._blurHandler);
      this._input.removeEventListener('change', this._changeHandler);
      this._input.removeEventListener('reset', this._resetHandler);
      _get(_getPrototypeOf(Textfield.prototype), "removeChild", this).call(this, this._element.querySelector(".".concat(CLASS_FOCUS_LINE)));
      _get(_getPrototypeOf(Textfield.prototype), "removeChild", this).call(this, this._element.querySelector(".".concat(CLASS_COUNTER)));
    }

    /**
     * Event Handler
     */
  }, {
    key: "_onInput",
    value: function _onInput(event) {
      this.update();
    }
  }, {
    key: "_onFocus",
    value: function _onFocus(event) {
      this.update();
    }

    /*_onTouchStart(event) {
      this._element.focus();
      this.update();
    }*/
  }, {
    key: "_onBlur",
    value: function _onBlur(event) {
      this.update();
    }
  }, {
    key: "_onChange",
    value: function _onChange(event) {
      this.update();
    }
  }, {
    key: "_onReset",
    value: function _onReset(event) {
      this.update();
    }
  }, {
    key: "_onKeyup",
    value: function _onKeyup(event) {
      this.updateCounter();
      if (this._autosize) {
        this.adjustHeightToContent();
      }
    }

    /**
     * Getter and Setter
     */
  }, {
    key: "input",
    get: function get() {
      return this._input;
    }
  }, {
    key: "autoSize",
    get: function get() {
      return this._autosize;
    },
    set: function set(value) {
      return this._autosize = Boolean(value);
    }
  }], [{
    key: "upgradeElements",
    value:
    /**
     * Upgrades all Textfield AUI components.
     * @returns {Array} Returns an array of all newly upgraded components.
     */
    function upgradeElements() {
      var components = [];
      Array.from(document.querySelectorAll(SELECTOR_COMPONENT)).forEach(function (element) {
        if (!_component_component__WEBPACK_IMPORTED_MODULE_0__["default"].isElementUpgraded(element)) {
          components.push(new Textfield(element));
        }
      });
      return components;
    }
  }]);
  return Textfield;
}(_component_component__WEBPACK_IMPORTED_MODULE_0__["default"]);


/***/ }),

/***/ "./source/tooltip/tooltip.js":
/*!***********************************!*\
  !*** ./source/tooltip/tooltip.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Tooltip)
/* harmony export */ });
/* harmony import */ var _component_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../component/component */ "./source/component/component.js");
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var SELECTOR_COMPONENT = '.ci-js-tooltip';
var CLASS_TRIANGLE = 'ci-tooltip-triangle';
var CLASS_IS_UPGRADED = 'is-upgraded';
var CLASS_IS_ACTIVE = 'is-active';
var CLASS_IS_TOP = 'is-top';
var OFFSET_VIEWPORT_X = 10;
var OFFSET_TARGET_TOP = 12;
var OFFSET_TARGET_BOTTOM = 12;

/**
 * Class constructor for Tooltip AUI component.
 * Implements AUI component design pattern defined at:
 * https://github.com/...
 *
 * @param {HTMLElement} element The element that will be upgraded.
 */
var Tooltip = /*#__PURE__*/function (_Component) {
  _inherits(Tooltip, _Component);
  var _super = _createSuper(Tooltip);
  function Tooltip() {
    _classCallCheck(this, Tooltip);
    return _super.apply(this, arguments);
  }
  _createClass(Tooltip, [{
    key: "init",
    value:
    /**
     * Initialize component
     */
    function init() {
      var _this = this;
      _get(_getPrototypeOf(Tooltip.prototype), "init", this).call(this);
      var forId = this._element.getAttribute('for');
      if (forId) {
        this._trigger = document.getElementById(forId);
      }
      if (this._trigger) {
        // Add triangle shape
        this._triangle = document.createElement('span');
        this._triangle.classList.add(CLASS_TRIANGLE);
        this._element.appendChild(this._triangle);

        // Prevent accidental text selection on Android
        if (!this._trigger.hasAttribute('tabindex')) {
          this._trigger.setAttribute('tabindex', '0');
        }
        this._trigger.addEventListener('mouseenter', this._boundMouseenter = function (event) {
          return _this._onTriggerEnter(event);
        });
        this._trigger.addEventListener('mouseleave', this._boundMouseleave = function (event) {
          return _this._onTriggerLeave(event);
        });
        this._trigger.addEventListener('focusin', this._boundfocusin = function (event) {
          return _this._onTriggerEnter(event);
        });
        this._trigger.addEventListener('focusout', this._boundfocusout = function (event) {
          return _this._onTriggerLeave(event);
        });
        this._trigger.addEventListener('touchstart', this._boundTouchstart = function (event) {
          return _this._onTriggerEnter(event);
        });
        window.addEventListener('touchend', this._boundTouchendWindow = function (event) {
          return _this._onTriggerLeaveOutside(event);
        });
      }
    }

    /**
     * Dispose component
     */
  }, {
    key: "dispose",
    value: function dispose() {
      this._trigger.removeEventListener('mouseenter', this._boundMouseenter);
      this._trigger.removeEventListener('mouseleave', this._boundMouseleave);
      this._trigger.removeEventListener('focusin', this._boundfocusin);
      this._trigger.removeEventListener('focusout', this._boundfocusout);
      this._trigger.removeEventListener('touchstart', this._boundTouchstart);
      window.removeEventListener('touchend', this._boundTouchendWindow);
      window.removeEventListener('scroll', this._boundScrollWindow);
      this._element.classList.remove(CLASS_IS_TOP, CLASS_IS_ACTIVE, CLASS_IS_UPGRADED);
      this._element.removeAttribute('style');
      this._element.removeChild(this._triangle);
    }

    /**
     * Open tooltip
     * @param {HTMLElement} trigger element that opens the tooltip.
     * @param {number} clientX the x-coordinate of trigger (mouse/touch).
     */
  }, {
    key: "open",
    value: function open(trigger, clientX) {
      var _this2 = this;
      if (!trigger) {
        return;
      }
      var rect = trigger.getBoundingClientRect();
      clientX = clientX || rect.left + rect.width / 2;
      var triggerX = clientX - rect.left;
      var yTop = rect.top - this._element.offsetHeight - OFFSET_TARGET_TOP;
      var yBottom = rect.bottom + OFFSET_TARGET_BOTTOM + 2;
      var x = rect.left + rect.width / 2 - this._element.offsetWidth / 2;
      var y = yBottom;
      var triangleX = 0;
      this._element.classList.remove(CLASS_IS_TOP);
      x = rect.left + triggerX - this._element.offsetWidth / 2;
      if (x < OFFSET_VIEWPORT_X) {
        x = OFFSET_VIEWPORT_X;
      }

      // If tooltip would be out of viewport on the right
      if (x + this._element.offsetWidth > window.innerWidth - OFFSET_VIEWPORT_X) {
        x = window.innerWidth - OFFSET_VIEWPORT_X - this._element.offsetWidth;
      }

      // If viewport height isn't large enough, place tooltip on top if possible
      if (yBottom + this._element.offsetHeight > window.innerHeight - OFFSET_VIEWPORT_X) {
        y = yTop;
        this._element.classList.add(CLASS_IS_TOP);
      }
      triangleX = triggerX + rect.left - x;
      this._element.classList.add(CLASS_IS_ACTIVE);
      this._element.style.left = "".concat(x, "px");
      this._element.style.top = "".concat(y, "px");
      this._triangle.style.left = "".concat(triangleX, "px");
      this._scrolled = false;
      window.addEventListener('scroll', this._boundScrollWindow = function (event) {
        return _this2._onScrollWindow(event);
      });
    }

    /**
     * Close tooltip.
     */
  }, {
    key: "close",
    value: function close() {
      window.removeEventListener('scroll', this._boundScrollWindow);
      this._element.classList.remove(CLASS_IS_ACTIVE);
    }

    /**
     * Handle enter event.
     * @param {Event} event that fired.
     */
  }, {
    key: "_onTriggerEnter",
    value: function _onTriggerEnter(event) {
      this.open(event.target, event.clientX);
    }

    /**
     * Handle leave event.
     * @param {Event} event that fired.
     */
  }, {
    key: "_onTriggerLeave",
    value: function _onTriggerLeave(event) {
      this.close();
    }

    /**
     * Handle leave outside event.
     * @param {Event} event that fired.
     */
  }, {
    key: "_onTriggerLeaveOutside",
    value: function _onTriggerLeaveOutside(event) {
      if (!this._element.contains(event.target) && !this._trigger.contains(event.target)) {
        this.close();
      }
      ;
    }

    /**
     * Handle scroll event.
     * @param {Event} event that fired.
     */
  }, {
    key: "_onScrollWindow",
    value: function _onScrollWindow(event) {
      window.removeEventListener('scroll', this._boundScrollWindow);
      if (!this._scrolled) {
        this.close();
        this._scrolled = true;
      }
    }
  }], [{
    key: "upgradeElements",
    value:
    /**
     * Upgrades all Tooltip AUI components.
     * @returns {Array} Returns an array of all newly upgraded components.
     */
    function upgradeElements() {
      var components = [];
      Array.from(document.querySelectorAll(SELECTOR_COMPONENT)).forEach(function (element) {
        if (!_component_component__WEBPACK_IMPORTED_MODULE_0__["default"].isElementUpgraded(element)) {
          components.push(new Tooltip(element));
        }
      });
      return components;
    }
  }]);
  return Tooltip;
}(_component_component__WEBPACK_IMPORTED_MODULE_0__["default"]);


/***/ }),

/***/ "./source/util/animation-end-event.js":
/*!********************************************!*\
  !*** ./source/util/animation-end-event.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
// From Modernizr
function whichAnimationEvent() {
  var type;
  var element = document.createElement('fakeelement');
  var animations = {
    'animation': 'animationend',
    'OAnimation': 'oAnimationEnd',
    'MozAnimation': 'animationend',
    'WebkitAnimation': 'webkitAnimationEnd'
  };
  for (type in animations) {
    if (element.style[type] !== undefined) {
      return animations[type];
    }
  }
}
var ANIMATION_EVENT = whichAnimationEvent();
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ANIMATION_EVENT);

/***/ }),

/***/ "./source/util/closest.js":
/*!********************************!*\
  !*** ./source/util/closest.js ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ closest)
/* harmony export */ });
/**
 * Get the first element that matches the selector by testing the element itself
 * and traversing up through its ancestors in the DOM tree.
 * @param {HTMLElement} element to search wherefrom
 * @param {string} selector A string containing a selector expression to match elements against.
 * @param {HTMLElement} context A DOM element within which a matching element may be found.
 * @returns {HTMLElement} found element or null
 */
function closest(element, selector, context) {
  var matchesFn;
  ['matches', 'webkitMatchesSelector', 'mozMatchesSelector', 'msMatchesSelector', 'oMatchesSelector'].some(function (fn) {
    if (typeof document.body[fn] === 'function') {
      matchesFn = fn;
      return true;
    }
    return false;
  });
  var parent;

  // traverse parents
  parent = element;
  while (parent) {
    if (parent && parent[matchesFn](selector)) {
      return parent;
    }
    if (parent === context) {
      return null;
    }
    parent = parent.parentElement;
  }
  return null;
}

/***/ }),

/***/ "./source/util/limit.js":
/*!******************************!*\
  !*** ./source/util/limit.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ limit)
/* harmony export */ });
/**
 * Limits a value to x >= min and x <= max.
 * @param {number} x The value to limit.
 * @param {number} min The value to limit.
 * @param {number} max The value to limit.
 * @returns {number} The limited value.
 */
function limit(x, min, max) {
  if (x > max) x = max;
  if (x < min) x = min;
  return x;
}

/***/ }),

/***/ "./source/util/map-linear.js":
/*!***********************************!*\
  !*** ./source/util/map-linear.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ mapLinear)
/* harmony export */ });
/**
 * Linear mapping from range <a1, a2> to range <b1, b2>
 * @param {number} x The value to map
 * @param {number} a1 First endpoint of the range <a1, a2>
 * @param {number} a2 Final endpoint of the range <a1, a2>
 * @param {number} b1 First endpoint of the range <b1, b2>
 * @param {number} b2 Final endpoint of the range  <b1, b2>
 * @returns {number} The mapped value.
 */
function mapLinear(x, a1, a2, b1, b2) {
  return b1 + (x - a1) * (b2 - b1) / (a2 - a1);
}

/***/ }),

/***/ "./source/util/object-resize.js":
/*!**************************************!*\
  !*** ./source/util/object-resize.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ObjectResize)
/* harmony export */ });
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
var ObjectResize = /*#__PURE__*/function () {
  function ObjectResize(parent, callback, callbackScope) {
    var _this = this;
    _classCallCheck(this, ObjectResize);
    var isIE = navigator.userAgent.match(/Trident/);

    // NOTE
    // this._parent.style.position != 'static'
    // this._parent.style.display = 'block'

    this._parent = parent;
    this._helperElement = document.createElement('object');
    this._helperElement.setAttribute('style', 'display: block; position: absolute; top: 0; left: 0; height: 100%; width: 100%; overflow: hidden; pointer-events: none; z-index: -1; border: 0px; opacity: 0;');
    this._helperElement.setAttribute('border', '0');
    this._helperElement.onload = function () {
      return _this._onLoad();
    };
    this._helperElement.type = 'text/html';
    if (isIE) {
      this._parent.appendChild(this._helperElement);
    }
    this._helperElement.data = 'about:blank';
    if (!isIE) {
      this._parent.appendChild(this._helperElement);
    }
    this._callback = callback;
    this._callbackScope = callbackScope;
    this._ticking = false;
  }
  _createClass(ObjectResize, [{
    key: "_onLoad",
    value: function _onLoad(event) {
      var _this2 = this;
      this._helperElement.contentDocument.defaultView.addEventListener('resize', this._resizeHandler = function (event) {
        return _this2._onResize(event);
      });
    }
  }, {
    key: "_onResize",
    value: function _onResize(event) {
      var _this3 = this;
      if (!this._ticking) {
        window.requestAnimationFrame(function () {
          _this3._ticking = false;
          _this3._callback.call(_this3._callbackScope);
        });
      }
      this._ticking = true;
    }
  }, {
    key: "dispose",
    value: function dispose() {
      this._helperElement.contentDocument.defaultView.removeEventListener('resize', this._resizeHandler);
      this._parent.removeChild(this._helperElement);
    }
  }]);
  return ObjectResize;
}();


/***/ }),

/***/ "./source/util/reflow.js":
/*!*******************************!*\
  !*** ./source/util/reflow.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ reflow)
/* harmony export */ });
/**
 * Trigger a reflow
 * @param {HTMLElement} element to trigger a reflow.
 */
function reflow(element) {
  new Function('bs', 'return bs')(element.offsetHeight);
}

/***/ }),

/***/ "./source/util/resize-observer.js":
/*!****************************************!*\
  !*** ./source/util/resize-observer.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ResizeObserver)
/* harmony export */ });
/* harmony import */ var _util_signal__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../util/signal */ "./source/util/signal.js");
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

var instance = null;
var ResizeObserver = /*#__PURE__*/function () {
  function ResizeObserver() {
    _classCallCheck(this, ResizeObserver);
    if (!instance) {
      instance = this;
      this.init();
    }
    return instance;
  }
  _createClass(ResizeObserver, [{
    key: "init",
    value: function init() {
      var _this = this;
      this._ticking = false;
      this.resized = new _util_signal__WEBPACK_IMPORTED_MODULE_0__["default"]();
      window.addEventListener('resize', this._resizeHandler = function (event) {
        return _this._onResize(event);
      });
    }
  }, {
    key: "_onResize",
    value: function _onResize(event) {
      var _this2 = this;
      if (!this._ticking) {
        window.requestAnimationFrame(function () {
          _this2._ticking = false;
          _this2.resized.dispatch();
        });
      }
      this._ticking = true;
    }
  }]);
  return ResizeObserver;
}();


/***/ }),

/***/ "./source/util/signal.js":
/*!*******************************!*\
  !*** ./source/util/signal.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
var SignalBinding = /*#__PURE__*/function () {
  function SignalBinding(signal, listener, isOnce, priority) {
    _classCallCheck(this, SignalBinding);
    // Handler function bound to the signal.
    this._listener = listener;

    // If binding should be executed just once.
    this._isOnce = isOnce;

    // Reference to Signal object that listener is currently bound to.
    this._signal = signal;

    // Listener priority
    this._priority = priority || 0;

    // If binding is active and should be executed.
    this._active = true;
  }
  _createClass(SignalBinding, [{
    key: "_isBound",
    value: function _isBound() {
      return !!this._signal && !!this._listener;
    }

    /**
     * Call listener passing arbitrary parameters.
     * If binding was added using `Signal.addOnce()` it will be automatically
     * removed from signal dispatch queue, this method is used internally for
     * the signal dispatch.
     * @param {Array} params Array of parameters that should be passed to the listener
     * @returns {*} Value returned by the listener.
     */
  }, {
    key: "execute",
    value: function execute(params) {
      var handlerReturn;
      if (this._active && !!this._listener) {
        handlerReturn = this._listener.apply(this._context, params);
        if (this._isOnce) {
          this.detach();
        }
      }
      return handlerReturn;
    }

    /**
     * Detach binding from signal.
     * - alias to: mySignal.remove(myBinding.getListener());
     * @returns {Function|null} Handler function bound to the signal or `null` if binding was previously detached.
     */
  }, {
    key: "detach",
    value: function detach() {
      return this._isBound() ? this._signal.remove(this._listener) : null;
    }
  }, {
    key: "isOnce",
    get: function get() {
      return this._isOnce;
    }
  }, {
    key: "listener",
    get: function get() {
      return this._listener;
    }
  }, {
    key: "signal",
    get: function get() {
      return this._signal;
    }
  }, {
    key: "priority",
    get: function get() {
      return this._priority;
    }
  }, {
    key: "dispose",
    value: function dispose() {
      delete this._signal;
      delete this._listener;
    }
  }, {
    key: "toString",
    value: function toString() {
      return '[SignalBinding isOnce:' + this._isOnce + ', isBound:' + this.isBound() + ', active:' + this._active + ']';
    }
  }]);
  return SignalBinding;
}();
var Signal = /*#__PURE__*/function () {
  function Signal() {
    _classCallCheck(this, Signal);
    this._bindings = [];
    this._prevParams = null;
    this._active = true;
  }

  /**
   * Add a listener to the signal.
   * @param {Function} listener Signal handler function.
   * @param {Number} [priority] The priority level of the event listener. Listeners with higher priority will be executed before listeners with lower priority. Listeners with same priority level will be executed at the same order as they were added. (default = 0)
   * @returns {SignalBinding} An Object representing the binding between the Signal and listener.
   */
  _createClass(Signal, [{
    key: "add",
    value: function add(listener, priority) {
      this._validateListener(listener, 'add');
      return this._registerListener(listener, false, priority);
    }
  }, {
    key: "addOnce",
    value: function addOnce(listener, priority) {
      this._validateListener(listener, 'addOnce');
      return this._registerListener(listener, true, priority);
    }
  }, {
    key: "remove",
    value: function remove(listener) {
      this._validateListener(listener, 'remove');
      var i = this._indexOfListener(listener);
      if (i !== -1) {
        this._bindings[i].dispose(); //no reason to a SignalBinding exist if it isn't attached to a signal
        this._bindings.splice(i, 1);
      }
      return listener;
    }
  }, {
    key: "removeAll",
    value: function removeAll() {
      var n = this._bindings.length;
      while (n--) {
        this._bindings[n].dispose();
      }
      this._bindings.length = 0;
    }
  }, {
    key: "has",
    value: function has(listener) {
      return this._indexOfListener(listener) !== -1;
    }
  }, {
    key: "dispatch",
    value: function dispatch() {
      if (!this._active) {
        return;
      }
      var n = this._bindings.length;
      if (!n) {
        return;
      }
      var params = Array.prototype.slice.call(arguments);
      var bindings;
      bindings = this._bindings.slice(); //clone array in case add/remove items during dispatch

      //execute all callbacks until end of the list or until a callback returns `false` or stops propagation
      //reverse loop since listeners with higher priority will be added at the end of the list
      do {
        n--;
      } while (bindings[n] && bindings[n].execute(params) !== false);
    }
  }, {
    key: "dispose",
    value: function dispose() {
      this.removeAll();
      delete this._bindings;
      delete this._prevParams;
    }
  }, {
    key: "_registerListener",
    value: function _registerListener(listener, isOnce, priority) {
      var prevIndex = this._indexOfListener(listener);
      var binding;
      if (prevIndex !== -1) {
        binding = this._bindings[prevIndex];
        if (binding.isOnce() !== isOnce) {
          throw new Error("You cannot add".concat(isOnce ? '' : 'Once', "() then add").concat(!isOnce ? '' : 'Once', "() the same listener without removing the relationship first."));
        }
      } else {
        binding = new SignalBinding(this, listener, isOnce, priority);
        this._addBinding(binding);
      }
      if (this.memorize && this._prevParams) {
        binding.execute(this._prevParams);
      }
      return binding;
    }
  }, {
    key: "_validateListener",
    value: function _validateListener(listener, fnName) {
      if (typeof listener !== 'function') {
        throw new Error("listener is a required param of ".concat(fnName, "() and should be a Function."));
      }
    }
  }, {
    key: "_indexOfListener",
    value: function _indexOfListener(listener) {
      var n = this._bindings.length;
      var current;
      while (n--) {
        current = this._bindings[n];
        if (current.listener === listener) {
          return n;
        }
      }
      return -1;
    }
  }, {
    key: "_addBinding",
    value: function _addBinding(binding) {
      var n = this._bindings.length;
      do {
        --n;
      } while (this._bindings[n] && binding.priority <= this._bindings[n].priority);
      this._bindings.splice(n + 1, 0, binding);
    }
  }]);
  return Signal;
}();
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Signal);

/***/ }),

/***/ "./source/util/transition-end-event.js":
/*!*********************************************!*\
  !*** ./source/util/transition-end-event.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
// From Modernizr
function whichTransitionEvent() {
  var t;
  var el = document.createElement('fakeelement');
  var transitions = {
    'transition': 'transitionend',
    'OTransition': 'oTransitionEnd',
    'MozTransition': 'transitionend',
    'WebkitTransition': 'webkitTransitionEnd'
  };
  for (t in transitions) {
    if (el.style[t] !== undefined) {
      return transitions[t];
    }
  }
}
var TRANSITION_EVENT = whichTransitionEvent();
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (TRANSITION_EVENT);

/***/ }),

/***/ "./node_modules/bezier-easing/src/index.js":
/*!*************************************************!*\
  !*** ./node_modules/bezier-easing/src/index.js ***!
  \*************************************************/
/***/ ((module) => {

/**
 * https://github.com/gre/bezier-easing
 * BezierEasing - use bezier curve for transition easing function
 * by Gaëtan Renaudeau 2014 - 2015 – MIT License
 */

// These values are established by empiricism with tests (tradeoff: performance VS precision)
var NEWTON_ITERATIONS = 4;
var NEWTON_MIN_SLOPE = 0.001;
var SUBDIVISION_PRECISION = 0.0000001;
var SUBDIVISION_MAX_ITERATIONS = 10;

var kSplineTableSize = 11;
var kSampleStepSize = 1.0 / (kSplineTableSize - 1.0);

var float32ArraySupported = typeof Float32Array === 'function';

function A (aA1, aA2) { return 1.0 - 3.0 * aA2 + 3.0 * aA1; }
function B (aA1, aA2) { return 3.0 * aA2 - 6.0 * aA1; }
function C (aA1)      { return 3.0 * aA1; }

// Returns x(t) given t, x1, and x2, or y(t) given t, y1, and y2.
function calcBezier (aT, aA1, aA2) { return ((A(aA1, aA2) * aT + B(aA1, aA2)) * aT + C(aA1)) * aT; }

// Returns dx/dt given t, x1, and x2, or dy/dt given t, y1, and y2.
function getSlope (aT, aA1, aA2) { return 3.0 * A(aA1, aA2) * aT * aT + 2.0 * B(aA1, aA2) * aT + C(aA1); }

function binarySubdivide (aX, aA, aB, mX1, mX2) {
  var currentX, currentT, i = 0;
  do {
    currentT = aA + (aB - aA) / 2.0;
    currentX = calcBezier(currentT, mX1, mX2) - aX;
    if (currentX > 0.0) {
      aB = currentT;
    } else {
      aA = currentT;
    }
  } while (Math.abs(currentX) > SUBDIVISION_PRECISION && ++i < SUBDIVISION_MAX_ITERATIONS);
  return currentT;
}

function newtonRaphsonIterate (aX, aGuessT, mX1, mX2) {
 for (var i = 0; i < NEWTON_ITERATIONS; ++i) {
   var currentSlope = getSlope(aGuessT, mX1, mX2);
   if (currentSlope === 0.0) {
     return aGuessT;
   }
   var currentX = calcBezier(aGuessT, mX1, mX2) - aX;
   aGuessT -= currentX / currentSlope;
 }
 return aGuessT;
}

function LinearEasing (x) {
  return x;
}

module.exports = function bezier (mX1, mY1, mX2, mY2) {
  if (!(0 <= mX1 && mX1 <= 1 && 0 <= mX2 && mX2 <= 1)) {
    throw new Error('bezier x values must be in [0, 1] range');
  }

  if (mX1 === mY1 && mX2 === mY2) {
    return LinearEasing;
  }

  // Precompute samples table
  var sampleValues = float32ArraySupported ? new Float32Array(kSplineTableSize) : new Array(kSplineTableSize);
  for (var i = 0; i < kSplineTableSize; ++i) {
    sampleValues[i] = calcBezier(i * kSampleStepSize, mX1, mX2);
  }

  function getTForX (aX) {
    var intervalStart = 0.0;
    var currentSample = 1;
    var lastSample = kSplineTableSize - 1;

    for (; currentSample !== lastSample && sampleValues[currentSample] <= aX; ++currentSample) {
      intervalStart += kSampleStepSize;
    }
    --currentSample;

    // Interpolate to provide an initial guess for t
    var dist = (aX - sampleValues[currentSample]) / (sampleValues[currentSample + 1] - sampleValues[currentSample]);
    var guessForT = intervalStart + dist * kSampleStepSize;

    var initialSlope = getSlope(guessForT, mX1, mX2);
    if (initialSlope >= NEWTON_MIN_SLOPE) {
      return newtonRaphsonIterate(aX, guessForT, mX1, mX2);
    } else if (initialSlope === 0.0) {
      return guessForT;
    } else {
      return binarySubdivide(aX, intervalStart, intervalStart + kSampleStepSize, mX1, mX2);
    }
  }

  return function BezierEasing (x) {
    // Because JavaScript number are imprecise, we should guarantee the extremes are right.
    if (x === 0) {
      return 0;
    }
    if (x === 1) {
      return 1;
    }
    return calcBezier(getTForX(x), mY1, mY2);
  };
};


/***/ }),

/***/ "./node_modules/nouislider/distribute/nouislider.js":
/*!**********************************************************!*\
  !*** ./node_modules/nouislider/distribute/nouislider.js ***!
  \**********************************************************/
/***/ ((module, exports) => {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*! nouislider - 9.2.0 - 2017-01-11 10:35:34 */

(function (factory) {

    if ( true ) {

        // AMD. Register as an anonymous module.
        !(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
		__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
		(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

    } else {}

}(function( ){

	'use strict';

	var VERSION = '9.2.0';


	// Creates a node, adds it to target, returns the new node.
	function addNodeTo ( target, className ) {
		var div = document.createElement('div');
		addClass(div, className);
		target.appendChild(div);
		return div;
	}

	// Removes duplicates from an array.
	function unique ( array ) {
		return array.filter(function(a){
			return !this[a] ? this[a] = true : false;
		}, {});
	}

	// Round a value to the closest 'to'.
	function closest ( value, to ) {
		return Math.round(value / to) * to;
	}

	// Current position of an element relative to the document.
	function offset ( elem, orientation ) {

	var rect = elem.getBoundingClientRect(),
		doc = elem.ownerDocument,
		docElem = doc.documentElement,
		pageOffset = getPageOffset();

		// getBoundingClientRect contains left scroll in Chrome on Android.
		// I haven't found a feature detection that proves this. Worst case
		// scenario on mis-match: the 'tap' feature on horizontal sliders breaks.
		if ( /webkit.*Chrome.*Mobile/i.test(navigator.userAgent) ) {
			pageOffset.x = 0;
		}

		return orientation ? (rect.top + pageOffset.y - docElem.clientTop) : (rect.left + pageOffset.x - docElem.clientLeft);
	}

	// Checks whether a value is numerical.
	function isNumeric ( a ) {
		return typeof a === 'number' && !isNaN( a ) && isFinite( a );
	}

	// Sets a class and removes it after [duration] ms.
	function addClassFor ( element, className, duration ) {
		if (duration > 0) {
		addClass(element, className);
			setTimeout(function(){
				removeClass(element, className);
			}, duration);
		}
	}

	// Limits a value to 0 - 100
	function limit ( a ) {
		return Math.max(Math.min(a, 100), 0);
	}

	// Wraps a variable as an array, if it isn't one yet.
	// Note that an input array is returned by reference!
	function asArray ( a ) {
		return Array.isArray(a) ? a : [a];
	}

	// Counts decimals
	function countDecimals ( numStr ) {
		numStr = String(numStr);
		var pieces = numStr.split(".");
		return pieces.length > 1 ? pieces[1].length : 0;
	}

	// http://youmightnotneedjquery.com/#add_class
	function addClass ( el, className ) {
		if ( el.classList ) {
			el.classList.add(className);
		} else {
			el.className += ' ' + className;
		}
	}

	// http://youmightnotneedjquery.com/#remove_class
	function removeClass ( el, className ) {
		if ( el.classList ) {
			el.classList.remove(className);
		} else {
			el.className = el.className.replace(new RegExp('(^|\\b)' + className.split(' ').join('|') + '(\\b|$)', 'gi'), ' ');
		}
	}

	// https://plainjs.com/javascript/attributes/adding-removing-and-testing-for-classes-9/
	function hasClass ( el, className ) {
		return el.classList ? el.classList.contains(className) : new RegExp('\\b' + className + '\\b').test(el.className);
	}

	// https://developer.mozilla.org/en-US/docs/Web/API/Window/scrollY#Notes
	function getPageOffset ( ) {

		var supportPageOffset = window.pageXOffset !== undefined,
			isCSS1Compat = ((document.compatMode || "") === "CSS1Compat"),
			x = supportPageOffset ? window.pageXOffset : isCSS1Compat ? document.documentElement.scrollLeft : document.body.scrollLeft,
			y = supportPageOffset ? window.pageYOffset : isCSS1Compat ? document.documentElement.scrollTop : document.body.scrollTop;

		return {
			x: x,
			y: y
		};
	}

	// we provide a function to compute constants instead
	// of accessing window.* as soon as the module needs it
	// so that we do not compute anything if not needed
	function getActions ( ) {

		// Determine the events to bind. IE11 implements pointerEvents without
		// a prefix, which breaks compatibility with the IE10 implementation.
		return window.navigator.pointerEnabled ? {
			start: 'pointerdown',
			move: 'pointermove',
			end: 'pointerup'
		} : window.navigator.msPointerEnabled ? {
			start: 'MSPointerDown',
			move: 'MSPointerMove',
			end: 'MSPointerUp'
		} : {
			start: 'mousedown touchstart',
			move: 'mousemove touchmove',
			end: 'mouseup touchend'
		};
	}


// Value calculation

	// Determine the size of a sub-range in relation to a full range.
	function subRangeRatio ( pa, pb ) {
		return (100 / (pb - pa));
	}

	// (percentage) How many percent is this value of this range?
	function fromPercentage ( range, value ) {
		return (value * 100) / ( range[1] - range[0] );
	}

	// (percentage) Where is this value on this range?
	function toPercentage ( range, value ) {
		return fromPercentage( range, range[0] < 0 ?
			value + Math.abs(range[0]) :
				value - range[0] );
	}

	// (value) How much is this percentage on this range?
	function isPercentage ( range, value ) {
		return ((value * ( range[1] - range[0] )) / 100) + range[0];
	}


// Range conversion

	function getJ ( value, arr ) {

		var j = 1;

		while ( value >= arr[j] ){
			j += 1;
		}

		return j;
	}

	// (percentage) Input a value, find where, on a scale of 0-100, it applies.
	function toStepping ( xVal, xPct, value ) {

		if ( value >= xVal.slice(-1)[0] ){
			return 100;
		}

		var j = getJ( value, xVal ), va, vb, pa, pb;

		va = xVal[j-1];
		vb = xVal[j];
		pa = xPct[j-1];
		pb = xPct[j];

		return pa + (toPercentage([va, vb], value) / subRangeRatio (pa, pb));
	}

	// (value) Input a percentage, find where it is on the specified range.
	function fromStepping ( xVal, xPct, value ) {

		// There is no range group that fits 100
		if ( value >= 100 ){
			return xVal.slice(-1)[0];
		}

		var j = getJ( value, xPct ), va, vb, pa, pb;

		va = xVal[j-1];
		vb = xVal[j];
		pa = xPct[j-1];
		pb = xPct[j];

		return isPercentage([va, vb], (value - pa) * subRangeRatio (pa, pb));
	}

	// (percentage) Get the step that applies at a certain value.
	function getStep ( xPct, xSteps, snap, value ) {

		if ( value === 100 ) {
			return value;
		}

		var j = getJ( value, xPct ), a, b;

		// If 'snap' is set, steps are used as fixed points on the slider.
		if ( snap ) {

			a = xPct[j-1];
			b = xPct[j];

			// Find the closest position, a or b.
			if ((value - a) > ((b-a)/2)){
				return b;
			}

			return a;
		}

		if ( !xSteps[j-1] ){
			return value;
		}

		return xPct[j-1] + closest(
			value - xPct[j-1],
			xSteps[j-1]
		);
	}


// Entry parsing

	function handleEntryPoint ( index, value, that ) {

		var percentage;

		// Wrap numerical input in an array.
		if ( typeof value === "number" ) {
			value = [value];
		}

		// Reject any invalid input, by testing whether value is an array.
		if ( Object.prototype.toString.call( value ) !== '[object Array]' ){
			throw new Error("noUiSlider (" + VERSION + "): 'range' contains invalid value.");
		}

		// Covert min/max syntax to 0 and 100.
		if ( index === 'min' ) {
			percentage = 0;
		} else if ( index === 'max' ) {
			percentage = 100;
		} else {
			percentage = parseFloat( index );
		}

		// Check for correct input.
		if ( !isNumeric( percentage ) || !isNumeric( value[0] ) ) {
			throw new Error("noUiSlider (" + VERSION + "): 'range' value isn't numeric.");
		}

		// Store values.
		that.xPct.push( percentage );
		that.xVal.push( value[0] );

		// NaN will evaluate to false too, but to keep
		// logging clear, set step explicitly. Make sure
		// not to override the 'step' setting with false.
		if ( !percentage ) {
			if ( !isNaN( value[1] ) ) {
				that.xSteps[0] = value[1];
			}
		} else {
			that.xSteps.push( isNaN(value[1]) ? false : value[1] );
		}

		that.xHighestCompleteStep.push(0);
	}

	function handleStepPoint ( i, n, that ) {

		// Ignore 'false' stepping.
		if ( !n ) {
			return true;
		}

		// Factor to range ratio
		that.xSteps[i] = fromPercentage([
			 that.xVal[i]
			,that.xVal[i+1]
		], n) / subRangeRatio (
			that.xPct[i],
			that.xPct[i+1] );

		var totalSteps = (that.xVal[i+1] - that.xVal[i]) / that.xNumSteps[i];
		var highestStep = Math.ceil(Number(totalSteps.toFixed(3)) - 1);
		var step = that.xVal[i] + (that.xNumSteps[i] * highestStep);

		that.xHighestCompleteStep[i] = step;
	}


// Interface

	// The interface to Spectrum handles all direction-based
	// conversions, so the above values are unaware.

	function Spectrum ( entry, snap, direction, singleStep ) {

		this.xPct = [];
		this.xVal = [];
		this.xSteps = [ singleStep || false ];
		this.xNumSteps = [ false ];
		this.xHighestCompleteStep = [];

		this.snap = snap;
		this.direction = direction;

		var index, ordered = [ /* [0, 'min'], [1, '50%'], [2, 'max'] */ ];

		// Map the object keys to an array.
		for ( index in entry ) {
			if ( entry.hasOwnProperty(index) ) {
				ordered.push([entry[index], index]);
			}
		}

		// Sort all entries by value (numeric sort).
		if ( ordered.length && typeof ordered[0][0] === "object" ) {
			ordered.sort(function(a, b) { return a[0][0] - b[0][0]; });
		} else {
			ordered.sort(function(a, b) { return a[0] - b[0]; });
		}


		// Convert all entries to subranges.
		for ( index = 0; index < ordered.length; index++ ) {
			handleEntryPoint(ordered[index][1], ordered[index][0], this);
		}

		// Store the actual step values.
		// xSteps is sorted in the same order as xPct and xVal.
		this.xNumSteps = this.xSteps.slice(0);

		// Convert all numeric steps to the percentage of the subrange they represent.
		for ( index = 0; index < this.xNumSteps.length; index++ ) {
			handleStepPoint(index, this.xNumSteps[index], this);
		}
	}

	Spectrum.prototype.getMargin = function ( value ) {

		var step = this.xNumSteps[0];

		if ( step && ((value / step) % 1) !== 0 ) {
			throw new Error("noUiSlider (" + VERSION + "): 'limit', 'margin' and 'padding' must be divisible by step.");
		}

		return this.xPct.length === 2 ? fromPercentage(this.xVal, value) : false;
	};

	Spectrum.prototype.toStepping = function ( value ) {

		value = toStepping( this.xVal, this.xPct, value );

		return value;
	};

	Spectrum.prototype.fromStepping = function ( value ) {

		return fromStepping( this.xVal, this.xPct, value );
	};

	Spectrum.prototype.getStep = function ( value ) {

		value = getStep(this.xPct, this.xSteps, this.snap, value );

		return value;
	};

	Spectrum.prototype.getNearbySteps = function ( value ) {

		var j = getJ(value, this.xPct);

		return {
			stepBefore: { startValue: this.xVal[j-2], step: this.xNumSteps[j-2], highestStep: this.xHighestCompleteStep[j-2] },
			thisStep: { startValue: this.xVal[j-1], step: this.xNumSteps[j-1], highestStep: this.xHighestCompleteStep[j-1] },
			stepAfter: { startValue: this.xVal[j-0], step: this.xNumSteps[j-0], highestStep: this.xHighestCompleteStep[j-0] }
		};
	};

	Spectrum.prototype.countStepDecimals = function () {
		var stepDecimals = this.xNumSteps.map(countDecimals);
		return Math.max.apply(null, stepDecimals);
 	};

	// Outside testing
	Spectrum.prototype.convert = function ( value ) {
		return this.getStep(this.toStepping(value));
	};

/*	Every input option is tested and parsed. This'll prevent
	endless validation in internal methods. These tests are
	structured with an item for every option available. An
	option can be marked as required by setting the 'r' flag.
	The testing function is provided with three arguments:
		- The provided value for the option;
		- A reference to the options object;
		- The name for the option;

	The testing function returns false when an error is detected,
	or true when everything is OK. It can also modify the option
	object, to make sure all values can be correctly looped elsewhere. */

	var defaultFormatter = { 'to': function( value ){
		return value !== undefined && value.toFixed(2);
	}, 'from': Number };

	function testStep ( parsed, entry ) {

		if ( !isNumeric( entry ) ) {
			throw new Error("noUiSlider (" + VERSION + "): 'step' is not numeric.");
		}

		// The step option can still be used to set stepping
		// for linear sliders. Overwritten if set in 'range'.
		parsed.singleStep = entry;
	}

	function testRange ( parsed, entry ) {

		// Filter incorrect input.
		if ( typeof entry !== 'object' || Array.isArray(entry) ) {
			throw new Error("noUiSlider (" + VERSION + "): 'range' is not an object.");
		}

		// Catch missing start or end.
		if ( entry.min === undefined || entry.max === undefined ) {
			throw new Error("noUiSlider (" + VERSION + "): Missing 'min' or 'max' in 'range'.");
		}

		// Catch equal start or end.
		if ( entry.min === entry.max ) {
			throw new Error("noUiSlider (" + VERSION + "): 'range' 'min' and 'max' cannot be equal.");
		}

		parsed.spectrum = new Spectrum(entry, parsed.snap, parsed.dir, parsed.singleStep);
	}

	function testStart ( parsed, entry ) {

		entry = asArray(entry);

		// Validate input. Values aren't tested, as the public .val method
		// will always provide a valid location.
		if ( !Array.isArray( entry ) || !entry.length ) {
			throw new Error("noUiSlider (" + VERSION + "): 'start' option is incorrect.");
		}

		// Store the number of handles.
		parsed.handles = entry.length;

		// When the slider is initialized, the .val method will
		// be called with the start options.
		parsed.start = entry;
	}

	function testSnap ( parsed, entry ) {

		// Enforce 100% stepping within subranges.
		parsed.snap = entry;

		if ( typeof entry !== 'boolean' ){
			throw new Error("noUiSlider (" + VERSION + "): 'snap' option must be a boolean.");
		}
	}

	function testAnimate ( parsed, entry ) {

		// Enforce 100% stepping within subranges.
		parsed.animate = entry;

		if ( typeof entry !== 'boolean' ){
			throw new Error("noUiSlider (" + VERSION + "): 'animate' option must be a boolean.");
		}
	}

	function testAnimationDuration ( parsed, entry ) {

		parsed.animationDuration = entry;

		if ( typeof entry !== 'number' ){
			throw new Error("noUiSlider (" + VERSION + "): 'animationDuration' option must be a number.");
		}
	}

	function testConnect ( parsed, entry ) {

		var connect = [false];
		var i;

		// Map legacy options
		if ( entry === 'lower' ) {
			entry = [true, false];
		}

		else if ( entry === 'upper' ) {
			entry = [false, true];
		}

		// Handle boolean options
		if ( entry === true || entry === false ) {

			for ( i = 1; i < parsed.handles; i++ ) {
				connect.push(entry);
			}

			connect.push(false);
		}

		// Reject invalid input
		else if ( !Array.isArray( entry ) || !entry.length || entry.length !== parsed.handles + 1 ) {
			throw new Error("noUiSlider (" + VERSION + "): 'connect' option doesn't match handle count.");
		}

		else {
			connect = entry;
		}

		parsed.connect = connect;
	}

	function testOrientation ( parsed, entry ) {

		// Set orientation to an a numerical value for easy
		// array selection.
		switch ( entry ){
		  case 'horizontal':
			parsed.ort = 0;
			break;
		  case 'vertical':
			parsed.ort = 1;
			break;
		  default:
			throw new Error("noUiSlider (" + VERSION + "): 'orientation' option is invalid.");
		}
	}

	function testMargin ( parsed, entry ) {

		if ( !isNumeric(entry) ){
			throw new Error("noUiSlider (" + VERSION + "): 'margin' option must be numeric.");
		}

		// Issue #582
		if ( entry === 0 ) {
			return;
		}

		parsed.margin = parsed.spectrum.getMargin(entry);

		if ( !parsed.margin ) {
			throw new Error("noUiSlider (" + VERSION + "): 'margin' option is only supported on linear sliders.");
		}
	}

	function testLimit ( parsed, entry ) {

		if ( !isNumeric(entry) ){
			throw new Error("noUiSlider (" + VERSION + "): 'limit' option must be numeric.");
		}

		parsed.limit = parsed.spectrum.getMargin(entry);

		if ( !parsed.limit || parsed.handles < 2 ) {
			throw new Error("noUiSlider (" + VERSION + "): 'limit' option is only supported on linear sliders with 2 or more handles.");
		}
	}

	function testPadding ( parsed, entry ) {

		if ( !isNumeric(entry) ){
			throw new Error("noUiSlider (" + VERSION + "): 'padding' option must be numeric.");
		}

		if ( entry === 0 ) {
			return;
		}

		parsed.padding = parsed.spectrum.getMargin(entry);

		if ( !parsed.padding ) {
			throw new Error("noUiSlider (" + VERSION + "): 'padding' option is only supported on linear sliders.");
		}

		if ( parsed.padding < 0 ) {
			throw new Error("noUiSlider (" + VERSION + "): 'padding' option must be a positive number.");
		}

		if ( parsed.padding >= 50 ) {
			throw new Error("noUiSlider (" + VERSION + "): 'padding' option must be less than half the range.");
		}
	}

	function testDirection ( parsed, entry ) {

		// Set direction as a numerical value for easy parsing.
		// Invert connection for RTL sliders, so that the proper
		// handles get the connect/background classes.
		switch ( entry ) {
		  case 'ltr':
			parsed.dir = 0;
			break;
		  case 'rtl':
			parsed.dir = 1;
			break;
		  default:
			throw new Error("noUiSlider (" + VERSION + "): 'direction' option was not recognized.");
		}
	}

	function testBehaviour ( parsed, entry ) {

		// Make sure the input is a string.
		if ( typeof entry !== 'string' ) {
			throw new Error("noUiSlider (" + VERSION + "): 'behaviour' must be a string containing options.");
		}

		// Check if the string contains any keywords.
		// None are required.
		var tap = entry.indexOf('tap') >= 0;
		var drag = entry.indexOf('drag') >= 0;
		var fixed = entry.indexOf('fixed') >= 0;
		var snap = entry.indexOf('snap') >= 0;
		var hover = entry.indexOf('hover') >= 0;

		if ( fixed ) {

			if ( parsed.handles !== 2 ) {
				throw new Error("noUiSlider (" + VERSION + "): 'fixed' behaviour must be used with 2 handles");
			}

			// Use margin to enforce fixed state
			testMargin(parsed, parsed.start[1] - parsed.start[0]);
		}

		parsed.events = {
			tap: tap || snap,
			drag: drag,
			fixed: fixed,
			snap: snap,
			hover: hover
		};
	}

	function testTooltips ( parsed, entry ) {

		if ( entry === false ) {
			return;
		}

		else if ( entry === true ) {

			parsed.tooltips = [];

			for ( var i = 0; i < parsed.handles; i++ ) {
				parsed.tooltips.push(true);
			}
		}

		else {

			parsed.tooltips = asArray(entry);

			if ( parsed.tooltips.length !== parsed.handles ) {
				throw new Error("noUiSlider (" + VERSION + "): must pass a formatter for all handles.");
			}

			parsed.tooltips.forEach(function(formatter){
				if ( typeof formatter !== 'boolean' && (typeof formatter !== 'object' || typeof formatter.to !== 'function') ) {
					throw new Error("noUiSlider (" + VERSION + "): 'tooltips' must be passed a formatter or 'false'.");
				}
			});
		}
	}

	function testFormat ( parsed, entry ) {

		parsed.format = entry;

		// Any object with a to and from method is supported.
		if ( typeof entry.to === 'function' && typeof entry.from === 'function' ) {
			return true;
		}

		throw new Error("noUiSlider (" + VERSION + "): 'format' requires 'to' and 'from' methods.");
	}

	function testCssPrefix ( parsed, entry ) {

		if ( entry !== undefined && typeof entry !== 'string' && entry !== false ) {
			throw new Error("noUiSlider (" + VERSION + "): 'cssPrefix' must be a string or `false`.");
		}

		parsed.cssPrefix = entry;
	}

	function testCssClasses ( parsed, entry ) {

		if ( entry !== undefined && typeof entry !== 'object' ) {
			throw new Error("noUiSlider (" + VERSION + "): 'cssClasses' must be an object.");
		}

		if ( typeof parsed.cssPrefix === 'string' ) {
			parsed.cssClasses = {};

			for ( var key in entry ) {
				if ( !entry.hasOwnProperty(key) ) { continue; }

				parsed.cssClasses[key] = parsed.cssPrefix + entry[key];
			}
		} else {
			parsed.cssClasses = entry;
		}
	}

	function testUseRaf ( parsed, entry ) {
		if ( entry === true || entry === false ) {
			parsed.useRequestAnimationFrame = entry;
		} else {
			throw new Error("noUiSlider (" + VERSION + "): 'useRequestAnimationFrame' option should be true (default) or false.");
		}
	}

	// Test all developer settings and parse to assumption-safe values.
	function testOptions ( options ) {

		// To prove a fix for #537, freeze options here.
		// If the object is modified, an error will be thrown.
		// Object.freeze(options);

		var parsed = {
			margin: 0,
			limit: 0,
			padding: 0,
			animate: true,
			animationDuration: 300,
			format: defaultFormatter
		};

		// Tests are executed in the order they are presented here.
		var tests = {
			'step': { r: false, t: testStep },
			'start': { r: true, t: testStart },
			'connect': { r: true, t: testConnect },
			'direction': { r: true, t: testDirection },
			'snap': { r: false, t: testSnap },
			'animate': { r: false, t: testAnimate },
			'animationDuration': { r: false, t: testAnimationDuration },
			'range': { r: true, t: testRange },
			'orientation': { r: false, t: testOrientation },
			'margin': { r: false, t: testMargin },
			'limit': { r: false, t: testLimit },
			'padding': { r: false, t: testPadding },
			'behaviour': { r: true, t: testBehaviour },
			'format': { r: false, t: testFormat },
			'tooltips': { r: false, t: testTooltips },
			'cssPrefix': { r: false, t: testCssPrefix },
			'cssClasses': { r: false, t: testCssClasses },
			'useRequestAnimationFrame': { r: false, t: testUseRaf }
		};

		var defaults = {
			'connect': false,
			'direction': 'ltr',
			'behaviour': 'tap',
			'orientation': 'horizontal',
			'cssPrefix' : 'noUi-',
			'cssClasses': {
				target: 'target',
				base: 'base',
				origin: 'origin',
				handle: 'handle',
				handleLower: 'handle-lower',
				handleUpper: 'handle-upper',
				horizontal: 'horizontal',
				vertical: 'vertical',
				background: 'background',
				connect: 'connect',
				ltr: 'ltr',
				rtl: 'rtl',
				draggable: 'draggable',
				drag: 'state-drag',
				tap: 'state-tap',
				active: 'active',
				tooltip: 'tooltip',
				pips: 'pips',
				pipsHorizontal: 'pips-horizontal',
				pipsVertical: 'pips-vertical',
				marker: 'marker',
				markerHorizontal: 'marker-horizontal',
				markerVertical: 'marker-vertical',
				markerNormal: 'marker-normal',
				markerLarge: 'marker-large',
				markerSub: 'marker-sub',
				value: 'value',
				valueHorizontal: 'value-horizontal',
				valueVertical: 'value-vertical',
				valueNormal: 'value-normal',
				valueLarge: 'value-large',
				valueSub: 'value-sub'
			},
			'useRequestAnimationFrame': true
		};

		// Run all options through a testing mechanism to ensure correct
		// input. It should be noted that options might get modified to
		// be handled properly. E.g. wrapping integers in arrays.
		Object.keys(tests).forEach(function( name ){

			// If the option isn't set, but it is required, throw an error.
			if ( options[name] === undefined && defaults[name] === undefined ) {

				if ( tests[name].r ) {
					throw new Error("noUiSlider (" + VERSION + "): '" + name + "' is required.");
				}

				return true;
			}

			tests[name].t( parsed, options[name] === undefined ? defaults[name] : options[name] );
		});

		// Forward pips options
		parsed.pips = options.pips;

		var styles = [['left', 'top'], ['right', 'bottom']];

		// Pre-define the styles.
		parsed.style = styles[parsed.dir][parsed.ort];
		parsed.styleOposite = styles[parsed.dir?0:1][parsed.ort];

		return parsed;
	}


function closure ( target, options, originalOptions ){

	var actions = getActions( );

	// All variables local to 'closure' are prefixed with 'scope_'
	var scope_Target = target;
	var scope_Locations = [];
	var scope_Base;
	var scope_Handles;
	var scope_HandleNumbers = [];
	var scope_ActiveHandle = false;
	var scope_Connects;
	var scope_Spectrum = options.spectrum;
	var scope_Values = [];
	var scope_Events = {};
	var scope_Self;


	// Append a origin to the base
	function addOrigin ( base, handleNumber ) {

		var origin = addNodeTo(base, options.cssClasses.origin);
		var handle = addNodeTo(origin, options.cssClasses.handle);

		handle.setAttribute('data-handle', handleNumber);

		if ( handleNumber === 0 ) {
			addClass(handle, options.cssClasses.handleLower);
		}

		else if ( handleNumber === options.handles - 1 ) {
			addClass(handle, options.cssClasses.handleUpper);
		}

		return origin;
	}

	// Insert nodes for connect elements
	function addConnect ( base, add ) {

		if ( !add ) {
			return false;
		}

		return addNodeTo(base, options.cssClasses.connect);
	}

	// Add handles to the slider base.
	function addElements ( connectOptions, base ) {

		scope_Handles = [];
		scope_Connects = [];

		scope_Connects.push(addConnect(base, connectOptions[0]));

		// [::::O====O====O====]
		// connectOptions = [0, 1, 1, 1]

		for ( var i = 0; i < options.handles; i++ ) {
			// Keep a list of all added handles.
			scope_Handles.push(addOrigin(base, i));
			scope_HandleNumbers[i] = i;
			scope_Connects.push(addConnect(base, connectOptions[i + 1]));
		}
	}

	// Initialize a single slider.
	function addSlider ( target ) {

		// Apply classes and data to the target.
		addClass(target, options.cssClasses.target);

		if ( options.dir === 0 ) {
			addClass(target, options.cssClasses.ltr);
		} else {
			addClass(target, options.cssClasses.rtl);
		}

		if ( options.ort === 0 ) {
			addClass(target, options.cssClasses.horizontal);
		} else {
			addClass(target, options.cssClasses.vertical);
		}

		scope_Base = addNodeTo(target, options.cssClasses.base);
	}


	function addTooltip ( handle, handleNumber ) {

		if ( !options.tooltips[handleNumber] ) {
			return false;
		}

		return addNodeTo(handle.firstChild, options.cssClasses.tooltip);
	}

	// The tooltips option is a shorthand for using the 'update' event.
	function tooltips ( ) {

		// Tooltips are added with options.tooltips in original order.
		var tips = scope_Handles.map(addTooltip);

		bindEvent('update', function(values, handleNumber, unencoded) {

			if ( !tips[handleNumber] ) {
				return;
			}

			var formattedValue = values[handleNumber];

			if ( options.tooltips[handleNumber] !== true ) {
				formattedValue = options.tooltips[handleNumber].to(unencoded[handleNumber]);
			}

			tips[handleNumber].innerHTML = formattedValue;
		});
	}


	function getGroup ( mode, values, stepped ) {

		// Use the range.
		if ( mode === 'range' || mode === 'steps' ) {
			return scope_Spectrum.xVal;
		}

		if ( mode === 'count' ) {

			if ( !values ) {
				throw new Error("noUiSlider (" + VERSION + "): 'values' required for mode 'count'.");
			}

			// Divide 0 - 100 in 'count' parts.
			var spread = ( 100 / (values - 1) );
			var v;
			var i = 0;

			values = [];

			// List these parts and have them handled as 'positions'.
			while ( (v = i++ * spread) <= 100 ) {
				values.push(v);
			}

			mode = 'positions';
		}

		if ( mode === 'positions' ) {

			// Map all percentages to on-range values.
			return values.map(function( value ){
				return scope_Spectrum.fromStepping( stepped ? scope_Spectrum.getStep( value ) : value );
			});
		}

		if ( mode === 'values' ) {

			// If the value must be stepped, it needs to be converted to a percentage first.
			if ( stepped ) {

				return values.map(function( value ){

					// Convert to percentage, apply step, return to value.
					return scope_Spectrum.fromStepping( scope_Spectrum.getStep( scope_Spectrum.toStepping( value ) ) );
				});

			}

			// Otherwise, we can simply use the values.
			return values;
		}
	}

	function generateSpread ( density, mode, group ) {

		function safeIncrement(value, increment) {
			// Avoid floating point variance by dropping the smallest decimal places.
			return (value + increment).toFixed(7) / 1;
		}

		var indexes = {};
		var firstInRange = scope_Spectrum.xVal[0];
		var lastInRange = scope_Spectrum.xVal[scope_Spectrum.xVal.length-1];
		var ignoreFirst = false;
		var ignoreLast = false;
		var prevPct = 0;

		// Create a copy of the group, sort it and filter away all duplicates.
		group = unique(group.slice().sort(function(a, b){ return a - b; }));

		// Make sure the range starts with the first element.
		if ( group[0] !== firstInRange ) {
			group.unshift(firstInRange);
			ignoreFirst = true;
		}

		// Likewise for the last one.
		if ( group[group.length - 1] !== lastInRange ) {
			group.push(lastInRange);
			ignoreLast = true;
		}

		group.forEach(function ( current, index ) {

			// Get the current step and the lower + upper positions.
			var step;
			var i;
			var q;
			var low = current;
			var high = group[index+1];
			var newPct;
			var pctDifference;
			var pctPos;
			var type;
			var steps;
			var realSteps;
			var stepsize;

			// When using 'steps' mode, use the provided steps.
			// Otherwise, we'll step on to the next subrange.
			if ( mode === 'steps' ) {
				step = scope_Spectrum.xNumSteps[ index ];
			}

			// Default to a 'full' step.
			if ( !step ) {
				step = high-low;
			}

			// Low can be 0, so test for false. If high is undefined,
			// we are at the last subrange. Index 0 is already handled.
			if ( low === false || high === undefined ) {
				return;
			}

			// Make sure step isn't 0, which would cause an infinite loop (#654)
			step = Math.max(step, 0.0000001);

			// Find all steps in the subrange.
			for ( i = low; i <= high; i = safeIncrement(i, step) ) {

				// Get the percentage value for the current step,
				// calculate the size for the subrange.
				newPct = scope_Spectrum.toStepping( i );
				pctDifference = newPct - prevPct;

				steps = pctDifference / density;
				realSteps = Math.round(steps);

				// This ratio represents the ammount of percentage-space a point indicates.
				// For a density 1 the points/percentage = 1. For density 2, that percentage needs to be re-devided.
				// Round the percentage offset to an even number, then divide by two
				// to spread the offset on both sides of the range.
				stepsize = pctDifference/realSteps;

				// Divide all points evenly, adding the correct number to this subrange.
				// Run up to <= so that 100% gets a point, event if ignoreLast is set.
				for ( q = 1; q <= realSteps; q += 1 ) {

					// The ratio between the rounded value and the actual size might be ~1% off.
					// Correct the percentage offset by the number of points
					// per subrange. density = 1 will result in 100 points on the
					// full range, 2 for 50, 4 for 25, etc.
					pctPos = prevPct + ( q * stepsize );
					indexes[pctPos.toFixed(5)] = ['x', 0];
				}

				// Determine the point type.
				type = (group.indexOf(i) > -1) ? 1 : ( mode === 'steps' ? 2 : 0 );

				// Enforce the 'ignoreFirst' option by overwriting the type for 0.
				if ( !index && ignoreFirst ) {
					type = 0;
				}

				if ( !(i === high && ignoreLast)) {
					// Mark the 'type' of this point. 0 = plain, 1 = real value, 2 = step value.
					indexes[newPct.toFixed(5)] = [i, type];
				}

				// Update the percentage count.
				prevPct = newPct;
			}
		});

		return indexes;
	}

	function addMarking ( spread, filterFunc, formatter ) {

		var element = document.createElement('div');
		var out = '';
		var valueSizeClasses = [
			options.cssClasses.valueNormal,
			options.cssClasses.valueLarge,
			options.cssClasses.valueSub
		];
		var markerSizeClasses = [
			options.cssClasses.markerNormal,
			options.cssClasses.markerLarge,
			options.cssClasses.markerSub
		];
		var valueOrientationClasses = [
			options.cssClasses.valueHorizontal,
			options.cssClasses.valueVertical
		];
		var markerOrientationClasses = [
			options.cssClasses.markerHorizontal,
			options.cssClasses.markerVertical
		];

		addClass(element, options.cssClasses.pips);
		addClass(element, options.ort === 0 ? options.cssClasses.pipsHorizontal : options.cssClasses.pipsVertical);

		function getClasses( type, source ){
			var a = source === options.cssClasses.value;
			var orientationClasses = a ? valueOrientationClasses : markerOrientationClasses;
			var sizeClasses = a ? valueSizeClasses : markerSizeClasses;

			return source + ' ' + orientationClasses[options.ort] + ' ' + sizeClasses[type];
		}

		function getTags( offset, source, values ) {
			return 'class="' + getClasses(values[1], source) + '" style="' + options.style + ': ' + offset + '%"';
		}

		function addSpread ( offset, values ){

			// Apply the filter function, if it is set.
			values[1] = (values[1] && filterFunc) ? filterFunc(values[0], values[1]) : values[1];

			// Add a marker for every point
			out += '<div ' + getTags(offset, options.cssClasses.marker, values) + '></div>';

			// Values are only appended for points marked '1' or '2'.
			if ( values[1] ) {
				out += '<div ' + getTags(offset, options.cssClasses.value, values) + '>' + formatter.to(values[0]) + '</div>';
			}
		}

		// Append all points.
		Object.keys(spread).forEach(function(a){
			addSpread(a, spread[a]);
		});

		element.innerHTML = out;

		return element;
	}

	function pips ( grid ) {

		var mode = grid.mode;
		var density = grid.density || 1;
		var filter = grid.filter || false;
		var values = grid.values || false;
		var stepped = grid.stepped || false;
		var group = getGroup( mode, values, stepped );
		var spread = generateSpread( density, mode, group );
		var format = grid.format || {
			to: Math.round
		};

		return scope_Target.appendChild(addMarking(
			spread,
			filter,
			format
		));
	}


	// Shorthand for base dimensions.
	function baseSize ( ) {
		var rect = scope_Base.getBoundingClientRect(), alt = 'offset' + ['Width', 'Height'][options.ort];
		return options.ort === 0 ? (rect.width||scope_Base[alt]) : (rect.height||scope_Base[alt]);
	}

	// Handler for attaching events trough a proxy.
	function attachEvent ( events, element, callback, data ) {

		// This function can be used to 'filter' events to the slider.
		// element is a node, not a nodeList

		var method = function ( e ){

			if ( scope_Target.hasAttribute('disabled') ) {
				return false;
			}

			// Stop if an active 'tap' transition is taking place.
			if ( hasClass(scope_Target, options.cssClasses.tap) ) {
				return false;
			}

			e = fixEvent(e, data.pageOffset);

			// Handle reject of multitouch
			if ( !e ) {
				return false;
			}

			// Ignore right or middle clicks on start #454
			if ( events === actions.start && e.buttons !== undefined && e.buttons > 1 ) {
				return false;
			}

			// Ignore right or middle clicks on start #454
			if ( data.hover && e.buttons ) {
				return false;
			}

			e.calcPoint = e.points[ options.ort ];

			// Call the event handler with the event [ and additional data ].
			callback ( e, data );
		};

		var methods = [];

		// Bind a closure on the target for every event type.
		events.split(' ').forEach(function( eventName ){
			element.addEventListener(eventName, method, false);
			methods.push([eventName, method]);
		});

		return methods;
	}

	// Provide a clean event with standardized offset values.
	function fixEvent ( e, pageOffset ) {

		// Prevent scrolling and panning on touch events, while
		// attempting to slide. The tap event also depends on this.
		e.preventDefault();

		// Filter the event to register the type, which can be
		// touch, mouse or pointer. Offset changes need to be
		// made on an event specific basis.
		var touch = e.type.indexOf('touch') === 0;
		var mouse = e.type.indexOf('mouse') === 0;
		var pointer = e.type.indexOf('pointer') === 0;
		var x;
		var y;

		// IE10 implemented pointer events with a prefix;
		if ( e.type.indexOf('MSPointer') === 0 ) {
			pointer = true;
		}

		if ( touch ) {

			// Fix bug when user touches with two or more fingers on mobile devices.
			// It's useful when you have two or more sliders on one page,
			// that can be touched simultaneously.
			// #649, #663, #668
			if ( e.touches.length > 1 ) {
				return false;
			}

			// noUiSlider supports one movement at a time,
			// so we can select the first 'changedTouch'.
			x = e.changedTouches[0].pageX;
			y = e.changedTouches[0].pageY;
		}

		pageOffset = pageOffset || getPageOffset();

		if ( mouse || pointer ) {
			x = e.clientX + pageOffset.x;
			y = e.clientY + pageOffset.y;
		}

		e.pageOffset = pageOffset;
		e.points = [x, y];
		e.cursor = mouse || pointer; // Fix #435

		return e;
	}

	// Translate a coordinate in the document to a percentage on the slider
	function calcPointToPercentage ( calcPoint ) {
		var location = calcPoint - offset(scope_Base, options.ort);
		var proposal = ( location * 100 ) / baseSize();
		return options.dir ? 100 - proposal : proposal;
	}

	// Find handle closest to a certain percentage on the slider
	function getClosestHandle ( proposal ) {

		var closest = 100;
		var handleNumber = false;

		scope_Handles.forEach(function(handle, index){

			// Disabled handles are ignored
			if ( handle.hasAttribute('disabled') ) {
				return;
			}

			var pos = Math.abs(scope_Locations[index] - proposal);

			if ( pos < closest ) {
				handleNumber = index;
				closest = pos;
			}
		});

		return handleNumber;
	}

	// Moves handle(s) by a percentage
	// (bool, % to move, [% where handle started, ...], [index in scope_Handles, ...])
	function moveHandles ( upward, proposal, locations, handleNumbers ) {

		var proposals = locations.slice();

		var b = [!upward, upward];
		var f = [upward, !upward];

		// Copy handleNumbers so we don't change the dataset
		handleNumbers = handleNumbers.slice();

		// Check to see which handle is 'leading'.
		// If that one can't move the second can't either.
		if ( upward ) {
			handleNumbers.reverse();
		}

		// Step 1: get the maximum percentage that any of the handles can move
		if ( handleNumbers.length > 1 ) {

			handleNumbers.forEach(function(handleNumber, o) {

				var to = checkHandlePosition(proposals, handleNumber, proposals[handleNumber] + proposal, b[o], f[o]);

				// Stop if one of the handles can't move.
				if ( to === false ) {
					proposal = 0;
				} else {
					proposal = to - proposals[handleNumber];
					proposals[handleNumber] = to;
				}
			});
		}

		// If using one handle, check backward AND forward
		else {
			b = f = [true];
		}

		var state = false;

		// Step 2: Try to set the handles with the found percentage
		handleNumbers.forEach(function(handleNumber, o) {
			state = setHandle(handleNumber, locations[handleNumber] + proposal, b[o], f[o]) || state;
		});

		// Step 3: If a handle moved, fire events
		if ( state ) {
			handleNumbers.forEach(function(handleNumber){
				fireEvent('update', handleNumber);
				fireEvent('slide', handleNumber);
			});
		}
	}

	// External event handling
	function fireEvent ( eventName, handleNumber, tap ) {

		Object.keys(scope_Events).forEach(function( targetEvent ) {

			var eventType = targetEvent.split('.')[0];

			if ( eventName === eventType ) {
				scope_Events[targetEvent].forEach(function( callback ) {

					callback.call(
						// Use the slider public API as the scope ('this')
						scope_Self,
						// Return values as array, so arg_1[arg_2] is always valid.
						scope_Values.map(options.format.to),
						// Handle index, 0 or 1
						handleNumber,
						// Unformatted slider values
						scope_Values.slice(),
						// Event is fired by tap, true or false
						tap || false,
						// Left offset of the handle, in relation to the slider
						scope_Locations.slice()
					);
				});
			}
		});
	}


	// Fire 'end' when a mouse or pen leaves the document.
	function documentLeave ( event, data ) {
		if ( event.type === "mouseout" && event.target.nodeName === "HTML" && event.relatedTarget === null ){
			eventEnd (event, data);
		}
	}

	// Handle movement on document for handle and range drag.
	function eventMove ( event, data ) {

		// Fix #498
		// Check value of .buttons in 'start' to work around a bug in IE10 mobile (data.buttonsProperty).
		// https://connect.microsoft.com/IE/feedback/details/927005/mobile-ie10-windows-phone-buttons-property-of-pointermove-event-always-zero
		// IE9 has .buttons and .which zero on mousemove.
		// Firefox breaks the spec MDN defines.
		if ( navigator.appVersion.indexOf("MSIE 9") === -1 && event.buttons === 0 && data.buttonsProperty !== 0 ) {
			return eventEnd(event, data);
		}

		// Check if we are moving up or down
		var movement = (options.dir ? -1 : 1) * (event.calcPoint - data.startCalcPoint);

		// Convert the movement into a percentage of the slider width/height
		var proposal = (movement * 100) / data.baseSize;

		moveHandles(movement > 0, proposal, data.locations, data.handleNumbers);
	}

	// Unbind move events on document, call callbacks.
	function eventEnd ( event, data ) {

		// The handle is no longer active, so remove the class.
		if ( scope_ActiveHandle ) {
			removeClass(scope_ActiveHandle, options.cssClasses.active);
			scope_ActiveHandle = false;
		}

		// Remove cursor styles and text-selection events bound to the body.
		if ( event.cursor ) {
			document.body.style.cursor = '';
			document.body.removeEventListener('selectstart', document.body.noUiListener);
		}

		// Unbind the move and end events, which are added on 'start'.
		document.documentElement.noUiListeners.forEach(function( c ) {
			document.documentElement.removeEventListener(c[0], c[1]);
		});

		// Remove dragging class.
		removeClass(scope_Target, options.cssClasses.drag);

		setZindex();

		data.handleNumbers.forEach(function(handleNumber){
			fireEvent('set', handleNumber);
			fireEvent('change', handleNumber);
			fireEvent('end', handleNumber);
		});
	}

	// Bind move events on document.
	function eventStart ( event, data ) {

		if ( data.handleNumbers.length === 1 ) {

			var handle = scope_Handles[data.handleNumbers[0]];

			// Ignore 'disabled' handles
			if ( handle.hasAttribute('disabled') ) {
				return false;
			}

			// Mark the handle as 'active' so it can be styled.
			scope_ActiveHandle = handle.children[0];
			addClass(scope_ActiveHandle, options.cssClasses.active);
		}

		// Fix #551, where a handle gets selected instead of dragged.
		event.preventDefault();

		// A drag should never propagate up to the 'tap' event.
		event.stopPropagation();

		// Attach the move and end events.
		var moveEvent = attachEvent(actions.move, document.documentElement, eventMove, {
			startCalcPoint: event.calcPoint,
			baseSize: baseSize(),
			pageOffset: event.pageOffset,
			handleNumbers: data.handleNumbers,
			buttonsProperty: event.buttons,
			locations: scope_Locations.slice()
		});

		var endEvent = attachEvent(actions.end, document.documentElement, eventEnd, {
			handleNumbers: data.handleNumbers
		});

		var outEvent = attachEvent("mouseout", document.documentElement, documentLeave, {
			handleNumbers: data.handleNumbers
		});

		document.documentElement.noUiListeners = moveEvent.concat(endEvent, outEvent);

		// Text selection isn't an issue on touch devices,
		// so adding cursor styles can be skipped.
		if ( event.cursor ) {

			// Prevent the 'I' cursor and extend the range-drag cursor.
			document.body.style.cursor = getComputedStyle(event.target).cursor;

			// Mark the target with a dragging state.
			if ( scope_Handles.length > 1 ) {
				addClass(scope_Target, options.cssClasses.drag);
			}

			var f = function(){
				return false;
			};

			document.body.noUiListener = f;

			// Prevent text selection when dragging the handles.
			document.body.addEventListener('selectstart', f, false);
		}

		data.handleNumbers.forEach(function(handleNumber){
			fireEvent('start', handleNumber);
		});
	}

	// Move closest handle to tapped location.
	function eventTap ( event ) {

		// The tap event shouldn't propagate up
		event.stopPropagation();

		var proposal = calcPointToPercentage(event.calcPoint);
		var handleNumber = getClosestHandle(proposal);

		// Tackle the case that all handles are 'disabled'.
		if ( handleNumber === false ) {
			return false;
		}

		// Flag the slider as it is now in a transitional state.
		// Transition takes a configurable amount of ms (default 300). Re-enable the slider after that.
		if ( !options.events.snap ) {
			addClassFor(scope_Target, options.cssClasses.tap, options.animationDuration);
		}

		setHandle(handleNumber, proposal, true, true);

		setZindex();

		fireEvent('slide', handleNumber, true);
		fireEvent('set', handleNumber, true);
		fireEvent('change', handleNumber, true);
		fireEvent('update', handleNumber, true);

		if ( options.events.snap ) {
			eventStart(event, { handleNumbers: [handleNumber] });
		}
	}

	// Fires a 'hover' event for a hovered mouse/pen position.
	function eventHover ( event ) {

		var proposal = calcPointToPercentage(event.calcPoint);

		var to = scope_Spectrum.getStep(proposal);
		var value = scope_Spectrum.fromStepping(to);

		Object.keys(scope_Events).forEach(function( targetEvent ) {
			if ( 'hover' === targetEvent.split('.')[0] ) {
				scope_Events[targetEvent].forEach(function( callback ) {
					callback.call( scope_Self, value );
				});
			}
		});
	}

	// Attach events to several slider parts.
	function bindSliderEvents ( behaviour ) {

		// Attach the standard drag event to the handles.
		if ( !behaviour.fixed ) {

			scope_Handles.forEach(function( handle, index ){

				// These events are only bound to the visual handle
				// element, not the 'real' origin element.
				attachEvent ( actions.start, handle.children[0], eventStart, {
					handleNumbers: [index]
				});
			});
		}

		// Attach the tap event to the slider base.
		if ( behaviour.tap ) {
			attachEvent (actions.start, scope_Base, eventTap, {});
		}

		// Fire hover events
		if ( behaviour.hover ) {
			attachEvent (actions.move, scope_Base, eventHover, { hover: true });
		}

		// Make the range draggable.
		if ( behaviour.drag ){

			scope_Connects.forEach(function( connect, index ){

				if ( connect === false || index === 0 || index === scope_Connects.length - 1 ) {
					return;
				}

				var handleBefore = scope_Handles[index - 1];
				var handleAfter = scope_Handles[index];
				var eventHolders = [connect];

				addClass(connect, options.cssClasses.draggable);

				// When the range is fixed, the entire range can
				// be dragged by the handles. The handle in the first
				// origin will propagate the start event upward,
				// but it needs to be bound manually on the other.
				if ( behaviour.fixed ) {
					eventHolders.push(handleBefore.children[0]);
					eventHolders.push(handleAfter.children[0]);
				}

				eventHolders.forEach(function( eventHolder ) {
					attachEvent ( actions.start, eventHolder, eventStart, {
						handles: [handleBefore, handleAfter],
						handleNumbers: [index - 1, index]
					});
				});
			});
		}
	}


	// Split out the handle positioning logic so the Move event can use it, too
	function checkHandlePosition ( reference, handleNumber, to, lookBackward, lookForward ) {

		// For sliders with multiple handles, limit movement to the other handle.
		// Apply the margin option by adding it to the handle positions.
		if ( scope_Handles.length > 1 ) {

			if ( lookBackward && handleNumber > 0 ) {
				to = Math.max(to, reference[handleNumber - 1] + options.margin);
			}

			if ( lookForward && handleNumber < scope_Handles.length - 1 ) {
				to = Math.min(to, reference[handleNumber + 1] - options.margin);
			}
		}

		// The limit option has the opposite effect, limiting handles to a
		// maximum distance from another. Limit must be > 0, as otherwise
		// handles would be unmoveable.
		if ( scope_Handles.length > 1 && options.limit ) {

			if ( lookBackward && handleNumber > 0 ) {
				to = Math.min(to, reference[handleNumber - 1] + options.limit);
			}

			if ( lookForward && handleNumber < scope_Handles.length - 1 ) {
				to = Math.max(to, reference[handleNumber + 1] - options.limit);
			}
		}

		// The padding option keeps the handles a certain distance from the
		// edges of the slider. Padding must be > 0.
		if ( options.padding ) {

			if ( handleNumber === 0 ) {
				to = Math.max(to, options.padding);
			}

			if ( handleNumber === scope_Handles.length - 1 ) {
				to = Math.min(to, 100 - options.padding);
			}
		}

		to = scope_Spectrum.getStep(to);

		// Limit percentage to the 0 - 100 range
		to = limit(to);

		// Return false if handle can't move
		if ( to === reference[handleNumber] ) {
			return false;
		}

		return to;
	}

	function toPct ( pct ) {
		return pct + '%';
	}

	// Updates scope_Locations and scope_Values, updates visual state
	function updateHandlePosition ( handleNumber, to ) {

		// Update locations.
		scope_Locations[handleNumber] = to;

		// Convert the value to the slider stepping/range.
		scope_Values[handleNumber] = scope_Spectrum.fromStepping(to);

		// Called synchronously or on the next animationFrame
		var stateUpdate = function() {
			scope_Handles[handleNumber].style[options.style] = toPct(to);
			updateConnect(handleNumber);
			updateConnect(handleNumber + 1);
		};

		// Set the handle to the new position.
		// Use requestAnimationFrame for efficient painting.
		// No significant effect in Chrome, Edge sees dramatic performace improvements.
		// Option to disable is useful for unit tests, and single-step debugging.
		if ( window.requestAnimationFrame && options.useRequestAnimationFrame ) {
			window.requestAnimationFrame(stateUpdate);
		} else {
			stateUpdate();
		}
	}

	function setZindex ( ) {

		scope_HandleNumbers.forEach(function(handleNumber){
			// Handles before the slider middle are stacked later = higher,
			// Handles after the middle later is lower
			// [[7] [8] .......... | .......... [5] [4]
			var dir = (scope_Locations[handleNumber] > 50 ? -1 : 1);
			var zIndex = 3 + (scope_Handles.length + (dir * handleNumber));
			scope_Handles[handleNumber].childNodes[0].style.zIndex = zIndex;
		});
	}

	// Test suggested values and apply margin, step.
	function setHandle ( handleNumber, to, lookBackward, lookForward ) {

		to = checkHandlePosition(scope_Locations, handleNumber, to, lookBackward, lookForward);

		if ( to === false ) {
			return false;
		}

		updateHandlePosition(handleNumber, to);

		return true;
	}

	// Updates style attribute for connect nodes
	function updateConnect ( index ) {

		// Skip connects set to false
		if ( !scope_Connects[index] ) {
			return;
		}

		var l = 0;
		var h = 100;

		if ( index !== 0 ) {
			l = scope_Locations[index - 1];
		}

		if ( index !== scope_Connects.length - 1 ) {
			h = scope_Locations[index];
		}

		scope_Connects[index].style[options.style] = toPct(l);
		scope_Connects[index].style[options.styleOposite] = toPct(100 - h);
	}

	// ...
	function setValue ( to, handleNumber ) {

		// Setting with null indicates an 'ignore'.
		// Inputting 'false' is invalid.
		if ( to === null || to === false ) {
			return;
		}

		// If a formatted number was passed, attemt to decode it.
		if ( typeof to === 'number' ) {
			to = String(to);
		}

		to = options.format.from(to);

		// Request an update for all links if the value was invalid.
		// Do so too if setting the handle fails.
		if ( to !== false && !isNaN(to) ) {
			setHandle(handleNumber, scope_Spectrum.toStepping(to), false, false);
		}
	}

	// Set the slider value.
	function valueSet ( input, fireSetEvent ) {

		var values = asArray(input);
		var isInit = scope_Locations[0] === undefined;

		// Event fires by default
		fireSetEvent = (fireSetEvent === undefined ? true : !!fireSetEvent);

		values.forEach(setValue);

		// Animation is optional.
		// Make sure the initial values were set before using animated placement.
		if ( options.animate && !isInit ) {
			addClassFor(scope_Target, options.cssClasses.tap, options.animationDuration);
		}

		// Now that all base values are set, apply constraints
		scope_HandleNumbers.forEach(function(handleNumber){
			setHandle(handleNumber, scope_Locations[handleNumber], true, false);
		});

		setZindex();

		scope_HandleNumbers.forEach(function(handleNumber){

			fireEvent('update', handleNumber);

			// Fire the event only for handles that received a new value, as per #579
			if ( values[handleNumber] !== null && fireSetEvent ) {
				fireEvent('set', handleNumber);
			}
		});
	}

	// Reset slider to initial values
	function valueReset ( fireSetEvent ) {
		valueSet(options.start, fireSetEvent);
	}

	// Get the slider value.
	function valueGet ( ) {

		var values = scope_Values.map(options.format.to);

		// If only one handle is used, return a single value.
		if ( values.length === 1 ){
			return values[0];
		}

		return values;
	}

	// Removes classes from the root and empties it.
	function destroy ( ) {

		for ( var key in options.cssClasses ) {
			if ( !options.cssClasses.hasOwnProperty(key) ) { continue; }
			removeClass(scope_Target, options.cssClasses[key]);
		}

		while (scope_Target.firstChild) {
			scope_Target.removeChild(scope_Target.firstChild);
		}

		delete scope_Target.noUiSlider;
	}

	// Get the current step size for the slider.
	function getCurrentStep ( ) {

		// Check all locations, map them to their stepping point.
		// Get the step point, then find it in the input list.
		return scope_Locations.map(function( location, index ){

			var nearbySteps = scope_Spectrum.getNearbySteps( location );
			var value = scope_Values[index];
			var increment = nearbySteps.thisStep.step;
			var decrement = null;

			// If the next value in this step moves into the next step,
			// the increment is the start of the next step - the current value
			if ( increment !== false ) {
				if ( value + increment > nearbySteps.stepAfter.startValue ) {
					increment = nearbySteps.stepAfter.startValue - value;
				}
			}


			// If the value is beyond the starting point
			if ( value > nearbySteps.thisStep.startValue ) {
				decrement = nearbySteps.thisStep.step;
			}

			else if ( nearbySteps.stepBefore.step === false ) {
				decrement = false;
			}

			// If a handle is at the start of a step, it always steps back into the previous step first
			else {
				decrement = value - nearbySteps.stepBefore.highestStep;
			}


			// Now, if at the slider edges, there is not in/decrement
			if ( location === 100 ) {
				increment = null;
			}

			else if ( location === 0 ) {
				decrement = null;
			}

			// As per #391, the comparison for the decrement step can have some rounding issues.
			var stepDecimals = scope_Spectrum.countStepDecimals();

			// Round per #391
			if ( increment !== null && increment !== false ) {
				increment = Number(increment.toFixed(stepDecimals));
			}

			if ( decrement !== null && decrement !== false ) {
				decrement = Number(decrement.toFixed(stepDecimals));
			}

			return [decrement, increment];
		});
	}

	// Attach an event to this slider, possibly including a namespace
	function bindEvent ( namespacedEvent, callback ) {
		scope_Events[namespacedEvent] = scope_Events[namespacedEvent] || [];
		scope_Events[namespacedEvent].push(callback);

		// If the event bound is 'update,' fire it immediately for all handles.
		if ( namespacedEvent.split('.')[0] === 'update' ) {
			scope_Handles.forEach(function(a, index){
				fireEvent('update', index);
			});
		}
	}

	// Undo attachment of event
	function removeEvent ( namespacedEvent ) {

		var event = namespacedEvent && namespacedEvent.split('.')[0];
		var namespace = event && namespacedEvent.substring(event.length);

		Object.keys(scope_Events).forEach(function( bind ){

			var tEvent = bind.split('.')[0],
				tNamespace = bind.substring(tEvent.length);

			if ( (!event || event === tEvent) && (!namespace || namespace === tNamespace) ) {
				delete scope_Events[bind];
			}
		});
	}

	// Updateable: margin, limit, padding, step, range, animate, snap
	function updateOptions ( optionsToUpdate, fireSetEvent ) {

		// Spectrum is created using the range, snap, direction and step options.
		// 'snap' and 'step' can be updated, 'direction' cannot, due to event binding.
		// If 'snap' and 'step' are not passed, they should remain unchanged.
		var v = valueGet();

		var updateAble = ['margin', 'limit', 'padding', 'range', 'animate', 'snap', 'step', 'format'];

		// Only change options that we're actually passed to update.
		updateAble.forEach(function(name){
			if ( optionsToUpdate[name] !== undefined ) {
				originalOptions[name] = optionsToUpdate[name];
			}
		});

		var newOptions = testOptions(originalOptions);

		// Load new options into the slider state
		updateAble.forEach(function(name){
			if ( optionsToUpdate[name] !== undefined ) {
				options[name] = newOptions[name];
			}
		});

		// Save current spectrum direction as testOptions in testRange call
		// doesn't rely on current direction
		newOptions.spectrum.direction = scope_Spectrum.direction;
		scope_Spectrum = newOptions.spectrum;

		// Limit, margin and padding depend on the spectrum but are stored outside of it. (#677)
		options.margin = newOptions.margin;
		options.limit = newOptions.limit;
		options.padding = newOptions.padding;

		// Invalidate the current positioning so valueSet forces an update.
		scope_Locations = [];
		valueSet(optionsToUpdate.start || v, fireSetEvent);
	}

	// Throw an error if the slider was already initialized.
	if ( scope_Target.noUiSlider ) {
		throw new Error("noUiSlider (" + VERSION + "): Slider was already initialized.");
	}

	// Create the base element, initialise HTML and set classes.
	// Add handles and connect elements.
	addSlider(scope_Target);
	addElements(options.connect, scope_Base);

	scope_Self = {
		destroy: destroy,
		steps: getCurrentStep,
		on: bindEvent,
		off: removeEvent,
		get: valueGet,
		set: valueSet,
		reset: valueReset,
		// Exposed for unit testing, don't use this in your application.
		__moveHandles: function(a, b, c) { moveHandles(a, b, scope_Locations, c); },
		options: originalOptions, // Issue #600, #678
		updateOptions: updateOptions,
		target: scope_Target, // Issue #597
		pips: pips // Issue #594
	};

	// Attach user events.
	bindSliderEvents(options.events);

	// Use the public value method to set the start values.
	valueSet(options.start);

	if ( options.pips ) {
		pips(options.pips);
	}

	if ( options.tooltips ) {
		tooltips();
	}

	return scope_Self;

}


	// Run the standard initializer
	function initialize ( target, originalOptions ) {

		if ( !target.nodeName ) {
			throw new Error("noUiSlider (" + VERSION + "): create requires a single element.");
		}

		// Test the options and create the slider environment;
		var options = testOptions( originalOptions, target );
		var api = closure( target, options, originalOptions );

		target.noUiSlider = api;

		return api;
	}

	// Use an object instead of a function for future expansibility;
	return {
		version: VERSION,
		create: initialize
	};

}));

/***/ }),

/***/ "./node_modules/tether/dist/js/tether.esm.js":
/*!***************************************************!*\
  !*** ./node_modules/tether/dist/js/tether.esm.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/*! tether 2.0.0 */

function _inheritsLoose(subClass, superClass) {
  subClass.prototype = Object.create(superClass.prototype);
  subClass.prototype.constructor = subClass;

  _setPrototypeOf(subClass, superClass);
}

function _setPrototypeOf(o, p) {
  _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
    o.__proto__ = p;
    return o;
  };

  return _setPrototypeOf(o, p);
}

function _assertThisInitialized(self) {
  if (self === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }

  return self;
}

/**
 * Checks if `value` is classified as a `Function` object.
 * @param {*} value The param to check if it is a function
 */
function isFunction(value) {
  return typeof value === 'function';
}
/**
 * Checks if `value` is classified as a `Number` object.
 * @param {*} value The param to check if it is a number
 */

function isNumber(value) {
  return typeof value === 'number';
}
/**
 * Checks if `value` is classified as an `Object`.
 * @param {*} value The param to check if it is an object
 */

function isObject(value) {
  return typeof value === 'object';
}
/**
 * Checks if `value` is classified as a `String` object.
 * @param {*} value The param to check if it is a string
 */

function isString(value) {
  return typeof value === 'string';
}
/**
 * Checks if `value` is undefined.
 * @param {*} value The param to check if it is undefined
 */

function isUndefined(value) {
  return value === undefined;
}

function addClass(el, name) {
  name.split(' ').forEach(function (cls) {
    if (cls.trim()) {
      el.classList.add(cls);
    }
  });
}
/**
 * Get class string based on previously determined classes
 * @param  {String} [key=''] - default value for the classes object
 * @param  {Object} classes
 * @param  {String} classPrefix
 */

function getClass(key, classes, classPrefix) {
  if (key === void 0) {
    key = '';
  }

  if (!isUndefined(classes) && !isUndefined(classes[key])) {
    if (classes[key] === false) {
      return '';
    }

    return classes[key];
  } else if (classPrefix) {
    return classPrefix + "-" + key;
  } else {
    return key;
  }
}
function removeClass(el, name) {
  name.split(' ').forEach(function (cls) {
    if (cls.trim()) {
      el.classList.remove(cls);
    }
  });
}
function updateClasses(el, add, all) {
  // Of the set of 'all' classes, we need the 'add' classes, and only the
  // 'add' classes to be set.
  all.forEach(function (cls) {
    if (add.indexOf(cls) === -1 && el.classList.contains(cls)) {
      removeClass(el, cls);
    }
  });
  add.forEach(function (cls) {
    if (!el.classList.contains(cls)) {
      addClass(el, cls);
    }
  });
}

var deferred = [];
function defer(fn) {
  deferred.push(fn);
}
function flush() {
  var fn; // eslint-disable-next-line

  while (fn = deferred.pop()) {
    fn();
  }
}

var _scrollBarSize = null;
function extend(out) {
  if (out === void 0) {
    out = {};
  }

  var args = [];
  Array.prototype.push.apply(args, arguments);
  args.slice(1).forEach(function (obj) {
    if (obj) {
      for (var key in obj) {
        if ({}.hasOwnProperty.call(obj, key)) {
          out[key] = obj[key];
        }
      }
    }
  });
  return out;
}
function getScrollBarSize() {
  if (_scrollBarSize) {
    return _scrollBarSize;
  }

  var inner = document.createElement('div');
  inner.style.width = '100%';
  inner.style.height = '200px';
  var outer = document.createElement('div');
  extend(outer.style, {
    position: 'absolute',
    top: 0,
    left: 0,
    pointerEvents: 'none',
    visibility: 'hidden',
    width: '200px',
    height: '150px',
    overflow: 'hidden'
  });
  outer.appendChild(inner);
  document.body.appendChild(outer);
  var widthContained = inner.offsetWidth;
  outer.style.overflow = 'scroll';
  var widthScroll = inner.offsetWidth;

  if (widthContained === widthScroll) {
    widthScroll = outer.clientWidth;
  }

  document.body.removeChild(outer);
  var width = widthContained - widthScroll;
  _scrollBarSize = {
    width: width,
    height: width
  };
  return _scrollBarSize;
}
var uniqueId = function () {
  var id = 0;
  return function () {
    return ++id;
  };
}();

var zeroPosCache = {};
var zeroElement = null;
function getBounds(body, el) {
  var doc;

  if (el === document) {
    doc = document;
    el = document.documentElement;
  } else {
    doc = el.ownerDocument;
  }

  var docEl = doc.documentElement;

  var box = _getActualBoundingClientRect(el);

  var origin = _getOrigin(body);

  box.top -= origin.top;
  box.left -= origin.left;

  if (isUndefined(box.width)) {
    box.width = document.body.scrollWidth - box.left - box.right;
  }

  if (isUndefined(box.height)) {
    box.height = document.body.scrollHeight - box.top - box.bottom;
  }

  box.top = box.top - docEl.clientTop;
  box.left = box.left - docEl.clientLeft;
  box.right = doc.body.clientWidth - box.width - box.left;
  box.bottom = doc.body.clientHeight - box.height - box.top;
  return box;
}
/**
 * Gets bounds for when target modifiier is 'scroll-handle'
 * @param target
 * @return {{left: number, width: number, height: number}}
 */

function getScrollHandleBounds(body, target) {
  var bounds; // We have to do the check for the scrollTop and if target === document.body here and set to variables
  // because we may reset target below.

  var targetScrollTop = target.scrollTop;
  var targetIsBody = target === document.body;

  if (targetIsBody) {
    target = document.documentElement;
    bounds = {
      left: pageXOffset,
      top: pageYOffset,
      height: innerHeight,
      width: innerWidth
    };
  } else {
    bounds = getBounds(body, target);
  }

  var style = getComputedStyle(target);
  var hasBottomScroll = target.scrollWidth > target.clientWidth || [style.overflow, style.overflowX].indexOf('scroll') >= 0 || !targetIsBody;
  var scrollBottom = 0;

  if (hasBottomScroll) {
    scrollBottom = 15;
  }

  var height = bounds.height - parseFloat(style.borderTopWidth) - parseFloat(style.borderBottomWidth) - scrollBottom;
  var out = {
    width: 15,
    height: height * 0.975 * (height / target.scrollHeight),
    left: bounds.left + bounds.width - parseFloat(style.borderLeftWidth) - 15
  };
  var fitAdj = 0;

  if (height < 408 && targetIsBody) {
    fitAdj = -0.00011 * Math.pow(height, 2) - 0.00727 * height + 22.58;
  }

  if (!targetIsBody) {
    out.height = Math.max(out.height, 24);
  }

  var scrollPercentage = targetScrollTop / (target.scrollHeight - height);
  out.top = scrollPercentage * (height - out.height - fitAdj) + bounds.top + parseFloat(style.borderTopWidth);

  if (targetIsBody) {
    out.height = Math.max(out.height, 24);
  }

  return out;
}
/**
 * Gets bounds for when target modifiier is 'visible
 * @param target
 * @return {{top: *, left: *, width: *, height: *}}
 */

function getVisibleBounds(body, target) {
  if (target === document.body) {
    return {
      top: pageYOffset,
      left: pageXOffset,
      height: innerHeight,
      width: innerWidth
    };
  } else {
    var bounds = getBounds(body, target);
    var out = {
      height: bounds.height,
      width: bounds.width,
      top: bounds.top,
      left: bounds.left
    };
    out.height = Math.min(out.height, bounds.height - (pageYOffset - bounds.top));
    out.height = Math.min(out.height, bounds.height - (bounds.top + bounds.height - (pageYOffset + innerHeight)));
    out.height = Math.min(innerHeight, out.height);
    out.height -= 2;
    out.width = Math.min(out.width, bounds.width - (pageXOffset - bounds.left));
    out.width = Math.min(out.width, bounds.width - (bounds.left + bounds.width - (pageXOffset + innerWidth)));
    out.width = Math.min(innerWidth, out.width);
    out.width -= 2;

    if (out.top < pageYOffset) {
      out.top = pageYOffset;
    }

    if (out.left < pageXOffset) {
      out.left = pageXOffset;
    }

    return out;
  }
}
function removeUtilElements(body) {
  if (zeroElement) {
    body.removeChild(zeroElement);
  }

  zeroElement = null;
}
/**
 * Same as native getBoundingClientRect, except it takes into account parent <frame> offsets
 * if the element lies within a nested document (<frame> or <iframe>-like).
 * @param node
 */

function _getActualBoundingClientRect(node) {
  var boundingRect = node.getBoundingClientRect(); // The original object returned by getBoundingClientRect is immutable, so we clone it
  // We can't use extend because the properties are not considered part of the object by hasOwnProperty in IE9

  var rect = {};

  for (var k in boundingRect) {
    rect[k] = boundingRect[k];
  }

  try {
    if (node.ownerDocument !== document) {
      var frameElement = node.ownerDocument.defaultView.frameElement;

      if (frameElement) {
        var frameRect = _getActualBoundingClientRect(frameElement);

        rect.top += frameRect.top;
        rect.bottom += frameRect.top;
        rect.left += frameRect.left;
        rect.right += frameRect.left;
      }
    }
  } catch (err) {// Ignore "Access is denied" in IE11/Edge
  }

  return rect;
}

function _getOrigin(body) {
  // getBoundingClientRect is unfortunately too accurate.  It introduces a pixel or two of
  // jitter as the user scrolls that messes with our ability to detect if two positions
  // are equivilant or not.  We place an element at the top left of the page that will
  // get the same jitter, so we can cancel the two out.
  var node = zeroElement;

  if (!node || !body.contains(node)) {
    node = document.createElement('div');
    node.setAttribute('data-tether-id', uniqueId());
    extend(node.style, {
      top: 0,
      left: 0,
      position: 'absolute'
    });
    body.appendChild(node);
    zeroElement = node;
  }

  var id = node.getAttribute('data-tether-id');

  if (isUndefined(zeroPosCache[id])) {
    zeroPosCache[id] = _getActualBoundingClientRect(node); // Clear the cache when this position call is done

    defer(function () {
      delete zeroPosCache[id];
    });
  }

  return zeroPosCache[id];
}

var Abutment = {
  position: function position(_ref) {
    var _this = this;

    var top = _ref.top,
        left = _ref.left;

    var _this$cache = this.cache('element-bounds', function () {
      return getBounds(_this.element);
    }),
        height = _this$cache.height,
        width = _this$cache.width;

    var targetPos = this.getTargetBounds();
    var bottom = top + height;
    var right = left + width;
    var abutted = [];

    if (top <= targetPos.bottom && bottom >= targetPos.top) {
      ['left', 'right'].forEach(function (side) {
        var targetPosSide = targetPos[side];

        if (targetPosSide === left || targetPosSide === right) {
          abutted.push(side);
        }
      });
    }

    if (left <= targetPos.right && right >= targetPos.left) {
      ['top', 'bottom'].forEach(function (side) {
        var targetPosSide = targetPos[side];

        if (targetPosSide === top || targetPosSide === bottom) {
          abutted.push(side);
        }
      });
    }

    var sides = ['left', 'top', 'right', 'bottom'];
    var _this$options = this.options,
        classes = _this$options.classes,
        classPrefix = _this$options.classPrefix;
    this.all.push(getClass('abutted', classes, classPrefix));
    sides.forEach(function (side) {
      _this.all.push(getClass('abutted', classes, classPrefix) + "-" + side);
    });

    if (abutted.length) {
      this.add.push(getClass('abutted', classes, classPrefix));
    }

    abutted.forEach(function (side) {
      _this.add.push(getClass('abutted', classes, classPrefix) + "-" + side);
    });
    defer(function () {
      if (!(_this.options.addTargetClasses === false)) {
        updateClasses(_this.target, _this.add, _this.all);
      }

      updateClasses(_this.element, _this.add, _this.all);
    });
    return true;
  }
};

var BOUNDS_FORMAT = ['left', 'top', 'right', 'bottom'];
/**
 * Returns an array of bounds of the format [left, top, right, bottom]
 * @param tether
 * @param to
 * @return {*[]|HTMLElement|ActiveX.IXMLDOMElement}
 */

function getBoundingRect(body, tether, to) {
  // arg to is required
  if (!to) {
    return null;
  }

  if (to === 'scrollParent') {
    to = tether.scrollParents[0];
  } else if (to === 'window') {
    to = [pageXOffset, pageYOffset, innerWidth + pageXOffset, innerHeight + pageYOffset];
  }

  if (to === document) {
    to = to.documentElement;
  }

  if (!isUndefined(to.nodeType)) {
    var node = to;
    var size = getBounds(body, to);
    var pos = size;
    var style = getComputedStyle(to);
    to = [pos.left, pos.top, size.width + pos.left, size.height + pos.top]; // Account any parent Frames scroll offset

    if (node.ownerDocument !== document) {
      var win = node.ownerDocument.defaultView;
      to[0] += win.pageXOffset;
      to[1] += win.pageYOffset;
      to[2] += win.pageXOffset;
      to[3] += win.pageYOffset;
    }

    BOUNDS_FORMAT.forEach(function (side, i) {
      side = side[0].toUpperCase() + side.substr(1);

      if (side === 'Top' || side === 'Left') {
        to[i] += parseFloat(style["border" + side + "Width"]);
      } else {
        to[i] -= parseFloat(style["border" + side + "Width"]);
      }
    });
  }

  return to;
}
/**
 * Add out of bounds classes to the list of classes we add to tether
 * @param {string[]} oob An array of directions that are out of bounds
 * @param {string[]} addClasses The array of classes to add to Tether
 * @param {string[]} classes The array of class types for Tether
 * @param {string} classPrefix The prefix to add to the front of the class
 * @param {string} outOfBoundsClass The class to apply when out of bounds
 * @private
 */


function _addOutOfBoundsClass(oob, addClasses, classes, classPrefix, outOfBoundsClass) {
  if (oob.length) {
    var oobClass;

    if (!isUndefined(outOfBoundsClass)) {
      oobClass = outOfBoundsClass;
    } else {
      oobClass = getClass('out-of-bounds', classes, classPrefix);
    }

    addClasses.push(oobClass);
    oob.forEach(function (side) {
      addClasses.push(oobClass + "-" + side);
    });
  }
}
/**
 * Calculates if out of bounds or pinned in the X direction.
 *
 * @param {number} left
 * @param {number[]} bounds Array of bounds of the format [left, top, right, bottom]
 * @param {number} width
 * @param pin
 * @param pinned
 * @param {string[]} oob
 * @return {number}
 * @private
 */


function _calculateOOBAndPinnedLeft(left, bounds, width, pin, pinned, oob) {
  if (left < bounds[0]) {
    if (pin.indexOf('left') >= 0) {
      left = bounds[0];
      pinned.push('left');
    } else {
      oob.push('left');
    }
  }

  if (left + width > bounds[2]) {
    if (pin.indexOf('right') >= 0) {
      left = bounds[2] - width;
      pinned.push('right');
    } else {
      oob.push('right');
    }
  }

  return left;
}
/**
 * Calculates if out of bounds or pinned in the Y direction.
 *
 * @param {number} top
 * @param {number[]} bounds Array of bounds of the format [left, top, right, bottom]
 * @param {number} height
 * @param pin
 * @param {string[]} pinned
 * @param {string[]} oob
 * @return {number}
 * @private
 */


function _calculateOOBAndPinnedTop(top, bounds, height, pin, pinned, oob) {
  if (top < bounds[1]) {
    if (pin.indexOf('top') >= 0) {
      top = bounds[1];
      pinned.push('top');
    } else {
      oob.push('top');
    }
  }

  if (top + height > bounds[3]) {
    if (pin.indexOf('bottom') >= 0) {
      top = bounds[3] - height;
      pinned.push('bottom');
    } else {
      oob.push('bottom');
    }
  }

  return top;
}
/**
 * Flip X "together"
 * @param {object} tAttachment The target attachment
 * @param {object} eAttachment The element attachment
 * @param {number[]} bounds Array of bounds of the format [left, top, right, bottom]
 * @param {number} width
 * @param targetWidth
 * @param {number} left
 * @private
 */


function _flipXTogether(tAttachment, eAttachment, bounds, width, targetWidth, left) {
  if (left < bounds[0] && tAttachment.left === 'left') {
    if (eAttachment.left === 'right') {
      left += targetWidth;
      tAttachment.left = 'right';
      left += width;
      eAttachment.left = 'left';
    } else if (eAttachment.left === 'left') {
      left += targetWidth;
      tAttachment.left = 'right';
      left -= width;
      eAttachment.left = 'right';
    }
  } else if (left + width > bounds[2] && tAttachment.left === 'right') {
    if (eAttachment.left === 'left') {
      left -= targetWidth;
      tAttachment.left = 'left';
      left -= width;
      eAttachment.left = 'right';
    } else if (eAttachment.left === 'right') {
      left -= targetWidth;
      tAttachment.left = 'left';
      left += width;
      eAttachment.left = 'left';
    }
  } else if (tAttachment.left === 'center') {
    if (left + width > bounds[2] && eAttachment.left === 'left') {
      left -= width;
      eAttachment.left = 'right';
    } else if (left < bounds[0] && eAttachment.left === 'right') {
      left += width;
      eAttachment.left = 'left';
    }
  }

  return left;
}
/**
 * Flip Y "together"
 * @param {object} tAttachment The target attachment
 * @param {object} eAttachment The element attachment
 * @param {number[]} bounds Array of bounds of the format [left, top, right, bottom]
 * @param {number} height
 * @param targetHeight
 * @param {number} top
 * @private
 */


function _flipYTogether(tAttachment, eAttachment, bounds, height, targetHeight, top) {
  if (tAttachment.top === 'top') {
    if (eAttachment.top === 'bottom' && top < bounds[1]) {
      top += targetHeight;
      tAttachment.top = 'bottom';
      top += height;
      eAttachment.top = 'top';
    } else if (eAttachment.top === 'top' && top + height > bounds[3] && top - (height - targetHeight) >= bounds[1]) {
      top -= height - targetHeight;
      tAttachment.top = 'bottom';
      eAttachment.top = 'bottom';
    }
  }

  if (tAttachment.top === 'bottom') {
    if (eAttachment.top === 'top' && top + height > bounds[3]) {
      top -= targetHeight;
      tAttachment.top = 'top';
      top -= height;
      eAttachment.top = 'bottom';
    } else if (eAttachment.top === 'bottom' && top < bounds[1] && top + (height * 2 - targetHeight) <= bounds[3]) {
      top += height - targetHeight;
      tAttachment.top = 'top';
      eAttachment.top = 'top';
    }
  }

  if (tAttachment.top === 'middle') {
    if (top + height > bounds[3] && eAttachment.top === 'top') {
      top -= height;
      eAttachment.top = 'bottom';
    } else if (top < bounds[1] && eAttachment.top === 'bottom') {
      top += height;
      eAttachment.top = 'top';
    }
  }

  return top;
}
/**
 * Get all the initial classes
 * @param classes
 * @param {string} classPrefix
 * @param constraints
 * @return {[*, *]}
 * @private
 */


function _getAllClasses(classes, classPrefix, constraints) {
  var allClasses = [getClass('pinned', classes, classPrefix), getClass('out-of-bounds', classes, classPrefix)];
  constraints.forEach(function (constraint) {
    var outOfBoundsClass = constraint.outOfBoundsClass,
        pinnedClass = constraint.pinnedClass;

    if (outOfBoundsClass) {
      allClasses.push(outOfBoundsClass);
    }

    if (pinnedClass) {
      allClasses.push(pinnedClass);
    }
  });
  allClasses.forEach(function (cls) {
    ['left', 'top', 'right', 'bottom'].forEach(function (side) {
      allClasses.push(cls + "-" + side);
    });
  });
  return allClasses;
}

var Constraint = {
  position: function position(_ref) {
    var _this = this;

    var top = _ref.top,
        left = _ref.left,
        targetAttachment = _ref.targetAttachment;

    if (!this.options.constraints) {
      return true;
    }

    var _this$cache = this.cache('element-bounds', function () {
      return getBounds(_this.bodyElement, _this.element);
    }),
        height = _this$cache.height,
        width = _this$cache.width;

    if (width === 0 && height === 0 && !isUndefined(this.lastSize)) {
      // Handle the item getting hidden as a result of our positioning without glitching
      // the classes in and out
      var _this$lastSize = this.lastSize;
      width = _this$lastSize.width;
      height = _this$lastSize.height;
    }

    var targetSize = this.cache('target-bounds', function () {
      return _this.getTargetBounds();
    });
    var targetHeight = targetSize.height,
        targetWidth = targetSize.width;
    var _this$options = this.options,
        classes = _this$options.classes,
        classPrefix = _this$options.classPrefix;

    var allClasses = _getAllClasses(classes, classPrefix, this.options.constraints);

    var addClasses = [];
    var tAttachment = extend({}, targetAttachment);
    var eAttachment = extend({}, this.attachment);
    this.options.constraints.forEach(function (constraint) {
      var to = constraint.to,
          attachment = constraint.attachment,
          pin = constraint.pin;

      if (isUndefined(attachment)) {
        attachment = '';
      }

      var changeAttachX, changeAttachY;

      if (attachment.indexOf(' ') >= 0) {
        var _attachment$split = attachment.split(' ');

        changeAttachY = _attachment$split[0];
        changeAttachX = _attachment$split[1];
      } else {
        changeAttachX = changeAttachY = attachment;
      }

      var bounds = getBoundingRect(_this.bodyElement, _this, to);

      if (changeAttachY === 'target' || changeAttachY === 'both') {
        if (top < bounds[1] && tAttachment.top === 'top') {
          top += targetHeight;
          tAttachment.top = 'bottom';
        }

        if (top + height > bounds[3] && tAttachment.top === 'bottom') {
          top -= targetHeight;
          tAttachment.top = 'top';
        }
      }

      if (changeAttachY === 'together') {
        top = _flipYTogether(tAttachment, eAttachment, bounds, height, targetHeight, top);
      }

      if (changeAttachX === 'target' || changeAttachX === 'both') {
        if (left < bounds[0] && tAttachment.left === 'left') {
          left += targetWidth;
          tAttachment.left = 'right';
        }

        if (left + width > bounds[2] && tAttachment.left === 'right') {
          left -= targetWidth;
          tAttachment.left = 'left';
        }
      }

      if (changeAttachX === 'together') {
        left = _flipXTogether(tAttachment, eAttachment, bounds, width, targetWidth, left);
      }

      if (changeAttachY === 'element' || changeAttachY === 'both') {
        if (top < bounds[1] && eAttachment.top === 'bottom') {
          top += height;
          eAttachment.top = 'top';
        }

        if (top + height > bounds[3] && eAttachment.top === 'top') {
          top -= height;
          eAttachment.top = 'bottom';
        }
      }

      if (changeAttachX === 'element' || changeAttachX === 'both') {
        if (left < bounds[0]) {
          if (eAttachment.left === 'right') {
            left += width;
            eAttachment.left = 'left';
          } else if (eAttachment.left === 'center') {
            left += width / 2;
            eAttachment.left = 'left';
          }
        }

        if (left + width > bounds[2]) {
          if (eAttachment.left === 'left') {
            left -= width;
            eAttachment.left = 'right';
          } else if (eAttachment.left === 'center') {
            left -= width / 2;
            eAttachment.left = 'right';
          }
        }
      }

      if (isString(pin)) {
        pin = pin.split(',').map(function (p) {
          return p.trim();
        });
      } else if (pin === true) {
        pin = ['top', 'left', 'right', 'bottom'];
      }

      pin = pin || [];
      var pinned = [];
      var oob = [];
      left = _calculateOOBAndPinnedLeft(left, bounds, width, pin, pinned, oob);
      top = _calculateOOBAndPinnedTop(top, bounds, height, pin, pinned, oob);

      if (pinned.length) {
        var pinnedClass;

        if (!isUndefined(_this.options.pinnedClass)) {
          pinnedClass = _this.options.pinnedClass;
        } else {
          pinnedClass = getClass('pinned', classes, classPrefix);
        }

        addClasses.push(pinnedClass);
        pinned.forEach(function (side) {
          addClasses.push(pinnedClass + "-" + side);
        });
      }

      _addOutOfBoundsClass(oob, addClasses, classes, classPrefix, _this.options.outOfBoundsClass);

      if (pinned.indexOf('left') >= 0 || pinned.indexOf('right') >= 0) {
        eAttachment.left = tAttachment.left = false;
      }

      if (pinned.indexOf('top') >= 0 || pinned.indexOf('bottom') >= 0) {
        eAttachment.top = tAttachment.top = false;
      }

      if (tAttachment.top !== targetAttachment.top || tAttachment.left !== targetAttachment.left || eAttachment.top !== _this.attachment.top || eAttachment.left !== _this.attachment.left) {
        _this.updateAttachClasses(eAttachment, tAttachment);

        _this.trigger('update', {
          attachment: eAttachment,
          targetAttachment: tAttachment
        });
      }
    });
    defer(function () {
      if (!(_this.options.addTargetClasses === false)) {
        updateClasses(_this.target, addClasses, allClasses);
      }

      updateClasses(_this.element, addClasses, allClasses);
    });
    return {
      top: top,
      left: left
    };
  }
};

var Shift = {
  position: function position(_ref) {
    var top = _ref.top,
        left = _ref.left;

    if (!this.options.shift) {
      return;
    }

    var shift = this.options.shift;

    if (isFunction(shift)) {
      shift = shift.call(this, {
        top: top,
        left: left
      });
    }

    var shiftTop, shiftLeft;

    if (isString(shift)) {
      shift = shift.split(' ');
      shift[1] = shift[1] || shift[0];
      var _shift = shift;
      shiftTop = _shift[0];
      shiftLeft = _shift[1];
      shiftTop = parseFloat(shiftTop, 10);
      shiftLeft = parseFloat(shiftLeft, 10);
    } else {
      var _ref2 = [shift.top, shift.left];
      shiftTop = _ref2[0];
      shiftLeft = _ref2[1];
    }

    top += shiftTop;
    left += shiftLeft;
    return {
      top: top,
      left: left
    };
  }
};

var Evented = /*#__PURE__*/function () {
  function Evented() {}

  var _proto = Evented.prototype;

  _proto.on = function on(event, handler, ctx, once) {
    if (once === void 0) {
      once = false;
    }

    if (isUndefined(this.bindings)) {
      this.bindings = {};
    }

    if (isUndefined(this.bindings[event])) {
      this.bindings[event] = [];
    }

    this.bindings[event].push({
      handler: handler,
      ctx: ctx,
      once: once
    });
    return this;
  };

  _proto.once = function once(event, handler, ctx) {
    return this.on(event, handler, ctx, true);
  };

  _proto.off = function off(event, handler) {
    var _this = this;

    if (isUndefined(this.bindings) || isUndefined(this.bindings[event])) {
      return this;
    }

    if (isUndefined(handler)) {
      delete this.bindings[event];
    } else {
      this.bindings[event].forEach(function (binding, index) {
        if (binding.handler === handler) {
          _this.bindings[event].splice(index, 1);
        }
      });
    }

    return this;
  };

  _proto.trigger = function trigger(event) {
    var _this2 = this;

    for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      args[_key - 1] = arguments[_key];
    }

    if (!isUndefined(this.bindings) && this.bindings[event]) {
      this.bindings[event].forEach(function (binding, index) {
        var ctx = binding.ctx,
            handler = binding.handler,
            once = binding.once;
        var context = ctx || _this2;
        handler.apply(context, args);

        if (once) {
          _this2.bindings[event].splice(index, 1);
        }
      });
    }

    return this;
  };

  return Evented;
}();

var MIRROR_LR = {
  center: 'center',
  left: 'right',
  right: 'left'
};
var MIRROR_TB = {
  middle: 'middle',
  top: 'bottom',
  bottom: 'top'
};
var OFFSET_MAP = {
  top: 0,
  left: 0,
  middle: '50%',
  center: '50%',
  bottom: '100%',
  right: '100%'
};
function addOffset() {
  var out = {
    top: 0,
    left: 0
  };

  for (var _len = arguments.length, offsets = new Array(_len), _key = 0; _key < _len; _key++) {
    offsets[_key] = arguments[_key];
  }

  offsets.forEach(function (_ref) {
    var top = _ref.top,
        left = _ref.left;

    if (isString(top)) {
      top = parseFloat(top);
    }

    if (isString(left)) {
      left = parseFloat(left);
    }

    out.top += top;
    out.left += left;
  });
  return out;
}
function attachmentToOffset(attachment) {
  var left = attachment.left,
      top = attachment.top;

  if (!isUndefined(OFFSET_MAP[attachment.left])) {
    left = OFFSET_MAP[attachment.left];
  }

  if (!isUndefined(OFFSET_MAP[attachment.top])) {
    top = OFFSET_MAP[attachment.top];
  }

  return {
    left: left,
    top: top
  };
}
function autoToFixedAttachment(attachment, relativeToAttachment) {
  var left = attachment.left,
      top = attachment.top;

  if (left === 'auto') {
    left = MIRROR_LR[relativeToAttachment.left];
  }

  if (top === 'auto') {
    top = MIRROR_TB[relativeToAttachment.top];
  }

  return {
    left: left,
    top: top
  };
}
function offsetToPx(offset, size) {
  if (isString(offset.left) && offset.left.indexOf('%') !== -1) {
    offset.left = parseFloat(offset.left) / 100 * size.width;
  }

  if (isString(offset.top) && offset.top.indexOf('%') !== -1) {
    offset.top = parseFloat(offset.top) / 100 * size.height;
  }

  return offset;
}
function parseTopLeft(value) {
  var _value$split = value.split(' '),
      top = _value$split[0],
      left = _value$split[1];

  return {
    top: top,
    left: left
  };
}

function getScrollParents(el) {
  // In firefox if the el is inside an iframe with display: none; window.getComputedStyle() will return null;
  // https://bugzilla.mozilla.org/show_bug.cgi?id=548397
  var computedStyle = getComputedStyle(el) || {};
  var position = computedStyle.position;
  var parents = [];

  if (position === 'fixed') {
    return [el];
  }

  var parent = el;

  while ((parent = parent.parentNode) && parent && parent.nodeType === 1) {
    var style = void 0;

    try {
      style = getComputedStyle(parent);
    } catch (err) {// Intentionally blank
    }

    if (isUndefined(style) || style === null) {
      parents.push(parent);
      return parents;
    }

    var _style = style,
        overflow = _style.overflow,
        overflowX = _style.overflowX,
        overflowY = _style.overflowY;

    if (/(auto|scroll|overlay)/.test(overflow + overflowY + overflowX)) {
      if (position !== 'absolute' || ['relative', 'absolute', 'fixed'].indexOf(style.position) >= 0) {
        parents.push(parent);
      }
    }
  }

  parents.push(el.ownerDocument.body); // If the node is within a frame, account for the parent window scroll

  if (el.ownerDocument !== document) {
    parents.push(el.ownerDocument.defaultView);
  }

  return parents;
}
function getOffsetParent(el) {
  return el.offsetParent || document.documentElement;
}

var TetherBase = {
  modules: [Constraint, Abutment, Shift]
};

function isFullscreenElement(e) {
  var d = e.ownerDocument;
  var fe = d.fullscreenElement || d.webkitFullscreenElement || d.mozFullScreenElement || d.msFullscreenElement;
  return fe === e;
}

function within(a, b, diff) {
  if (diff === void 0) {
    diff = 1;
  }

  return a + diff >= b && b >= a - diff;
}

var transformKey = function () {
  if (isUndefined(document)) {
    return '';
  }

  var el = document.createElement('div');
  var transforms = ['transform', 'WebkitTransform', 'OTransform', 'MozTransform', 'msTransform'];

  for (var i = 0; i < transforms.length; ++i) {
    var key = transforms[i];

    if (el.style[key] !== undefined) {
      return key;
    }
  }
}();

var tethers = [];

var position = function position() {
  tethers.forEach(function (tether) {
    tether.position(false);
  });
  flush();
};

function now() {
  return performance.now();
}

(function () {
  var lastCall = null;
  var lastDuration = null;
  var pendingTimeout = null;

  var tick = function tick() {
    if (!isUndefined(lastDuration) && lastDuration > 16) {
      // We voluntarily throttle ourselves if we can't manage 60fps
      lastDuration = Math.min(lastDuration - 16, 250); // Just in case this is the last event, remember to position just once more

      pendingTimeout = setTimeout(tick, 250);
      return;
    }

    if (!isUndefined(lastCall) && now() - lastCall < 10) {
      // Some browsers call events a little too frequently, refuse to run more than is reasonable
      return;
    }

    if (pendingTimeout != null) {
      clearTimeout(pendingTimeout);
      pendingTimeout = null;
    }

    lastCall = now();
    position();
    lastDuration = now() - lastCall;
  };

  if (!isUndefined(window) && !isUndefined(window.addEventListener)) {
    ['resize', 'scroll', 'touchmove'].forEach(function (event) {
      window.addEventListener(event, tick);
    });
  }
})();

var TetherClass = /*#__PURE__*/function (_Evented) {
  _inheritsLoose(TetherClass, _Evented);

  function TetherClass(options) {
    var _this;

    _this = _Evented.call(this) || this;
    _this.position = _this.position.bind(_assertThisInitialized(_this));
    tethers.push(_assertThisInitialized(_this));
    _this.history = [];

    _this.setOptions(options, false);

    TetherBase.modules.forEach(function (module) {
      if (!isUndefined(module.initialize)) {
        module.initialize.call(_assertThisInitialized(_this));
      }
    });

    _this.position();

    return _this;
  }

  var _proto = TetherClass.prototype;

  _proto.setOptions = function setOptions(options, pos) {
    var _this2 = this;

    if (pos === void 0) {
      pos = true;
    }

    var defaults = {
      offset: '0 0',
      targetOffset: '0 0',
      targetAttachment: 'auto auto',
      classPrefix: 'tether',
      bodyElement: document.body
    };
    this.options = extend(defaults, options);
    var _this$options = this.options,
        element = _this$options.element,
        target = _this$options.target,
        targetModifier = _this$options.targetModifier,
        bodyElement = _this$options.bodyElement;
    this.element = element;
    this.target = target;
    this.targetModifier = targetModifier;

    if (typeof bodyElement === 'string') {
      bodyElement = document.querySelector(bodyElement);
    }

    this.bodyElement = bodyElement;

    if (this.target === 'viewport') {
      this.target = document.body;
      this.targetModifier = 'visible';
    } else if (this.target === 'scroll-handle') {
      this.target = document.body;
      this.targetModifier = 'scroll-handle';
    }

    ['element', 'target'].forEach(function (key) {
      if (isUndefined(_this2[key])) {
        throw new Error('Tether Error: Both element and target must be defined');
      }

      if (!isUndefined(_this2[key].jquery)) {
        _this2[key] = _this2[key][0];
      } else if (isString(_this2[key])) {
        _this2[key] = document.querySelector(_this2[key]);
      }
    });

    this._addClasses();

    if (!this.options.attachment) {
      throw new Error('Tether Error: You must provide an attachment');
    }

    this.targetAttachment = parseTopLeft(this.options.targetAttachment);
    this.attachment = parseTopLeft(this.options.attachment);
    this.offset = parseTopLeft(this.options.offset);
    this.targetOffset = parseTopLeft(this.options.targetOffset);

    if (!isUndefined(this.scrollParents)) {
      this.disable();
    }

    if (this.targetModifier === 'scroll-handle') {
      this.scrollParents = [this.target];
    } else {
      this.scrollParents = getScrollParents(this.target);
    }

    if (!(this.options.enabled === false)) {
      this.enable(pos);
    }
  };

  _proto.getTargetBounds = function getTargetBounds() {
    if (!isUndefined(this.targetModifier)) {
      if (this.targetModifier === 'visible') {
        return getVisibleBounds(this.bodyElement, this.target);
      } else if (this.targetModifier === 'scroll-handle') {
        return getScrollHandleBounds(this.bodyElement, this.target);
      }
    } else {
      return getBounds(this.bodyElement, this.target);
    }
  };

  _proto.clearCache = function clearCache() {
    this._cache = {};
  };

  _proto.cache = function cache(k, getter) {
    // More than one module will often need the same DOM info, so
    // we keep a cache which is cleared on each position call
    if (isUndefined(this._cache)) {
      this._cache = {};
    }

    if (isUndefined(this._cache[k])) {
      this._cache[k] = getter.call(this);
    }

    return this._cache[k];
  };

  _proto.enable = function enable(pos) {
    var _this3 = this;

    if (pos === void 0) {
      pos = true;
    }

    var _this$options2 = this.options,
        classes = _this$options2.classes,
        classPrefix = _this$options2.classPrefix;

    if (!(this.options.addTargetClasses === false)) {
      addClass(this.target, getClass('enabled', classes, classPrefix));
    }

    addClass(this.element, getClass('enabled', classes, classPrefix));
    this.enabled = true;
    this.scrollParents.forEach(function (parent) {
      if (parent !== _this3.target.ownerDocument) {
        parent.addEventListener('scroll', _this3.position);
      }
    });

    if (pos) {
      this.position();
    }
  };

  _proto.disable = function disable() {
    var _this4 = this;

    var _this$options3 = this.options,
        classes = _this$options3.classes,
        classPrefix = _this$options3.classPrefix;
    removeClass(this.target, getClass('enabled', classes, classPrefix));
    removeClass(this.element, getClass('enabled', classes, classPrefix));
    this.enabled = false;

    if (!isUndefined(this.scrollParents)) {
      this.scrollParents.forEach(function (parent) {
        if (parent && parent.removeEventListener) {
          parent.removeEventListener('scroll', _this4.position);
        }
      });
    }
  };

  _proto.destroy = function destroy() {
    var _this5 = this;

    this.disable();

    this._removeClasses();

    tethers.forEach(function (tether, i) {
      if (tether === _this5) {
        tethers.splice(i, 1);
      }
    }); // Remove any elements we were using for convenience from the DOM

    if (tethers.length === 0) {
      removeUtilElements(this.bodyElement);
    }
  };

  _proto.updateAttachClasses = function updateAttachClasses(elementAttach, targetAttach) {
    var _this6 = this;

    elementAttach = elementAttach || this.attachment;
    targetAttach = targetAttach || this.targetAttachment;
    var sides = ['left', 'top', 'bottom', 'right', 'middle', 'center'];
    var _this$options4 = this.options,
        classes = _this$options4.classes,
        classPrefix = _this$options4.classPrefix;

    if (!isUndefined(this._addAttachClasses) && this._addAttachClasses.length) {
      // updateAttachClasses can be called more than once in a position call, so
      // we need to clean up after ourselves such that when the last defer gets
      // ran it doesn't add any extra classes from previous calls.
      this._addAttachClasses.splice(0, this._addAttachClasses.length);
    }

    if (isUndefined(this._addAttachClasses)) {
      this._addAttachClasses = [];
    }

    this.add = this._addAttachClasses;

    if (elementAttach.top) {
      this.add.push(getClass('element-attached', classes, classPrefix) + "-" + elementAttach.top);
    }

    if (elementAttach.left) {
      this.add.push(getClass('element-attached', classes, classPrefix) + "-" + elementAttach.left);
    }

    if (targetAttach.top) {
      this.add.push(getClass('target-attached', classes, classPrefix) + "-" + targetAttach.top);
    }

    if (targetAttach.left) {
      this.add.push(getClass('target-attached', classes, classPrefix) + "-" + targetAttach.left);
    }

    this.all = [];
    sides.forEach(function (side) {
      _this6.all.push(getClass('element-attached', classes, classPrefix) + "-" + side);

      _this6.all.push(getClass('target-attached', classes, classPrefix) + "-" + side);
    });
    defer(function () {
      if (isUndefined(_this6._addAttachClasses)) {
        return;
      }

      updateClasses(_this6.element, _this6._addAttachClasses, _this6.all);

      if (!(_this6.options.addTargetClasses === false)) {
        updateClasses(_this6.target, _this6._addAttachClasses, _this6.all);
      }

      delete _this6._addAttachClasses;
    });
  };

  _proto.position = function position(flushChanges) {
    var _this7 = this;

    if (flushChanges === void 0) {
      flushChanges = true;
    }

    // flushChanges commits the changes immediately, leave true unless you are positioning multiple
    // tethers (in which case call Tether.Utils.flush yourself when you're done)
    if (!this.enabled) {
      return;
    }

    this.clearCache(); // Turn 'auto' attachments into the appropriate corner or edge

    var targetAttachment = autoToFixedAttachment(this.targetAttachment, this.attachment);
    this.updateAttachClasses(this.attachment, targetAttachment);
    var elementPos = this.cache('element-bounds', function () {
      return getBounds(_this7.bodyElement, _this7.element);
    });
    var width = elementPos.width,
        height = elementPos.height;

    if (width === 0 && height === 0 && !isUndefined(this.lastSize)) {
      // We cache the height and width to make it possible to position elements that are
      // getting hidden.
      var _this$lastSize = this.lastSize;
      width = _this$lastSize.width;
      height = _this$lastSize.height;
    } else {
      this.lastSize = {
        width: width,
        height: height
      };
    }

    var targetPos = this.cache('target-bounds', function () {
      return _this7.getTargetBounds();
    });
    var targetSize = targetPos; // Get an actual px offset from the attachment

    var offset = offsetToPx(attachmentToOffset(this.attachment), {
      width: width,
      height: height
    });
    var targetOffset = offsetToPx(attachmentToOffset(targetAttachment), targetSize);
    var manualOffset = offsetToPx(this.offset, {
      width: width,
      height: height
    });
    var manualTargetOffset = offsetToPx(this.targetOffset, targetSize); // Add the manually provided offset

    offset = addOffset(offset, manualOffset);
    targetOffset = addOffset(targetOffset, manualTargetOffset); // It's now our goal to make (element position + offset) == (target position + target offset)

    var left = targetPos.left + targetOffset.left - offset.left;
    var top = targetPos.top + targetOffset.top - offset.top;

    for (var i = 0; i < TetherBase.modules.length; ++i) {
      var module = TetherBase.modules[i];
      var ret = module.position.call(this, {
        left: left,
        top: top,
        targetAttachment: targetAttachment,
        targetPos: targetPos,
        elementPos: elementPos,
        offset: offset,
        targetOffset: targetOffset,
        manualOffset: manualOffset,
        manualTargetOffset: manualTargetOffset,
        scrollbarSize: scrollbarSize,
        attachment: this.attachment
      });

      if (ret === false) {
        return false;
      } else if (isUndefined(ret) || !isObject(ret)) {
        continue;
      } else {
        top = ret.top;
        left = ret.left;
      }
    } // We describe the position three different ways to give the optimizer
    // a chance to decide the best possible way to position the element
    // with the fewest repaints.


    var next = {
      // It's position relative to the page (absolute positioning when
      // the element is a child of the body)
      page: {
        top: top,
        left: left
      },
      // It's position relative to the viewport (fixed positioning)
      viewport: {
        top: top - pageYOffset,
        bottom: pageYOffset - top - height + innerHeight,
        left: left - pageXOffset,
        right: pageXOffset - left - width + innerWidth
      }
    };
    var doc = this.target.ownerDocument;
    var win = doc.defaultView;
    var scrollbarSize;

    if (win.innerHeight > doc.documentElement.clientHeight) {
      scrollbarSize = this.cache('scrollbar-size', getScrollBarSize);
      next.viewport.bottom -= scrollbarSize.height;
    }

    if (win.innerWidth > doc.documentElement.clientWidth) {
      scrollbarSize = this.cache('scrollbar-size', getScrollBarSize);
      next.viewport.right -= scrollbarSize.width;
    }

    if (['', 'static'].indexOf(doc.body.style.position) === -1 || ['', 'static'].indexOf(doc.body.parentElement.style.position) === -1) {
      // Absolute positioning in the body will be relative to the page, not the 'initial containing block'
      next.page.bottom = doc.body.scrollHeight - top - height;
      next.page.right = doc.body.scrollWidth - left - width;
    }

    if (!isUndefined(this.options.optimizations) && this.options.optimizations.moveElement !== false && isUndefined(this.targetModifier)) {
      var offsetParent = this.cache('target-offsetparent', function () {
        return getOffsetParent(_this7.target);
      });
      var offsetPosition = this.cache('target-offsetparent-bounds', function () {
        return getBounds(_this7.bodyElement, offsetParent);
      });
      var offsetParentStyle = getComputedStyle(offsetParent);
      var offsetParentSize = offsetPosition;
      var offsetBorder = {};
      ['Top', 'Left', 'Bottom', 'Right'].forEach(function (side) {
        offsetBorder[side.toLowerCase()] = parseFloat(offsetParentStyle["border" + side + "Width"]);
      });
      offsetPosition.right = doc.body.scrollWidth - offsetPosition.left - offsetParentSize.width + offsetBorder.right;
      offsetPosition.bottom = doc.body.scrollHeight - offsetPosition.top - offsetParentSize.height + offsetBorder.bottom;

      if (next.page.top >= offsetPosition.top + offsetBorder.top && next.page.bottom >= offsetPosition.bottom) {
        if (next.page.left >= offsetPosition.left + offsetBorder.left && next.page.right >= offsetPosition.right) {
          // We're within the visible part of the target's scroll parent
          var scrollLeft = offsetParent.scrollLeft,
              scrollTop = offsetParent.scrollTop; // It's position relative to the target's offset parent (absolute positioning when
          // the element is moved to be a child of the target's offset parent).

          next.offset = {
            top: next.page.top - offsetPosition.top + scrollTop - offsetBorder.top,
            left: next.page.left - offsetPosition.left + scrollLeft - offsetBorder.left
          };
        }
      }
    } // We could also travel up the DOM and try each containing context, rather than only
    // looking at the body, but we're gonna get diminishing returns.


    this.move(next);
    this.history.unshift(next);

    if (this.history.length > 3) {
      this.history.pop();
    }

    if (flushChanges) {
      flush();
    }

    return true;
  } // THE ISSUE
  ;

  _proto.move = function move(pos) {
    var _this8 = this;

    if (isUndefined(this.element.parentNode)) {
      return;
    }

    var same = {};

    for (var type in pos) {
      same[type] = {};

      for (var key in pos[type]) {
        var found = false;

        for (var i = 0; i < this.history.length; ++i) {
          var point = this.history[i];

          if (!isUndefined(point[type]) && !within(point[type][key], pos[type][key])) {
            found = true;
            break;
          }
        }

        if (!found) {
          same[type][key] = true;
        }
      }
    }

    var css = {
      top: '',
      left: '',
      right: '',
      bottom: ''
    };

    var transcribe = function transcribe(_same, _pos) {
      var hasOptimizations = !isUndefined(_this8.options.optimizations);
      var gpu = hasOptimizations ? _this8.options.optimizations.gpu : null;

      if (gpu !== false) {
        var yPos, xPos;

        if (_same.top) {
          css.top = 0;
          yPos = _pos.top;
        } else {
          css.bottom = 0;
          yPos = -_pos.bottom;
        }

        if (_same.left) {
          css.left = 0;
          xPos = _pos.left;
        } else {
          css.right = 0;
          xPos = -_pos.right;
        }

        if (isNumber(window.devicePixelRatio) && devicePixelRatio % 1 === 0) {
          xPos = Math.round(xPos * devicePixelRatio) / devicePixelRatio;
          yPos = Math.round(yPos * devicePixelRatio) / devicePixelRatio;
        }

        css[transformKey] = "translateX(" + xPos + "px) translateY(" + yPos + "px)";

        if (transformKey !== 'msTransform') {
          // The Z transform will keep this in the GPU (faster, and prevents artifacts),
          // but IE9 doesn't support 3d transforms and will choke.
          css[transformKey] += ' translateZ(0)';
        }
      } else {
        if (_same.top) {
          css.top = _pos.top + "px";
        } else {
          css.bottom = _pos.bottom + "px";
        }

        if (_same.left) {
          css.left = _pos.left + "px";
        } else {
          css.right = _pos.right + "px";
        }
      }
    };

    var hasOptimizations = !isUndefined(this.options.optimizations);
    var allowPositionFixed = true;

    if (hasOptimizations && this.options.optimizations.allowPositionFixed === false) {
      allowPositionFixed = false;
    }

    var moved = false;

    if ((same.page.top || same.page.bottom) && (same.page.left || same.page.right)) {
      css.position = 'absolute';
      transcribe(same.page, pos.page);
    } else if (allowPositionFixed && (same.viewport.top || same.viewport.bottom) && (same.viewport.left || same.viewport.right)) {
      css.position = 'fixed';
      transcribe(same.viewport, pos.viewport);
    } else if (!isUndefined(same.offset) && same.offset.top && same.offset.left) {
      css.position = 'absolute';
      var offsetParent = this.cache('target-offsetparent', function () {
        return getOffsetParent(_this8.target);
      });

      if (getOffsetParent(this.element) !== offsetParent) {
        defer(function () {
          _this8.element.parentNode.removeChild(_this8.element);

          offsetParent.appendChild(_this8.element);
        });
      }

      transcribe(same.offset, pos.offset);
      moved = true;
    } else {
      css.position = 'absolute';
      transcribe({
        top: true,
        left: true
      }, pos.page);
    }

    if (!moved) {
      if (this.options.bodyElement) {
        if (this.element.parentNode !== this.options.bodyElement) {
          this.options.bodyElement.appendChild(this.element);
        }
      } else {
        var offsetParentIsBody = true;
        var currentNode = this.element.parentNode;

        while (currentNode && currentNode.nodeType === 1 && currentNode.tagName !== 'BODY' && !isFullscreenElement(currentNode)) {
          if (getComputedStyle(currentNode).position !== 'static') {
            offsetParentIsBody = false;
            break;
          }

          currentNode = currentNode.parentNode;
        }

        if (!offsetParentIsBody) {
          this.element.parentNode.removeChild(this.element);
          this.element.ownerDocument.body.appendChild(this.element);
        }
      }
    } // Any css change will trigger a repaint, so let's avoid one if nothing changed


    var writeCSS = {};
    var write = false;

    for (var _key in css) {
      var val = css[_key];
      var elVal = this.element.style[_key];

      if (elVal !== val) {
        write = true;
        writeCSS[_key] = val;
      }
    }

    if (write) {
      defer(function () {
        extend(_this8.element.style, writeCSS);

        _this8.trigger('repositioned');
      });
    }
  };

  _proto._addClasses = function _addClasses() {
    var _this$options5 = this.options,
        classes = _this$options5.classes,
        classPrefix = _this$options5.classPrefix;
    addClass(this.element, getClass('element', classes, classPrefix));

    if (!(this.options.addTargetClasses === false)) {
      addClass(this.target, getClass('target', classes, classPrefix));
    }
  };

  _proto._removeClasses = function _removeClasses() {
    var _this9 = this;

    var _this$options6 = this.options,
        classes = _this$options6.classes,
        classPrefix = _this$options6.classPrefix;
    removeClass(this.element, getClass('element', classes, classPrefix));

    if (!(this.options.addTargetClasses === false)) {
      removeClass(this.target, getClass('target', classes, classPrefix));
    }

    this.all.forEach(function (className) {
      _this9.element.classList.remove(className);

      _this9.target.classList.remove(className);
    });
  };

  return TetherClass;
}(Evented);

TetherClass.modules = [];
TetherBase.position = position;
var Tether = extend(TetherClass, TetherBase);
Tether.modules.push({
  initialize: function initialize() {
    var _this10 = this;

    var _this$options7 = this.options,
        classes = _this$options7.classes,
        classPrefix = _this$options7.classPrefix;
    this.markers = {};
    ['target', 'element'].forEach(function (type) {
      var el = document.createElement('div');
      el.className = getClass(type + "-marker", classes, classPrefix);
      var dot = document.createElement('div');
      dot.className = getClass('marker-dot', classes, classPrefix);
      el.appendChild(dot);

      _this10[type].appendChild(el);

      _this10.markers[type] = {
        dot: dot,
        el: el
      };
    });
  },
  position: function position(_ref) {
    var manualOffset = _ref.manualOffset,
        manualTargetOffset = _ref.manualTargetOffset;
    var offsets = {
      element: manualOffset,
      target: manualTargetOffset
    };

    for (var type in offsets) {
      var offset = offsets[type];

      for (var side in offset) {
        var _this$markers$type$do;

        var val = offset[side];

        if (!isString(val) || val.indexOf('%') === -1 && val.indexOf('px') === -1) {
          val += 'px';
        }

        if (this.markers[type] && ((_this$markers$type$do = this.markers[type].dot) == null ? void 0 : _this$markers$type$do.style[side]) !== val) {
          this.markers[type].dot.style[side] = val;
        }
      }
    }

    return true;
  }
});

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Tether);
//# sourceMappingURL=tether.esm.js.map


/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be in strict mode.
(() => {
"use strict";
/*!*************************!*\
  !*** ./source/index.js ***!
  \*************************/
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Checkbox": () => (/* reexport safe */ _checkbox_checkbox__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   "Dropdown": () => (/* reexport safe */ _dropdown_dropdown__WEBPACK_IMPORTED_MODULE_1__["default"]),
/* harmony export */   "Flyout": () => (/* reexport safe */ _flyout_flyout__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   "Modal": () => (/* reexport safe */ _modal_modal__WEBPACK_IMPORTED_MODULE_3__["default"]),
/* harmony export */   "Popover": () => (/* reexport safe */ _popover_popover__WEBPACK_IMPORTED_MODULE_4__["default"]),
/* harmony export */   "Progress": () => (/* reexport safe */ _progress_progress__WEBPACK_IMPORTED_MODULE_5__["default"]),
/* harmony export */   "Radio": () => (/* reexport safe */ _radio_radio__WEBPACK_IMPORTED_MODULE_6__["default"]),
/* harmony export */   "Response": () => (/* reexport safe */ _response_response__WEBPACK_IMPORTED_MODULE_7__["default"]),
/* harmony export */   "Select": () => (/* reexport safe */ _select_select__WEBPACK_IMPORTED_MODULE_8__["default"]),
/* harmony export */   "Slider": () => (/* reexport safe */ _slider_slider__WEBPACK_IMPORTED_MODULE_9__["default"]),
/* harmony export */   "Spinner": () => (/* reexport safe */ _spinner_spinner__WEBPACK_IMPORTED_MODULE_10__["default"]),
/* harmony export */   "Textfield": () => (/* reexport safe */ _textfield_textfield__WEBPACK_IMPORTED_MODULE_11__["default"]),
/* harmony export */   "Tooltip": () => (/* reexport safe */ _tooltip_tooltip__WEBPACK_IMPORTED_MODULE_12__["default"]),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _checkbox_checkbox__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./checkbox/checkbox */ "./source/checkbox/checkbox.js");
/* harmony import */ var _dropdown_dropdown__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./dropdown/dropdown */ "./source/dropdown/dropdown.js");
/* harmony import */ var _flyout_flyout__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./flyout/flyout */ "./source/flyout/flyout.js");
/* harmony import */ var _modal_modal__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./modal/modal */ "./source/modal/modal.js");
/* harmony import */ var _popover_popover__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./popover/popover */ "./source/popover/popover.js");
/* harmony import */ var _progress_progress__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./progress/progress */ "./source/progress/progress.js");
/* harmony import */ var _radio_radio__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./radio/radio */ "./source/radio/radio.js");
/* harmony import */ var _response_response__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./response/response */ "./source/response/response.js");
/* harmony import */ var _select_select__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./select/select */ "./source/select/select.js");
/* harmony import */ var _slider_slider__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./slider/slider */ "./source/slider/slider.js");
/* harmony import */ var _spinner_spinner__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./spinner/spinner */ "./source/spinner/spinner.js");
/* harmony import */ var _textfield_textfield__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./textfield/textfield */ "./source/textfield/textfield.js");
/* harmony import */ var _tooltip_tooltip__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./tooltip/tooltip */ "./source/tooltip/tooltip.js");
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
/**
 * Import all AUI components.
 */
// import Alert from './alert/alert';
// import Breadcrumb from './breadcrumb/breadcrumb';



// import Header from './header/header';

// import Nav from './nav/nav';
// import Notification from './notification/notification';
// import Pagination from './pagination/pagination';
// import Player from './player/player';






// import Slidernav from './slidernav/slidernav';




/**
 * Export all AUI components to make them accessible through npm.
 * @example
 * import {Alert} from 'audi-ui';
 * Alert.upgradeElements();
 */
// export {  Alert,  Breadcrumb,  Checkbox,  Dropdown,  Flyout,  Header,  Modal,  Nav,  Notification,  Pagination,  Player,  Popover,  Progress,  Radio,  Response,  Select,  Slider,  Slidernav,  Spinner,  Textfield,  Tooltip}


/**
 * Export Component Handler as default to have access to all components.
 * @example
 * import auiHandler from 'audi-ui';
 * auiHandler.upgradeAllElements();
 */
var ComponentHandler = /*#__PURE__*/function () {
  function ComponentHandler() {
    _classCallCheck(this, ComponentHandler);
    /**
     * Performs a "Cutting the mustard" test. If the browser supports the features
     * tested, adds a aui-js class to the <html> element.
     */
    if ('classList' in document.createElement('div') && 'querySelector' in document && 'addEventListener' in window && Array.prototype.forEach) {
      document.documentElement.classList.add('aui-js');
    }

    // TODO: M.O.: ohne das hier hat es nicht geupdated: (Vielleicht nicht die optimale Lösung...)
    this.upgradeAllElements();
  }
  _createClass(ComponentHandler, [{
    key: "upgradeAllElements",
    value: function upgradeAllElements() {
      // Alert.upgradeElements();
      // Breadcrumb.upgradeElements();
      _checkbox_checkbox__WEBPACK_IMPORTED_MODULE_0__["default"].upgradeElements();
      _dropdown_dropdown__WEBPACK_IMPORTED_MODULE_1__["default"].upgradeElements();
      _flyout_flyout__WEBPACK_IMPORTED_MODULE_2__["default"].upgradeElements();
      // Header.upgradeElements();
      _modal_modal__WEBPACK_IMPORTED_MODULE_3__["default"].upgradeElements();
      // Nav.upgradeElements();
      // Notification.upgradeElements();
      // Pagination.upgradeElements();
      // Player.upgradeElements();
      _popover_popover__WEBPACK_IMPORTED_MODULE_4__["default"].upgradeElements();
      _progress_progress__WEBPACK_IMPORTED_MODULE_5__["default"].upgradeElements();
      _radio_radio__WEBPACK_IMPORTED_MODULE_6__["default"].upgradeElements();
      _response_response__WEBPACK_IMPORTED_MODULE_7__["default"].upgradeElements();
      _select_select__WEBPACK_IMPORTED_MODULE_8__["default"].upgradeElements();
      _slider_slider__WEBPACK_IMPORTED_MODULE_9__["default"].upgradeElements();
      // Slidernav.upgradeElements();
      _spinner_spinner__WEBPACK_IMPORTED_MODULE_10__["default"].upgradeElements();
      _textfield_textfield__WEBPACK_IMPORTED_MODULE_11__["default"].upgradeElements();
      _tooltip_tooltip__WEBPACK_IMPORTED_MODULE_12__["default"].upgradeElements();
    }
  }]);
  return ComponentHandler;
}();
var componentHandler = new ComponentHandler();
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (componentHandler);
})();

/******/ 	return __webpack_exports__;
/******/ })()
;
});
//# sourceMappingURL=audi-ci.js.map