/*!
 * 
 *      * @audi/ci-2017 - Audi WBT CI based on Audi Corporate Identity 2017
 *      * @version v1.1.2
 *      * @license MIT
 *      * @copyright 2018 Sascha Kurth <s.kurth@innovationmecom.de>
 *      * @link http://www.innovationmecom.de
 *   
 * 
 */
(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define("audi-ci", [], factory);
	else if(typeof exports === 'object')
		exports["audi-ci"] = factory();
	else
		root["audi-ci"] = factory();
})(window, function() {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = "./source/index.js");
/******/ })
/************************************************************************/
/******/ ({

/***/ "./node_modules/bezier-easing/src/index.js":
/*!*************************************************!*\
  !*** ./node_modules/bezier-easing/src/index.js ***!
  \*************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

/**
 * https://github.com/gre/bezier-easing
 * BezierEasing - use bezier curve for transition easing function
 * by Gaëtan Renaudeau 2014 - 2015 – MIT License
 */

// These values are established by empiricism with tests (tradeoff: performance VS precision)
var NEWTON_ITERATIONS = 4;
var NEWTON_MIN_SLOPE = 0.001;
var SUBDIVISION_PRECISION = 0.0000001;
var SUBDIVISION_MAX_ITERATIONS = 10;

var kSplineTableSize = 11;
var kSampleStepSize = 1.0 / (kSplineTableSize - 1.0);

var float32ArraySupported = typeof Float32Array === 'function';

function A (aA1, aA2) { return 1.0 - 3.0 * aA2 + 3.0 * aA1; }
function B (aA1, aA2) { return 3.0 * aA2 - 6.0 * aA1; }
function C (aA1)      { return 3.0 * aA1; }

// Returns x(t) given t, x1, and x2, or y(t) given t, y1, and y2.
function calcBezier (aT, aA1, aA2) { return ((A(aA1, aA2) * aT + B(aA1, aA2)) * aT + C(aA1)) * aT; }

// Returns dx/dt given t, x1, and x2, or dy/dt given t, y1, and y2.
function getSlope (aT, aA1, aA2) { return 3.0 * A(aA1, aA2) * aT * aT + 2.0 * B(aA1, aA2) * aT + C(aA1); }

function binarySubdivide (aX, aA, aB, mX1, mX2) {
  var currentX, currentT, i = 0;
  do {
    currentT = aA + (aB - aA) / 2.0;
    currentX = calcBezier(currentT, mX1, mX2) - aX;
    if (currentX > 0.0) {
      aB = currentT;
    } else {
      aA = currentT;
    }
  } while (Math.abs(currentX) > SUBDIVISION_PRECISION && ++i < SUBDIVISION_MAX_ITERATIONS);
  return currentT;
}

function newtonRaphsonIterate (aX, aGuessT, mX1, mX2) {
 for (var i = 0; i < NEWTON_ITERATIONS; ++i) {
   var currentSlope = getSlope(aGuessT, mX1, mX2);
   if (currentSlope === 0.0) {
     return aGuessT;
   }
   var currentX = calcBezier(aGuessT, mX1, mX2) - aX;
   aGuessT -= currentX / currentSlope;
 }
 return aGuessT;
}

module.exports = function bezier (mX1, mY1, mX2, mY2) {
  if (!(0 <= mX1 && mX1 <= 1 && 0 <= mX2 && mX2 <= 1)) {
    throw new Error('bezier x values must be in [0, 1] range');
  }

  // Precompute samples table
  var sampleValues = float32ArraySupported ? new Float32Array(kSplineTableSize) : new Array(kSplineTableSize);
  if (mX1 !== mY1 || mX2 !== mY2) {
    for (var i = 0; i < kSplineTableSize; ++i) {
      sampleValues[i] = calcBezier(i * kSampleStepSize, mX1, mX2);
    }
  }

  function getTForX (aX) {
    var intervalStart = 0.0;
    var currentSample = 1;
    var lastSample = kSplineTableSize - 1;

    for (; currentSample !== lastSample && sampleValues[currentSample] <= aX; ++currentSample) {
      intervalStart += kSampleStepSize;
    }
    --currentSample;

    // Interpolate to provide an initial guess for t
    var dist = (aX - sampleValues[currentSample]) / (sampleValues[currentSample + 1] - sampleValues[currentSample]);
    var guessForT = intervalStart + dist * kSampleStepSize;

    var initialSlope = getSlope(guessForT, mX1, mX2);
    if (initialSlope >= NEWTON_MIN_SLOPE) {
      return newtonRaphsonIterate(aX, guessForT, mX1, mX2);
    } else if (initialSlope === 0.0) {
      return guessForT;
    } else {
      return binarySubdivide(aX, intervalStart, intervalStart + kSampleStepSize, mX1, mX2);
    }
  }

  return function BezierEasing (x) {
    if (mX1 === mY1 && mX2 === mY2) {
      return x; // linear
    }
    // Because JavaScript number are imprecise, we should guarantee the extremes are right.
    if (x === 0) {
      return 0;
    }
    if (x === 1) {
      return 1;
    }
    return calcBezier(getTForX(x), mY1, mY2);
  };
};


/***/ }),

/***/ "./node_modules/nouislider/distribute/nouislider.js":
/*!**********************************************************!*\
  !*** ./node_modules/nouislider/distribute/nouislider.js ***!
  \**********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*! nouislider - 9.2.0 - 2017-01-11 10:35:34 */

(function (factory) {

    if ( true ) {

        // AMD. Register as an anonymous module.
        !(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

    } else {}

}(function( ){

	'use strict';

	var VERSION = '9.2.0';


	// Creates a node, adds it to target, returns the new node.
	function addNodeTo ( target, className ) {
		var div = document.createElement('div');
		addClass(div, className);
		target.appendChild(div);
		return div;
	}

	// Removes duplicates from an array.
	function unique ( array ) {
		return array.filter(function(a){
			return !this[a] ? this[a] = true : false;
		}, {});
	}

	// Round a value to the closest 'to'.
	function closest ( value, to ) {
		return Math.round(value / to) * to;
	}

	// Current position of an element relative to the document.
	function offset ( elem, orientation ) {

	var rect = elem.getBoundingClientRect(),
		doc = elem.ownerDocument,
		docElem = doc.documentElement,
		pageOffset = getPageOffset();

		// getBoundingClientRect contains left scroll in Chrome on Android.
		// I haven't found a feature detection that proves this. Worst case
		// scenario on mis-match: the 'tap' feature on horizontal sliders breaks.
		if ( /webkit.*Chrome.*Mobile/i.test(navigator.userAgent) ) {
			pageOffset.x = 0;
		}

		return orientation ? (rect.top + pageOffset.y - docElem.clientTop) : (rect.left + pageOffset.x - docElem.clientLeft);
	}

	// Checks whether a value is numerical.
	function isNumeric ( a ) {
		return typeof a === 'number' && !isNaN( a ) && isFinite( a );
	}

	// Sets a class and removes it after [duration] ms.
	function addClassFor ( element, className, duration ) {
		if (duration > 0) {
		addClass(element, className);
			setTimeout(function(){
				removeClass(element, className);
			}, duration);
		}
	}

	// Limits a value to 0 - 100
	function limit ( a ) {
		return Math.max(Math.min(a, 100), 0);
	}

	// Wraps a variable as an array, if it isn't one yet.
	// Note that an input array is returned by reference!
	function asArray ( a ) {
		return Array.isArray(a) ? a : [a];
	}

	// Counts decimals
	function countDecimals ( numStr ) {
		numStr = String(numStr);
		var pieces = numStr.split(".");
		return pieces.length > 1 ? pieces[1].length : 0;
	}

	// http://youmightnotneedjquery.com/#add_class
	function addClass ( el, className ) {
		if ( el.classList ) {
			el.classList.add(className);
		} else {
			el.className += ' ' + className;
		}
	}

	// http://youmightnotneedjquery.com/#remove_class
	function removeClass ( el, className ) {
		if ( el.classList ) {
			el.classList.remove(className);
		} else {
			el.className = el.className.replace(new RegExp('(^|\\b)' + className.split(' ').join('|') + '(\\b|$)', 'gi'), ' ');
		}
	}

	// https://plainjs.com/javascript/attributes/adding-removing-and-testing-for-classes-9/
	function hasClass ( el, className ) {
		return el.classList ? el.classList.contains(className) : new RegExp('\\b' + className + '\\b').test(el.className);
	}

	// https://developer.mozilla.org/en-US/docs/Web/API/Window/scrollY#Notes
	function getPageOffset ( ) {

		var supportPageOffset = window.pageXOffset !== undefined,
			isCSS1Compat = ((document.compatMode || "") === "CSS1Compat"),
			x = supportPageOffset ? window.pageXOffset : isCSS1Compat ? document.documentElement.scrollLeft : document.body.scrollLeft,
			y = supportPageOffset ? window.pageYOffset : isCSS1Compat ? document.documentElement.scrollTop : document.body.scrollTop;

		return {
			x: x,
			y: y
		};
	}

	// we provide a function to compute constants instead
	// of accessing window.* as soon as the module needs it
	// so that we do not compute anything if not needed
	function getActions ( ) {

		// Determine the events to bind. IE11 implements pointerEvents without
		// a prefix, which breaks compatibility with the IE10 implementation.
		return window.navigator.pointerEnabled ? {
			start: 'pointerdown',
			move: 'pointermove',
			end: 'pointerup'
		} : window.navigator.msPointerEnabled ? {
			start: 'MSPointerDown',
			move: 'MSPointerMove',
			end: 'MSPointerUp'
		} : {
			start: 'mousedown touchstart',
			move: 'mousemove touchmove',
			end: 'mouseup touchend'
		};
	}


// Value calculation

	// Determine the size of a sub-range in relation to a full range.
	function subRangeRatio ( pa, pb ) {
		return (100 / (pb - pa));
	}

	// (percentage) How many percent is this value of this range?
	function fromPercentage ( range, value ) {
		return (value * 100) / ( range[1] - range[0] );
	}

	// (percentage) Where is this value on this range?
	function toPercentage ( range, value ) {
		return fromPercentage( range, range[0] < 0 ?
			value + Math.abs(range[0]) :
				value - range[0] );
	}

	// (value) How much is this percentage on this range?
	function isPercentage ( range, value ) {
		return ((value * ( range[1] - range[0] )) / 100) + range[0];
	}


// Range conversion

	function getJ ( value, arr ) {

		var j = 1;

		while ( value >= arr[j] ){
			j += 1;
		}

		return j;
	}

	// (percentage) Input a value, find where, on a scale of 0-100, it applies.
	function toStepping ( xVal, xPct, value ) {

		if ( value >= xVal.slice(-1)[0] ){
			return 100;
		}

		var j = getJ( value, xVal ), va, vb, pa, pb;

		va = xVal[j-1];
		vb = xVal[j];
		pa = xPct[j-1];
		pb = xPct[j];

		return pa + (toPercentage([va, vb], value) / subRangeRatio (pa, pb));
	}

	// (value) Input a percentage, find where it is on the specified range.
	function fromStepping ( xVal, xPct, value ) {

		// There is no range group that fits 100
		if ( value >= 100 ){
			return xVal.slice(-1)[0];
		}

		var j = getJ( value, xPct ), va, vb, pa, pb;

		va = xVal[j-1];
		vb = xVal[j];
		pa = xPct[j-1];
		pb = xPct[j];

		return isPercentage([va, vb], (value - pa) * subRangeRatio (pa, pb));
	}

	// (percentage) Get the step that applies at a certain value.
	function getStep ( xPct, xSteps, snap, value ) {

		if ( value === 100 ) {
			return value;
		}

		var j = getJ( value, xPct ), a, b;

		// If 'snap' is set, steps are used as fixed points on the slider.
		if ( snap ) {

			a = xPct[j-1];
			b = xPct[j];

			// Find the closest position, a or b.
			if ((value - a) > ((b-a)/2)){
				return b;
			}

			return a;
		}

		if ( !xSteps[j-1] ){
			return value;
		}

		return xPct[j-1] + closest(
			value - xPct[j-1],
			xSteps[j-1]
		);
	}


// Entry parsing

	function handleEntryPoint ( index, value, that ) {

		var percentage;

		// Wrap numerical input in an array.
		if ( typeof value === "number" ) {
			value = [value];
		}

		// Reject any invalid input, by testing whether value is an array.
		if ( Object.prototype.toString.call( value ) !== '[object Array]' ){
			throw new Error("noUiSlider (" + VERSION + "): 'range' contains invalid value.");
		}

		// Covert min/max syntax to 0 and 100.
		if ( index === 'min' ) {
			percentage = 0;
		} else if ( index === 'max' ) {
			percentage = 100;
		} else {
			percentage = parseFloat( index );
		}

		// Check for correct input.
		if ( !isNumeric( percentage ) || !isNumeric( value[0] ) ) {
			throw new Error("noUiSlider (" + VERSION + "): 'range' value isn't numeric.");
		}

		// Store values.
		that.xPct.push( percentage );
		that.xVal.push( value[0] );

		// NaN will evaluate to false too, but to keep
		// logging clear, set step explicitly. Make sure
		// not to override the 'step' setting with false.
		if ( !percentage ) {
			if ( !isNaN( value[1] ) ) {
				that.xSteps[0] = value[1];
			}
		} else {
			that.xSteps.push( isNaN(value[1]) ? false : value[1] );
		}

		that.xHighestCompleteStep.push(0);
	}

	function handleStepPoint ( i, n, that ) {

		// Ignore 'false' stepping.
		if ( !n ) {
			return true;
		}

		// Factor to range ratio
		that.xSteps[i] = fromPercentage([
			 that.xVal[i]
			,that.xVal[i+1]
		], n) / subRangeRatio (
			that.xPct[i],
			that.xPct[i+1] );

		var totalSteps = (that.xVal[i+1] - that.xVal[i]) / that.xNumSteps[i];
		var highestStep = Math.ceil(Number(totalSteps.toFixed(3)) - 1);
		var step = that.xVal[i] + (that.xNumSteps[i] * highestStep);

		that.xHighestCompleteStep[i] = step;
	}


// Interface

	// The interface to Spectrum handles all direction-based
	// conversions, so the above values are unaware.

	function Spectrum ( entry, snap, direction, singleStep ) {

		this.xPct = [];
		this.xVal = [];
		this.xSteps = [ singleStep || false ];
		this.xNumSteps = [ false ];
		this.xHighestCompleteStep = [];

		this.snap = snap;
		this.direction = direction;

		var index, ordered = [ /* [0, 'min'], [1, '50%'], [2, 'max'] */ ];

		// Map the object keys to an array.
		for ( index in entry ) {
			if ( entry.hasOwnProperty(index) ) {
				ordered.push([entry[index], index]);
			}
		}

		// Sort all entries by value (numeric sort).
		if ( ordered.length && typeof ordered[0][0] === "object" ) {
			ordered.sort(function(a, b) { return a[0][0] - b[0][0]; });
		} else {
			ordered.sort(function(a, b) { return a[0] - b[0]; });
		}


		// Convert all entries to subranges.
		for ( index = 0; index < ordered.length; index++ ) {
			handleEntryPoint(ordered[index][1], ordered[index][0], this);
		}

		// Store the actual step values.
		// xSteps is sorted in the same order as xPct and xVal.
		this.xNumSteps = this.xSteps.slice(0);

		// Convert all numeric steps to the percentage of the subrange they represent.
		for ( index = 0; index < this.xNumSteps.length; index++ ) {
			handleStepPoint(index, this.xNumSteps[index], this);
		}
	}

	Spectrum.prototype.getMargin = function ( value ) {

		var step = this.xNumSteps[0];

		if ( step && ((value / step) % 1) !== 0 ) {
			throw new Error("noUiSlider (" + VERSION + "): 'limit', 'margin' and 'padding' must be divisible by step.");
		}

		return this.xPct.length === 2 ? fromPercentage(this.xVal, value) : false;
	};

	Spectrum.prototype.toStepping = function ( value ) {

		value = toStepping( this.xVal, this.xPct, value );

		return value;
	};

	Spectrum.prototype.fromStepping = function ( value ) {

		return fromStepping( this.xVal, this.xPct, value );
	};

	Spectrum.prototype.getStep = function ( value ) {

		value = getStep(this.xPct, this.xSteps, this.snap, value );

		return value;
	};

	Spectrum.prototype.getNearbySteps = function ( value ) {

		var j = getJ(value, this.xPct);

		return {
			stepBefore: { startValue: this.xVal[j-2], step: this.xNumSteps[j-2], highestStep: this.xHighestCompleteStep[j-2] },
			thisStep: { startValue: this.xVal[j-1], step: this.xNumSteps[j-1], highestStep: this.xHighestCompleteStep[j-1] },
			stepAfter: { startValue: this.xVal[j-0], step: this.xNumSteps[j-0], highestStep: this.xHighestCompleteStep[j-0] }
		};
	};

	Spectrum.prototype.countStepDecimals = function () {
		var stepDecimals = this.xNumSteps.map(countDecimals);
		return Math.max.apply(null, stepDecimals);
 	};

	// Outside testing
	Spectrum.prototype.convert = function ( value ) {
		return this.getStep(this.toStepping(value));
	};

/*	Every input option is tested and parsed. This'll prevent
	endless validation in internal methods. These tests are
	structured with an item for every option available. An
	option can be marked as required by setting the 'r' flag.
	The testing function is provided with three arguments:
		- The provided value for the option;
		- A reference to the options object;
		- The name for the option;

	The testing function returns false when an error is detected,
	or true when everything is OK. It can also modify the option
	object, to make sure all values can be correctly looped elsewhere. */

	var defaultFormatter = { 'to': function( value ){
		return value !== undefined && value.toFixed(2);
	}, 'from': Number };

	function testStep ( parsed, entry ) {

		if ( !isNumeric( entry ) ) {
			throw new Error("noUiSlider (" + VERSION + "): 'step' is not numeric.");
		}

		// The step option can still be used to set stepping
		// for linear sliders. Overwritten if set in 'range'.
		parsed.singleStep = entry;
	}

	function testRange ( parsed, entry ) {

		// Filter incorrect input.
		if ( typeof entry !== 'object' || Array.isArray(entry) ) {
			throw new Error("noUiSlider (" + VERSION + "): 'range' is not an object.");
		}

		// Catch missing start or end.
		if ( entry.min === undefined || entry.max === undefined ) {
			throw new Error("noUiSlider (" + VERSION + "): Missing 'min' or 'max' in 'range'.");
		}

		// Catch equal start or end.
		if ( entry.min === entry.max ) {
			throw new Error("noUiSlider (" + VERSION + "): 'range' 'min' and 'max' cannot be equal.");
		}

		parsed.spectrum = new Spectrum(entry, parsed.snap, parsed.dir, parsed.singleStep);
	}

	function testStart ( parsed, entry ) {

		entry = asArray(entry);

		// Validate input. Values aren't tested, as the public .val method
		// will always provide a valid location.
		if ( !Array.isArray( entry ) || !entry.length ) {
			throw new Error("noUiSlider (" + VERSION + "): 'start' option is incorrect.");
		}

		// Store the number of handles.
		parsed.handles = entry.length;

		// When the slider is initialized, the .val method will
		// be called with the start options.
		parsed.start = entry;
	}

	function testSnap ( parsed, entry ) {

		// Enforce 100% stepping within subranges.
		parsed.snap = entry;

		if ( typeof entry !== 'boolean' ){
			throw new Error("noUiSlider (" + VERSION + "): 'snap' option must be a boolean.");
		}
	}

	function testAnimate ( parsed, entry ) {

		// Enforce 100% stepping within subranges.
		parsed.animate = entry;

		if ( typeof entry !== 'boolean' ){
			throw new Error("noUiSlider (" + VERSION + "): 'animate' option must be a boolean.");
		}
	}

	function testAnimationDuration ( parsed, entry ) {

		parsed.animationDuration = entry;

		if ( typeof entry !== 'number' ){
			throw new Error("noUiSlider (" + VERSION + "): 'animationDuration' option must be a number.");
		}
	}

	function testConnect ( parsed, entry ) {

		var connect = [false];
		var i;

		// Map legacy options
		if ( entry === 'lower' ) {
			entry = [true, false];
		}

		else if ( entry === 'upper' ) {
			entry = [false, true];
		}

		// Handle boolean options
		if ( entry === true || entry === false ) {

			for ( i = 1; i < parsed.handles; i++ ) {
				connect.push(entry);
			}

			connect.push(false);
		}

		// Reject invalid input
		else if ( !Array.isArray( entry ) || !entry.length || entry.length !== parsed.handles + 1 ) {
			throw new Error("noUiSlider (" + VERSION + "): 'connect' option doesn't match handle count.");
		}

		else {
			connect = entry;
		}

		parsed.connect = connect;
	}

	function testOrientation ( parsed, entry ) {

		// Set orientation to an a numerical value for easy
		// array selection.
		switch ( entry ){
		  case 'horizontal':
			parsed.ort = 0;
			break;
		  case 'vertical':
			parsed.ort = 1;
			break;
		  default:
			throw new Error("noUiSlider (" + VERSION + "): 'orientation' option is invalid.");
		}
	}

	function testMargin ( parsed, entry ) {

		if ( !isNumeric(entry) ){
			throw new Error("noUiSlider (" + VERSION + "): 'margin' option must be numeric.");
		}

		// Issue #582
		if ( entry === 0 ) {
			return;
		}

		parsed.margin = parsed.spectrum.getMargin(entry);

		if ( !parsed.margin ) {
			throw new Error("noUiSlider (" + VERSION + "): 'margin' option is only supported on linear sliders.");
		}
	}

	function testLimit ( parsed, entry ) {

		if ( !isNumeric(entry) ){
			throw new Error("noUiSlider (" + VERSION + "): 'limit' option must be numeric.");
		}

		parsed.limit = parsed.spectrum.getMargin(entry);

		if ( !parsed.limit || parsed.handles < 2 ) {
			throw new Error("noUiSlider (" + VERSION + "): 'limit' option is only supported on linear sliders with 2 or more handles.");
		}
	}

	function testPadding ( parsed, entry ) {

		if ( !isNumeric(entry) ){
			throw new Error("noUiSlider (" + VERSION + "): 'padding' option must be numeric.");
		}

		if ( entry === 0 ) {
			return;
		}

		parsed.padding = parsed.spectrum.getMargin(entry);

		if ( !parsed.padding ) {
			throw new Error("noUiSlider (" + VERSION + "): 'padding' option is only supported on linear sliders.");
		}

		if ( parsed.padding < 0 ) {
			throw new Error("noUiSlider (" + VERSION + "): 'padding' option must be a positive number.");
		}

		if ( parsed.padding >= 50 ) {
			throw new Error("noUiSlider (" + VERSION + "): 'padding' option must be less than half the range.");
		}
	}

	function testDirection ( parsed, entry ) {

		// Set direction as a numerical value for easy parsing.
		// Invert connection for RTL sliders, so that the proper
		// handles get the connect/background classes.
		switch ( entry ) {
		  case 'ltr':
			parsed.dir = 0;
			break;
		  case 'rtl':
			parsed.dir = 1;
			break;
		  default:
			throw new Error("noUiSlider (" + VERSION + "): 'direction' option was not recognized.");
		}
	}

	function testBehaviour ( parsed, entry ) {

		// Make sure the input is a string.
		if ( typeof entry !== 'string' ) {
			throw new Error("noUiSlider (" + VERSION + "): 'behaviour' must be a string containing options.");
		}

		// Check if the string contains any keywords.
		// None are required.
		var tap = entry.indexOf('tap') >= 0;
		var drag = entry.indexOf('drag') >= 0;
		var fixed = entry.indexOf('fixed') >= 0;
		var snap = entry.indexOf('snap') >= 0;
		var hover = entry.indexOf('hover') >= 0;

		if ( fixed ) {

			if ( parsed.handles !== 2 ) {
				throw new Error("noUiSlider (" + VERSION + "): 'fixed' behaviour must be used with 2 handles");
			}

			// Use margin to enforce fixed state
			testMargin(parsed, parsed.start[1] - parsed.start[0]);
		}

		parsed.events = {
			tap: tap || snap,
			drag: drag,
			fixed: fixed,
			snap: snap,
			hover: hover
		};
	}

	function testTooltips ( parsed, entry ) {

		if ( entry === false ) {
			return;
		}

		else if ( entry === true ) {

			parsed.tooltips = [];

			for ( var i = 0; i < parsed.handles; i++ ) {
				parsed.tooltips.push(true);
			}
		}

		else {

			parsed.tooltips = asArray(entry);

			if ( parsed.tooltips.length !== parsed.handles ) {
				throw new Error("noUiSlider (" + VERSION + "): must pass a formatter for all handles.");
			}

			parsed.tooltips.forEach(function(formatter){
				if ( typeof formatter !== 'boolean' && (typeof formatter !== 'object' || typeof formatter.to !== 'function') ) {
					throw new Error("noUiSlider (" + VERSION + "): 'tooltips' must be passed a formatter or 'false'.");
				}
			});
		}
	}

	function testFormat ( parsed, entry ) {

		parsed.format = entry;

		// Any object with a to and from method is supported.
		if ( typeof entry.to === 'function' && typeof entry.from === 'function' ) {
			return true;
		}

		throw new Error("noUiSlider (" + VERSION + "): 'format' requires 'to' and 'from' methods.");
	}

	function testCssPrefix ( parsed, entry ) {

		if ( entry !== undefined && typeof entry !== 'string' && entry !== false ) {
			throw new Error("noUiSlider (" + VERSION + "): 'cssPrefix' must be a string or `false`.");
		}

		parsed.cssPrefix = entry;
	}

	function testCssClasses ( parsed, entry ) {

		if ( entry !== undefined && typeof entry !== 'object' ) {
			throw new Error("noUiSlider (" + VERSION + "): 'cssClasses' must be an object.");
		}

		if ( typeof parsed.cssPrefix === 'string' ) {
			parsed.cssClasses = {};

			for ( var key in entry ) {
				if ( !entry.hasOwnProperty(key) ) { continue; }

				parsed.cssClasses[key] = parsed.cssPrefix + entry[key];
			}
		} else {
			parsed.cssClasses = entry;
		}
	}

	function testUseRaf ( parsed, entry ) {
		if ( entry === true || entry === false ) {
			parsed.useRequestAnimationFrame = entry;
		} else {
			throw new Error("noUiSlider (" + VERSION + "): 'useRequestAnimationFrame' option should be true (default) or false.");
		}
	}

	// Test all developer settings and parse to assumption-safe values.
	function testOptions ( options ) {

		// To prove a fix for #537, freeze options here.
		// If the object is modified, an error will be thrown.
		// Object.freeze(options);

		var parsed = {
			margin: 0,
			limit: 0,
			padding: 0,
			animate: true,
			animationDuration: 300,
			format: defaultFormatter
		};

		// Tests are executed in the order they are presented here.
		var tests = {
			'step': { r: false, t: testStep },
			'start': { r: true, t: testStart },
			'connect': { r: true, t: testConnect },
			'direction': { r: true, t: testDirection },
			'snap': { r: false, t: testSnap },
			'animate': { r: false, t: testAnimate },
			'animationDuration': { r: false, t: testAnimationDuration },
			'range': { r: true, t: testRange },
			'orientation': { r: false, t: testOrientation },
			'margin': { r: false, t: testMargin },
			'limit': { r: false, t: testLimit },
			'padding': { r: false, t: testPadding },
			'behaviour': { r: true, t: testBehaviour },
			'format': { r: false, t: testFormat },
			'tooltips': { r: false, t: testTooltips },
			'cssPrefix': { r: false, t: testCssPrefix },
			'cssClasses': { r: false, t: testCssClasses },
			'useRequestAnimationFrame': { r: false, t: testUseRaf }
		};

		var defaults = {
			'connect': false,
			'direction': 'ltr',
			'behaviour': 'tap',
			'orientation': 'horizontal',
			'cssPrefix' : 'noUi-',
			'cssClasses': {
				target: 'target',
				base: 'base',
				origin: 'origin',
				handle: 'handle',
				handleLower: 'handle-lower',
				handleUpper: 'handle-upper',
				horizontal: 'horizontal',
				vertical: 'vertical',
				background: 'background',
				connect: 'connect',
				ltr: 'ltr',
				rtl: 'rtl',
				draggable: 'draggable',
				drag: 'state-drag',
				tap: 'state-tap',
				active: 'active',
				tooltip: 'tooltip',
				pips: 'pips',
				pipsHorizontal: 'pips-horizontal',
				pipsVertical: 'pips-vertical',
				marker: 'marker',
				markerHorizontal: 'marker-horizontal',
				markerVertical: 'marker-vertical',
				markerNormal: 'marker-normal',
				markerLarge: 'marker-large',
				markerSub: 'marker-sub',
				value: 'value',
				valueHorizontal: 'value-horizontal',
				valueVertical: 'value-vertical',
				valueNormal: 'value-normal',
				valueLarge: 'value-large',
				valueSub: 'value-sub'
			},
			'useRequestAnimationFrame': true
		};

		// Run all options through a testing mechanism to ensure correct
		// input. It should be noted that options might get modified to
		// be handled properly. E.g. wrapping integers in arrays.
		Object.keys(tests).forEach(function( name ){

			// If the option isn't set, but it is required, throw an error.
			if ( options[name] === undefined && defaults[name] === undefined ) {

				if ( tests[name].r ) {
					throw new Error("noUiSlider (" + VERSION + "): '" + name + "' is required.");
				}

				return true;
			}

			tests[name].t( parsed, options[name] === undefined ? defaults[name] : options[name] );
		});

		// Forward pips options
		parsed.pips = options.pips;

		var styles = [['left', 'top'], ['right', 'bottom']];

		// Pre-define the styles.
		parsed.style = styles[parsed.dir][parsed.ort];
		parsed.styleOposite = styles[parsed.dir?0:1][parsed.ort];

		return parsed;
	}


function closure ( target, options, originalOptions ){

	var actions = getActions( );

	// All variables local to 'closure' are prefixed with 'scope_'
	var scope_Target = target;
	var scope_Locations = [];
	var scope_Base;
	var scope_Handles;
	var scope_HandleNumbers = [];
	var scope_ActiveHandle = false;
	var scope_Connects;
	var scope_Spectrum = options.spectrum;
	var scope_Values = [];
	var scope_Events = {};
	var scope_Self;


	// Append a origin to the base
	function addOrigin ( base, handleNumber ) {

		var origin = addNodeTo(base, options.cssClasses.origin);
		var handle = addNodeTo(origin, options.cssClasses.handle);

		handle.setAttribute('data-handle', handleNumber);

		if ( handleNumber === 0 ) {
			addClass(handle, options.cssClasses.handleLower);
		}

		else if ( handleNumber === options.handles - 1 ) {
			addClass(handle, options.cssClasses.handleUpper);
		}

		return origin;
	}

	// Insert nodes for connect elements
	function addConnect ( base, add ) {

		if ( !add ) {
			return false;
		}

		return addNodeTo(base, options.cssClasses.connect);
	}

	// Add handles to the slider base.
	function addElements ( connectOptions, base ) {

		scope_Handles = [];
		scope_Connects = [];

		scope_Connects.push(addConnect(base, connectOptions[0]));

		// [::::O====O====O====]
		// connectOptions = [0, 1, 1, 1]

		for ( var i = 0; i < options.handles; i++ ) {
			// Keep a list of all added handles.
			scope_Handles.push(addOrigin(base, i));
			scope_HandleNumbers[i] = i;
			scope_Connects.push(addConnect(base, connectOptions[i + 1]));
		}
	}

	// Initialize a single slider.
	function addSlider ( target ) {

		// Apply classes and data to the target.
		addClass(target, options.cssClasses.target);

		if ( options.dir === 0 ) {
			addClass(target, options.cssClasses.ltr);
		} else {
			addClass(target, options.cssClasses.rtl);
		}

		if ( options.ort === 0 ) {
			addClass(target, options.cssClasses.horizontal);
		} else {
			addClass(target, options.cssClasses.vertical);
		}

		scope_Base = addNodeTo(target, options.cssClasses.base);
	}


	function addTooltip ( handle, handleNumber ) {

		if ( !options.tooltips[handleNumber] ) {
			return false;
		}

		return addNodeTo(handle.firstChild, options.cssClasses.tooltip);
	}

	// The tooltips option is a shorthand for using the 'update' event.
	function tooltips ( ) {

		// Tooltips are added with options.tooltips in original order.
		var tips = scope_Handles.map(addTooltip);

		bindEvent('update', function(values, handleNumber, unencoded) {

			if ( !tips[handleNumber] ) {
				return;
			}

			var formattedValue = values[handleNumber];

			if ( options.tooltips[handleNumber] !== true ) {
				formattedValue = options.tooltips[handleNumber].to(unencoded[handleNumber]);
			}

			tips[handleNumber].innerHTML = formattedValue;
		});
	}


	function getGroup ( mode, values, stepped ) {

		// Use the range.
		if ( mode === 'range' || mode === 'steps' ) {
			return scope_Spectrum.xVal;
		}

		if ( mode === 'count' ) {

			if ( !values ) {
				throw new Error("noUiSlider (" + VERSION + "): 'values' required for mode 'count'.");
			}

			// Divide 0 - 100 in 'count' parts.
			var spread = ( 100 / (values - 1) );
			var v;
			var i = 0;

			values = [];

			// List these parts and have them handled as 'positions'.
			while ( (v = i++ * spread) <= 100 ) {
				values.push(v);
			}

			mode = 'positions';
		}

		if ( mode === 'positions' ) {

			// Map all percentages to on-range values.
			return values.map(function( value ){
				return scope_Spectrum.fromStepping( stepped ? scope_Spectrum.getStep( value ) : value );
			});
		}

		if ( mode === 'values' ) {

			// If the value must be stepped, it needs to be converted to a percentage first.
			if ( stepped ) {

				return values.map(function( value ){

					// Convert to percentage, apply step, return to value.
					return scope_Spectrum.fromStepping( scope_Spectrum.getStep( scope_Spectrum.toStepping( value ) ) );
				});

			}

			// Otherwise, we can simply use the values.
			return values;
		}
	}

	function generateSpread ( density, mode, group ) {

		function safeIncrement(value, increment) {
			// Avoid floating point variance by dropping the smallest decimal places.
			return (value + increment).toFixed(7) / 1;
		}

		var indexes = {};
		var firstInRange = scope_Spectrum.xVal[0];
		var lastInRange = scope_Spectrum.xVal[scope_Spectrum.xVal.length-1];
		var ignoreFirst = false;
		var ignoreLast = false;
		var prevPct = 0;

		// Create a copy of the group, sort it and filter away all duplicates.
		group = unique(group.slice().sort(function(a, b){ return a - b; }));

		// Make sure the range starts with the first element.
		if ( group[0] !== firstInRange ) {
			group.unshift(firstInRange);
			ignoreFirst = true;
		}

		// Likewise for the last one.
		if ( group[group.length - 1] !== lastInRange ) {
			group.push(lastInRange);
			ignoreLast = true;
		}

		group.forEach(function ( current, index ) {

			// Get the current step and the lower + upper positions.
			var step;
			var i;
			var q;
			var low = current;
			var high = group[index+1];
			var newPct;
			var pctDifference;
			var pctPos;
			var type;
			var steps;
			var realSteps;
			var stepsize;

			// When using 'steps' mode, use the provided steps.
			// Otherwise, we'll step on to the next subrange.
			if ( mode === 'steps' ) {
				step = scope_Spectrum.xNumSteps[ index ];
			}

			// Default to a 'full' step.
			if ( !step ) {
				step = high-low;
			}

			// Low can be 0, so test for false. If high is undefined,
			// we are at the last subrange. Index 0 is already handled.
			if ( low === false || high === undefined ) {
				return;
			}

			// Make sure step isn't 0, which would cause an infinite loop (#654)
			step = Math.max(step, 0.0000001);

			// Find all steps in the subrange.
			for ( i = low; i <= high; i = safeIncrement(i, step) ) {

				// Get the percentage value for the current step,
				// calculate the size for the subrange.
				newPct = scope_Spectrum.toStepping( i );
				pctDifference = newPct - prevPct;

				steps = pctDifference / density;
				realSteps = Math.round(steps);

				// This ratio represents the ammount of percentage-space a point indicates.
				// For a density 1 the points/percentage = 1. For density 2, that percentage needs to be re-devided.
				// Round the percentage offset to an even number, then divide by two
				// to spread the offset on both sides of the range.
				stepsize = pctDifference/realSteps;

				// Divide all points evenly, adding the correct number to this subrange.
				// Run up to <= so that 100% gets a point, event if ignoreLast is set.
				for ( q = 1; q <= realSteps; q += 1 ) {

					// The ratio between the rounded value and the actual size might be ~1% off.
					// Correct the percentage offset by the number of points
					// per subrange. density = 1 will result in 100 points on the
					// full range, 2 for 50, 4 for 25, etc.
					pctPos = prevPct + ( q * stepsize );
					indexes[pctPos.toFixed(5)] = ['x', 0];
				}

				// Determine the point type.
				type = (group.indexOf(i) > -1) ? 1 : ( mode === 'steps' ? 2 : 0 );

				// Enforce the 'ignoreFirst' option by overwriting the type for 0.
				if ( !index && ignoreFirst ) {
					type = 0;
				}

				if ( !(i === high && ignoreLast)) {
					// Mark the 'type' of this point. 0 = plain, 1 = real value, 2 = step value.
					indexes[newPct.toFixed(5)] = [i, type];
				}

				// Update the percentage count.
				prevPct = newPct;
			}
		});

		return indexes;
	}

	function addMarking ( spread, filterFunc, formatter ) {

		var element = document.createElement('div');
		var out = '';
		var valueSizeClasses = [
			options.cssClasses.valueNormal,
			options.cssClasses.valueLarge,
			options.cssClasses.valueSub
		];
		var markerSizeClasses = [
			options.cssClasses.markerNormal,
			options.cssClasses.markerLarge,
			options.cssClasses.markerSub
		];
		var valueOrientationClasses = [
			options.cssClasses.valueHorizontal,
			options.cssClasses.valueVertical
		];
		var markerOrientationClasses = [
			options.cssClasses.markerHorizontal,
			options.cssClasses.markerVertical
		];

		addClass(element, options.cssClasses.pips);
		addClass(element, options.ort === 0 ? options.cssClasses.pipsHorizontal : options.cssClasses.pipsVertical);

		function getClasses( type, source ){
			var a = source === options.cssClasses.value;
			var orientationClasses = a ? valueOrientationClasses : markerOrientationClasses;
			var sizeClasses = a ? valueSizeClasses : markerSizeClasses;

			return source + ' ' + orientationClasses[options.ort] + ' ' + sizeClasses[type];
		}

		function getTags( offset, source, values ) {
			return 'class="' + getClasses(values[1], source) + '" style="' + options.style + ': ' + offset + '%"';
		}

		function addSpread ( offset, values ){

			// Apply the filter function, if it is set.
			values[1] = (values[1] && filterFunc) ? filterFunc(values[0], values[1]) : values[1];

			// Add a marker for every point
			out += '<div ' + getTags(offset, options.cssClasses.marker, values) + '></div>';

			// Values are only appended for points marked '1' or '2'.
			if ( values[1] ) {
				out += '<div ' + getTags(offset, options.cssClasses.value, values) + '>' + formatter.to(values[0]) + '</div>';
			}
		}

		// Append all points.
		Object.keys(spread).forEach(function(a){
			addSpread(a, spread[a]);
		});

		element.innerHTML = out;

		return element;
	}

	function pips ( grid ) {

		var mode = grid.mode;
		var density = grid.density || 1;
		var filter = grid.filter || false;
		var values = grid.values || false;
		var stepped = grid.stepped || false;
		var group = getGroup( mode, values, stepped );
		var spread = generateSpread( density, mode, group );
		var format = grid.format || {
			to: Math.round
		};

		return scope_Target.appendChild(addMarking(
			spread,
			filter,
			format
		));
	}


	// Shorthand for base dimensions.
	function baseSize ( ) {
		var rect = scope_Base.getBoundingClientRect(), alt = 'offset' + ['Width', 'Height'][options.ort];
		return options.ort === 0 ? (rect.width||scope_Base[alt]) : (rect.height||scope_Base[alt]);
	}

	// Handler for attaching events trough a proxy.
	function attachEvent ( events, element, callback, data ) {

		// This function can be used to 'filter' events to the slider.
		// element is a node, not a nodeList

		var method = function ( e ){

			if ( scope_Target.hasAttribute('disabled') ) {
				return false;
			}

			// Stop if an active 'tap' transition is taking place.
			if ( hasClass(scope_Target, options.cssClasses.tap) ) {
				return false;
			}

			e = fixEvent(e, data.pageOffset);

			// Handle reject of multitouch
			if ( !e ) {
				return false;
			}

			// Ignore right or middle clicks on start #454
			if ( events === actions.start && e.buttons !== undefined && e.buttons > 1 ) {
				return false;
			}

			// Ignore right or middle clicks on start #454
			if ( data.hover && e.buttons ) {
				return false;
			}

			e.calcPoint = e.points[ options.ort ];

			// Call the event handler with the event [ and additional data ].
			callback ( e, data );
		};

		var methods = [];

		// Bind a closure on the target for every event type.
		events.split(' ').forEach(function( eventName ){
			element.addEventListener(eventName, method, false);
			methods.push([eventName, method]);
		});

		return methods;
	}

	// Provide a clean event with standardized offset values.
	function fixEvent ( e, pageOffset ) {

		// Prevent scrolling and panning on touch events, while
		// attempting to slide. The tap event also depends on this.
		e.preventDefault();

		// Filter the event to register the type, which can be
		// touch, mouse or pointer. Offset changes need to be
		// made on an event specific basis.
		var touch = e.type.indexOf('touch') === 0;
		var mouse = e.type.indexOf('mouse') === 0;
		var pointer = e.type.indexOf('pointer') === 0;
		var x;
		var y;

		// IE10 implemented pointer events with a prefix;
		if ( e.type.indexOf('MSPointer') === 0 ) {
			pointer = true;
		}

		if ( touch ) {

			// Fix bug when user touches with two or more fingers on mobile devices.
			// It's useful when you have two or more sliders on one page,
			// that can be touched simultaneously.
			// #649, #663, #668
			if ( e.touches.length > 1 ) {
				return false;
			}

			// noUiSlider supports one movement at a time,
			// so we can select the first 'changedTouch'.
			x = e.changedTouches[0].pageX;
			y = e.changedTouches[0].pageY;
		}

		pageOffset = pageOffset || getPageOffset();

		if ( mouse || pointer ) {
			x = e.clientX + pageOffset.x;
			y = e.clientY + pageOffset.y;
		}

		e.pageOffset = pageOffset;
		e.points = [x, y];
		e.cursor = mouse || pointer; // Fix #435

		return e;
	}

	// Translate a coordinate in the document to a percentage on the slider
	function calcPointToPercentage ( calcPoint ) {
		var location = calcPoint - offset(scope_Base, options.ort);
		var proposal = ( location * 100 ) / baseSize();
		return options.dir ? 100 - proposal : proposal;
	}

	// Find handle closest to a certain percentage on the slider
	function getClosestHandle ( proposal ) {

		var closest = 100;
		var handleNumber = false;

		scope_Handles.forEach(function(handle, index){

			// Disabled handles are ignored
			if ( handle.hasAttribute('disabled') ) {
				return;
			}

			var pos = Math.abs(scope_Locations[index] - proposal);

			if ( pos < closest ) {
				handleNumber = index;
				closest = pos;
			}
		});

		return handleNumber;
	}

	// Moves handle(s) by a percentage
	// (bool, % to move, [% where handle started, ...], [index in scope_Handles, ...])
	function moveHandles ( upward, proposal, locations, handleNumbers ) {

		var proposals = locations.slice();

		var b = [!upward, upward];
		var f = [upward, !upward];

		// Copy handleNumbers so we don't change the dataset
		handleNumbers = handleNumbers.slice();

		// Check to see which handle is 'leading'.
		// If that one can't move the second can't either.
		if ( upward ) {
			handleNumbers.reverse();
		}

		// Step 1: get the maximum percentage that any of the handles can move
		if ( handleNumbers.length > 1 ) {

			handleNumbers.forEach(function(handleNumber, o) {

				var to = checkHandlePosition(proposals, handleNumber, proposals[handleNumber] + proposal, b[o], f[o]);

				// Stop if one of the handles can't move.
				if ( to === false ) {
					proposal = 0;
				} else {
					proposal = to - proposals[handleNumber];
					proposals[handleNumber] = to;
				}
			});
		}

		// If using one handle, check backward AND forward
		else {
			b = f = [true];
		}

		var state = false;

		// Step 2: Try to set the handles with the found percentage
		handleNumbers.forEach(function(handleNumber, o) {
			state = setHandle(handleNumber, locations[handleNumber] + proposal, b[o], f[o]) || state;
		});

		// Step 3: If a handle moved, fire events
		if ( state ) {
			handleNumbers.forEach(function(handleNumber){
				fireEvent('update', handleNumber);
				fireEvent('slide', handleNumber);
			});
		}
	}

	// External event handling
	function fireEvent ( eventName, handleNumber, tap ) {

		Object.keys(scope_Events).forEach(function( targetEvent ) {

			var eventType = targetEvent.split('.')[0];

			if ( eventName === eventType ) {
				scope_Events[targetEvent].forEach(function( callback ) {

					callback.call(
						// Use the slider public API as the scope ('this')
						scope_Self,
						// Return values as array, so arg_1[arg_2] is always valid.
						scope_Values.map(options.format.to),
						// Handle index, 0 or 1
						handleNumber,
						// Unformatted slider values
						scope_Values.slice(),
						// Event is fired by tap, true or false
						tap || false,
						// Left offset of the handle, in relation to the slider
						scope_Locations.slice()
					);
				});
			}
		});
	}


	// Fire 'end' when a mouse or pen leaves the document.
	function documentLeave ( event, data ) {
		if ( event.type === "mouseout" && event.target.nodeName === "HTML" && event.relatedTarget === null ){
			eventEnd (event, data);
		}
	}

	// Handle movement on document for handle and range drag.
	function eventMove ( event, data ) {

		// Fix #498
		// Check value of .buttons in 'start' to work around a bug in IE10 mobile (data.buttonsProperty).
		// https://connect.microsoft.com/IE/feedback/details/927005/mobile-ie10-windows-phone-buttons-property-of-pointermove-event-always-zero
		// IE9 has .buttons and .which zero on mousemove.
		// Firefox breaks the spec MDN defines.
		if ( navigator.appVersion.indexOf("MSIE 9") === -1 && event.buttons === 0 && data.buttonsProperty !== 0 ) {
			return eventEnd(event, data);
		}

		// Check if we are moving up or down
		var movement = (options.dir ? -1 : 1) * (event.calcPoint - data.startCalcPoint);

		// Convert the movement into a percentage of the slider width/height
		var proposal = (movement * 100) / data.baseSize;

		moveHandles(movement > 0, proposal, data.locations, data.handleNumbers);
	}

	// Unbind move events on document, call callbacks.
	function eventEnd ( event, data ) {

		// The handle is no longer active, so remove the class.
		if ( scope_ActiveHandle ) {
			removeClass(scope_ActiveHandle, options.cssClasses.active);
			scope_ActiveHandle = false;
		}

		// Remove cursor styles and text-selection events bound to the body.
		if ( event.cursor ) {
			document.body.style.cursor = '';
			document.body.removeEventListener('selectstart', document.body.noUiListener);
		}

		// Unbind the move and end events, which are added on 'start'.
		document.documentElement.noUiListeners.forEach(function( c ) {
			document.documentElement.removeEventListener(c[0], c[1]);
		});

		// Remove dragging class.
		removeClass(scope_Target, options.cssClasses.drag);

		setZindex();

		data.handleNumbers.forEach(function(handleNumber){
			fireEvent('set', handleNumber);
			fireEvent('change', handleNumber);
			fireEvent('end', handleNumber);
		});
	}

	// Bind move events on document.
	function eventStart ( event, data ) {

		if ( data.handleNumbers.length === 1 ) {

			var handle = scope_Handles[data.handleNumbers[0]];

			// Ignore 'disabled' handles
			if ( handle.hasAttribute('disabled') ) {
				return false;
			}

			// Mark the handle as 'active' so it can be styled.
			scope_ActiveHandle = handle.children[0];
			addClass(scope_ActiveHandle, options.cssClasses.active);
		}

		// Fix #551, where a handle gets selected instead of dragged.
		event.preventDefault();

		// A drag should never propagate up to the 'tap' event.
		event.stopPropagation();

		// Attach the move and end events.
		var moveEvent = attachEvent(actions.move, document.documentElement, eventMove, {
			startCalcPoint: event.calcPoint,
			baseSize: baseSize(),
			pageOffset: event.pageOffset,
			handleNumbers: data.handleNumbers,
			buttonsProperty: event.buttons,
			locations: scope_Locations.slice()
		});

		var endEvent = attachEvent(actions.end, document.documentElement, eventEnd, {
			handleNumbers: data.handleNumbers
		});

		var outEvent = attachEvent("mouseout", document.documentElement, documentLeave, {
			handleNumbers: data.handleNumbers
		});

		document.documentElement.noUiListeners = moveEvent.concat(endEvent, outEvent);

		// Text selection isn't an issue on touch devices,
		// so adding cursor styles can be skipped.
		if ( event.cursor ) {

			// Prevent the 'I' cursor and extend the range-drag cursor.
			document.body.style.cursor = getComputedStyle(event.target).cursor;

			// Mark the target with a dragging state.
			if ( scope_Handles.length > 1 ) {
				addClass(scope_Target, options.cssClasses.drag);
			}

			var f = function(){
				return false;
			};

			document.body.noUiListener = f;

			// Prevent text selection when dragging the handles.
			document.body.addEventListener('selectstart', f, false);
		}

		data.handleNumbers.forEach(function(handleNumber){
			fireEvent('start', handleNumber);
		});
	}

	// Move closest handle to tapped location.
	function eventTap ( event ) {

		// The tap event shouldn't propagate up
		event.stopPropagation();

		var proposal = calcPointToPercentage(event.calcPoint);
		var handleNumber = getClosestHandle(proposal);

		// Tackle the case that all handles are 'disabled'.
		if ( handleNumber === false ) {
			return false;
		}

		// Flag the slider as it is now in a transitional state.
		// Transition takes a configurable amount of ms (default 300). Re-enable the slider after that.
		if ( !options.events.snap ) {
			addClassFor(scope_Target, options.cssClasses.tap, options.animationDuration);
		}

		setHandle(handleNumber, proposal, true, true);

		setZindex();

		fireEvent('slide', handleNumber, true);
		fireEvent('set', handleNumber, true);
		fireEvent('change', handleNumber, true);
		fireEvent('update', handleNumber, true);

		if ( options.events.snap ) {
			eventStart(event, { handleNumbers: [handleNumber] });
		}
	}

	// Fires a 'hover' event for a hovered mouse/pen position.
	function eventHover ( event ) {

		var proposal = calcPointToPercentage(event.calcPoint);

		var to = scope_Spectrum.getStep(proposal);
		var value = scope_Spectrum.fromStepping(to);

		Object.keys(scope_Events).forEach(function( targetEvent ) {
			if ( 'hover' === targetEvent.split('.')[0] ) {
				scope_Events[targetEvent].forEach(function( callback ) {
					callback.call( scope_Self, value );
				});
			}
		});
	}

	// Attach events to several slider parts.
	function bindSliderEvents ( behaviour ) {

		// Attach the standard drag event to the handles.
		if ( !behaviour.fixed ) {

			scope_Handles.forEach(function( handle, index ){

				// These events are only bound to the visual handle
				// element, not the 'real' origin element.
				attachEvent ( actions.start, handle.children[0], eventStart, {
					handleNumbers: [index]
				});
			});
		}

		// Attach the tap event to the slider base.
		if ( behaviour.tap ) {
			attachEvent (actions.start, scope_Base, eventTap, {});
		}

		// Fire hover events
		if ( behaviour.hover ) {
			attachEvent (actions.move, scope_Base, eventHover, { hover: true });
		}

		// Make the range draggable.
		if ( behaviour.drag ){

			scope_Connects.forEach(function( connect, index ){

				if ( connect === false || index === 0 || index === scope_Connects.length - 1 ) {
					return;
				}

				var handleBefore = scope_Handles[index - 1];
				var handleAfter = scope_Handles[index];
				var eventHolders = [connect];

				addClass(connect, options.cssClasses.draggable);

				// When the range is fixed, the entire range can
				// be dragged by the handles. The handle in the first
				// origin will propagate the start event upward,
				// but it needs to be bound manually on the other.
				if ( behaviour.fixed ) {
					eventHolders.push(handleBefore.children[0]);
					eventHolders.push(handleAfter.children[0]);
				}

				eventHolders.forEach(function( eventHolder ) {
					attachEvent ( actions.start, eventHolder, eventStart, {
						handles: [handleBefore, handleAfter],
						handleNumbers: [index - 1, index]
					});
				});
			});
		}
	}


	// Split out the handle positioning logic so the Move event can use it, too
	function checkHandlePosition ( reference, handleNumber, to, lookBackward, lookForward ) {

		// For sliders with multiple handles, limit movement to the other handle.
		// Apply the margin option by adding it to the handle positions.
		if ( scope_Handles.length > 1 ) {

			if ( lookBackward && handleNumber > 0 ) {
				to = Math.max(to, reference[handleNumber - 1] + options.margin);
			}

			if ( lookForward && handleNumber < scope_Handles.length - 1 ) {
				to = Math.min(to, reference[handleNumber + 1] - options.margin);
			}
		}

		// The limit option has the opposite effect, limiting handles to a
		// maximum distance from another. Limit must be > 0, as otherwise
		// handles would be unmoveable.
		if ( scope_Handles.length > 1 && options.limit ) {

			if ( lookBackward && handleNumber > 0 ) {
				to = Math.min(to, reference[handleNumber - 1] + options.limit);
			}

			if ( lookForward && handleNumber < scope_Handles.length - 1 ) {
				to = Math.max(to, reference[handleNumber + 1] - options.limit);
			}
		}

		// The padding option keeps the handles a certain distance from the
		// edges of the slider. Padding must be > 0.
		if ( options.padding ) {

			if ( handleNumber === 0 ) {
				to = Math.max(to, options.padding);
			}

			if ( handleNumber === scope_Handles.length - 1 ) {
				to = Math.min(to, 100 - options.padding);
			}
		}

		to = scope_Spectrum.getStep(to);

		// Limit percentage to the 0 - 100 range
		to = limit(to);

		// Return false if handle can't move
		if ( to === reference[handleNumber] ) {
			return false;
		}

		return to;
	}

	function toPct ( pct ) {
		return pct + '%';
	}

	// Updates scope_Locations and scope_Values, updates visual state
	function updateHandlePosition ( handleNumber, to ) {

		// Update locations.
		scope_Locations[handleNumber] = to;

		// Convert the value to the slider stepping/range.
		scope_Values[handleNumber] = scope_Spectrum.fromStepping(to);

		// Called synchronously or on the next animationFrame
		var stateUpdate = function() {
			scope_Handles[handleNumber].style[options.style] = toPct(to);
			updateConnect(handleNumber);
			updateConnect(handleNumber + 1);
		};

		// Set the handle to the new position.
		// Use requestAnimationFrame for efficient painting.
		// No significant effect in Chrome, Edge sees dramatic performace improvements.
		// Option to disable is useful for unit tests, and single-step debugging.
		if ( window.requestAnimationFrame && options.useRequestAnimationFrame ) {
			window.requestAnimationFrame(stateUpdate);
		} else {
			stateUpdate();
		}
	}

	function setZindex ( ) {

		scope_HandleNumbers.forEach(function(handleNumber){
			// Handles before the slider middle are stacked later = higher,
			// Handles after the middle later is lower
			// [[7] [8] .......... | .......... [5] [4]
			var dir = (scope_Locations[handleNumber] > 50 ? -1 : 1);
			var zIndex = 3 + (scope_Handles.length + (dir * handleNumber));
			scope_Handles[handleNumber].childNodes[0].style.zIndex = zIndex;
		});
	}

	// Test suggested values and apply margin, step.
	function setHandle ( handleNumber, to, lookBackward, lookForward ) {

		to = checkHandlePosition(scope_Locations, handleNumber, to, lookBackward, lookForward);

		if ( to === false ) {
			return false;
		}

		updateHandlePosition(handleNumber, to);

		return true;
	}

	// Updates style attribute for connect nodes
	function updateConnect ( index ) {

		// Skip connects set to false
		if ( !scope_Connects[index] ) {
			return;
		}

		var l = 0;
		var h = 100;

		if ( index !== 0 ) {
			l = scope_Locations[index - 1];
		}

		if ( index !== scope_Connects.length - 1 ) {
			h = scope_Locations[index];
		}

		scope_Connects[index].style[options.style] = toPct(l);
		scope_Connects[index].style[options.styleOposite] = toPct(100 - h);
	}

	// ...
	function setValue ( to, handleNumber ) {

		// Setting with null indicates an 'ignore'.
		// Inputting 'false' is invalid.
		if ( to === null || to === false ) {
			return;
		}

		// If a formatted number was passed, attemt to decode it.
		if ( typeof to === 'number' ) {
			to = String(to);
		}

		to = options.format.from(to);

		// Request an update for all links if the value was invalid.
		// Do so too if setting the handle fails.
		if ( to !== false && !isNaN(to) ) {
			setHandle(handleNumber, scope_Spectrum.toStepping(to), false, false);
		}
	}

	// Set the slider value.
	function valueSet ( input, fireSetEvent ) {

		var values = asArray(input);
		var isInit = scope_Locations[0] === undefined;

		// Event fires by default
		fireSetEvent = (fireSetEvent === undefined ? true : !!fireSetEvent);

		values.forEach(setValue);

		// Animation is optional.
		// Make sure the initial values were set before using animated placement.
		if ( options.animate && !isInit ) {
			addClassFor(scope_Target, options.cssClasses.tap, options.animationDuration);
		}

		// Now that all base values are set, apply constraints
		scope_HandleNumbers.forEach(function(handleNumber){
			setHandle(handleNumber, scope_Locations[handleNumber], true, false);
		});

		setZindex();

		scope_HandleNumbers.forEach(function(handleNumber){

			fireEvent('update', handleNumber);

			// Fire the event only for handles that received a new value, as per #579
			if ( values[handleNumber] !== null && fireSetEvent ) {
				fireEvent('set', handleNumber);
			}
		});
	}

	// Reset slider to initial values
	function valueReset ( fireSetEvent ) {
		valueSet(options.start, fireSetEvent);
	}

	// Get the slider value.
	function valueGet ( ) {

		var values = scope_Values.map(options.format.to);

		// If only one handle is used, return a single value.
		if ( values.length === 1 ){
			return values[0];
		}

		return values;
	}

	// Removes classes from the root and empties it.
	function destroy ( ) {

		for ( var key in options.cssClasses ) {
			if ( !options.cssClasses.hasOwnProperty(key) ) { continue; }
			removeClass(scope_Target, options.cssClasses[key]);
		}

		while (scope_Target.firstChild) {
			scope_Target.removeChild(scope_Target.firstChild);
		}

		delete scope_Target.noUiSlider;
	}

	// Get the current step size for the slider.
	function getCurrentStep ( ) {

		// Check all locations, map them to their stepping point.
		// Get the step point, then find it in the input list.
		return scope_Locations.map(function( location, index ){

			var nearbySteps = scope_Spectrum.getNearbySteps( location );
			var value = scope_Values[index];
			var increment = nearbySteps.thisStep.step;
			var decrement = null;

			// If the next value in this step moves into the next step,
			// the increment is the start of the next step - the current value
			if ( increment !== false ) {
				if ( value + increment > nearbySteps.stepAfter.startValue ) {
					increment = nearbySteps.stepAfter.startValue - value;
				}
			}


			// If the value is beyond the starting point
			if ( value > nearbySteps.thisStep.startValue ) {
				decrement = nearbySteps.thisStep.step;
			}

			else if ( nearbySteps.stepBefore.step === false ) {
				decrement = false;
			}

			// If a handle is at the start of a step, it always steps back into the previous step first
			else {
				decrement = value - nearbySteps.stepBefore.highestStep;
			}


			// Now, if at the slider edges, there is not in/decrement
			if ( location === 100 ) {
				increment = null;
			}

			else if ( location === 0 ) {
				decrement = null;
			}

			// As per #391, the comparison for the decrement step can have some rounding issues.
			var stepDecimals = scope_Spectrum.countStepDecimals();

			// Round per #391
			if ( increment !== null && increment !== false ) {
				increment = Number(increment.toFixed(stepDecimals));
			}

			if ( decrement !== null && decrement !== false ) {
				decrement = Number(decrement.toFixed(stepDecimals));
			}

			return [decrement, increment];
		});
	}

	// Attach an event to this slider, possibly including a namespace
	function bindEvent ( namespacedEvent, callback ) {
		scope_Events[namespacedEvent] = scope_Events[namespacedEvent] || [];
		scope_Events[namespacedEvent].push(callback);

		// If the event bound is 'update,' fire it immediately for all handles.
		if ( namespacedEvent.split('.')[0] === 'update' ) {
			scope_Handles.forEach(function(a, index){
				fireEvent('update', index);
			});
		}
	}

	// Undo attachment of event
	function removeEvent ( namespacedEvent ) {

		var event = namespacedEvent && namespacedEvent.split('.')[0];
		var namespace = event && namespacedEvent.substring(event.length);

		Object.keys(scope_Events).forEach(function( bind ){

			var tEvent = bind.split('.')[0],
				tNamespace = bind.substring(tEvent.length);

			if ( (!event || event === tEvent) && (!namespace || namespace === tNamespace) ) {
				delete scope_Events[bind];
			}
		});
	}

	// Updateable: margin, limit, padding, step, range, animate, snap
	function updateOptions ( optionsToUpdate, fireSetEvent ) {

		// Spectrum is created using the range, snap, direction and step options.
		// 'snap' and 'step' can be updated, 'direction' cannot, due to event binding.
		// If 'snap' and 'step' are not passed, they should remain unchanged.
		var v = valueGet();

		var updateAble = ['margin', 'limit', 'padding', 'range', 'animate', 'snap', 'step', 'format'];

		// Only change options that we're actually passed to update.
		updateAble.forEach(function(name){
			if ( optionsToUpdate[name] !== undefined ) {
				originalOptions[name] = optionsToUpdate[name];
			}
		});

		var newOptions = testOptions(originalOptions);

		// Load new options into the slider state
		updateAble.forEach(function(name){
			if ( optionsToUpdate[name] !== undefined ) {
				options[name] = newOptions[name];
			}
		});

		// Save current spectrum direction as testOptions in testRange call
		// doesn't rely on current direction
		newOptions.spectrum.direction = scope_Spectrum.direction;
		scope_Spectrum = newOptions.spectrum;

		// Limit, margin and padding depend on the spectrum but are stored outside of it. (#677)
		options.margin = newOptions.margin;
		options.limit = newOptions.limit;
		options.padding = newOptions.padding;

		// Invalidate the current positioning so valueSet forces an update.
		scope_Locations = [];
		valueSet(optionsToUpdate.start || v, fireSetEvent);
	}

	// Throw an error if the slider was already initialized.
	if ( scope_Target.noUiSlider ) {
		throw new Error("noUiSlider (" + VERSION + "): Slider was already initialized.");
	}

	// Create the base element, initialise HTML and set classes.
	// Add handles and connect elements.
	addSlider(scope_Target);
	addElements(options.connect, scope_Base);

	scope_Self = {
		destroy: destroy,
		steps: getCurrentStep,
		on: bindEvent,
		off: removeEvent,
		get: valueGet,
		set: valueSet,
		reset: valueReset,
		// Exposed for unit testing, don't use this in your application.
		__moveHandles: function(a, b, c) { moveHandles(a, b, scope_Locations, c); },
		options: originalOptions, // Issue #600, #678
		updateOptions: updateOptions,
		target: scope_Target, // Issue #597
		pips: pips // Issue #594
	};

	// Attach user events.
	bindSliderEvents(options.events);

	// Use the public value method to set the start values.
	valueSet(options.start);

	if ( options.pips ) {
		pips(options.pips);
	}

	if ( options.tooltips ) {
		tooltips();
	}

	return scope_Self;

}


	// Run the standard initializer
	function initialize ( target, originalOptions ) {

		if ( !target.nodeName ) {
			throw new Error("noUiSlider (" + VERSION + "): create requires a single element.");
		}

		// Test the options and create the slider environment;
		var options = testOptions( originalOptions, target );
		var api = closure( target, options, originalOptions );

		target.noUiSlider = api;

		return api;
	}

	// Use an object instead of a function for future expansibility;
	return {
		version: VERSION,
		create: initialize
	};

}));

/***/ }),

/***/ "./node_modules/tether/dist/js/tether.js":
/*!***********************************************!*\
  !*** ./node_modules/tether/dist/js/tether.js ***!
  \***********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*! tether 1.4.4 */

(function(root, factory) {
  if (true) {
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else {}
}(this, function() {

'use strict';

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

var TetherBase = undefined;
if (typeof TetherBase === 'undefined') {
  TetherBase = { modules: [] };
}

var zeroElement = null;

// Same as native getBoundingClientRect, except it takes into account parent <frame> offsets
// if the element lies within a nested document (<frame> or <iframe>-like).
function getActualBoundingClientRect(node) {
  var boundingRect = node.getBoundingClientRect();

  // The original object returned by getBoundingClientRect is immutable, so we clone it
  // We can't use extend because the properties are not considered part of the object by hasOwnProperty in IE9
  var rect = {};
  for (var k in boundingRect) {
    rect[k] = boundingRect[k];
  }

  if (node.ownerDocument !== document) {
    var _frameElement = node.ownerDocument.defaultView.frameElement;
    if (_frameElement) {
      var frameRect = getActualBoundingClientRect(_frameElement);
      rect.top += frameRect.top;
      rect.bottom += frameRect.top;
      rect.left += frameRect.left;
      rect.right += frameRect.left;
    }
  }

  return rect;
}

function getScrollParents(el) {
  // In firefox if the el is inside an iframe with display: none; window.getComputedStyle() will return null;
  // https://bugzilla.mozilla.org/show_bug.cgi?id=548397
  var computedStyle = getComputedStyle(el) || {};
  var position = computedStyle.position;
  var parents = [];

  if (position === 'fixed') {
    return [el];
  }

  var parent = el;
  while ((parent = parent.parentNode) && parent && parent.nodeType === 1) {
    var style = undefined;
    try {
      style = getComputedStyle(parent);
    } catch (err) {}

    if (typeof style === 'undefined' || style === null) {
      parents.push(parent);
      return parents;
    }

    var _style = style;
    var overflow = _style.overflow;
    var overflowX = _style.overflowX;
    var overflowY = _style.overflowY;

    if (/(auto|scroll|overlay)/.test(overflow + overflowY + overflowX)) {
      if (position !== 'absolute' || ['relative', 'absolute', 'fixed'].indexOf(style.position) >= 0) {
        parents.push(parent);
      }
    }
  }

  parents.push(el.ownerDocument.body);

  // If the node is within a frame, account for the parent window scroll
  if (el.ownerDocument !== document) {
    parents.push(el.ownerDocument.defaultView);
  }

  return parents;
}

var uniqueId = (function () {
  var id = 0;
  return function () {
    return ++id;
  };
})();

var zeroPosCache = {};
var getOrigin = function getOrigin() {
  // getBoundingClientRect is unfortunately too accurate.  It introduces a pixel or two of
  // jitter as the user scrolls that messes with our ability to detect if two positions
  // are equivilant or not.  We place an element at the top left of the page that will
  // get the same jitter, so we can cancel the two out.
  var node = zeroElement;
  if (!node || !document.body.contains(node)) {
    node = document.createElement('div');
    node.setAttribute('data-tether-id', uniqueId());
    extend(node.style, {
      top: 0,
      left: 0,
      position: 'absolute'
    });

    document.body.appendChild(node);

    zeroElement = node;
  }

  var id = node.getAttribute('data-tether-id');
  if (typeof zeroPosCache[id] === 'undefined') {
    zeroPosCache[id] = getActualBoundingClientRect(node);

    // Clear the cache when this position call is done
    defer(function () {
      delete zeroPosCache[id];
    });
  }

  return zeroPosCache[id];
};

function removeUtilElements() {
  if (zeroElement) {
    document.body.removeChild(zeroElement);
  }
  zeroElement = null;
};

function getBounds(el) {
  var doc = undefined;
  if (el === document) {
    doc = document;
    el = document.documentElement;
  } else {
    doc = el.ownerDocument;
  }

  var docEl = doc.documentElement;

  var box = getActualBoundingClientRect(el);

  var origin = getOrigin();

  box.top -= origin.top;
  box.left -= origin.left;

  if (typeof box.width === 'undefined') {
    box.width = document.body.scrollWidth - box.left - box.right;
  }
  if (typeof box.height === 'undefined') {
    box.height = document.body.scrollHeight - box.top - box.bottom;
  }

  box.top = box.top - docEl.clientTop;
  box.left = box.left - docEl.clientLeft;
  box.right = doc.body.clientWidth - box.width - box.left;
  box.bottom = doc.body.clientHeight - box.height - box.top;

  return box;
}

function getOffsetParent(el) {
  return el.offsetParent || document.documentElement;
}

var _scrollBarSize = null;
function getScrollBarSize() {
  if (_scrollBarSize) {
    return _scrollBarSize;
  }
  var inner = document.createElement('div');
  inner.style.width = '100%';
  inner.style.height = '200px';

  var outer = document.createElement('div');
  extend(outer.style, {
    position: 'absolute',
    top: 0,
    left: 0,
    pointerEvents: 'none',
    visibility: 'hidden',
    width: '200px',
    height: '150px',
    overflow: 'hidden'
  });

  outer.appendChild(inner);

  document.body.appendChild(outer);

  var widthContained = inner.offsetWidth;
  outer.style.overflow = 'scroll';
  var widthScroll = inner.offsetWidth;

  if (widthContained === widthScroll) {
    widthScroll = outer.clientWidth;
  }

  document.body.removeChild(outer);

  var width = widthContained - widthScroll;

  _scrollBarSize = { width: width, height: width };
  return _scrollBarSize;
}

function extend() {
  var out = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];

  var args = [];

  Array.prototype.push.apply(args, arguments);

  args.slice(1).forEach(function (obj) {
    if (obj) {
      for (var key in obj) {
        if (({}).hasOwnProperty.call(obj, key)) {
          out[key] = obj[key];
        }
      }
    }
  });

  return out;
}

function removeClass(el, name) {
  if (typeof el.classList !== 'undefined') {
    name.split(' ').forEach(function (cls) {
      if (cls.trim()) {
        el.classList.remove(cls);
      }
    });
  } else {
    var regex = new RegExp('(^| )' + name.split(' ').join('|') + '( |$)', 'gi');
    var className = getClassName(el).replace(regex, ' ');
    setClassName(el, className);
  }
}

function addClass(el, name) {
  if (typeof el.classList !== 'undefined') {
    name.split(' ').forEach(function (cls) {
      if (cls.trim()) {
        el.classList.add(cls);
      }
    });
  } else {
    removeClass(el, name);
    var cls = getClassName(el) + (' ' + name);
    setClassName(el, cls);
  }
}

function hasClass(el, name) {
  if (typeof el.classList !== 'undefined') {
    return el.classList.contains(name);
  }
  var className = getClassName(el);
  return new RegExp('(^| )' + name + '( |$)', 'gi').test(className);
}

function getClassName(el) {
  // Can't use just SVGAnimatedString here since nodes within a Frame in IE have
  // completely separately SVGAnimatedString base classes
  if (el.className instanceof el.ownerDocument.defaultView.SVGAnimatedString) {
    return el.className.baseVal;
  }
  return el.className;
}

function setClassName(el, className) {
  el.setAttribute('class', className);
}

function updateClasses(el, add, all) {
  // Of the set of 'all' classes, we need the 'add' classes, and only the
  // 'add' classes to be set.
  all.forEach(function (cls) {
    if (add.indexOf(cls) === -1 && hasClass(el, cls)) {
      removeClass(el, cls);
    }
  });

  add.forEach(function (cls) {
    if (!hasClass(el, cls)) {
      addClass(el, cls);
    }
  });
}

var deferred = [];

var defer = function defer(fn) {
  deferred.push(fn);
};

var flush = function flush() {
  var fn = undefined;
  while (fn = deferred.pop()) {
    fn();
  }
};

var Evented = (function () {
  function Evented() {
    _classCallCheck(this, Evented);
  }

  _createClass(Evented, [{
    key: 'on',
    value: function on(event, handler, ctx) {
      var once = arguments.length <= 3 || arguments[3] === undefined ? false : arguments[3];

      if (typeof this.bindings === 'undefined') {
        this.bindings = {};
      }
      if (typeof this.bindings[event] === 'undefined') {
        this.bindings[event] = [];
      }
      this.bindings[event].push({ handler: handler, ctx: ctx, once: once });
    }
  }, {
    key: 'once',
    value: function once(event, handler, ctx) {
      this.on(event, handler, ctx, true);
    }
  }, {
    key: 'off',
    value: function off(event, handler) {
      if (typeof this.bindings === 'undefined' || typeof this.bindings[event] === 'undefined') {
        return;
      }

      if (typeof handler === 'undefined') {
        delete this.bindings[event];
      } else {
        var i = 0;
        while (i < this.bindings[event].length) {
          if (this.bindings[event][i].handler === handler) {
            this.bindings[event].splice(i, 1);
          } else {
            ++i;
          }
        }
      }
    }
  }, {
    key: 'trigger',
    value: function trigger(event) {
      if (typeof this.bindings !== 'undefined' && this.bindings[event]) {
        var i = 0;

        for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
          args[_key - 1] = arguments[_key];
        }

        while (i < this.bindings[event].length) {
          var _bindings$event$i = this.bindings[event][i];
          var handler = _bindings$event$i.handler;
          var ctx = _bindings$event$i.ctx;
          var once = _bindings$event$i.once;

          var context = ctx;
          if (typeof context === 'undefined') {
            context = this;
          }

          handler.apply(context, args);

          if (once) {
            this.bindings[event].splice(i, 1);
          } else {
            ++i;
          }
        }
      }
    }
  }]);

  return Evented;
})();

TetherBase.Utils = {
  getActualBoundingClientRect: getActualBoundingClientRect,
  getScrollParents: getScrollParents,
  getBounds: getBounds,
  getOffsetParent: getOffsetParent,
  extend: extend,
  addClass: addClass,
  removeClass: removeClass,
  hasClass: hasClass,
  updateClasses: updateClasses,
  defer: defer,
  flush: flush,
  uniqueId: uniqueId,
  Evented: Evented,
  getScrollBarSize: getScrollBarSize,
  removeUtilElements: removeUtilElements
};
/* globals TetherBase, performance */

'use strict';

var _slicedToArray = (function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i['return']) _i['return'](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError('Invalid attempt to destructure non-iterable instance'); } }; })();

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x6, _x7, _x8) { var _again = true; _function: while (_again) { var object = _x6, property = _x7, receiver = _x8; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x6 = parent; _x7 = property; _x8 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

if (typeof TetherBase === 'undefined') {
  throw new Error('You must include the utils.js file before tether.js');
}

var _TetherBase$Utils = TetherBase.Utils;
var getScrollParents = _TetherBase$Utils.getScrollParents;
var getBounds = _TetherBase$Utils.getBounds;
var getOffsetParent = _TetherBase$Utils.getOffsetParent;
var extend = _TetherBase$Utils.extend;
var addClass = _TetherBase$Utils.addClass;
var removeClass = _TetherBase$Utils.removeClass;
var updateClasses = _TetherBase$Utils.updateClasses;
var defer = _TetherBase$Utils.defer;
var flush = _TetherBase$Utils.flush;
var getScrollBarSize = _TetherBase$Utils.getScrollBarSize;
var removeUtilElements = _TetherBase$Utils.removeUtilElements;

function within(a, b) {
  var diff = arguments.length <= 2 || arguments[2] === undefined ? 1 : arguments[2];

  return a + diff >= b && b >= a - diff;
}

var transformKey = (function () {
  if (typeof document === 'undefined') {
    return '';
  }
  var el = document.createElement('div');

  var transforms = ['transform', 'WebkitTransform', 'OTransform', 'MozTransform', 'msTransform'];
  for (var i = 0; i < transforms.length; ++i) {
    var key = transforms[i];
    if (el.style[key] !== undefined) {
      return key;
    }
  }
})();

var tethers = [];

var position = function position() {
  tethers.forEach(function (tether) {
    tether.position(false);
  });
  flush();
};

function now() {
  if (typeof performance === 'object' && typeof performance.now === 'function') {
    return performance.now();
  }
  return +new Date();
}

(function () {
  var lastCall = null;
  var lastDuration = null;
  var pendingTimeout = null;

  var tick = function tick() {
    if (typeof lastDuration !== 'undefined' && lastDuration > 16) {
      // We voluntarily throttle ourselves if we can't manage 60fps
      lastDuration = Math.min(lastDuration - 16, 250);

      // Just in case this is the last event, remember to position just once more
      pendingTimeout = setTimeout(tick, 250);
      return;
    }

    if (typeof lastCall !== 'undefined' && now() - lastCall < 10) {
      // Some browsers call events a little too frequently, refuse to run more than is reasonable
      return;
    }

    if (pendingTimeout != null) {
      clearTimeout(pendingTimeout);
      pendingTimeout = null;
    }

    lastCall = now();
    position();
    lastDuration = now() - lastCall;
  };

  if (typeof window !== 'undefined' && typeof window.addEventListener !== 'undefined') {
    ['resize', 'scroll', 'touchmove'].forEach(function (event) {
      window.addEventListener(event, tick);
    });
  }
})();

var MIRROR_LR = {
  center: 'center',
  left: 'right',
  right: 'left'
};

var MIRROR_TB = {
  middle: 'middle',
  top: 'bottom',
  bottom: 'top'
};

var OFFSET_MAP = {
  top: 0,
  left: 0,
  middle: '50%',
  center: '50%',
  bottom: '100%',
  right: '100%'
};

var autoToFixedAttachment = function autoToFixedAttachment(attachment, relativeToAttachment) {
  var left = attachment.left;
  var top = attachment.top;

  if (left === 'auto') {
    left = MIRROR_LR[relativeToAttachment.left];
  }

  if (top === 'auto') {
    top = MIRROR_TB[relativeToAttachment.top];
  }

  return { left: left, top: top };
};

var attachmentToOffset = function attachmentToOffset(attachment) {
  var left = attachment.left;
  var top = attachment.top;

  if (typeof OFFSET_MAP[attachment.left] !== 'undefined') {
    left = OFFSET_MAP[attachment.left];
  }

  if (typeof OFFSET_MAP[attachment.top] !== 'undefined') {
    top = OFFSET_MAP[attachment.top];
  }

  return { left: left, top: top };
};

function addOffset() {
  var out = { top: 0, left: 0 };

  for (var _len = arguments.length, offsets = Array(_len), _key = 0; _key < _len; _key++) {
    offsets[_key] = arguments[_key];
  }

  offsets.forEach(function (_ref) {
    var top = _ref.top;
    var left = _ref.left;

    if (typeof top === 'string') {
      top = parseFloat(top, 10);
    }
    if (typeof left === 'string') {
      left = parseFloat(left, 10);
    }

    out.top += top;
    out.left += left;
  });

  return out;
}

function offsetToPx(offset, size) {
  if (typeof offset.left === 'string' && offset.left.indexOf('%') !== -1) {
    offset.left = parseFloat(offset.left, 10) / 100 * size.width;
  }
  if (typeof offset.top === 'string' && offset.top.indexOf('%') !== -1) {
    offset.top = parseFloat(offset.top, 10) / 100 * size.height;
  }

  return offset;
}

var parseOffset = function parseOffset(value) {
  var _value$split = value.split(' ');

  var _value$split2 = _slicedToArray(_value$split, 2);

  var top = _value$split2[0];
  var left = _value$split2[1];

  return { top: top, left: left };
};
var parseAttachment = parseOffset;

var TetherClass = (function (_Evented) {
  _inherits(TetherClass, _Evented);

  function TetherClass(options) {
    var _this = this;

    _classCallCheck(this, TetherClass);

    _get(Object.getPrototypeOf(TetherClass.prototype), 'constructor', this).call(this);
    this.position = this.position.bind(this);

    tethers.push(this);

    this.history = [];

    this.setOptions(options, false);

    TetherBase.modules.forEach(function (module) {
      if (typeof module.initialize !== 'undefined') {
        module.initialize.call(_this);
      }
    });

    this.position();
  }

  _createClass(TetherClass, [{
    key: 'getClass',
    value: function getClass() {
      var key = arguments.length <= 0 || arguments[0] === undefined ? '' : arguments[0];
      var classes = this.options.classes;

      if (typeof classes !== 'undefined' && classes[key]) {
        return this.options.classes[key];
      } else if (this.options.classPrefix) {
        return this.options.classPrefix + '-' + key;
      } else {
        return key;
      }
    }
  }, {
    key: 'setOptions',
    value: function setOptions(options) {
      var _this2 = this;

      var pos = arguments.length <= 1 || arguments[1] === undefined ? true : arguments[1];

      var defaults = {
        offset: '0 0',
        targetOffset: '0 0',
        targetAttachment: 'auto auto',
        classPrefix: 'tether'
      };

      this.options = extend(defaults, options);

      var _options = this.options;
      var element = _options.element;
      var target = _options.target;
      var targetModifier = _options.targetModifier;

      this.element = element;
      this.target = target;
      this.targetModifier = targetModifier;

      if (this.target === 'viewport') {
        this.target = document.body;
        this.targetModifier = 'visible';
      } else if (this.target === 'scroll-handle') {
        this.target = document.body;
        this.targetModifier = 'scroll-handle';
      }

      ['element', 'target'].forEach(function (key) {
        if (typeof _this2[key] === 'undefined') {
          throw new Error('Tether Error: Both element and target must be defined');
        }

        if (typeof _this2[key].jquery !== 'undefined') {
          _this2[key] = _this2[key][0];
        } else if (typeof _this2[key] === 'string') {
          _this2[key] = document.querySelector(_this2[key]);
        }
      });

      addClass(this.element, this.getClass('element'));
      if (!(this.options.addTargetClasses === false)) {
        addClass(this.target, this.getClass('target'));
      }

      if (!this.options.attachment) {
        throw new Error('Tether Error: You must provide an attachment');
      }

      this.targetAttachment = parseAttachment(this.options.targetAttachment);
      this.attachment = parseAttachment(this.options.attachment);
      this.offset = parseOffset(this.options.offset);
      this.targetOffset = parseOffset(this.options.targetOffset);

      if (typeof this.scrollParents !== 'undefined') {
        this.disable();
      }

      if (this.targetModifier === 'scroll-handle') {
        this.scrollParents = [this.target];
      } else {
        this.scrollParents = getScrollParents(this.target);
      }

      if (!(this.options.enabled === false)) {
        this.enable(pos);
      }
    }
  }, {
    key: 'getTargetBounds',
    value: function getTargetBounds() {
      if (typeof this.targetModifier !== 'undefined') {
        if (this.targetModifier === 'visible') {
          if (this.target === document.body) {
            return { top: pageYOffset, left: pageXOffset, height: innerHeight, width: innerWidth };
          } else {
            var bounds = getBounds(this.target);

            var out = {
              height: bounds.height,
              width: bounds.width,
              top: bounds.top,
              left: bounds.left
            };

            out.height = Math.min(out.height, bounds.height - (pageYOffset - bounds.top));
            out.height = Math.min(out.height, bounds.height - (bounds.top + bounds.height - (pageYOffset + innerHeight)));
            out.height = Math.min(innerHeight, out.height);
            out.height -= 2;

            out.width = Math.min(out.width, bounds.width - (pageXOffset - bounds.left));
            out.width = Math.min(out.width, bounds.width - (bounds.left + bounds.width - (pageXOffset + innerWidth)));
            out.width = Math.min(innerWidth, out.width);
            out.width -= 2;

            if (out.top < pageYOffset) {
              out.top = pageYOffset;
            }
            if (out.left < pageXOffset) {
              out.left = pageXOffset;
            }

            return out;
          }
        } else if (this.targetModifier === 'scroll-handle') {
          var bounds = undefined;
          var target = this.target;
          if (target === document.body) {
            target = document.documentElement;

            bounds = {
              left: pageXOffset,
              top: pageYOffset,
              height: innerHeight,
              width: innerWidth
            };
          } else {
            bounds = getBounds(target);
          }

          var style = getComputedStyle(target);

          var hasBottomScroll = target.scrollWidth > target.clientWidth || [style.overflow, style.overflowX].indexOf('scroll') >= 0 || this.target !== document.body;

          var scrollBottom = 0;
          if (hasBottomScroll) {
            scrollBottom = 15;
          }

          var height = bounds.height - parseFloat(style.borderTopWidth) - parseFloat(style.borderBottomWidth) - scrollBottom;

          var out = {
            width: 15,
            height: height * 0.975 * (height / target.scrollHeight),
            left: bounds.left + bounds.width - parseFloat(style.borderLeftWidth) - 15
          };

          var fitAdj = 0;
          if (height < 408 && this.target === document.body) {
            fitAdj = -0.00011 * Math.pow(height, 2) - 0.00727 * height + 22.58;
          }

          if (this.target !== document.body) {
            out.height = Math.max(out.height, 24);
          }

          var scrollPercentage = this.target.scrollTop / (target.scrollHeight - height);
          out.top = scrollPercentage * (height - out.height - fitAdj) + bounds.top + parseFloat(style.borderTopWidth);

          if (this.target === document.body) {
            out.height = Math.max(out.height, 24);
          }

          return out;
        }
      } else {
        return getBounds(this.target);
      }
    }
  }, {
    key: 'clearCache',
    value: function clearCache() {
      this._cache = {};
    }
  }, {
    key: 'cache',
    value: function cache(k, getter) {
      // More than one module will often need the same DOM info, so
      // we keep a cache which is cleared on each position call
      if (typeof this._cache === 'undefined') {
        this._cache = {};
      }

      if (typeof this._cache[k] === 'undefined') {
        this._cache[k] = getter.call(this);
      }

      return this._cache[k];
    }
  }, {
    key: 'enable',
    value: function enable() {
      var _this3 = this;

      var pos = arguments.length <= 0 || arguments[0] === undefined ? true : arguments[0];

      if (!(this.options.addTargetClasses === false)) {
        addClass(this.target, this.getClass('enabled'));
      }
      addClass(this.element, this.getClass('enabled'));
      this.enabled = true;

      this.scrollParents.forEach(function (parent) {
        if (parent !== _this3.target.ownerDocument) {
          parent.addEventListener('scroll', _this3.position);
        }
      });

      if (pos) {
        this.position();
      }
    }
  }, {
    key: 'disable',
    value: function disable() {
      var _this4 = this;

      removeClass(this.target, this.getClass('enabled'));
      removeClass(this.element, this.getClass('enabled'));
      this.enabled = false;

      if (typeof this.scrollParents !== 'undefined') {
        this.scrollParents.forEach(function (parent) {
          parent.removeEventListener('scroll', _this4.position);
        });
      }
    }
  }, {
    key: 'destroy',
    value: function destroy() {
      var _this5 = this;

      this.disable();

      tethers.forEach(function (tether, i) {
        if (tether === _this5) {
          tethers.splice(i, 1);
        }
      });

      // Remove any elements we were using for convenience from the DOM
      if (tethers.length === 0) {
        removeUtilElements();
      }
    }
  }, {
    key: 'updateAttachClasses',
    value: function updateAttachClasses(elementAttach, targetAttach) {
      var _this6 = this;

      elementAttach = elementAttach || this.attachment;
      targetAttach = targetAttach || this.targetAttachment;
      var sides = ['left', 'top', 'bottom', 'right', 'middle', 'center'];

      if (typeof this._addAttachClasses !== 'undefined' && this._addAttachClasses.length) {
        // updateAttachClasses can be called more than once in a position call, so
        // we need to clean up after ourselves such that when the last defer gets
        // ran it doesn't add any extra classes from previous calls.
        this._addAttachClasses.splice(0, this._addAttachClasses.length);
      }

      if (typeof this._addAttachClasses === 'undefined') {
        this._addAttachClasses = [];
      }
      var add = this._addAttachClasses;

      if (elementAttach.top) {
        add.push(this.getClass('element-attached') + '-' + elementAttach.top);
      }
      if (elementAttach.left) {
        add.push(this.getClass('element-attached') + '-' + elementAttach.left);
      }
      if (targetAttach.top) {
        add.push(this.getClass('target-attached') + '-' + targetAttach.top);
      }
      if (targetAttach.left) {
        add.push(this.getClass('target-attached') + '-' + targetAttach.left);
      }

      var all = [];
      sides.forEach(function (side) {
        all.push(_this6.getClass('element-attached') + '-' + side);
        all.push(_this6.getClass('target-attached') + '-' + side);
      });

      defer(function () {
        if (!(typeof _this6._addAttachClasses !== 'undefined')) {
          return;
        }

        updateClasses(_this6.element, _this6._addAttachClasses, all);
        if (!(_this6.options.addTargetClasses === false)) {
          updateClasses(_this6.target, _this6._addAttachClasses, all);
        }

        delete _this6._addAttachClasses;
      });
    }
  }, {
    key: 'position',
    value: function position() {
      var _this7 = this;

      var flushChanges = arguments.length <= 0 || arguments[0] === undefined ? true : arguments[0];

      // flushChanges commits the changes immediately, leave true unless you are positioning multiple
      // tethers (in which case call Tether.Utils.flush yourself when you're done)

      if (!this.enabled) {
        return;
      }

      this.clearCache();

      // Turn 'auto' attachments into the appropriate corner or edge
      var targetAttachment = autoToFixedAttachment(this.targetAttachment, this.attachment);

      this.updateAttachClasses(this.attachment, targetAttachment);

      var elementPos = this.cache('element-bounds', function () {
        return getBounds(_this7.element);
      });

      var width = elementPos.width;
      var height = elementPos.height;

      if (width === 0 && height === 0 && typeof this.lastSize !== 'undefined') {
        var _lastSize = this.lastSize;

        // We cache the height and width to make it possible to position elements that are
        // getting hidden.
        width = _lastSize.width;
        height = _lastSize.height;
      } else {
        this.lastSize = { width: width, height: height };
      }

      var targetPos = this.cache('target-bounds', function () {
        return _this7.getTargetBounds();
      });
      var targetSize = targetPos;

      // Get an actual px offset from the attachment
      var offset = offsetToPx(attachmentToOffset(this.attachment), { width: width, height: height });
      var targetOffset = offsetToPx(attachmentToOffset(targetAttachment), targetSize);

      var manualOffset = offsetToPx(this.offset, { width: width, height: height });
      var manualTargetOffset = offsetToPx(this.targetOffset, targetSize);

      // Add the manually provided offset
      offset = addOffset(offset, manualOffset);
      targetOffset = addOffset(targetOffset, manualTargetOffset);

      // It's now our goal to make (element position + offset) == (target position + target offset)
      var left = targetPos.left + targetOffset.left - offset.left;
      var top = targetPos.top + targetOffset.top - offset.top;

      for (var i = 0; i < TetherBase.modules.length; ++i) {
        var _module2 = TetherBase.modules[i];
        var ret = _module2.position.call(this, {
          left: left,
          top: top,
          targetAttachment: targetAttachment,
          targetPos: targetPos,
          elementPos: elementPos,
          offset: offset,
          targetOffset: targetOffset,
          manualOffset: manualOffset,
          manualTargetOffset: manualTargetOffset,
          scrollbarSize: scrollbarSize,
          attachment: this.attachment
        });

        if (ret === false) {
          return false;
        } else if (typeof ret === 'undefined' || typeof ret !== 'object') {
          continue;
        } else {
          top = ret.top;
          left = ret.left;
        }
      }

      // We describe the position three different ways to give the optimizer
      // a chance to decide the best possible way to position the element
      // with the fewest repaints.
      var next = {
        // It's position relative to the page (absolute positioning when
        // the element is a child of the body)
        page: {
          top: top,
          left: left
        },

        // It's position relative to the viewport (fixed positioning)
        viewport: {
          top: top - pageYOffset,
          bottom: pageYOffset - top - height + innerHeight,
          left: left - pageXOffset,
          right: pageXOffset - left - width + innerWidth
        }
      };

      var doc = this.target.ownerDocument;
      var win = doc.defaultView;

      var scrollbarSize = undefined;
      if (win.innerHeight > doc.documentElement.clientHeight) {
        scrollbarSize = this.cache('scrollbar-size', getScrollBarSize);
        next.viewport.bottom -= scrollbarSize.height;
      }

      if (win.innerWidth > doc.documentElement.clientWidth) {
        scrollbarSize = this.cache('scrollbar-size', getScrollBarSize);
        next.viewport.right -= scrollbarSize.width;
      }

      if (['', 'static'].indexOf(doc.body.style.position) === -1 || ['', 'static'].indexOf(doc.body.parentElement.style.position) === -1) {
        // Absolute positioning in the body will be relative to the page, not the 'initial containing block'
        next.page.bottom = doc.body.scrollHeight - top - height;
        next.page.right = doc.body.scrollWidth - left - width;
      }

      if (typeof this.options.optimizations !== 'undefined' && this.options.optimizations.moveElement !== false && !(typeof this.targetModifier !== 'undefined')) {
        (function () {
          var offsetParent = _this7.cache('target-offsetparent', function () {
            return getOffsetParent(_this7.target);
          });
          var offsetPosition = _this7.cache('target-offsetparent-bounds', function () {
            return getBounds(offsetParent);
          });
          var offsetParentStyle = getComputedStyle(offsetParent);
          var offsetParentSize = offsetPosition;

          var offsetBorder = {};
          ['Top', 'Left', 'Bottom', 'Right'].forEach(function (side) {
            offsetBorder[side.toLowerCase()] = parseFloat(offsetParentStyle['border' + side + 'Width']);
          });

          offsetPosition.right = doc.body.scrollWidth - offsetPosition.left - offsetParentSize.width + offsetBorder.right;
          offsetPosition.bottom = doc.body.scrollHeight - offsetPosition.top - offsetParentSize.height + offsetBorder.bottom;

          if (next.page.top >= offsetPosition.top + offsetBorder.top && next.page.bottom >= offsetPosition.bottom) {
            if (next.page.left >= offsetPosition.left + offsetBorder.left && next.page.right >= offsetPosition.right) {
              // We're within the visible part of the target's scroll parent
              var scrollTop = offsetParent.scrollTop;
              var scrollLeft = offsetParent.scrollLeft;

              // It's position relative to the target's offset parent (absolute positioning when
              // the element is moved to be a child of the target's offset parent).
              next.offset = {
                top: next.page.top - offsetPosition.top + scrollTop - offsetBorder.top,
                left: next.page.left - offsetPosition.left + scrollLeft - offsetBorder.left
              };
            }
          }
        })();
      }

      // We could also travel up the DOM and try each containing context, rather than only
      // looking at the body, but we're gonna get diminishing returns.

      this.move(next);

      this.history.unshift(next);

      if (this.history.length > 3) {
        this.history.pop();
      }

      if (flushChanges) {
        flush();
      }

      return true;
    }

    // THE ISSUE
  }, {
    key: 'move',
    value: function move(pos) {
      var _this8 = this;

      if (!(typeof this.element.parentNode !== 'undefined')) {
        return;
      }

      var same = {};

      for (var type in pos) {
        same[type] = {};

        for (var key in pos[type]) {
          var found = false;

          for (var i = 0; i < this.history.length; ++i) {
            var point = this.history[i];
            if (typeof point[type] !== 'undefined' && !within(point[type][key], pos[type][key])) {
              found = true;
              break;
            }
          }

          if (!found) {
            same[type][key] = true;
          }
        }
      }

      var css = { top: '', left: '', right: '', bottom: '' };

      var transcribe = function transcribe(_same, _pos) {
        var hasOptimizations = typeof _this8.options.optimizations !== 'undefined';
        var gpu = hasOptimizations ? _this8.options.optimizations.gpu : null;
        if (gpu !== false) {
          var yPos = undefined,
              xPos = undefined;
          if (_same.top) {
            css.top = 0;
            yPos = _pos.top;
          } else {
            css.bottom = 0;
            yPos = -_pos.bottom;
          }

          if (_same.left) {
            css.left = 0;
            xPos = _pos.left;
          } else {
            css.right = 0;
            xPos = -_pos.right;
          }

          if (window.matchMedia) {
            // HubSpot/tether#207
            var retina = window.matchMedia('only screen and (min-resolution: 1.3dppx)').matches || window.matchMedia('only screen and (-webkit-min-device-pixel-ratio: 1.3)').matches;
            if (!retina) {
              xPos = Math.round(xPos);
              yPos = Math.round(yPos);
            }
          }

          css[transformKey] = 'translateX(' + xPos + 'px) translateY(' + yPos + 'px)';

          if (transformKey !== 'msTransform') {
            // The Z transform will keep this in the GPU (faster, and prevents artifacts),
            // but IE9 doesn't support 3d transforms and will choke.
            css[transformKey] += " translateZ(0)";
          }
        } else {
          if (_same.top) {
            css.top = _pos.top + 'px';
          } else {
            css.bottom = _pos.bottom + 'px';
          }

          if (_same.left) {
            css.left = _pos.left + 'px';
          } else {
            css.right = _pos.right + 'px';
          }
        }
      };

      var moved = false;
      if ((same.page.top || same.page.bottom) && (same.page.left || same.page.right)) {
        css.position = 'absolute';
        transcribe(same.page, pos.page);
      } else if ((same.viewport.top || same.viewport.bottom) && (same.viewport.left || same.viewport.right)) {
        css.position = 'fixed';
        transcribe(same.viewport, pos.viewport);
      } else if (typeof same.offset !== 'undefined' && same.offset.top && same.offset.left) {
        (function () {
          css.position = 'absolute';
          var offsetParent = _this8.cache('target-offsetparent', function () {
            return getOffsetParent(_this8.target);
          });

          if (getOffsetParent(_this8.element) !== offsetParent) {
            defer(function () {
              _this8.element.parentNode.removeChild(_this8.element);
              offsetParent.appendChild(_this8.element);
            });
          }

          transcribe(same.offset, pos.offset);
          moved = true;
        })();
      } else {
        css.position = 'absolute';
        transcribe({ top: true, left: true }, pos.page);
      }

      if (!moved) {
        if (this.options.bodyElement) {
          if (this.element.parentNode !== this.options.bodyElement) {
            this.options.bodyElement.appendChild(this.element);
          }
        } else {
          var offsetParentIsBody = true;
          var currentNode = this.element.parentNode;
          while (currentNode && currentNode.nodeType === 1 && currentNode.tagName !== 'BODY') {
            if (getComputedStyle(currentNode).position !== 'static') {
              offsetParentIsBody = false;
              break;
            }

            currentNode = currentNode.parentNode;
          }

          if (!offsetParentIsBody) {
            this.element.parentNode.removeChild(this.element);
            this.element.ownerDocument.body.appendChild(this.element);
          }
        }
      }

      // Any css change will trigger a repaint, so let's avoid one if nothing changed
      var writeCSS = {};
      var write = false;
      for (var key in css) {
        var val = css[key];
        var elVal = this.element.style[key];

        if (elVal !== val) {
          write = true;
          writeCSS[key] = val;
        }
      }

      if (write) {
        defer(function () {
          extend(_this8.element.style, writeCSS);
          _this8.trigger('repositioned');
        });
      }
    }
  }]);

  return TetherClass;
})(Evented);

TetherClass.modules = [];

TetherBase.position = position;

var Tether = extend(TetherClass, TetherBase);
/* globals TetherBase */

'use strict';

var _slicedToArray = (function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i['return']) _i['return'](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError('Invalid attempt to destructure non-iterable instance'); } }; })();

var _TetherBase$Utils = TetherBase.Utils;
var getBounds = _TetherBase$Utils.getBounds;
var extend = _TetherBase$Utils.extend;
var updateClasses = _TetherBase$Utils.updateClasses;
var defer = _TetherBase$Utils.defer;

var BOUNDS_FORMAT = ['left', 'top', 'right', 'bottom'];

function getBoundingRect(tether, to) {
  if (to === 'scrollParent') {
    to = tether.scrollParents[0];
  } else if (to === 'window') {
    to = [pageXOffset, pageYOffset, innerWidth + pageXOffset, innerHeight + pageYOffset];
  }

  if (to === document) {
    to = to.documentElement;
  }

  if (typeof to.nodeType !== 'undefined') {
    (function () {
      var node = to;
      var size = getBounds(to);
      var pos = size;
      var style = getComputedStyle(to);

      to = [pos.left, pos.top, size.width + pos.left, size.height + pos.top];

      // Account any parent Frames scroll offset
      if (node.ownerDocument !== document) {
        var win = node.ownerDocument.defaultView;
        to[0] += win.pageXOffset;
        to[1] += win.pageYOffset;
        to[2] += win.pageXOffset;
        to[3] += win.pageYOffset;
      }

      BOUNDS_FORMAT.forEach(function (side, i) {
        side = side[0].toUpperCase() + side.substr(1);
        if (side === 'Top' || side === 'Left') {
          to[i] += parseFloat(style['border' + side + 'Width']);
        } else {
          to[i] -= parseFloat(style['border' + side + 'Width']);
        }
      });
    })();
  }

  return to;
}

TetherBase.modules.push({
  position: function position(_ref) {
    var _this = this;

    var top = _ref.top;
    var left = _ref.left;
    var targetAttachment = _ref.targetAttachment;

    if (!this.options.constraints) {
      return true;
    }

    var _cache = this.cache('element-bounds', function () {
      return getBounds(_this.element);
    });

    var height = _cache.height;
    var width = _cache.width;

    if (width === 0 && height === 0 && typeof this.lastSize !== 'undefined') {
      var _lastSize = this.lastSize;

      // Handle the item getting hidden as a result of our positioning without glitching
      // the classes in and out
      width = _lastSize.width;
      height = _lastSize.height;
    }

    var targetSize = this.cache('target-bounds', function () {
      return _this.getTargetBounds();
    });

    var targetHeight = targetSize.height;
    var targetWidth = targetSize.width;

    var allClasses = [this.getClass('pinned'), this.getClass('out-of-bounds')];

    this.options.constraints.forEach(function (constraint) {
      var outOfBoundsClass = constraint.outOfBoundsClass;
      var pinnedClass = constraint.pinnedClass;

      if (outOfBoundsClass) {
        allClasses.push(outOfBoundsClass);
      }
      if (pinnedClass) {
        allClasses.push(pinnedClass);
      }
    });

    allClasses.forEach(function (cls) {
      ['left', 'top', 'right', 'bottom'].forEach(function (side) {
        allClasses.push(cls + '-' + side);
      });
    });

    var addClasses = [];

    var tAttachment = extend({}, targetAttachment);
    var eAttachment = extend({}, this.attachment);

    this.options.constraints.forEach(function (constraint) {
      var to = constraint.to;
      var attachment = constraint.attachment;
      var pin = constraint.pin;

      if (typeof attachment === 'undefined') {
        attachment = '';
      }

      var changeAttachX = undefined,
          changeAttachY = undefined;
      if (attachment.indexOf(' ') >= 0) {
        var _attachment$split = attachment.split(' ');

        var _attachment$split2 = _slicedToArray(_attachment$split, 2);

        changeAttachY = _attachment$split2[0];
        changeAttachX = _attachment$split2[1];
      } else {
        changeAttachX = changeAttachY = attachment;
      }

      var bounds = getBoundingRect(_this, to);

      if (changeAttachY === 'target' || changeAttachY === 'both') {
        if (top < bounds[1] && tAttachment.top === 'top') {
          top += targetHeight;
          tAttachment.top = 'bottom';
        }

        if (top + height > bounds[3] && tAttachment.top === 'bottom') {
          top -= targetHeight;
          tAttachment.top = 'top';
        }
      }

      if (changeAttachY === 'together') {
        if (tAttachment.top === 'top') {
          if (eAttachment.top === 'bottom' && top < bounds[1]) {
            top += targetHeight;
            tAttachment.top = 'bottom';

            top += height;
            eAttachment.top = 'top';
          } else if (eAttachment.top === 'top' && top + height > bounds[3] && top - (height - targetHeight) >= bounds[1]) {
            top -= height - targetHeight;
            tAttachment.top = 'bottom';

            eAttachment.top = 'bottom';
          }
        }

        if (tAttachment.top === 'bottom') {
          if (eAttachment.top === 'top' && top + height > bounds[3]) {
            top -= targetHeight;
            tAttachment.top = 'top';

            top -= height;
            eAttachment.top = 'bottom';
          } else if (eAttachment.top === 'bottom' && top < bounds[1] && top + (height * 2 - targetHeight) <= bounds[3]) {
            top += height - targetHeight;
            tAttachment.top = 'top';

            eAttachment.top = 'top';
          }
        }

        if (tAttachment.top === 'middle') {
          if (top + height > bounds[3] && eAttachment.top === 'top') {
            top -= height;
            eAttachment.top = 'bottom';
          } else if (top < bounds[1] && eAttachment.top === 'bottom') {
            top += height;
            eAttachment.top = 'top';
          }
        }
      }

      if (changeAttachX === 'target' || changeAttachX === 'both') {
        if (left < bounds[0] && tAttachment.left === 'left') {
          left += targetWidth;
          tAttachment.left = 'right';
        }

        if (left + width > bounds[2] && tAttachment.left === 'right') {
          left -= targetWidth;
          tAttachment.left = 'left';
        }
      }

      if (changeAttachX === 'together') {
        if (left < bounds[0] && tAttachment.left === 'left') {
          if (eAttachment.left === 'right') {
            left += targetWidth;
            tAttachment.left = 'right';

            left += width;
            eAttachment.left = 'left';
          } else if (eAttachment.left === 'left') {
            left += targetWidth;
            tAttachment.left = 'right';

            left -= width;
            eAttachment.left = 'right';
          }
        } else if (left + width > bounds[2] && tAttachment.left === 'right') {
          if (eAttachment.left === 'left') {
            left -= targetWidth;
            tAttachment.left = 'left';

            left -= width;
            eAttachment.left = 'right';
          } else if (eAttachment.left === 'right') {
            left -= targetWidth;
            tAttachment.left = 'left';

            left += width;
            eAttachment.left = 'left';
          }
        } else if (tAttachment.left === 'center') {
          if (left + width > bounds[2] && eAttachment.left === 'left') {
            left -= width;
            eAttachment.left = 'right';
          } else if (left < bounds[0] && eAttachment.left === 'right') {
            left += width;
            eAttachment.left = 'left';
          }
        }
      }

      if (changeAttachY === 'element' || changeAttachY === 'both') {
        if (top < bounds[1] && eAttachment.top === 'bottom') {
          top += height;
          eAttachment.top = 'top';
        }

        if (top + height > bounds[3] && eAttachment.top === 'top') {
          top -= height;
          eAttachment.top = 'bottom';
        }
      }

      if (changeAttachX === 'element' || changeAttachX === 'both') {
        if (left < bounds[0]) {
          if (eAttachment.left === 'right') {
            left += width;
            eAttachment.left = 'left';
          } else if (eAttachment.left === 'center') {
            left += width / 2;
            eAttachment.left = 'left';
          }
        }

        if (left + width > bounds[2]) {
          if (eAttachment.left === 'left') {
            left -= width;
            eAttachment.left = 'right';
          } else if (eAttachment.left === 'center') {
            left -= width / 2;
            eAttachment.left = 'right';
          }
        }
      }

      if (typeof pin === 'string') {
        pin = pin.split(',').map(function (p) {
          return p.trim();
        });
      } else if (pin === true) {
        pin = ['top', 'left', 'right', 'bottom'];
      }

      pin = pin || [];

      var pinned = [];
      var oob = [];

      if (top < bounds[1]) {
        if (pin.indexOf('top') >= 0) {
          top = bounds[1];
          pinned.push('top');
        } else {
          oob.push('top');
        }
      }

      if (top + height > bounds[3]) {
        if (pin.indexOf('bottom') >= 0) {
          top = bounds[3] - height;
          pinned.push('bottom');
        } else {
          oob.push('bottom');
        }
      }

      if (left < bounds[0]) {
        if (pin.indexOf('left') >= 0) {
          left = bounds[0];
          pinned.push('left');
        } else {
          oob.push('left');
        }
      }

      if (left + width > bounds[2]) {
        if (pin.indexOf('right') >= 0) {
          left = bounds[2] - width;
          pinned.push('right');
        } else {
          oob.push('right');
        }
      }

      if (pinned.length) {
        (function () {
          var pinnedClass = undefined;
          if (typeof _this.options.pinnedClass !== 'undefined') {
            pinnedClass = _this.options.pinnedClass;
          } else {
            pinnedClass = _this.getClass('pinned');
          }

          addClasses.push(pinnedClass);
          pinned.forEach(function (side) {
            addClasses.push(pinnedClass + '-' + side);
          });
        })();
      }

      if (oob.length) {
        (function () {
          var oobClass = undefined;
          if (typeof _this.options.outOfBoundsClass !== 'undefined') {
            oobClass = _this.options.outOfBoundsClass;
          } else {
            oobClass = _this.getClass('out-of-bounds');
          }

          addClasses.push(oobClass);
          oob.forEach(function (side) {
            addClasses.push(oobClass + '-' + side);
          });
        })();
      }

      if (pinned.indexOf('left') >= 0 || pinned.indexOf('right') >= 0) {
        eAttachment.left = tAttachment.left = false;
      }
      if (pinned.indexOf('top') >= 0 || pinned.indexOf('bottom') >= 0) {
        eAttachment.top = tAttachment.top = false;
      }

      if (tAttachment.top !== targetAttachment.top || tAttachment.left !== targetAttachment.left || eAttachment.top !== _this.attachment.top || eAttachment.left !== _this.attachment.left) {
        _this.updateAttachClasses(eAttachment, tAttachment);
        _this.trigger('update', {
          attachment: eAttachment,
          targetAttachment: tAttachment
        });
      }
    });

    defer(function () {
      if (!(_this.options.addTargetClasses === false)) {
        updateClasses(_this.target, addClasses, allClasses);
      }
      updateClasses(_this.element, addClasses, allClasses);
    });

    return { top: top, left: left };
  }
});
/* globals TetherBase */

'use strict';

var _TetherBase$Utils = TetherBase.Utils;
var getBounds = _TetherBase$Utils.getBounds;
var updateClasses = _TetherBase$Utils.updateClasses;
var defer = _TetherBase$Utils.defer;

TetherBase.modules.push({
  position: function position(_ref) {
    var _this = this;

    var top = _ref.top;
    var left = _ref.left;

    var _cache = this.cache('element-bounds', function () {
      return getBounds(_this.element);
    });

    var height = _cache.height;
    var width = _cache.width;

    var targetPos = this.getTargetBounds();

    var bottom = top + height;
    var right = left + width;

    var abutted = [];
    if (top <= targetPos.bottom && bottom >= targetPos.top) {
      ['left', 'right'].forEach(function (side) {
        var targetPosSide = targetPos[side];
        if (targetPosSide === left || targetPosSide === right) {
          abutted.push(side);
        }
      });
    }

    if (left <= targetPos.right && right >= targetPos.left) {
      ['top', 'bottom'].forEach(function (side) {
        var targetPosSide = targetPos[side];
        if (targetPosSide === top || targetPosSide === bottom) {
          abutted.push(side);
        }
      });
    }

    var allClasses = [];
    var addClasses = [];

    var sides = ['left', 'top', 'right', 'bottom'];
    allClasses.push(this.getClass('abutted'));
    sides.forEach(function (side) {
      allClasses.push(_this.getClass('abutted') + '-' + side);
    });

    if (abutted.length) {
      addClasses.push(this.getClass('abutted'));
    }

    abutted.forEach(function (side) {
      addClasses.push(_this.getClass('abutted') + '-' + side);
    });

    defer(function () {
      if (!(_this.options.addTargetClasses === false)) {
        updateClasses(_this.target, addClasses, allClasses);
      }
      updateClasses(_this.element, addClasses, allClasses);
    });

    return true;
  }
});
/* globals TetherBase */

'use strict';

var _slicedToArray = (function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i['return']) _i['return'](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError('Invalid attempt to destructure non-iterable instance'); } }; })();

TetherBase.modules.push({
  position: function position(_ref) {
    var top = _ref.top;
    var left = _ref.left;

    if (!this.options.shift) {
      return;
    }

    var shift = this.options.shift;
    if (typeof this.options.shift === 'function') {
      shift = this.options.shift.call(this, { top: top, left: left });
    }

    var shiftTop = undefined,
        shiftLeft = undefined;
    if (typeof shift === 'string') {
      shift = shift.split(' ');
      shift[1] = shift[1] || shift[0];

      var _shift = shift;

      var _shift2 = _slicedToArray(_shift, 2);

      shiftTop = _shift2[0];
      shiftLeft = _shift2[1];

      shiftTop = parseFloat(shiftTop, 10);
      shiftLeft = parseFloat(shiftLeft, 10);
    } else {
      shiftTop = shift.top;
      shiftLeft = shift.left;
    }

    top += shiftTop;
    left += shiftLeft;

    return { top: top, left: left };
  }
});
return Tether;

}));


/***/ }),

/***/ "./source/checkbox/checkbox.js":
/*!*************************************!*\
  !*** ./source/checkbox/checkbox.js ***!
  \*************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _component = __webpack_require__(/*! ../component/component */ "./source/component/component.js");

var _component2 = _interopRequireDefault(_component);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var NAMESPACE = 'ciCheckbox';
var SELECTOR_COMPONENT = '.ci-js-checkbox';
var CLASS_INPUT = 'ci-checkbox-input';
var CLASS_LABEL = 'ci-checkbox-label';
var CLASS_BOX = 'ci-checkbox-box';
var CLASS_TICK = 'ci-checkbox-tick';
var CLASS_IS_FOCUS = 'is-focused';
var CLASS_IS_CHECKED = 'is-checked';
var CLASS_IS_DISABLED = 'is-disabled';

var _chechboxes = [];

/**
 * Class constructor for Checkbox AUI component.
 * Implements AUI component design pattern defined at:
 * https://github.com/...
 *
 * @param {HTMLElement} element The element that will be upgraded.
 */

var Checkbox = function (_Component) {
  _inherits(Checkbox, _Component);

  /**
   * Upgrades all Checkbox AUI components.
   * @returns {Array} Returns an array of all newly upgraded components.
   */
  Checkbox.upgradeElements = function upgradeElements() {
    var components = [];
    Array.from(document.querySelectorAll(SELECTOR_COMPONENT)).forEach(function (element) {
      if (!_component2.default.isElementUpgraded(element)) {
        components.push(new Checkbox(element));
      }
    });

    _chechboxes = _chechboxes.concat(components);

    return components;
  };

  /**
   * Returns all AUI component instances within the given container
   * @param {HTMLElement} container The container element to search for components
   * @returns {Array} Returns an array of all newly upgraded components.
   */
  Checkbox.get = function get() {
    var container = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : document;

    var components = [];
    if (container) {
      Array.from(container.querySelectorAll(SELECTOR_COMPONENT)).forEach(function (element) {
        components.push(element.ciCheckbox);
      });
    }
    return components;
  };

  function Checkbox(element) {
    _classCallCheck(this, Checkbox);

    return _possibleConstructorReturn(this, _Component.call(this, element, NAMESPACE));
  }

  Checkbox.prototype.init = function init() {
    var _this2 = this;

    _Component.prototype.init.call(this);

    this._input = this._element.querySelector('.' + CLASS_INPUT);
    this._input.addEventListener('change', this._changeHandler = function (event) {
      return _this2._onChange(event);
    });
    this._input.addEventListener('focus', this._focusHandler = function (event) {
      return _this2._onFocus(event);
    });
    this._input.addEventListener('blur', this._blurHandler = function (event) {
      return _this2._onBlur(event);
    });

    // Insert box with tick after label element:
    this._label = this._element.querySelector('.' + CLASS_LABEL);
    var box = document.createElement('span');
    box.classList.add(CLASS_BOX);
    this._label.parentNode.insertBefore(box, this._label.nextSibling);
    var tick = document.createElement('span');
    tick.classList.add(CLASS_TICK);
    box.appendChild(tick);

    this.updateClasses();
  };

  Checkbox.prototype.updateClasses = function updateClasses() {
    this.checkDisabled();
    this.checkToggleState();
    this.checkFocus();
  };

  /**
   * Check the disabled state and update field accordingly.
   */


  Checkbox.prototype.checkDisabled = function checkDisabled() {
    if (this._input.disabled) {
      this._element.classList.add(CLASS_IS_DISABLED);
    } else {
      this._element.classList.remove(CLASS_IS_DISABLED);
    }
  };

  /**
   * Check the toggle state and update field accordingly.
   */


  Checkbox.prototype.checkToggleState = function checkToggleState() {
    if (this._input.checked) {
      this._element.classList.add(CLASS_IS_CHECKED);
    } else {
      this._element.classList.remove(CLASS_IS_CHECKED);
    }
  };

  /**
   * Check the focus state and update field accordingly.
   */


  Checkbox.prototype.checkFocus = function checkFocus() {
    if (Boolean(this._element.querySelector(':focus'))) {
      this._element.classList.add(CLASS_IS_FOCUS);
    } else {
      this._element.classList.remove(CLASS_IS_FOCUS);
    }
  };

  /**
   * Enable checkbox
   */


  Checkbox.prototype.enable = function enable() {
    this._input.disabled = false;
    this.updateClasses();
  };

  /**
   * Disable checkbox
   */


  Checkbox.prototype.disable = function disable() {
    this._input.disabled = true;
    this.updateClasses();
  };

  /**
   * Check checkbox
   */


  Checkbox.prototype.check = function check() {
    this._input.checked = true;
    console.log(this._input);
    this.updateClasses();
  };

  /**
   * Uncheck checkbox
   */


  Checkbox.prototype.uncheck = function uncheck() {
    this._input.checked = false;
    this.updateClasses();
  };

  /**
   * Uncheck checkbox
   */


  Checkbox.prototype.toggle = function toggle() {
    if (this._input.checked) {
      this.uncheck();
    } else {
      this.check();
    }
  };

  /**
   * Dispose component
   */


  Checkbox.prototype.dispose = function dispose() {
    _Component.prototype.dispose.call(this);

    this._input.removeEventListener('change', this._changeHandler);
    this._input.removeEventListener('focus', this._focusHandler);
    this._input.removeEventListener('blur', this._blurHandler);

    this._element.removeChild(this._element.querySelector('.' + CLASS_BOX));
  };

  /**
   * Event Handler
   */

  Checkbox.prototype._onChange = function _onChange(event) {
    this.updateClasses();

    // Since other radio buttons don't get change events, we need to look for
    // them to update their classes.
    for (var i = 0; i < _chechboxes.length; i++) {
      var button = _chechboxes[i];
      // Different name == different group, so no point updating those.
      if (button._input.getAttribute('name') === this.groupName) {
        button.updateClasses();
      }
    }
  };

  // TODO Find out why unfocus is triggered on mousedown


  Checkbox.prototype._onFocus = function _onFocus(event) {
    this._element.classList.add(CLASS_IS_FOCUS);
  };

  Checkbox.prototype._onBlur = function _onBlur(event) {
    this._element.classList.remove(CLASS_IS_FOCUS);
  };

  /**
   * Getter and Setter
   */

  _createClass(Checkbox, [{
    key: 'input',
    get: function get() {
      return this._input;
    }
  }, {
    key: 'checked',
    get: function get() {
      return this._input.checked = true;
    },
    set: function set(value) {
      if (value) {
        this.check();
      } else {
        this.uncheck();
      }
    }
  }, {
    key: 'disabled',
    get: function get() {
      return this._input.disabled = true;
    },
    set: function set(value) {
      if (value) {
        this.disable();
      } else {
        this.enable();
      }
    }
  }]);

  return Checkbox;
}(_component2.default);

exports.default = Checkbox;
module.exports = exports['default'];

/***/ }),

/***/ "./source/component/component.js":
/*!***************************************!*\
  !*** ./source/component/component.js ***!
  \***************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var CLASS_IS_UPGRADED = 'is-upgraded';

var SVG_NS = 'http://www.w3.org/2000/svg';

/**
 * Class constructor for abstract AUI Component.
 * Implements AUI component design pattern defined at:
 * https://github.com/...
 *
 * @param {HTMLElement} element The element that will be upgraded.
 */

var Component = function () {

  /**
   * Check if an element is upgraded.
   * @param {HTMLElement} element The element to test if its already be upgraded.
   * @returns {boolean} Returns true if element is already upgraded
   */
  Component.isElementUpgraded = function isElementUpgraded(element) {
    return element.classList.contains(CLASS_IS_UPGRADED);
  };

  /**
   * Constructor
   * @constructor
   * @param {HTMLElement} element The element of the AUI component.
   * @param {String} namespace The namespace of the AUI component, like `ciComponent`.
   */


  function Component(element, namespace) {
    _classCallCheck(this, Component);

    this._element = element;

    if (this._element) {
      if (namespace) {
        this._element[namespace] = this;
      }
      this.init();
    }
  }

  /**
   * Initialize component
   */


  Component.prototype.init = function init() {
    this._element.classList.add(CLASS_IS_UPGRADED);
  };

  /**
   * Dispose component
   */


  Component.prototype.dispose = function dispose() {
    this._element.classList.remove(CLASS_IS_UPGRADED);
  };

  /**
   * Remove a child element from its parent.
   * @param {HTMLElement} childNode The element to remove.
   */


  Component.prototype.removeChild = function removeChild(childNode) {
    if (childNode && childNode.parentNode) {
      childNode.remove();
    }
  };

  /**
   * Creates an HTML element and sets the given CSS classes and attributes.
   * @param {string} tagName is a string that specifies the type of element to be created.
   * @param {Array} classes is an array of class names to set, e.g. ['aui-class-1', 'aui-class-2'].
   * @param {Object} attributes is an object with attributes to set, e.g. {width: 100}.
   * @returns {HTMLElement} The created element.
   */


  Component.prototype.createElement = function createElement(tagName, classes, attributes) {
    var element = document.createElement(tagName);
    if (classes && classes.length) {
      element.classList.add.apply(element.classList, classes);
    }
    for (var attr in attributes) {
      element.setAttribute(attr, attributes[attr]);
    }
    return element;
  };

  /**
   * Creates an SVG element and sets the given attributes.
   * @param {string} qualifiedName is a string that specifies the type of element to be created.
   * @param {Object} attributes is an object with attributes to set, e.g. {width: 100}.
   * @returns {SVGElement} The created element.
   */


  Component.prototype.createSvgNode = function createSvgNode(qualifiedName, attributes) {
    var element = document.createElementNS(SVG_NS, qualifiedName);
    for (var attr in attributes) {
      element.setAttributeNS(null,
      // Replaces viewBox with view-box
      // attr.replace(/[A-Z]/g, function(match) {
      //   return '-' + match.toLowerCase();
      // }),
      attr, attributes[attr]);
    }
    return element;
  };

  /**
   * Returns the HTMLElement of component.
   */


  _createClass(Component, [{
    key: 'element',
    get: function get() {
      return this._element;
    }
  }]);

  return Component;
}();

exports.default = Component;
module.exports = exports['default'];

/***/ }),

/***/ "./source/dropdown/dropdown.js":
/*!*************************************!*\
  !*** ./source/dropdown/dropdown.js ***!
  \*************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _component = __webpack_require__(/*! ../component/component */ "./source/component/component.js");

var _component2 = _interopRequireDefault(_component);

var _checkbox = __webpack_require__(/*! ../checkbox/checkbox */ "./source/checkbox/checkbox.js");

var _checkbox2 = _interopRequireDefault(_checkbox);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var SELECTOR_COMPONENT = '.ci-js-dropdown';
var SELECTOR_OPTION_INPUT = 'input';
var CLASS_ANIMATED_LIST_ITEMS = 'ci-dropdown-list-item--animate';
var CLASS_LABEL = 'ci-dropdown-label';
var CLASS_INPUT = 'ci-dropdown-input';
var CLASS_VALUE = 'ci-dropdown-value';
var CLASS_FOCUS_LINE = 'ci-dropdown-focus-line';
var CLASS_OPTION = 'ci-dropdown-option';
var CLASS_MULTIPLE = 'ci-dropdown--multiple';
var CLASS_IS_FOCUS = 'is-focused';
var CLASS_IS_DIRTY = 'is-dirty';
var CLASS_IS_DISABLED = 'is-disabled';
var CLASS_IS_ACTIVE = 'is-active';

/**
 * Class constructor for Dropdown AUI component.
 * Implements AUI component design pattern defined at:
 * https://github.com/...
 *
 * @param {HTMLElement} element The element that will be upgraded.
 */

var Dropdown = function (_Component) {
  _inherits(Dropdown, _Component);

  /**
   * Upgrades all Dropdown AUI components.
   * @returns {Array} Returns an array of all newly upgraded components.
   */
  Dropdown.upgradeElements = function upgradeElements() {
    var components = [];
    Array.from(document.querySelectorAll(SELECTOR_COMPONENT)).forEach(function (element) {
      if (!_component2.default.isElementUpgraded(element)) {
        components.push(new Dropdown(element));
      }
    });
    return components;
  };

  /**
   * Constructor
   * @constructor
   * @param {HTMLElement} element The element of the AUI component.
   */
  function Dropdown(element) {
    _classCallCheck(this, Dropdown);

    var _this = _possibleConstructorReturn(this, _Component.call(this, element));

    _this._element.addEventListener('click', _this._clickHandler = function (event) {
      return _this._onClick(event);
    });

    _this.multiple = _this._element.classList.contains(CLASS_MULTIPLE);
    _this._isActive = false;

    _this._valueField = _this._element.querySelector('.' + CLASS_VALUE);

    _this._input = _this._element.querySelector('.' + CLASS_INPUT);
    _this._input.addEventListener('input', _this._inputHandler = function (event) {
      return _this._onInput(event);
    });
    _this._input.addEventListener('focus', _this._focusHandler = function (event) {
      return _this._onFocus(event);
    });
    _this._input.addEventListener('blur', _this._blurHandler = function (event) {
      return _this._onBlur(event);
    });
    _this._input.addEventListener('reset', _this._resetHandler = function (event) {
      return _this._onReset(event);
    });

    var itemsAnimated = _this._element.querySelectorAll('.' + CLASS_ANIMATED_LIST_ITEMS);
    for (var i = 0; i < itemsAnimated.length; i++) {
      itemsAnimated[i].style.transitionDelay = itemsAnimated[i].style.webkitTransitionDelay = .05 * i + 's';
    }

    // Insert thick focus line after label element:
    _this._label = _this._element.querySelector('.' + CLASS_LABEL);
    var focusLine = document.createElement('span');
    focusLine.classList.add(CLASS_FOCUS_LINE);
    _this._label.parentNode.insertBefore(focusLine, _this._label.nextSibling);

    _this.updateClasses();
    return _this;
  }

  Dropdown.prototype.optionClicked = function optionClicked(option) {
    if (this._valueField) {
      this._valueField.value = this._getOptionValue(option);
    }

    this.updateInput(option);

    if (!this.multiple) {
      this.close();
    }
  };

  Dropdown.prototype.updateInput = function updateInput(option) {
    var _this2 = this;

    var value = '';
    if (this.multiple) {
      var values = [];
      Array.from(this._element.querySelectorAll('.' + CLASS_OPTION)).forEach(function (element) {
        var input = element.querySelector(SELECTOR_OPTION_INPUT);
        if (input && input.checked) {
          values.push(_this2._getOptionTitle(element));
        }
      });
      value = values.length > 0 ? '(' + values.length + ') ' + values.join(', ') : '';
    } else {
      value = this._getOptionTitle(option);
    }
    this._input.value = value;
    this.updateClasses();
  };

  Dropdown.prototype._getOptionTitle = function _getOptionTitle(option) {
    var title = '';
    if (option) {
      title = option.hasAttribute('data-title') ? option.getAttribute('data-title') : '';
    }
    return title;
  };

  Dropdown.prototype._getOptionValue = function _getOptionValue(option) {
    var value = '';
    if (option) {
      value = option.hasAttribute('data-value') ? option.getAttribute('data-value') : '';
    }
    return value;
  };

  Dropdown.prototype.open = function open() {
    var _this3 = this;

    if (!this._element.classList.contains(CLASS_IS_DISABLED)) {
      this._isActive = true;
      this._element.classList.add(CLASS_IS_ACTIVE);
      window.addEventListener('click', this._clickHandlerWindow = function (event) {
        return _this3._onClickOutside(event);
      });
    }
  };

  Dropdown.prototype.close = function close() {
    this._isActive = false;
    this._element.classList.remove(CLASS_IS_ACTIVE);
    window.removeEventListener('click', this.close);
  };

  Dropdown.prototype.toggleOpen = function toggleOpen() {
    if (this._isActive) {
      this.close();
    } else {
      this.open();
    }
  };

  Dropdown.prototype.updateClasses = function updateClasses() {
    this.checkDisabled();
    this.checkDirty();
    this.checkFocus();
  };

  /**
   * Check the disabled state and update field accordingly.
   */


  Dropdown.prototype.checkDisabled = function checkDisabled() {
    if (this._input.disabled) {
      this._element.classList.add(CLASS_IS_DISABLED);
    } else {
      this._element.classList.remove(CLASS_IS_DISABLED);
    }
  };

  /**
   * Check the dirty state and update field accordingly.
   */


  Dropdown.prototype.checkDirty = function checkDirty() {
    if (this._input.value && this._input.value.length > 0) {
      this._element.classList.add(CLASS_IS_DIRTY);
    } else {
      this._element.classList.remove(CLASS_IS_DIRTY);
    }
  };

  /**
   * Check the focus state and update field accordingly.
   */


  Dropdown.prototype.checkFocus = function checkFocus() {
    if (Boolean(this._element.querySelector(':focus'))) {
      this._element.classList.add(CLASS_IS_FOCUS);
    } else {
      this._element.classList.remove(CLASS_IS_FOCUS);
    }
  };

  /**
   * Disable text field.
   */


  Dropdown.prototype.disable = function disable() {
    this._input.disabled = true;
    this.updateClasses();
  };

  /**
   * Dispose component
   */


  Dropdown.prototype.dispose = function dispose() {
    _Component.prototype.dispose.call(this);

    this._input.removeEventListener('input', this._inputHandler);
    this._input.removeEventListener('focus', this._focusHandler);
    this._input.removeEventListener('blur', this._blurHandler);
    this._input.removeEventListener('reset', this._resetHandler);

    window.removeEventListener('click', this.close);
  };

  /**
   * Event Handler
   */

  Dropdown.prototype._onClick = function _onClick(event) {
    var _this4 = this;

    var isOption = false;

    // Find closest action element
    var currentElement = event.target;
    while (currentElement !== event.currentTarget) {
      if (currentElement.classList.contains(CLASS_OPTION)) {
        isOption = true;
        break;
      }
      currentElement = currentElement.parentNode;
    }

    if (!isOption) {
      this.toggleOpen();
    } else {
      // Toggle the Checkbox contained
      _checkbox2.default.get(currentElement).forEach(function (checkbox) {
        checkbox.toggle();
        _this4.optionClicked(currentElement);
      });
    }
  };

  Dropdown.prototype._onClickOutside = function _onClickOutside(event) {
    if (!this._element.contains(event.target)) {
      this.close();
      this.updateClasses();
    }
  };

  Dropdown.prototype._onInput = function _onInput(event) {
    this.updateClasses();
  };

  Dropdown.prototype._onFocus = function _onFocus(event) {
    this._element.classList.add(CLASS_IS_FOCUS);
  };

  Dropdown.prototype._onBlur = function _onBlur(event) {
    this._element.classList.remove(CLASS_IS_FOCUS);
  };

  Dropdown.prototype._onReset = function _onReset(event) {
    this.updateClasses();
  };

  return Dropdown;
}(_component2.default);

exports.default = Dropdown;
module.exports = exports['default'];

/***/ }),

/***/ "./source/flyout/flyout.js":
/*!*********************************!*\
  !*** ./source/flyout/flyout.js ***!
  \*********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _component = __webpack_require__(/*! ../component/component */ "./source/component/component.js");

var _component2 = _interopRequireDefault(_component);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var SELECTOR_COMPONENT = '.ci-js-flyout';
var CLASS_TOGGLE = 'ci-flyout-toggle';
var CLASS_TRIANGLE = 'ci-flyout-triangle';
var CLASS_HEADER = 'ci-flyout-header';
var CLASS_CLOSE_BUTTON = 'ci-flyout-close';
var CLASS_PANEL = 'ci-flyout-panel';
var CLASS_IS_UPGRADED = 'is-upgraded';
var CLASS_IS_ACTIVE = 'is-active';
var CLASS_FLYOUT_IS_OPEN = 'ci-flyout-is-open';
var TOGGLE_THRESHOLD = 250; // in ms

/**
 * Class constructor for Flyout AUI component.
 * Implements AUI component design pattern defined at:
 * https://github.com/...
 *
 * @param {HTMLElement} element The element that will be upgraded.
 */

var Flyout = function (_Component) {
  _inherits(Flyout, _Component);

  function Flyout() {
    _classCallCheck(this, Flyout);

    return _possibleConstructorReturn(this, _Component.apply(this, arguments));
  }

  /**
   * Upgrades all Flyout AUI components.
   * @returns {Array} Returns an array of all newly upgraded components.
   */
  Flyout.upgradeElements = function upgradeElements() {
    var components = [];
    Array.from(document.querySelectorAll(SELECTOR_COMPONENT)).forEach(function (element) {
      if (!_component2.default.isElementUpgraded(element)) {
        components.push(new Flyout(element));
      }
    });
    return components;
  };

  /**
   * Initialize component
   */
  Flyout.prototype.init = function init() {
    var _this2 = this;

    _Component.prototype.init.call(this);

    this._activationTime = 0;

    this._body = document.querySelector('body');
    this._toggle = this._element.querySelector('.' + CLASS_TOGGLE);
    this._panel = this._element.querySelector('.' + CLASS_PANEL);

    // Add triangle shape
    this._triangle = document.createElement('span');
    this._triangle.classList.add(CLASS_TRIANGLE);
    this._panel.appendChild(this._triangle);

    // Add panel header with close button
    this._header = document.createElement('div');
    this._header.classList.add(CLASS_HEADER);
    this._header.innerHTML = '<button class="' + CLASS_CLOSE_BUTTON + '" type="button"></button>';
    this._panel.appendChild(this._header);

    this._closeBtn = this._header.querySelector('.' + CLASS_CLOSE_BUTTON);
    this._closeBtn.addEventListener('click', this._boundClickClose = function (event) {
      return _this2._onClickClose(event);
    });
    this._toggle.addEventListener('click', this._boundClickToggle = function (event) {
      return _this2._onClickToggle(event);
    });

    if (this._element.classList.contains(CLASS_IS_ACTIVE)) {
      this.open();
    }
  };

  /**
   * Dispose component
   */


  Flyout.prototype.dispose = function dispose() {
    this._toggle.removeEventListener('click', this._boundClickToggle);
    this._closeBtn.removeEventListener('click', this._boundClickClose);
    window.removeEventListener('click', this._boundClickWindow);
    window.removeEventListener('touchend', this._boundTouchendWindow);

    this._panel.removeChild(this._triangle);

    this._element.classList.remove(CLASS_IS_ACTIVE, CLASS_IS_UPGRADED);
    this._element.removeAttribute('style');
  };

  /**
   * Open Flyout
   */


  Flyout.prototype.open = function open() {
    var _this3 = this;

    this._body.classList.add(CLASS_FLYOUT_IS_OPEN);
    this._activationTime = Date.now();
    this._isActive = true;
    this._element.classList.add(CLASS_IS_ACTIVE);
    window.addEventListener('click', this._boundClickWindow = function (event) {
      return _this3._onTouchOutside(event);
    }, true);
    window.addEventListener('touchend', this._boundTouchendWindow = function (event) {
      return _this3._onTouchOutside(event);
    }, true);
  };

  /**
   * Close Flyout
   */


  Flyout.prototype.close = function close() {
    this._body.classList.remove(CLASS_FLYOUT_IS_OPEN);
    this._isActive = false;
    this._element.classList.remove(CLASS_IS_ACTIVE);
    window.removeEventListener('click', this._boundClickWindow, true);
    window.removeEventListener('touchend', this._boundTouchendWindow, true);
  };

  /**
   * Toggle open/close Flyout
   */


  Flyout.prototype.toggle = function toggle() {
    var elapsed = Date.now() - this._activationTime;
    if (elapsed < TOGGLE_THRESHOLD) {
      return;
    }

    if (this._isActive) {
      this.close();
    } else {
      this.open();
    }
  };

  /**
   * Handle click of close button.
   * @param {Event} event that fired.
   */


  Flyout.prototype._onClickClose = function _onClickClose(event) {
    this.close();
  };

  /**
   * Handle click of toggle.
   * @param {Event} event that fired.
   */


  Flyout.prototype._onClickToggle = function _onClickToggle(event) {
    this.toggle();
  };

  /**
   * Handle mouseneter.
   * @param {Event} event that fired.
   */


  Flyout.prototype._onMouseEnter = function _onMouseEnter(event) {
    this.open(event.target, event.clientX);
  };

  /**
   * Handle mouseleave.
   * @param {Event} event that fired.
   */


  Flyout.prototype._onMouseLeave = function _onMouseLeave(event) {
    this.close();
  };

  /**
   * Handle touch.
   * @param {Event} event that fired.
   */


  Flyout.prototype._onTouch = function _onTouch(event) {
    event.stopPropagation();
    this.open();
  };

  /**
   * Handle touch outside.
   * @param {Event} event that fired.
   */


  Flyout.prototype._onTouchOutside = function _onTouchOutside(event) {
    if (!this._element.contains(event.target)) {
      this.close();
    }
  };

  return Flyout;
}(_component2.default);

exports.default = Flyout;
module.exports = exports['default'];

/***/ }),

/***/ "./source/index.js":
/*!*************************!*\
  !*** ./source/index.js ***!
  \*************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Tooltip = exports.Textfield = exports.Spinner = exports.Slider = exports.Select = exports.Response = exports.Radio = exports.Progress = exports.Popover = exports.Modal = exports.Flyout = exports.Dropdown = exports.Checkbox = undefined;

var _checkbox = __webpack_require__(/*! ./checkbox/checkbox */ "./source/checkbox/checkbox.js");

var _checkbox2 = _interopRequireDefault(_checkbox);

var _dropdown = __webpack_require__(/*! ./dropdown/dropdown */ "./source/dropdown/dropdown.js");

var _dropdown2 = _interopRequireDefault(_dropdown);

var _flyout = __webpack_require__(/*! ./flyout/flyout */ "./source/flyout/flyout.js");

var _flyout2 = _interopRequireDefault(_flyout);

var _modal = __webpack_require__(/*! ./modal/modal */ "./source/modal/modal.js");

var _modal2 = _interopRequireDefault(_modal);

var _popover = __webpack_require__(/*! ./popover/popover */ "./source/popover/popover.js");

var _popover2 = _interopRequireDefault(_popover);

var _progress = __webpack_require__(/*! ./progress/progress */ "./source/progress/progress.js");

var _progress2 = _interopRequireDefault(_progress);

var _radio = __webpack_require__(/*! ./radio/radio */ "./source/radio/radio.js");

var _radio2 = _interopRequireDefault(_radio);

var _response = __webpack_require__(/*! ./response/response */ "./source/response/response.js");

var _response2 = _interopRequireDefault(_response);

var _select = __webpack_require__(/*! ./select/select */ "./source/select/select.js");

var _select2 = _interopRequireDefault(_select);

var _slider = __webpack_require__(/*! ./slider/slider */ "./source/slider/slider.js");

var _slider2 = _interopRequireDefault(_slider);

var _spinner = __webpack_require__(/*! ./spinner/spinner */ "./source/spinner/spinner.js");

var _spinner2 = _interopRequireDefault(_spinner);

var _textfield = __webpack_require__(/*! ./textfield/textfield */ "./source/textfield/textfield.js");

var _textfield2 = _interopRequireDefault(_textfield);

var _tooltip = __webpack_require__(/*! ./tooltip/tooltip */ "./source/tooltip/tooltip.js");

var _tooltip2 = _interopRequireDefault(_tooltip);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } } /**
                                                                                                                                                           * Import all AUI components.
                                                                                                                                                           */
// import Alert from './alert/alert';
// import Breadcrumb from './breadcrumb/breadcrumb';

// import Header from './header/header';

// import Nav from './nav/nav';
// import Notification from './notification/notification';
// import Pagination from './pagination/pagination';
// import Player from './player/player';

// import Slidernav from './slidernav/slidernav';


/**
 * Export all AUI components to make them accessible through npm.
 * @example
 * import {Alert} from 'audi-ui';
 * Alert.upgradeElements();
 */
// export {  Alert,  Breadcrumb,  Checkbox,  Dropdown,  Flyout,  Header,  Modal,  Nav,  Notification,  Pagination,  Player,  Popover,  Progress,  Radio,  Response,  Select,  Slider,  Slidernav,  Spinner,  Textfield,  Tooltip}
exports.Checkbox = _checkbox2.default;
exports.Dropdown = _dropdown2.default;
exports.Flyout = _flyout2.default;
exports.Modal = _modal2.default;
exports.Popover = _popover2.default;
exports.Progress = _progress2.default;
exports.Radio = _radio2.default;
exports.Response = _response2.default;
exports.Select = _select2.default;
exports.Slider = _slider2.default;
exports.Spinner = _spinner2.default;
exports.Textfield = _textfield2.default;
exports.Tooltip = _tooltip2.default;

/**
 * Export Component Handler as default to have access to all components.
 * @example
 * import auiHandler from 'audi-ui';
 * auiHandler.upgradeAllElements();
 */

var ComponentHandler = function () {
  function ComponentHandler() {
    _classCallCheck(this, ComponentHandler);

    /**
     * Performs a "Cutting the mustard" test. If the browser supports the features
     * tested, adds a aui-js class to the <html> element.
     */
    if ('classList' in document.createElement('div') && 'querySelector' in document && 'addEventListener' in window && Array.prototype.forEach) {
      document.documentElement.classList.add('aui-js');
    }

    // TODO: M.O.: ohne das hier hat es nicht geupdated: (Vielleicht nicht die optimale Lösung...)
    this.upgradeAllElements();
  }

  ComponentHandler.prototype.upgradeAllElements = function upgradeAllElements() {
    // Alert.upgradeElements();
    // Breadcrumb.upgradeElements();
    _checkbox2.default.upgradeElements();
    _dropdown2.default.upgradeElements();
    _flyout2.default.upgradeElements();
    // Header.upgradeElements();
    _modal2.default.upgradeElements();
    // Nav.upgradeElements();
    // Notification.upgradeElements();
    // Pagination.upgradeElements();
    // Player.upgradeElements();
    _popover2.default.upgradeElements();
    _progress2.default.upgradeElements();
    _radio2.default.upgradeElements();
    _response2.default.upgradeElements();
    _select2.default.upgradeElements();
    _slider2.default.upgradeElements();
    // Slidernav.upgradeElements();
    _spinner2.default.upgradeElements();
    _textfield2.default.upgradeElements();
    _tooltip2.default.upgradeElements();
  };

  return ComponentHandler;
}();

var componentHandler = new ComponentHandler();

exports.default = componentHandler;

/***/ }),

/***/ "./source/modal/modal-default.js":
/*!***************************************!*\
  !*** ./source/modal/modal-default.js ***!
  \***************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _modalDialog = __webpack_require__(/*! ../modal/modal-dialog */ "./source/modal/modal-dialog.js");

var _modalDialog2 = _interopRequireDefault(_modalDialog);

var _resizeObserver = __webpack_require__(/*! ../util/resize-observer */ "./source/util/resize-observer.js");

var _resizeObserver2 = _interopRequireDefault(_resizeObserver);

var _transitionEndEvent = __webpack_require__(/*! ../util/transition-end-event */ "./source/util/transition-end-event.js");

var _transitionEndEvent2 = _interopRequireDefault(_transitionEndEvent);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var CLASS_MODAL_IS_OPEN = 'ci-modal-open';
var CLASS_WINDOW = 'ci-modal-dialog-window';
var CLASS_DIALOG_BODY = 'ci-modal-dialog-body';
var CLASS_IS_ACTIVE = 'is-active';

/**
 * Class constructor for ModalDefault AUI component.
 * Implements AUI component design pattern defined at:
 * https://github.com/...
 *
 * @param {HTMLElement} element The element that will be upgraded.
 */

var ModalDefault = function (_ModalDialog) {
  _inherits(ModalDefault, _ModalDialog);

  function ModalDefault() {
    _classCallCheck(this, ModalDefault);

    return _possibleConstructorReturn(this, _ModalDialog.apply(this, arguments));
  }

  /**
   * Opens this modal.
   * @param {HTMLElement} trigger The element which opens the modal.
   */
  ModalDefault.prototype.open = function open(trigger) {
    var _this2 = this;

    _ModalDialog.prototype.open.call(this);
    this._trigger = trigger;

    // Make modal element visible
    this._element.classList.add(CLASS_IS_ACTIVE);
    this._element.scrollTop = 0;
    this._addBackdrop();

    // If dialog acts as window, we have to reposition the close button to
    // stick with the dialog.
    if (this._element.querySelector('.' + CLASS_WINDOW) && this._closeButton) {
      if (this._resizeObserver === undefined) {
        this._resizeObserver = new _resizeObserver2.default();
        this._dialogBody = this._element.querySelector('.' + CLASS_DIALOG_BODY);
      }
      this._resizeObserver.resized.add(this._resizedHandler = function () {
        return _this2._repositionCloseButton();
      });
      this._repositionCloseButton();
    }

    window.requestAnimationFrame(function () {
      return _this2._prepareOpenTransition();
    });
  };

  /**
   * Prepare the open transition.
   */


  ModalDefault.prototype._prepareOpenTransition = function _prepareOpenTransition() {
    var _this3 = this;

    // Loops until modal is really visible.
    // That's required to make transitions work as aspected.
    if (this._element.offsetWidth > 0) {

      // Start opening animation
      this._body.classList.add(CLASS_MODAL_IS_OPEN);
    } else {
      window.requestAnimationFrame(function () {
        return _this3._prepareOpenTransition();
      });
    }
  };

  /**
   * Closes this modal.
   */


  ModalDefault.prototype.close = function close() {
    var _this4 = this;

    if (this._backdrop) {
      this._backdrop.removeEventListener(_transitionEndEvent2.default, this._backdropCloseTransitionendHandler);
      _transitionEndEvent2.default && this._backdrop.addEventListener(_transitionEndEvent2.default, this._backdropCloseTransitionendHandler = function (event) {
        return _this4._onBackdropCloseTransitionend(event);
      });
    }

    if (this._resizeObserver) {
      this._resizeObserver.resized.remove(this._resizedHandler);
    }

    this._body.classList.remove(CLASS_MODAL_IS_OPEN);
  };

  /**
   * Reposition close button with dialog
   */


  ModalDefault.prototype._repositionCloseButton = function _repositionCloseButton() {
    var rect = this._dialogBody.getBoundingClientRect();
    var right = rect.right - rect.width;
    // Only reposition if the window is positioned center, otherwise respect
    // CSS styling:
    if (right > 0) {
      this._closeButton.style.right = right + 'px';
    } else {
      this._closeButton.style.right = '';
    }
  };

  return ModalDefault;
}(_modalDialog2.default);

exports.default = ModalDefault;
module.exports = exports['default'];

/***/ }),

/***/ "./source/modal/modal-dialog.js":
/*!**************************************!*\
  !*** ./source/modal/modal-dialog.js ***!
  \**************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _component = __webpack_require__(/*! ../component/component */ "./source/component/component.js");

var _component2 = _interopRequireDefault(_component);

var _transitionEndEvent = __webpack_require__(/*! ../util/transition-end-event */ "./source/util/transition-end-event.js");

var _transitionEndEvent2 = _interopRequireDefault(_transitionEndEvent);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var CLOSE_BUTTON_SIZE_SMALL = 45;
var CLOSE_BUTTON_SIZE_LARGE = 81;
var CLOSE_ICON_SIZE_SMALL = 17;
var CLOSE_ICON_SIZE_LARGE = 31;
var CLASS_BACKDROP = 'ci-modal-backdrop';
var CLASS_CLOSE = 'ci-modal-dialog-close';
var CLASS_IS_ACTIVE = 'is-active';

/**
 * Class constructor for ModalDialog AUI component.
 * Implements AUI component design pattern defined at:
 * https://github.com/...
 *
 * @param {HTMLElement} element The element that will be upgraded.
 */

var ModalDialog = function (_Component) {
  _inherits(ModalDialog, _Component);

  function ModalDialog() {
    _classCallCheck(this, ModalDialog);

    return _possibleConstructorReturn(this, _Component.apply(this, arguments));
  }

  /**
   * Initialize component
   */
  ModalDialog.prototype.init = function init() {
    _Component.prototype.init.call(this);

    this._body = document.querySelector('body');

    this._closeButton = this._element.querySelector('.' + CLASS_CLOSE);
    if (this._closeButton) {
      this._addCloseButton(this._closeButton);
    }
  };

  /**
   * Opens this modal.
   */


  ModalDialog.prototype.open = function open() {
    if (this._element.parentNode !== this._body) {
      this._body.appendChild(this._element);
    }
  };

  /**
   * Handle transition end event
   * @param {Event} event which was fired.
   */


  ModalDialog.prototype._onBackdropCloseTransitionend = function _onBackdropCloseTransitionend(event) {
    if (event.target === event.currentTarget) {
      this._backdrop.removeEventListener(_transitionEndEvent2.default, this._backdropCloseTransitionendHandler);
      this._element.classList.remove(CLASS_IS_ACTIVE);
      this._removeBackdrop();
    }
  };

  /**
   * Adds a semi-transparent backdrop element behind the modal.
   */


  ModalDialog.prototype._addBackdrop = function _addBackdrop() {
    if (!this._backdrop) {
      this._backdrop = document.createElement('div');
      this._backdrop.classList.add(CLASS_BACKDROP);
      this._body.appendChild(this._backdrop);
    }
  };

  /**
   * Removes the backdrop element behind modal.
   */


  ModalDialog.prototype._removeBackdrop = function _removeBackdrop() {
    if (this._backdrop) {
      this._body.removeChild(this._backdrop);
      this._backdrop = null;
    }
  };

  /**
   * Adds close button
   * @param {HTMLElement} container to append close icon to.
   */


  ModalDialog.prototype._addCloseButton = function _addCloseButton(container) {
    var diagonalHalf = Math.sqrt(2) * CLOSE_ICON_SIZE_SMALL / 2;
    var btnSize = CLOSE_BUTTON_SIZE_SMALL;

    var small = this.createSvgNode('svg', {
      class: 'ci-modal-close-icon-small',
      viewBox: '0 0 ' + btnSize + ' ' + btnSize
    });
    var group = this.createSvgNode('g', {
      transform: 'translate(' + btnSize / 2 + ', ' + btnSize / 2 + ')'
    });
    group.appendChild(this.createSvgNode('line', {
      x1: '0',
      y1: -diagonalHalf,
      x2: '0',
      y2: diagonalHalf,
      stroke: 'currentColor',
      transform: 'rotate(-45, 0, 0)'
    }));
    group.appendChild(this.createSvgNode('line', {
      x1: '0',
      y1: -diagonalHalf,
      x2: '0',
      y2: diagonalHalf,
      stroke: 'currentColor',
      transform: 'rotate(45, 0, 0)'
    }));
    small.appendChild(group);
    container.appendChild(small);

    diagonalHalf = Math.sqrt(2) * CLOSE_ICON_SIZE_LARGE / 2;
    btnSize = CLOSE_BUTTON_SIZE_LARGE;
    var large = this.createSvgNode('svg', {
      'class': 'ci-modal-close-icon-large',
      'viewBox': '0 0 ' + btnSize + ' ' + btnSize
    });
    group = this.createSvgNode('g', {
      transform: 'translate(' + btnSize / 2 + ', ' + btnSize / 2 + ')'
    });
    group.appendChild(this.createSvgNode('line', {
      x1: '0',
      y1: -diagonalHalf,
      x2: '0',
      y2: diagonalHalf,
      stroke: 'currentColor',
      transform: 'rotate(-45, 0, 0)'
    }));
    group.appendChild(this.createSvgNode('line', {
      x1: '0',
      y1: -diagonalHalf,
      x2: '0',
      y2: diagonalHalf,
      stroke: 'currentColor',
      transform: 'rotate(45, 0, 0)'
    }));
    large.appendChild(group);
    container.appendChild(large);
  };

  return ModalDialog;
}(_component2.default);

exports.default = ModalDialog;
module.exports = exports['default'];

/***/ }),

/***/ "./source/modal/modal-morph.js":
/*!*************************************!*\
  !*** ./source/modal/modal-morph.js ***!
  \*************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _modalDialog = __webpack_require__(/*! ../modal/modal-dialog */ "./source/modal/modal-dialog.js");

var _modalDialog2 = _interopRequireDefault(_modalDialog);

var _transitionEndEvent = __webpack_require__(/*! ../util/transition-end-event */ "./source/util/transition-end-event.js");

var _transitionEndEvent2 = _interopRequireDefault(_transitionEndEvent);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var CLASS_MODAL_IS_OPEN = 'ci-modal-open';
var CLASS_CONTENT = 'ci-modal-dialog-content';
var CLASS_MORPH_DIALOG = 'ci-modal-morph';
var CLASS_IS_ACTIVE = 'is-active';
var CLASS_IS_MORPHING = 'is-morphing';

/**
 * Class constructor for ModalMorph AUI component.
 * Implements AUI component design pattern defined at:
 * https://github.com/...
 *
 * @param {HTMLElement} element The element that will be upgraded.
 */

var ModalMorph = function (_ModalDialog) {
  _inherits(ModalMorph, _ModalDialog);

  function ModalMorph() {
    _classCallCheck(this, ModalMorph);

    return _possibleConstructorReturn(this, _ModalDialog.apply(this, arguments));
  }

  /**
   * Initialize component
   */
  ModalMorph.prototype.init = function init() {
    _ModalDialog.prototype.init.call(this);

    this._content = this._element.querySelector('.' + CLASS_CONTENT);
  };

  /**
   * Open modal
   * @param {HTMLElement} trigger The element which opens the modal.
   */


  ModalMorph.prototype.open = function open(trigger) {
    var _this2 = this;

    console.log('Open morphing modal');
    _ModalDialog.prototype.open.call(this);
    this._trigger = trigger;

    // Make modal element visible
    this._element.classList.add(CLASS_IS_ACTIVE);
    this._element.scrollTop = 0;
    this._addBackdrop();

    window.requestAnimationFrame(function () {
      return _this2._prepareOpenTransition();
    });
  };

  ModalMorph.prototype._prepareOpenTransition = function _prepareOpenTransition() {
    var _this3 = this;

    var rect = this._trigger.getBoundingClientRect();

    // Apply bounding rect to start with to morphing element
    this._morph = this._getMorphElement(rect);

    // Start opening animation
    window.requestAnimationFrame(function () {
      return _this3._startOpenTransition();
    });
  };

  ModalMorph.prototype._startOpenTransition = function _startOpenTransition() {
    var _this4 = this;

    var rect = this._content.getBoundingClientRect();

    // Apply bounding rect to end on to morphing element
    this._applyBoundingRectToElement(this._morph, rect);
    _transitionEndEvent2.default && this._element.addEventListener(_transitionEndEvent2.default, this._boundTransitionendElementIn = function (event) {
      return _this4._onTransitionendElementIn(event);
    });
    this._morph.classList.add(CLASS_IS_MORPHING);
    this._body.classList.add(CLASS_MODAL_IS_OPEN);
  };

  ModalMorph.prototype._onTransitionendElementIn = function _onTransitionendElementIn(event) {
    this._element.removeEventListener(_transitionEndEvent2.default, this._boundTransitionendElementIn);
    this._morph.classList.remove(CLASS_IS_MORPHING);
  };

  /**
   * Close modal
   */


  ModalMorph.prototype.close = function close() {
    var _this5 = this;

    console.log('close');
    if (this._backdrop) {
      this._backdrop.removeEventListener(_transitionEndEvent2.default, this._backdropCloseTransitionendHandler);
      _transitionEndEvent2.default && this._backdrop.addEventListener(_transitionEndEvent2.default, this._backdropCloseTransitionendHandler = function (event) {
        return _this5._onBackdropCloseTransitionend(event);
      });
    }

    this._element.removeEventListener(_transitionEndEvent2.default, this._boundTransitionendElementIn);

    var rect = this._content.getBoundingClientRect();
    this._applyBoundingRectToElement(this._morph, rect);
    this._morph.classList.add(CLASS_IS_MORPHING);

    _transitionEndEvent2.default && this._morph.addEventListener(_transitionEndEvent2.default, this._boundTransitionendMorphOut = function (event) {
      return _this5._onTransitionendMorphOut(event);
    });

    window.requestAnimationFrame(function () {
      return _this5._startCloseTransition();
    });
  };

  ModalMorph.prototype._startCloseTransition = function _startCloseTransition() {
    var rect = this._trigger.getBoundingClientRect();
    this._applyBoundingRectToElement(this._morph, rect);

    this._body.classList.remove(CLASS_MODAL_IS_OPEN);
  };

  ModalMorph.prototype._onTransitionendMorphOut = function _onTransitionendMorphOut(event) {
    this._morph.removeEventListener(_transitionEndEvent2.default, this._boundTransitionendMorphOut);
    this.removeChild(this._morph);
    this._morph = null;
  };

  ModalMorph.prototype._onMorpBodyCloseTransitionend = function _onMorpBodyCloseTransitionend(event) {
    if (event.target === event.currentTarget) {
      this._morphBody.removeEventListener(_transitionEndEvent2.default, this._morpBodyCloseTransitionendHandler);
      this._morphBody.removeAttribute('style');
      this._content.classList.remove(CLASS_IS_MORPHING);
    }
  };

  ModalMorph.prototype._applyBoundingRectToElement = function _applyBoundingRectToElement(element, rect) {
    element.style.top = Math.round(rect.top) + 'px';
    element.style.left = Math.round(rect.left) + 'px';
    element.style.width = Math.round(rect.width) + 'px';
    element.style.height = Math.round(rect.height) + 'px';
  };

  ModalMorph.prototype._getMorphElement = function _getMorphElement(rect) {
    if (!this._morph) {
      this._morph = this.createElement('div', [CLASS_MORPH_DIALOG]);
      this._applyBoundingRectToElement(this._morph, rect);
      this._body.append(this._morph);
    }
    return this._morph;
  };

  return ModalMorph;
}(_modalDialog2.default);

exports.default = ModalMorph;
module.exports = exports['default'];

/***/ }),

/***/ "./source/modal/modal.js":
/*!*******************************!*\
  !*** ./source/modal/modal.js ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _component = __webpack_require__(/*! ../component/component */ "./source/component/component.js");

var _component2 = _interopRequireDefault(_component);

var _modalDefault = __webpack_require__(/*! ../modal/modal-default */ "./source/modal/modal-default.js");

var _modalDefault2 = _interopRequireDefault(_modalDefault);

var _modalMorph = __webpack_require__(/*! ../modal/modal-morph */ "./source/modal/modal-morph.js");

var _modalMorph2 = _interopRequireDefault(_modalMorph);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var SELECTOR_COMPONENT = '.ci-js-modal';
var CLASS_MORPH = 'ci-modal-morph';

var modalComponents = void 0;
var currentModal = void 0;

/**
 * Class constructor for Modal AUI component.
 * Implements AUI component design pattern defined at:
 * https://github.com/...
 *
 * @param {HTMLElement} element The element that will be upgraded.
 */

var Modal = function (_Component) {
  _inherits(Modal, _Component);

  function Modal() {
    _classCallCheck(this, Modal);

    return _possibleConstructorReturn(this, _Component.apply(this, arguments));
  }

  /**
   * Upgrades all Modal AUI components.
   * @returns {Array} Returns an array of all newly upgraded components.
   */
  Modal.upgradeElements = function upgradeElements() {
    var components = [];
    Array.from(document.querySelectorAll(SELECTOR_COMPONENT)).forEach(function (element) {
      if (!_component2.default.isElementUpgraded(element)) {
        components.push(new Modal(element));
      }
    });
    modalComponents = components;
    return components;
  };

  /**
   * Get a modal component by element ID.
   * @param {string} id The id attribute of the components HTML element.
   * @returns {Modal} Returns a modal with the given ID.
   */
  Modal.getModalById = function getModalById(id) {
    console.log("getModalById id: " + id);
    console.log(modalComponents);
    for (var i = 0; i < modalComponents.length; i++) {
      if (modalComponents[i].id === id) {
        return modalComponents[i];
      }
    }
  };

  /**
   * Close current modal.
   */


  Modal.closeCurrentModal = function closeCurrentModal() {
    if (currentModal) {
      currentModal.close();
      currentModal = null;
    }
  };

  /**
   * Returns modifier `morph`
   */


  /**
   * Initialize component
   */
  Modal.prototype.init = function init() {
    _Component.prototype.init.call(this);

    this._id = this._element.getAttribute('id');

    // Initialize with appropriate decorator depending on modifier,
    // represented by according CSS class:
    if (this._element.classList.contains(CLASS_MORPH)) {
      this._decorator = new _modalMorph2.default(this._element);
    } else {
      this._decorator = new _modalDefault2.default(this._element);
    }
  };

  /**
   * Opens this modal.
   * @param {HTMLElement} trigger The element which opens the modal.
   */


  Modal.prototype.open = function open(trigger) {
    currentModal = this;
    this._decorator.open(trigger);
  };

  /**
   * Closes this modal.
   */


  Modal.prototype.close = function close() {
    currentModal = null;
    this._decorator.close();
  };

  /**
   * @returns {string} Returns the ID of the modal
   */


  _createClass(Modal, [{
    key: 'id',
    get: function get() {
      return this._id;
    }
  }], [{
    key: 'MODIFIER_MORPH',
    get: function get() {
      return CLASS_MORPH;
    }

    /**
     * Returns modifier `default`
     */

  }, {
    key: 'MODIFIER_DEFAULT',
    get: function get() {
      return '';
    }
  }]);

  return Modal;
}(_component2.default);

exports.default = Modal;


if (!Array.from) {
  Array.from = function () {
    var toStr = Object.prototype.toString;
    var isCallable = function isCallable(fn) {
      return typeof fn === 'function' || toStr.call(fn) === '[object Function]';
    };
    var toInteger = function toInteger(value) {
      var number = Number(value);
      if (isNaN(number)) {
        return 0;
      }
      if (number === 0 || !isFinite(number)) {
        return number;
      }
      return (number > 0 ? 1 : -1) * Math.floor(Math.abs(number));
    };
    var maxSafeInteger = Math.pow(2, 53) - 1;
    var toLength = function toLength(value) {
      var len = toInteger(value);
      return Math.min(Math.max(len, 0), maxSafeInteger);
    };

    return function from(arrayLike) {
      var C = this;
      var items = Object(arrayLike);
      if (arrayLike === null) {
        throw new TypeError("Array.from requires an array-like object - not null or undefined");
      }
      var mapFn = arguments.length > 1 ? arguments[1] : void undefined;
      var T;
      if (typeof mapFn !== 'undefined') {
        if (!isCallable(mapFn)) {
          throw new TypeError('Array.from: when provided, the second argument must be a function');
        }
        if (arguments.length > 2) {
          T = arguments[2];
        }
      }
      var len = toLength(items.length);
      var A = isCallable(C) ? Object(new C(len)) : new Array(len);

      var k = 0;
      var kValue;
      while (k < len) {
        kValue = items[k];
        if (mapFn) {
          A[k] = typeof T === 'undefined' ? mapFn(kValue, k) : mapFn.call(T, kValue, k);
        } else {
          A[k] = kValue;
        }
        k += 1;
      }
      A.length = len;
      return A;
    };
  }();
}
/**
 * to open modal:
 */
Array.from(document.querySelectorAll('[data-toggle="modal"]')).forEach(function (element) {
  console.log("Modal erkannt");
  element.addEventListener('click', function (event) {
    console.log("klick auf modal opener");
    var modal = Modal.getModalById(element.getAttribute('data-target'));
    if (modal) {
      modal.open(event.currentTarget);
    }
  });
});

Array.from(document.querySelectorAll('[data-dismiss="modal"]')).forEach(function (element) {
  console.log("Modal-schließen-Btn erkannt");
  element.addEventListener('click', function (event) {
    console.log("Modal schließen Event");
    Modal.closeCurrentModal();
  });
});
module.exports = exports['default'];

/***/ }),

/***/ "./source/popover/popover.js":
/*!***********************************!*\
  !*** ./source/popover/popover.js ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _component = __webpack_require__(/*! ../component/component */ "./source/component/component.js");

var _component2 = _interopRequireDefault(_component);

var _reflow = __webpack_require__(/*! ../util/reflow */ "./source/util/reflow.js");

var _reflow2 = _interopRequireDefault(_reflow);

var _closest = __webpack_require__(/*! ../util/closest */ "./source/util/closest.js");

var _closest2 = _interopRequireDefault(_closest);

var _transitionEndEvent = __webpack_require__(/*! ../util/transition-end-event */ "./source/util/transition-end-event.js");

var _transitionEndEvent2 = _interopRequireDefault(_transitionEndEvent);

var _tether = __webpack_require__(/*! tether */ "./node_modules/tether/dist/js/tether.js");

var _tether2 = _interopRequireDefault(_tether);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var SELECTOR_COMPONENT = '.ci-js-popover';
var SELECTOR_DISMISS = '[data-dismiss="popover"]';
var CLASS_ARROW = 'ci-popover-arrow';
var CLASS_ARROW_SHAPE = 'ci-popover-arrow-shape';
var CLASS_ACTIVE = 'is-active';
var CLASS_SHOWN = 'is-shown';
var CLASS_POPOVER_IS_OPEN = 'ci-popover-is-open';
var ARROW_SIZE = 20;

var AttachmentMap = {
  top: 'bottom center',
  right: 'middle left',
  bottom: 'top center',
  left: 'middle right'

  /**
   * Class constructor for Popover AUI component.
   * Implements AUI component design pattern defined at:
   * https://github.com/...
   *
   * @param {HTMLElement} element The element that will be upgraded.
   */
};
var Popover = function (_Component) {
  _inherits(Popover, _Component);

  function Popover() {
    _classCallCheck(this, Popover);

    return _possibleConstructorReturn(this, _Component.apply(this, arguments));
  }

  /**
   * Upgrades all Popover AUI components.
   * @returns {Array} Returns an array of all newly upgraded components.
   */
  Popover.upgradeElements = function upgradeElements() {
    var components = [];
    Array.from(document.querySelectorAll(SELECTOR_COMPONENT)).forEach(function (element) {
      if (!_component2.default.isElementUpgraded(element)) {
        components.push(new Popover(element));
      }
    });
    return components;
  };

  /**
   * Initialize component
   */
  Popover.prototype.init = function init() {
    var _this2 = this;

    _Component.prototype.init.call(this);

    this._body = document.querySelector('body');

    this._id = this._element.getAttribute('id');
    this._trigger = document.getElementById(this._element.getAttribute('for'));
    this._tether = null;
    var placement = this._element.hasAttribute('data-placement') ? this._element.getAttribute('data-placement') : 'top';
    this._attachement = AttachmentMap[placement.toLowerCase()];

    var content = this._element.querySelector('.ci-popover-content');
    var arrowColor = this._element.hasAttribute('data-arrow-color') ? this._element.getAttribute('data-arrow-color') : window.getComputedStyle(content).backgroundColor;
    this._arrow = this._addArrow(content, arrowColor);

    if (this._trigger) {
      this._trigger.addEventListener('click', this._boundClickHandler = function (event) {
        return _this2.toggle(event);
      });
    }
  };

  /**
   * Dispose component
   */


  Popover.prototype.dispose = function dispose() {
    _Component.prototype.dispose.call(this);

    this.hide();
    this.removeChild(this._arrow);

    if (this._trigger) {
      this._trigger.removeEventListener('click', this._boundClickHandler);
    }
  };

  /**
   * Toggle show/hide Popover
   * @param {Event} event Click event of trigger element (optional)
   */


  Popover.prototype.toggle = function toggle(event) {
    var _this3 = this;

    var performToggle = function performToggle() {
      if (!_this3._element.classList.contains(CLASS_ACTIVE) && _this3._tether) {
        _this3.show();
      } else {
        _this3.hide();
      }
    };

    if (event) {
      event.preventDefault();

      if (this._tether === null) {
        this._tether = new _tether2.default({
          element: this._element,
          target: event.currentTarget,
          attachment: this._attachement,
          classPrefix: 'ci-tether',
          // NOTE We set an offset in CSS, because this offset wouln't be
          // flipped as it should:
          // https://github.com/HubSpot/tether/issues/106
          offset: '0 0',
          constraints: [{
            to: 'window',
            pin: ['left', 'right'],
            attachment: 'together'
          }],
          optimizations: {
            gpu: false
          }
        });
        (0, _reflow2.default)(this._element); // TODO Do we need this anymore?
        this._tether.position();
      }
      performToggle();
    } else {
      performToggle();
    }
  };

  /**
   * Show Popover
   */


  Popover.prototype.show = function show() {
    var _this4 = this;

    this._body.classList.add(CLASS_POPOVER_IS_OPEN);
    this._element.classList.add(CLASS_ACTIVE);
    this._element.classList.add(CLASS_SHOWN);
    setTimeout(function () {
      window.addEventListener('click', _this4._boundWindowClickHandler = function (event) {
        return _this4._onClickOutside(event);
      });
    });
  };

  /**
   * Hide Popover
   */


  Popover.prototype.hide = function hide() {
    var _this5 = this;

    this._element.classList.remove(CLASS_SHOWN);
    this._element.addEventListener(_transitionEndEvent2.default, this._boundAnimationendHandler = function (event) {
      return _this5._onHideComplete(event);
    });
    // this._cleanupTether();
    window.removeEventListener('click', this._boundWindowClickHandler);
  };

  /**
   * Clean up Tether instance
   * @private
   */


  Popover.prototype._cleanupTether = function _cleanupTether() {
    if (this._tether) {
      this._tether.destroy();
      this._tether = null;
    }
    this._element.removeAttribute('style');
  };

  /**
   * Handle click of window.
   * @param {Event} event The event that fired.
   * @private
   */


  Popover.prototype._onClickOutside = function _onClickOutside(event) {
    // Hide if target dismisses Popover
    if ((0, _closest2.default)(event.target, SELECTOR_DISMISS, this._element)) {
      this.hide();

      // Hide if target is not inside Popover and not trigger element
    } else if (!this._element.contains(event.target) && event.target !== this._trigger) {
      this.hide();
    }
  };

  /**
   * Handle hide transition complete.
   * @param {Event} event The event that fired.
   * @private
   */


  Popover.prototype._onHideComplete = function _onHideComplete(event) {
    this._body.classList.remove(CLASS_POPOVER_IS_OPEN);
    this._element.classList.remove(CLASS_ACTIVE);
    this._element.removeEventListener(_transitionEndEvent2.default, this._boundAnimationendHandler);
    this._cleanupTether();
  };

  /**
   * Adds an arrow SVG element
   * <span class="…"><svg … ><path … /></svg></span>
   *
   * @param {HTMLElement} parent element to append arrow to.
   * @param {string} color used as value of fill property.
   * @returns {HTMLElement} the added arrow element.
   */


  Popover.prototype._addArrow = function _addArrow(parent, color) {
    var element = document.createElement('span');
    element.classList.add(CLASS_ARROW);
    var svg = this.createSvgNode('svg', {
      class: CLASS_ARROW_SHAPE,
      width: ARROW_SIZE,
      height: ARROW_SIZE,
      viewBox: '0 0 ' + ARROW_SIZE + ' ' + ARROW_SIZE
    });
    // Draw a diamond square ◆
    var path = this.createSvgNode('path', {
      d: 'M' + ARROW_SIZE / 2 + ' 0 L ' + ARROW_SIZE + ' ' + ARROW_SIZE / 2 + ' L ' + ARROW_SIZE / 2 + ' ' + ARROW_SIZE + ' L 0 ' + ARROW_SIZE / 2 + ' Z',
      fill: color
    });
    svg.appendChild(path);
    element.appendChild(svg);
    parent.appendChild(element);
    return element;
  };

  return Popover;
}(_component2.default);

exports.default = Popover;
module.exports = exports['default'];

/***/ }),

/***/ "./source/progress/progress.js":
/*!*************************************!*\
  !*** ./source/progress/progress.js ***!
  \*************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _component = __webpack_require__(/*! ../component/component */ "./source/component/component.js");

var _component2 = _interopRequireDefault(_component);

var _limit = __webpack_require__(/*! ../util/limit */ "./source/util/limit.js");

var _limit2 = _interopRequireDefault(_limit);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var SELECTOR_COMPONENT = '.ci-js-progress';
var CLASS_CONTINUOUS = 'ci-progress-continuous';
var CLASS_BAR = 'ci-progress-bar';
var CLASS_IS_PENDING = 'is-pending';
var CLASS_IS_LOADING = 'is-loading';
var CLASS_IS_COMPLETE = 'is-complete';

/**
 * Class constructor for Progress AUI component.
 * Implements AUI component design pattern defined at:
 * https://github.com/...
 *
 * @param {HTMLElement} element The element that will be upgraded.
 */

var Progress = function (_Component) {
  _inherits(Progress, _Component);

  /**
   * Upgrades all Progress AUI components.
   * @returns {Array} Returns an array of all newly upgraded components.
   */
  Progress.upgradeElements = function upgradeElements() {
    var components = [];
    Array.from(document.querySelectorAll(SELECTOR_COMPONENT)).forEach(function (element) {
      if (!_component2.default.isElementUpgraded(element)) {
        components.push(new Progress(element));
      }
    });
    return components;
  };

  function Progress(element) {
    _classCallCheck(this, Progress);

    return _possibleConstructorReturn(this, _Component.call(this, element));
  }

  Progress.prototype.init = function init() {
    _Component.prototype.init.call(this);

    this._continuous = this._element.classList.contains(CLASS_CONTINUOUS);

    // Add bar elements:
    this._bar = document.createElement('span');
    this._bar.classList.add(CLASS_BAR);
    this._element.appendChild(this._bar);

    if (this._continuous) {
      this.progress(0);
    } else {
      this._progressvalue = this._element.getAttribute("data-progress-value");
      this.progress(this._progressvalue / 100);
    }
  };

  Progress.prototype.progress = function progress(ratio) {
    ratio = (0, _limit2.default)(ratio, 0, 1);
    this._progress = ratio;

    if (!this._continuous) {
      this._bar.style.width = this._progress * 100 + '%';
    }

    this.updateClasses();
  };

  Progress.prototype.updateClasses = function updateClasses() {
    if (this._progress === 0) {
      this._element.classList.add(CLASS_IS_PENDING);
    } else {
      this._element.classList.remove(CLASS_IS_PENDING);
    }

    if (this._progress > 0 && this._progress < 1) {
      this._element.classList.add(CLASS_IS_LOADING);
    } else {
      this._element.classList.remove(CLASS_IS_LOADING);
    }

    if (this._progress === 1) {
      this._element.classList.add(CLASS_IS_COMPLETE);
    } else {
      this._element.classList.remove(CLASS_IS_COMPLETE);
    }
  };

  return Progress;
}(_component2.default);

exports.default = Progress;
module.exports = exports['default'];

/***/ }),

/***/ "./source/radio/radio.js":
/*!*******************************!*\
  !*** ./source/radio/radio.js ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _component = __webpack_require__(/*! ../component/component */ "./source/component/component.js");

var _component2 = _interopRequireDefault(_component);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var SELECTOR_COMPONENT = '.ci-js-radio';
var CLASS_INPUT = 'ci-radio-input';
var CLASS_LABEL = 'ci-radio-label';
var CLASS_BOX = 'ci-radio-box';
var CLASS_TICK = 'ci-radio-tick';
var CLASS_IS_FOCUS = 'is-focused';
var CLASS_IS_CHECKED = 'is-checked';
var CLASS_IS_DISABLED = 'is-disabled';

var _radios = [];

/**
 * Class constructor for Radio AUI component.
 * Implements AUI component design pattern defined at:
 * https://github.com/...
 *
 * @param {HTMLElement} element The element that will be upgraded.
 */

var Radio = function (_Component) {
  _inherits(Radio, _Component);

  function Radio() {
    _classCallCheck(this, Radio);

    return _possibleConstructorReturn(this, _Component.apply(this, arguments));
  }

  /**
   * Upgrades all Radio AUI components.
   * @returns {Array} Returns an array of all newly upgraded components.
   */
  Radio.upgradeElements = function upgradeElements() {
    var components = [];
    Array.from(document.querySelectorAll(SELECTOR_COMPONENT)).forEach(function (element) {
      if (!_component2.default.isElementUpgraded(element)) {
        components.push(new Radio(element));
      }
    });
    _radios = _radios.concat(components);

    return components;
  };

  Radio.prototype.init = function init() {
    var _this2 = this;

    _Component.prototype.init.call(this);

    this._input = this._element.querySelector('.' + CLASS_INPUT);
    this._input.addEventListener('change', this._changeHandler = function (event) {
      return _this2._onChange(event);
    });
    this._input.addEventListener('focus', this._focusHandler = function (event) {
      return _this2._onFocus(event);
    });
    this._input.addEventListener('blur', this._blurHandler = function (event) {
      return _this2._onBlur(event);
    });

    // Insert box with tick after label element:
    this._label = this._element.querySelector('.' + CLASS_LABEL);
    var box = document.createElement('span');
    box.classList.add(CLASS_BOX);
    this._label.parentNode.insertBefore(box, this._label.nextSibling);
    var tick = document.createElement('span');
    tick.classList.add(CLASS_TICK);
    box.appendChild(tick);

    this.groupName = this._input.getAttribute('name');

    this.updateClasses();
  };

  Radio.prototype.updateClasses = function updateClasses() {
    this.checkDisabled();
    this.checkToggleState();
    this.checkFocus();
  };

  /**
   * Check the disabled state and update field accordingly.
   */


  Radio.prototype.checkDisabled = function checkDisabled() {
    if (this._input.disabled) {
      this._element.classList.add(CLASS_IS_DISABLED);
    } else {
      this._element.classList.remove(CLASS_IS_DISABLED);
    }
  };

  /**
   * Check the toggle state and update field accordingly.
   */


  Radio.prototype.checkToggleState = function checkToggleState() {
    if (this._input.checked) {
      this._element.classList.add(CLASS_IS_CHECKED);
    } else {
      this._element.classList.remove(CLASS_IS_CHECKED);
    }
  };

  /**
   * Check the focus state and update field accordingly.
   */


  Radio.prototype.checkFocus = function checkFocus() {
    if (Boolean(this._element.querySelector(':focus'))) {
      this._element.classList.add(CLASS_IS_FOCUS);
    } else {
      this._element.classList.remove(CLASS_IS_FOCUS);
    }
  };

  /**
   * Enable radio.
   */


  Radio.prototype.enable = function enable() {
    this._input.disabled = false;
    this.updateClasses();
  };

  /**
   * Disable radio.
   */


  Radio.prototype.disable = function disable() {
    this._input.disabled = true;
    this.updateClasses();
  };

  /**
   * Check radio.
   */


  Radio.prototype.check = function check() {
    this._input.checked = true;
    this.updateClasses();
  };

  /**
   * Uncheck radio.
   */


  Radio.prototype.uncheck = function uncheck() {
    this._input.checked = false;
    this.updateClasses();
  };

  /**
   * Dispose component
   */


  Radio.prototype.dispose = function dispose() {
    _Component.prototype.dispose.call(this);

    this._input.removeEventListener('change', this._changeHandler);
    this._input.removeEventListener('focus', this._focusHandler);
    this._input.removeEventListener('blur', this._blurHandler);

    this._element.removeChild(this._element.querySelector('.' + CLASS_BOX));
  };

  /**
   * Handle change event.
   * @param {Event} event that fired.
   */


  Radio.prototype._onChange = function _onChange(event) {
    this.updateClasses();
    // Since other radio buttons don't get change events, we need to look for
    // them to update their classes.
    for (var i = 0; i < _radios.length; i++) {
      var button = _radios[i];
      // Different name == different group, so no point updating those.
      if (button._input.getAttribute('name') === this.groupName) {
        button.updateClasses();
      }
    }
  };

  // TODO Find out why unfocus is triggered on mousedown


  Radio.prototype._onFocus = function _onFocus(event) {
    this._element.classList.add(CLASS_IS_FOCUS);
  };

  Radio.prototype._onBlur = function _onBlur(event) {
    this._element.classList.remove(CLASS_IS_FOCUS);
  };

  /**
   * Getter and Setter
   */

  _createClass(Radio, [{
    key: 'input',
    get: function get() {
      return this._input;
    }
  }, {
    key: 'checked',
    get: function get() {
      return this._input.checked = true;
    },
    set: function set(value) {
      if (value) {
        this.check();
      } else {
        this.uncheck();
      }
    }
  }, {
    key: 'disabled',
    get: function get() {
      return this._input.disabled = true;
    },
    set: function set(value) {
      if (value) {
        this.disable();
      } else {
        this.enable();
      }
    }
  }]);

  return Radio;
}(_component2.default);

exports.default = Radio;
module.exports = exports['default'];

/***/ }),

/***/ "./source/response/response.js":
/*!*************************************!*\
  !*** ./source/response/response.js ***!
  \*************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _component = __webpack_require__(/*! ../component/component */ "./source/component/component.js");

var _component2 = _interopRequireDefault(_component);

var _animationEndEvent = __webpack_require__(/*! ../util/animation-end-event */ "./source/util/animation-end-event.js");

var _animationEndEvent2 = _interopRequireDefault(_animationEndEvent);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var SELECTOR_COMPONENT = '.js-response';
var CLASS_BUTTON_PRIMARY = 'primary';
var CLASS_BUTTON_SECONDARY = 'secondary';
var CLASS_BUTTON_ICON = 'button-icon';
var CLASS_BUTTON_FLOATING = 'button-floating';
var CLASS_RESPONSE = 'response';
var CLASS_RESPONSE_MASKED = 'response-masked';
var CLASS_EFFECT = 'response-effect';
var CLASS_EFFECT_LARGE = 'response-effect-large';
var CLASS_IS_ANIMATING = 'animating';
var CLASS_IS_DISABLED = 'is-disabled';

/**
 * Class constructor for Response AUI component.
 * Implements AUI component design pattern defined at:
 * https://github.com/...
 *
 * @param {HTMLElement} element The element that will be upgraded.
 */

var Response = function (_Component) {
  _inherits(Response, _Component);

  /**
   * Upgrades all Response AUI components.
   * @returns {Array} Returns an array of all newly upgraded components.
   */
  Response.upgradeElements = function upgradeElements() {
    var components = [];
    Array.from(document.querySelectorAll(SELECTOR_COMPONENT)).forEach(function (element) {
      if (!_component2.default.isElementUpgraded(element)) {
        components.push(new Response(element));
      }
    });
    return components;
  };

  /**
   * Constructor
   * @constructor
   * @param {HTMLElement} element The element of the AUI component.
   */
  function Response(element) {
    _classCallCheck(this, Response);

    return _possibleConstructorReturn(this, _Component.call(this, element));
  }

  /**
   * Initialize component
   */


  Response.prototype.init = function init() {
    var _this2 = this;

    _Component.prototype.init.call(this);

    var boxedButton = this._element.classList.contains(CLASS_BUTTON_PRIMARY) || this._element.classList.contains(CLASS_BUTTON_SECONDARY) || this._element.classList.contains(CLASS_BUTTON_FLOATING);

    this._useTriggerX = boxedButton || !this._element.classList.contains(CLASS_BUTTON_ICON);
    this._useTriggerY = boxedButton;
    this._masked = boxedButton;
    this._large = boxedButton;

    this._responseContainer = document.createElement('span');
    this._responseContainer.classList.add(CLASS_RESPONSE);
    if (this._masked) {
      this._responseContainer.classList.add(CLASS_RESPONSE_MASKED);
    }
    this._element.appendChild(this._responseContainer);

    this._responseEffect = document.createElement('span');
    this._responseEffect.classList.add(CLASS_EFFECT);
    if (this._large) {
      this._responseEffect.classList.add(CLASS_EFFECT_LARGE);
    }
    this._responseContainer.appendChild(this._responseEffect);

    this._element.addEventListener('mousedown', this._mousedownHandler = function (event) {
      return _this2._onMousedown(event);
    });
    _animationEndEvent2.default && this._responseEffect.addEventListener(_animationEndEvent2.default, this._animationendHandler = function (event) {
      return _this2._onAnimationend(event);
    });
  };

  /**
   * Dispose component
   */


  Response.prototype.dispose = function dispose() {
    _Component.prototype.dispose.call(this);

    this._element.removeEventListener('mousedown', this._mousedownHandler);
    if (_animationEndEvent2.default && this._responseEffect) {
      this._responseEffect.removeEventListener(_animationEndEvent2.default, this._animationendHandler);
    }
    this._element.removeChild(this._responseContainer);
  };

  /**
   * Handle mousedown of element.
   * @param {Event} event The event that fired.
   * @private
   */


  Response.prototype._onMousedown = function _onMousedown(event) {
    // Get cross-browser offsetX, offsetY
    var target = event.currentTarget || event.srcElement,
        rect = target.getBoundingClientRect(),
        offsetX = event.clientX - rect.left,
        offsetY = event.clientY - rect.top;

    if (!target.classList.contains(CLASS_IS_DISABLED)) {
      this._responseEffect.style.left = this._useTriggerX ? offsetX + 'px' : '50%';
      this._responseEffect.style.top = this._useTriggerY ? offsetY + 'px' : '50%';
      this._responseContainer.classList.add(CLASS_IS_ANIMATING);
    }
  };

  /**
   * Handle animationend of element.
   * @param {Event} event The event that fired.
   * @private
   */


  Response.prototype._onAnimationend = function _onAnimationend(event) {
    this._responseContainer.classList.remove(CLASS_IS_ANIMATING);
  };

  return Response;
}(_component2.default);

exports.default = Response;
module.exports = exports['default'];

/***/ }),

/***/ "./source/select/select.js":
/*!*********************************!*\
  !*** ./source/select/select.js ***!
  \*********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _component = __webpack_require__(/*! ../component/component */ "./source/component/component.js");

var _component2 = _interopRequireDefault(_component);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var SELECTOR_COMPONENT = '.ci-js-select';
var CLASS_INPUT = 'ci-select-input';
var CLASS_LABEL = 'ci-select-label';
var CLASS_FOCUS_LINE = 'ci-select-focus-line';
var CLASS_IS_FOCUS = 'is-focused';
var CLASS_IS_DIRTY = 'is-dirty';
var CLASS_IS_DISABLED = 'is-disabled';

/**
 * Class constructor for Select AUI component.
 * Implements AUI component design pattern defined at:
 * https://github.com/...
 *
 * @param {HTMLElement} element The element that will be upgraded.
 */

var Select = function (_Component) {
  _inherits(Select, _Component);

  /**
   * Upgrades all Select AUI components.
   * @returns {Array} Returns an array of all newly upgraded components.
   */
  Select.upgradeElements = function upgradeElements() {
    var components = [];
    Array.from(document.querySelectorAll(SELECTOR_COMPONENT)).forEach(function (element) {
      if (!_component2.default.isElementUpgraded(element)) {
        components.push(new Select(element));
      }
    });
    return components;
  };

  function Select(element) {
    _classCallCheck(this, Select);

    return _possibleConstructorReturn(this, _Component.call(this, element));
  }

  Select.prototype.init = function init() {
    var _this2 = this;

    _Component.prototype.init.call(this);

    this._label = this._element.querySelector('.' + CLASS_LABEL);

    this._input = this._element.querySelector('.' + CLASS_INPUT);
    this._input.addEventListener('change', this._changeHandler = function (event) {
      return _this2._onChange(event);
    });
    this._input.addEventListener('focus', this._focusHandler = function (event) {
      return _this2._onFocus(event);
    });
    this._input.addEventListener('blur', this._blurHandler = function (event) {
      return _this2._onBlur(event);
    });
    this._input.addEventListener('reset', this._resetHandler = function (event) {
      return _this2._onReset(event);
    });

    // Insert thick focus line after select element:
    var focusLine = document.createElement('span');
    focusLine.classList.add(CLASS_FOCUS_LINE);
    this._label.parentNode.insertBefore(focusLine, this._label.nextSibling);

    this.updateClasses();
  };

  Select.prototype.updateClasses = function updateClasses() {
    this.checkDisabled();
    this.checkDirty();
    this.checkFocus();
  };

  /**
   * Check the disabled state and update field accordingly.
   */


  Select.prototype.checkDisabled = function checkDisabled() {
    if (this._input.disabled) {
      this._element.classList.add(CLASS_IS_DISABLED);
    } else {
      this._element.classList.remove(CLASS_IS_DISABLED);
    }
  };

  /**
   * Check the dirty state and update field accordingly.
   */


  Select.prototype.checkDirty = function checkDirty() {
    // console.log('value', this._input.value, typeof this._input.value);
    // console.log('options', this._input.options[this._input.selectedIndex].disabled);
    if (!this._input.options[this._input.selectedIndex].disabled) {
      this._element.classList.add(CLASS_IS_DIRTY);
    } else {
      this._element.classList.remove(CLASS_IS_DIRTY);
    }
  };

  /**
   * Check the focus state and update field accordingly.
   */


  Select.prototype.checkFocus = function checkFocus() {
    if (Boolean(this._element.querySelector(':focus'))) {
      this._element.classList.add(CLASS_IS_FOCUS);
    } else {
      this._element.classList.remove(CLASS_IS_FOCUS);
    }
  };

  /**
   * Disable text field.
   */


  Select.prototype.disable = function disable() {
    this._input.disabled = true;
    this.updateClasses();
  };

  /**
   * Event Handler
   */

  Select.prototype._onChange = function _onChange(event) {
    this.updateClasses();
  };

  Select.prototype._onFocus = function _onFocus(event) {
    this._element.classList.add(CLASS_IS_FOCUS);
  };

  Select.prototype._onBlur = function _onBlur(event) {
    this._element.classList.remove(CLASS_IS_FOCUS);
  };

  Select.prototype._onReset = function _onReset(event) {
    this.updateClasses();
  };

  return Select;
}(_component2.default);

exports.default = Select;
module.exports = exports['default'];

/***/ }),

/***/ "./source/slider/slider.js":
/*!*********************************!*\
  !*** ./source/slider/slider.js ***!
  \*********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _component = __webpack_require__(/*! ../component/component */ "./source/component/component.js");

var _component2 = _interopRequireDefault(_component);

var _limit = __webpack_require__(/*! ../util/limit */ "./source/util/limit.js");

var _limit2 = _interopRequireDefault(_limit);

var _mapLinear = __webpack_require__(/*! ../util/map-linear */ "./source/util/map-linear.js");

var _mapLinear2 = _interopRequireDefault(_mapLinear);

var _resizeObserver = __webpack_require__(/*! ../util/resize-observer */ "./source/util/resize-observer.js");

var _resizeObserver2 = _interopRequireDefault(_resizeObserver);

var _nouislider = __webpack_require__(/*! nouislider */ "./node_modules/nouislider/distribute/nouislider.js");

var _nouislider2 = _interopRequireDefault(_nouislider);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * NOTE Slider AUI components rely on the 3rd party library noUiSlider.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @see https://github.com/leongersen/noUiSlider
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */

var SELECTOR_COMPONENT = '.ci-js-slider';
var SELECTOR_HIDDEN_FIELD = '.ci-slider-hidden-field';
var SELECTOR_OUTPUT = '.ci-slider-output';
var CLASS_COMPONENT = 'ci-slider';
var CLASS_IS_DISABLED = 'is-disabled';
var EVENT_NAMESPACE = CLASS_COMPONENT;

/**
 * Class constructor for Slider AUI component.
 * Implements AUI component design pattern defined at:
 * https://github.com/...
 *
 * @param {HTMLElement} element The element that will be upgraded.
 */

var Slider = function (_Component) {
  _inherits(Slider, _Component);

  function Slider() {
    _classCallCheck(this, Slider);

    return _possibleConstructorReturn(this, _Component.apply(this, arguments));
  }

  /**
   * Upgrades all Slider AUI components.
   * @returns {Array} Returns an array of all newly upgraded components.
   */
  Slider.upgradeElements = function upgradeElements() {
    var components = [];
    Array.from(document.querySelectorAll(SELECTOR_COMPONENT)).forEach(function (element) {
      if (!_component2.default.isElementUpgraded(element)) {
        components.push(new Slider(element));
      }
    });
    return components;
  };

  /**
   * Initialize component
   */
  Slider.prototype.init = function init() {
    var _this2 = this;

    _Component.prototype.init.call(this);

    // Save reference to component elements
    this._hiddenField = this._element.querySelector(SELECTOR_HIDDEN_FIELD);
    this._output = this._element.querySelector(SELECTOR_OUTPUT);

    // Create slider container element
    this._slider = document.createElement('div');
    this._element.insertBefore(this._slider, this._element.firstChild);

    // Parse and save start and range values:
    this._value = this._parseData(this._hiddenField.value);
    this._rangeMin = this._parseData(this._element.getAttribute('data-min'));
    this._rangeMax = this._parseData(this._element.getAttribute('data-max'));

    // Create noUiSlider instance
    _nouislider2.default.create(this._slider, {
      // Set the start value defined in the hidden field.
      // https://refreshless.com/nouislider/slider-options/#section-start
      start: this._value,

      // Set the range as defined in the data attributes
      // https://refreshless.com/nouislider/slider-values/#section-range
      range: {
        min: this._rangeMin,
        max: this._rangeMax
      },

      // If there are two handles, set the bar between the handles, but not
      // between the handles and the sliders edges. If there is only one handle,
      // set the bar from the slider edge to the handle.
      // https://refreshless.com/nouislider/slider-options/#section-Connect
      connect: this._value.length > 1 ? true : [true, false],

      // Define behaviour depending on number of handles
      // https://refreshless.com/nouislider/behaviour-option/
      behaviour: this._value.length > 1 ? 'tap-drag' : 'tap',

      // Use AUI namespace for css classes
      // https://refreshless.com/nouislider/more/#section-styling
      cssPrefix: CLASS_COMPONENT + '-'
    });
    this._slider.noUiSlider.on('update.' + EVENT_NAMESPACE, function (values, handle, unencoded, tap, positions) {
      return _this2._onUpdate(values, handle, unencoded, tap, positions);
    });

    if (this._output) {
      this._resizeObserver = new _resizeObserver2.default();
      this._resizeObserver.resized.add(this._resizedHandler = function () {
        return _this2._centerOutput();
      });
    }

    if (this._element.classList.contains(CLASS_IS_DISABLED)) {
      this.disable();
    }
  };

  /**
   * Dispose component
   */


  Slider.prototype.dispose = function dispose() {
    if (this._slider) {
      this._slider.noUiSlider.off('.' + EVENT_NAMESPACE);
    }
    if (this._resizeObserver) {
      this._resizeObserver.resized.remove(this._resizedHandler);
      this._resizeObserver = null;
    }
  };

  /**
   * Enable component
   */


  Slider.prototype.enable = function enable() {
    this._element.classList.remove(CLASS_IS_DISABLED);
    this._slider.removeAttribute('disabled');
  };

  /**
   * Disable component
   */


  Slider.prototype.disable = function disable() {
    this._element.classList.add(CLASS_IS_DISABLED);
    this._slider.setAttribute('disabled', true);
  };

  /**
   * Handle on update
   * @param {Array} values Current slider values
   * @param {Integer} handle Handle that caused the event 0 or 1
   * @param {Array} unencoded Slider values without formatting
   * @param {boolean} tap Event was caused by the user tapping the slider
   * @param {Array} positions Left offset of the handles in relation to the slider
   */


  Slider.prototype._onUpdate = function _onUpdate(values, handle, unencoded, tap, positions) {
    if (this._hiddenField) {
      this._hiddenField.value = unencoded;
    }

    // Position output to center of slider handles
    if (this._output) {
      this._output.innerHTML = values.length > 1 ? values[0] + ' to ' + values[1] : '' + values[0];
      this._centerOutput();
    }
  };

  /**
   * Center output bewteen handles.
   */


  Slider.prototype._centerOutput = function _centerOutput() {
    var unencoded = this._slider.noUiSlider.get();
    var sliderAverage = (typeof unencoded === 'undefined' ? 'undefined' : _typeof(unencoded)) === 'object' ? unencoded.reduce(function (previousValue, currentValue) {
      return previousValue + parseFloat(currentValue);
    }, 0) / unencoded.length : parseFloat(unencoded);
    var maxRight = this._element.offsetWidth - this._output.offsetWidth;
    var handleSize = this._slider.offsetHeight;
    var position = (0, _mapLinear2.default)(sliderAverage, this._rangeMin, this._rangeMax, 0, 1) * this._slider.offsetWidth - this._output.offsetWidth / 2 + handleSize / 2;
    this._output.style.left = (0, _limit2.default)(position, 0, maxRight) + 'px';
  };

  /**
   * Parse data to use with noUiSlider
   * Returns given value as array of floats
   * "0,100" => [0,100]
   * @param {string} value Current slider values
   * @returns {Array} values as floats
   */


  Slider.prototype._parseData = function _parseData(value) {
    return value && value.split(',').map(function (element) {
      return parseFloat(element);
    });
  };

  return Slider;
}(_component2.default);

exports.default = Slider;
module.exports = exports['default'];

/***/ }),

/***/ "./source/spinner/spinner.js":
/*!***********************************!*\
  !*** ./source/spinner/spinner.js ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _component = __webpack_require__(/*! ../component/component */ "./source/component/component.js");

var _component2 = _interopRequireDefault(_component);

var _objectResize = __webpack_require__(/*! ../util/object-resize */ "./source/util/object-resize.js");

var _objectResize2 = _interopRequireDefault(_objectResize);

var _limit = __webpack_require__(/*! ../util/limit */ "./source/util/limit.js");

var _limit2 = _interopRequireDefault(_limit);

var _bezierEasing = __webpack_require__(/*! bezier-easing */ "./node_modules/bezier-easing/src/index.js");

var _bezierEasing2 = _interopRequireDefault(_bezierEasing);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var SELECTOR_COMPONENT = '.ci-js-spinner';
var CLASS_CONTINUOUS = 'ci-spinner-continuous';
var CLASS_SHAPE = 'ci-spinner-svg';
var CLASS_PATH = 'ci-spinner-path';
var CLASS_PATH_PROGRESS = 'ci-spinner-path-progress';
var CLASS_GROUP = 'ci-spinner-group';
var CLASS_GROUP_BASE_PATH = 'ci-spinner-group-base';
var CLASS_GROUP_PROGRESS_PATH = 'ci-spinner-group-progress';
var CLASS_VALUE = 'ci-spinner-value';
var CLASS_IS_PENDING = 'is-pending';
var CLASS_IS_LOADING = 'is-loading';
var CLASS_IS_COMPLETE = 'is-complete';
var CLASS_HAS_SVG = 'has-svg';
var SIZE = 48;
var RADIUS = 22;
var STROKE_WIDTH = 3;
var LOOP_ANIMATION_DURATION = 1.5;
var LOOP_ANIMATION = [{
  dashLength: 0,
  dashOffset: 0,
  rotate: 0
}, {
  dashLength: 0.65,
  dashOffset: -1,
  rotate: 360
}];

/**
 * Class constructor for Spinner AUI component.
 * Implements AUI component design pattern defined at:
 * https://github.com/...
 *
 * @param {HTMLElement} element The element that will be upgraded.
 */

var Spinner = function (_Component) {
  _inherits(Spinner, _Component);

  /**
   * Upgrades all Spinner AUI components.
   * @returns {Array} Returns an array of all newly upgraded components.
   */
  Spinner.upgradeElements = function upgradeElements() {
    var components = [];
    Array.from(document.querySelectorAll(SELECTOR_COMPONENT)).forEach(function (element) {
      if (!_component2.default.isElementUpgraded(element)) {
        components.push(new Spinner(element));
      }
    });
    return components;
  };

  function Spinner(element) {
    _classCallCheck(this, Spinner);

    return _possibleConstructorReturn(this, _Component.call(this, element));
  }

  Spinner.prototype.init = function init() {
    _Component.prototype.init.call(this);

    this._objectResize = new _objectResize2.default(this._element, this.resize, this);

    this._continuous = this._element.classList.contains(CLASS_CONTINUOUS);

    // Add value element, if required:
    if (!this._continuous) {
      this._value = document.createElement('span');
      this._value.classList.add(CLASS_VALUE);
      this._element.appendChild(this._value);
      this._progressvalue = this._element.getAttribute("data-progress-value");
    }

    var shape = void 0,
        group = void 0,
        groupCircle1 = void 0,
        groupCircle2 = void 0,
        circle1 = void 0,
        circle2 = void 0;

    if (!this._element.classList.contains(CLASS_HAS_SVG)) {
      // Add SVG graphic:
      // <svg class="ci-spinner-shape" viewBox="0 0 200 200">
      //   <g class="ci-spinner-group">
      //     <circle class="ci-spinner-path" cx="0" cy="0" r="100" />
      //     <circle class="ci-spinner-path ci-spinner-path-progress" cx="0" cy="0" r="100" />
      //   </g>
      // </svg>
      shape = this.createSvgNode('svg', {
        class: CLASS_SHAPE,
        viewBox: '0 0 ' + SIZE + ' ' + SIZE
      });
      group = this.createSvgNode('g', { class: CLASS_GROUP });
      groupCircle1 = this.createSvgNode('g', { class: CLASS_GROUP_BASE_PATH });
      groupCircle2 = this.createSvgNode('g', { class: CLASS_GROUP_PROGRESS_PATH });
      circle1 = this.createSvgNode('circle', {
        class: CLASS_PATH,
        cx: 0,
        cy: 0,
        r: RADIUS
      });
      circle2 = this.createSvgNode('circle', {
        class: CLASS_PATH + ' ' + CLASS_PATH_PROGRESS,
        cx: 0,
        cy: 0,
        r: RADIUS,
        transform: 'rotate(-90)'
      });
      groupCircle1.appendChild(circle1);
      groupCircle2.appendChild(circle2);
      group.appendChild(groupCircle1);
      group.appendChild(groupCircle2);
      shape.appendChild(group);
      this._element.appendChild(shape);
    } else {
      // BENUTZE VORHANDENES SVG:
      shape = this._element.getElementsByTagName("svg")[0];
      group = shape.getElementsByTagName("g")[0];
      groupCircle1 = group.getElementsByTagName("g")[0];
      groupCircle2 = group.getElementsByTagName("g")[1];
      circle1 = groupCircle1.getElementsByTagName("circle")[0];
      circle2 = groupCircle2.getElementsByTagName("circle")[0];
    }

    this._shape = shape;
    this._group = group;
    this._progressPath = circle2;
    this._basePath = circle1;
    this._groupProgress = groupCircle2;

    this._easing = (0, _bezierEasing2.default)(0.75, 0.02, 0.5, 1);
    this._easingDasharray = (0, _bezierEasing2.default)(0.4, 0, 0, 1);
    this._progressPath.style.strokeOpacity = 0;

    this.resize();

    // TODO: nur zur show in den docs:
    // this.progress(0);
    if (this._continuous) this.progress(0);else this.progress(this._progressvalue / 100);
  };

  Spinner.prototype.progress = function progress(ratio) {
    ratio = (0, _limit2.default)(ratio, 0, 1);
    this._progress = ratio;
    var pathLength = this._getCircleLength(this._progressPath);

    if (!this._continuous) {
      this._progressPath.style.strokeDasharray = this._progress === 1 ? 'none' : this._progress * pathLength + ', ' + pathLength;
      this._progressPath.style.strokeOpacity = this._progress === 0 ? 0 : 1;
    } else {
      this.loop();
    }

    if (this._value) {
      this._value.innerHTML = '' + Math.round(this._progress * 100);
    }

    this._updateClasses();
  };

  Spinner.prototype.loop = function loop() {
    var _this2 = this;

    if (this._continuous) {
      this._progressPath.style.strokeOpacity = 1;
      window.requestAnimationFrame(function (timestamp) {
        return _this2._animateLoop(timestamp);
      });
    }
  };

  Spinner.prototype.stop = function stop() {};

  Spinner.prototype.resize = function resize() {
    var size = this._element.offsetWidth;
    var radius = (size - STROKE_WIDTH) / 2;
    this._shape.setAttributeNS(null, 'viewBox', size / -2 + ' ' + size / -2 + ' ' + size + ' ' + size);
    this._basePath.setAttributeNS(null, 'r', '' + radius);
    this._progressPath.setAttributeNS(null, 'r', '' + radius);
  };

  // TODO Optimize calculations; wording.


  Spinner.prototype._animateLoop = function _animateLoop(timestamp) {
    var _this3 = this;

    if (!this._loopStart) {
      this._loopStart = timestamp;
    }

    // The progress in seconds 0 <= progress <= LOOP_ANIMATION_DURATION
    var progress = (timestamp - this._loopStart) / 1000;
    // The progress ratio between 0 <= progressRatio <= 1
    var progressRatio = progress / LOOP_ANIMATION_DURATION;
    if (progressRatio > 1 || progressRatio === 0) {
      this._animationEndSet = false;
      progress = 0;
      progressRatio = 0;
      this._loopStart = timestamp;
      this._dashLengthStart = LOOP_ANIMATION[0].dashLength;
      this._dashOffsetStart = LOOP_ANIMATION[0].dashOffset;
      this._dashLengthEnd = LOOP_ANIMATION[1].dashLength;
      this._dashOffsetEnd = LOOP_ANIMATION[1].dashOffset;
    }
    var ease = this._easing(progressRatio);
    var pathLength = this._getCircleLength(this._progressPath);
    this._dashLengthRatio = this._dashLengthStart + (this._dashLengthEnd - this._dashLengthStart) * this._easingDasharray(progressRatio);
    this._dashOffsetRatio = this._dashOffsetStart + (this._dashOffsetEnd - this._dashOffsetStart) * ease;
    this._rotate = LOOP_ANIMATION[1].rotate * ease;

    var dashLength = pathLength * this._dashLengthRatio;
    var dashOffset = pathLength * this._dashOffsetRatio;

    this._progressPath.style.strokeDasharray = dashLength + ', ' + pathLength;
    this._progressPath.style.strokeDashoffset = '' + dashOffset;
    // this._group.setAttributeNS(null, 'transform', `rotate(${this._rotate})`);
    this._groupProgress.setAttributeNS(null, 'transform', 'rotate(' + this._rotate + ')');

    window.requestAnimationFrame(function (timestamp) {
      return _this3._animateLoop(timestamp);
    });
  };

  Spinner.prototype._updateClasses = function _updateClasses() {
    if (this._progress === 0) {
      this._element.classList.add(CLASS_IS_PENDING);
    } else {
      this._element.classList.remove(CLASS_IS_PENDING);
    }

    if (this._progress > 0 && this._progress < 1) {
      this._element.classList.add(CLASS_IS_LOADING);
    } else {
      this._element.classList.remove(CLASS_IS_LOADING);
    }

    if (this._progress === 1) {
      this._element.classList.add(CLASS_IS_COMPLETE);
    } else {
      this._element.classList.remove(CLASS_IS_COMPLETE);
    }
  };

  Spinner.prototype._getCircleLength = function _getCircleLength(circle) {
    var r = circle.getAttribute('r');
    return 2 * Math.PI * r;
  };

  return Spinner;
}(_component2.default);

exports.default = Spinner;
module.exports = exports['default'];

/***/ }),

/***/ "./source/textfield/textfield.js":
/*!***************************************!*\
  !*** ./source/textfield/textfield.js ***!
  \***************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _component = __webpack_require__(/*! ../component/component */ "./source/component/component.js");

var _component2 = _interopRequireDefault(_component);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var SELECTOR_COMPONENT = '.ci-js-textfield';
var CLASS_FIELD = 'ci-textfield-field';
var CLASS_INPUT = 'ci-textfield-input';
var CLASS_LABEL = 'ci-textfield-label';
var CLASS_FOCUS_LINE = 'ci-textfield-focus-line';
var CLASS_COUNTER = 'ci-textfield-counter';
var CLASS_COUNTER_VALUE = 'ci-textfield-counter-value';
var CLASS_IS_FOCUS = 'is-focused';
var CLASS_IS_DIRTY = 'is-dirty';
var CLASS_IS_INVALID = 'is-invalid';
var CLASS_IS_DISABLED = 'is-disabled';
var CLASS_IS_EQUAL_MAX_CHARS = 'is-equal-max-length';
var CLASS_IS_GREATER_MAX_CHARS = 'is-greater-max-length';
var ATTR_AUTOSIZE = 'data-autosize';

/**
 * Class constructor for Textfield AUI component.
 * Implements AUI component design pattern defined at:
 * https://github.com/...
 *
 * @param {HTMLElement} element The element that will be upgraded.
 */

var Textfield = function (_Component) {
  _inherits(Textfield, _Component);

  /**
   * Upgrades all Textfield AUI components.
   * @returns {Array} Returns an array of all newly upgraded components.
   */
  Textfield.upgradeElements = function upgradeElements() {
    var components = [];
    Array.from(document.querySelectorAll(SELECTOR_COMPONENT)).forEach(function (element) {
      if (!_component2.default.isElementUpgraded(element)) {
        components.push(new Textfield(element));
      }
    });
    return components;
  };

  function Textfield(element) {
    _classCallCheck(this, Textfield);

    return _possibleConstructorReturn(this, _Component.call(this, element));
  }

  Textfield.prototype.init = function init() {
    var _this2 = this;

    _Component.prototype.init.call(this);

    this._input = this._element.querySelector('.' + CLASS_INPUT);
    this._input.addEventListener('input', this._inputHandler = function (event) {
      return _this2._onInput(event);
    });
    //this._input.addEventListener('touchstart', this._touchHandler = (event) => this._onTouchStart(event));
    this._input.addEventListener('focus', this._focusHandler = function (event) {
      return _this2._onFocus(event);
    });
    this._input.addEventListener('blur', this._blurHandler = function (event) {
      return _this2._onBlur(event);
    });
    this._input.addEventListener('change', this._changeHandler = function (event) {
      return _this2._onChange(event);
    });
    this._input.addEventListener('reset', this._resetHandler = function (event) {
      return _this2._onReset(event);
    });

    // Insert counter if data attribute 'count' is present:
    if (this._element.getAttribute('data-count')) {
      this._maxChars = parseInt(this._element.getAttribute('data-count')) || 0;
      this._label = this._element.querySelector('.' + CLASS_FIELD);
      this._counter = document.createElement('span');
      this._counter.classList.add(CLASS_COUNTER);
      this._label.parentNode.insertBefore(this._counter, this._label.nextSibling);
      this._counterValue = document.createElement('span');
      this._counterValue.classList.add(CLASS_COUNTER_VALUE);
      this._counterValue.innerHTML = this._maxChars;
      this._counter.appendChild(this._counterValue);
      this._hasCounter = true;
    }

    // Insert thick focus line after label element:
    this._label = this._element.querySelector('.' + CLASS_LABEL);
    var focusLine = document.createElement('span');
    focusLine.classList.add(CLASS_FOCUS_LINE);
    this._label.parentNode.insertBefore(focusLine, this._label.nextSibling);

    // If textarea should adjust height to content
    if (this._element.hasAttribute(ATTR_AUTOSIZE) && this._element.getAttribute(ATTR_AUTOSIZE) !== 'false') {
      var style = window.getComputedStyle(this._input);
      this._inputPadding = parseInt(style.paddingTop) + parseInt(style.paddingBottom) || 0;
      this._inputBorder = parseInt(style.borderTop) + parseInt(style.borderBottom) || 0;
      this._input.addEventListener('keyup', this._keyupHandler = function (event) {
        return _this2._onKeyup(event);
      });
      this._autosize = true;
    }

    this.updateClasses();
  };

  Textfield.prototype.update = function update() {
    this.updateClasses();
    this.updateCounter();
    if (this._autosize) {
      this.adjustHeightToContent();
    }
  };

  Textfield.prototype.updateClasses = function updateClasses() {
    this.checkDisabled();
    this.checkDirty();
    this.checkFocus();
  };

  Textfield.prototype.updateCounter = function updateCounter() {
    if (this._counterValue) {
      var numChars = this._input.value.length;
      var remainingChars = this._maxChars - numChars;
      this._counterValue.innerHTML = remainingChars;

      if (remainingChars === 0) {
        this._element.classList.add(CLASS_IS_EQUAL_MAX_CHARS);
      } else {
        this._element.classList.remove(CLASS_IS_EQUAL_MAX_CHARS);
      }

      if (remainingChars < 0) {
        this._element.classList.add(CLASS_IS_GREATER_MAX_CHARS);
        this._element.classList.add(CLASS_IS_INVALID);
      } else {
        this._element.classList.remove(CLASS_IS_GREATER_MAX_CHARS);
        this._element.classList.remove(CLASS_IS_INVALID);
      }
    }
  };

  /**
   * Check the disabled state and update field accordingly.
   */


  Textfield.prototype.checkDisabled = function checkDisabled() {
    if (this._input.disabled) {
      this._element.classList.add(CLASS_IS_DISABLED);
    } else {
      this._element.classList.remove(CLASS_IS_DISABLED);
    }
  };

  /**
   * Check the dirty state and update field accordingly.
   */


  Textfield.prototype.checkDirty = function checkDirty() {
    if (this._input.value && this._input.value.length > 0) {
      this._element.classList.add(CLASS_IS_DIRTY);
    } else {
      this._element.classList.remove(CLASS_IS_DIRTY);
    }
  };

  /**
   * Check the focus state and update field accordingly.
   */


  Textfield.prototype.checkFocus = function checkFocus() {
    var isFocused = false;
    var element = document.activeElement;

    while (element !== this._element && element !== null) {
      element = element.parentNode;
    }

    if (element === this._element) {
      isFocused = true;
      this._element.querySelector('input').focus();
    }

    if (Boolean(this._element.querySelector(':focus')) || isFocused) {
      this._element.classList.add(CLASS_IS_FOCUS);
    } else {
      this._element.classList.remove(CLASS_IS_FOCUS);
    }
  };

  /**
   * Resize textarea
   */


  Textfield.prototype.adjustHeightToContent = function adjustHeightToContent() {
    var htmlTop = window.pageYOffset;
    var bodyTop = document.body.scrollTop;
    var originalHeight = this._input.style.height;

    this._input.style.height = 'auto';
    if (this._input.scrollHeight === 0) {
      // If the scrollHeight is 0, then the element probably has display:none or is detached from the DOM.
      this._input.style.height = originalHeight;
      return;
    }
    this._input.style.height = this._input.scrollHeight + this._inputBorder + 'px';

    // prevents scroll position jump
    document.documentElement.scrollTop = htmlTop;
    document.body.scrollTop = bodyTop;
  };

  /**
   * Disable text field.
   */


  Textfield.prototype.disable = function disable() {
    this._input.disabled = true;
    this.updateClasses();
  };

  /**
   * Dispose component
   */


  Textfield.prototype.dispose = function dispose() {
    _Component.prototype.dispose.call(this);

    this._input.removeEventListener('input', this._inputHandler);
    this._input.removeEventListener('focus', this._focusHandler);
    //this._input.removeEventListener('touch', this._touchHandler);
    this._input.removeEventListener('blur', this._blurHandler);
    this._input.removeEventListener('change', this._changeHandler);
    this._input.removeEventListener('reset', this._resetHandler);

    _Component.prototype.removeChild.call(this, this._element.querySelector('.' + CLASS_FOCUS_LINE));
    _Component.prototype.removeChild.call(this, this._element.querySelector('.' + CLASS_COUNTER));
  };

  /**
   * Event Handler
   */

  Textfield.prototype._onInput = function _onInput(event) {
    this.update();
  };

  Textfield.prototype._onFocus = function _onFocus(event) {
    this.update();
  };

  /*_onTouchStart(event) {
    this._element.focus();
    this.update();
  }*/

  Textfield.prototype._onBlur = function _onBlur(event) {
    this.update();
  };

  Textfield.prototype._onChange = function _onChange(event) {
    this.update();
  };

  Textfield.prototype._onReset = function _onReset(event) {
    this.update();
  };

  Textfield.prototype._onKeyup = function _onKeyup(event) {
    this.updateCounter();
    if (this._autosize) {
      this.adjustHeightToContent();
    }
  };

  /**
   * Getter and Setter
   */

  _createClass(Textfield, [{
    key: 'input',
    get: function get() {
      return this._input;
    }
  }, {
    key: 'autoSize',
    get: function get() {
      return this._autosize;
    },
    set: function set(value) {
      return this._autosize = Boolean(value);
    }
  }]);

  return Textfield;
}(_component2.default);

exports.default = Textfield;
module.exports = exports['default'];

/***/ }),

/***/ "./source/tooltip/tooltip.js":
/*!***********************************!*\
  !*** ./source/tooltip/tooltip.js ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _component = __webpack_require__(/*! ../component/component */ "./source/component/component.js");

var _component2 = _interopRequireDefault(_component);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var SELECTOR_COMPONENT = '.ci-js-tooltip';
var CLASS_TRIANGLE = 'ci-tooltip-triangle';
var CLASS_IS_UPGRADED = 'is-upgraded';
var CLASS_IS_ACTIVE = 'is-active';
var CLASS_IS_TOP = 'is-top';
var OFFSET_VIEWPORT_X = 10;
var OFFSET_TARGET_TOP = 12;
var OFFSET_TARGET_BOTTOM = 12;

/**
 * Class constructor for Tooltip AUI component.
 * Implements AUI component design pattern defined at:
 * https://github.com/...
 *
 * @param {HTMLElement} element The element that will be upgraded.
 */

var Tooltip = function (_Component) {
  _inherits(Tooltip, _Component);

  function Tooltip() {
    _classCallCheck(this, Tooltip);

    return _possibleConstructorReturn(this, _Component.apply(this, arguments));
  }

  /**
   * Upgrades all Tooltip AUI components.
   * @returns {Array} Returns an array of all newly upgraded components.
   */
  Tooltip.upgradeElements = function upgradeElements() {
    var components = [];
    Array.from(document.querySelectorAll(SELECTOR_COMPONENT)).forEach(function (element) {
      if (!_component2.default.isElementUpgraded(element)) {
        components.push(new Tooltip(element));
      }
    });
    return components;
  };

  /**
   * Initialize component
   */
  Tooltip.prototype.init = function init() {
    var _this2 = this;

    _Component.prototype.init.call(this);

    var forId = this._element.getAttribute('for');

    if (forId) {
      this._trigger = document.getElementById(forId);
    }

    if (this._trigger) {
      // Add triangle shape
      this._triangle = document.createElement('span');
      this._triangle.classList.add(CLASS_TRIANGLE);
      this._element.appendChild(this._triangle);

      // Prevent accidental text selection on Android
      if (!this._trigger.hasAttribute('tabindex')) {
        this._trigger.setAttribute('tabindex', '0');
      }

      this._trigger.addEventListener('mouseenter', this._boundMouseenter = function (event) {
        return _this2._onTriggerEnter(event);
      });
      this._trigger.addEventListener('mouseleave', this._boundMouseleave = function (event) {
        return _this2._onTriggerLeave(event);
      });
      this._trigger.addEventListener('focusin', this._boundfocusin = function (event) {
        return _this2._onTriggerEnter(event);
      });
      this._trigger.addEventListener('focusout', this._boundfocusout = function (event) {
        return _this2._onTriggerLeave(event);
      });
      this._trigger.addEventListener('touchstart', this._boundTouchstart = function (event) {
        return _this2._onTriggerEnter(event);
      });
      window.addEventListener('touchend', this._boundTouchendWindow = function (event) {
        return _this2._onTriggerLeaveOutside(event);
      });
    }
  };

  /**
   * Dispose component
   */


  Tooltip.prototype.dispose = function dispose() {
    this._trigger.removeEventListener('mouseenter', this._boundMouseenter);
    this._trigger.removeEventListener('mouseleave', this._boundMouseleave);
    this._trigger.removeEventListener('focusin', this._boundfocusin);
    this._trigger.removeEventListener('focusout', this._boundfocusout);
    this._trigger.removeEventListener('touchstart', this._boundTouchstart);
    window.removeEventListener('touchend', this._boundTouchendWindow);
    window.removeEventListener('scroll', this._boundScrollWindow);

    this._element.classList.remove(CLASS_IS_TOP, CLASS_IS_ACTIVE, CLASS_IS_UPGRADED);
    this._element.removeAttribute('style');
    this._element.removeChild(this._triangle);
  };

  /**
   * Open tooltip
   * @param {HTMLElement} trigger element that opens the tooltip.
   * @param {number} clientX the x-coordinate of trigger (mouse/touch).
   */


  Tooltip.prototype.open = function open(trigger, clientX) {
    var _this3 = this;

    if (!trigger) {
      return;
    }

    var rect = trigger.getBoundingClientRect();
    clientX = clientX || rect.left + rect.width / 2;
    var triggerX = clientX - rect.left;
    var yTop = rect.top - this._element.offsetHeight - OFFSET_TARGET_TOP;
    var yBottom = rect.bottom + OFFSET_TARGET_BOTTOM + 2;
    var x = rect.left + rect.width / 2 - this._element.offsetWidth / 2;
    var y = yBottom;
    var triangleX = 0;

    this._element.classList.remove(CLASS_IS_TOP);

    x = rect.left + triggerX - this._element.offsetWidth / 2;

    if (x < OFFSET_VIEWPORT_X) {
      x = OFFSET_VIEWPORT_X;
    }

    // If tooltip would be out of viewport on the right
    if (x + this._element.offsetWidth > window.innerWidth - OFFSET_VIEWPORT_X) {
      x = window.innerWidth - OFFSET_VIEWPORT_X - this._element.offsetWidth;
    }

    // If viewport height isn't large enough, place tooltip on top if possible
    if (yBottom + this._element.offsetHeight > window.innerHeight - OFFSET_VIEWPORT_X) {
      y = yTop;
      this._element.classList.add(CLASS_IS_TOP);
    }

    triangleX = triggerX + rect.left - x;

    this._element.classList.add(CLASS_IS_ACTIVE);
    this._element.style.left = x + 'px';
    this._element.style.top = y + 'px';

    this._triangle.style.left = triangleX + 'px';

    this._scrolled = false;
    window.addEventListener('scroll', this._boundScrollWindow = function (event) {
      return _this3._onScrollWindow(event);
    });
  };

  /**
   * Close tooltip.
   */


  Tooltip.prototype.close = function close() {
    window.removeEventListener('scroll', this._boundScrollWindow);
    this._element.classList.remove(CLASS_IS_ACTIVE);
  };

  /**
   * Handle enter event.
   * @param {Event} event that fired.
   */


  Tooltip.prototype._onTriggerEnter = function _onTriggerEnter(event) {
    this.open(event.target, event.clientX);
  };

  /**
   * Handle leave event.
   * @param {Event} event that fired.
   */


  Tooltip.prototype._onTriggerLeave = function _onTriggerLeave(event) {
    this.close();
  };

  /**
   * Handle leave outside event.
   * @param {Event} event that fired.
   */


  Tooltip.prototype._onTriggerLeaveOutside = function _onTriggerLeaveOutside(event) {
    if (!this._element.contains(event.target) && !this._trigger.contains(event.target)) {
      this.close();
    };
  };

  /**
   * Handle scroll event.
   * @param {Event} event that fired.
   */


  Tooltip.prototype._onScrollWindow = function _onScrollWindow(event) {
    window.removeEventListener('scroll', this._boundScrollWindow);
    if (!this._scrolled) {
      this.close();
      this._scrolled = true;
    }
  };

  return Tooltip;
}(_component2.default);

exports.default = Tooltip;
module.exports = exports['default'];

/***/ }),

/***/ "./source/util/animation-end-event.js":
/*!********************************************!*\
  !*** ./source/util/animation-end-event.js ***!
  \********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
// From Modernizr
function whichAnimationEvent() {
  var type = void 0;
  var element = document.createElement('fakeelement');
  var animations = {
    'animation': 'animationend',
    'OAnimation': 'oAnimationEnd',
    'MozAnimation': 'animationend',
    'WebkitAnimation': 'webkitAnimationEnd'
  };

  for (type in animations) {
    if (element.style[type] !== undefined) {
      return animations[type];
    }
  }
}

var ANIMATION_EVENT = whichAnimationEvent();

exports.default = ANIMATION_EVENT;
module.exports = exports['default'];

/***/ }),

/***/ "./source/util/closest.js":
/*!********************************!*\
  !*** ./source/util/closest.js ***!
  \********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = closest;
/**
 * Get the first element that matches the selector by testing the element itself
 * and traversing up through its ancestors in the DOM tree.
 * @param {HTMLElement} element to search wherefrom
 * @param {string} selector A string containing a selector expression to match elements against.
 * @param {HTMLElement} context A DOM element within which a matching element may be found.
 * @returns {HTMLElement} found element or null
 */
function closest(element, selector, context) {
  var matchesFn = void 0;

  ['matches', 'webkitMatchesSelector', 'mozMatchesSelector', 'msMatchesSelector', 'oMatchesSelector'].some(function (fn) {
    if (typeof document.body[fn] === 'function') {
      matchesFn = fn;
      return true;
    }
    return false;
  });

  var parent = void 0;

  // traverse parents
  parent = element;
  while (parent) {
    if (parent && parent[matchesFn](selector)) {
      return parent;
    }
    if (parent === context) {
      return null;
    }
    parent = parent.parentElement;
  }

  return null;
}
module.exports = exports['default'];

/***/ }),

/***/ "./source/util/limit.js":
/*!******************************!*\
  !*** ./source/util/limit.js ***!
  \******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = limit;
/**
 * Limits a value to x >= min and x <= max.
 * @param {number} x The value to limit.
 * @param {number} min The value to limit.
 * @param {number} max The value to limit.
 * @returns {number} The limited value.
 */
function limit(x, min, max) {
  if (x > max) x = max;
  if (x < min) x = min;
  return x;
}
module.exports = exports["default"];

/***/ }),

/***/ "./source/util/map-linear.js":
/*!***********************************!*\
  !*** ./source/util/map-linear.js ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = mapLinear;
/**
 * Linear mapping from range <a1, a2> to range <b1, b2>
 * @param {number} x The value to map
 * @param {number} a1 First endpoint of the range <a1, a2>
 * @param {number} a2 Final endpoint of the range <a1, a2>
 * @param {number} b1 First endpoint of the range <b1, b2>
 * @param {number} b2 Final endpoint of the range  <b1, b2>
 * @returns {number} The mapped value.
 */
function mapLinear(x, a1, a2, b1, b2) {
  return b1 + (x - a1) * (b2 - b1) / (a2 - a1);
}
module.exports = exports["default"];

/***/ }),

/***/ "./source/util/object-resize.js":
/*!**************************************!*\
  !*** ./source/util/object-resize.js ***!
  \**************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var ObjectResize = function () {
  function ObjectResize(parent, callback, callbackScope) {
    var _this = this;

    _classCallCheck(this, ObjectResize);

    var isIE = navigator.userAgent.match(/Trident/);

    // NOTE
    // this._parent.style.position != 'static'
    // this._parent.style.display = 'block'

    this._parent = parent;
    this._helperElement = document.createElement('object');
    this._helperElement.setAttribute('style', 'display: block; position: absolute; top: 0; left: 0; height: 100%; width: 100%; overflow: hidden; pointer-events: none; z-index: -1; border: 0px; opacity: 0;');
    this._helperElement.setAttribute('border', '0');
    this._helperElement.onload = function () {
      return _this._onLoad();
    };
    this._helperElement.type = 'text/html';
    if (isIE) {
      this._parent.appendChild(this._helperElement);
    }
    this._helperElement.data = 'about:blank';
    if (!isIE) {
      this._parent.appendChild(this._helperElement);
    }

    this._callback = callback;
    this._callbackScope = callbackScope;

    this._ticking = false;
  }

  ObjectResize.prototype._onLoad = function _onLoad(event) {
    var _this2 = this;

    this._helperElement.contentDocument.defaultView.addEventListener('resize', this._resizeHandler = function (event) {
      return _this2._onResize(event);
    });
  };

  ObjectResize.prototype._onResize = function _onResize(event) {
    var _this3 = this;

    if (!this._ticking) {
      window.requestAnimationFrame(function () {
        _this3._ticking = false;
        _this3._callback.call(_this3._callbackScope);
      });
    }
    this._ticking = true;
  };

  ObjectResize.prototype.dispose = function dispose() {
    this._helperElement.contentDocument.defaultView.removeEventListener('resize', this._resizeHandler);
    this._parent.removeChild(this._helperElement);
  };

  return ObjectResize;
}();

exports.default = ObjectResize;
module.exports = exports['default'];

/***/ }),

/***/ "./source/util/reflow.js":
/*!*******************************!*\
  !*** ./source/util/reflow.js ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = reflow;
/**
 * Trigger a reflow
 * @param {HTMLElement} element to trigger a reflow.
 */
function reflow(element) {
  new Function('bs', 'return bs')(element.offsetHeight);
}
module.exports = exports['default'];

/***/ }),

/***/ "./source/util/resize-observer.js":
/*!****************************************!*\
  !*** ./source/util/resize-observer.js ***!
  \****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _signal = __webpack_require__(/*! ../util/signal */ "./source/util/signal.js");

var _signal2 = _interopRequireDefault(_signal);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var instance = null;

var ResizeObserver = function () {
  function ResizeObserver() {
    _classCallCheck(this, ResizeObserver);

    if (!instance) {
      instance = this;
      this.init();
    }

    return instance;
  }

  ResizeObserver.prototype.init = function init() {
    var _this = this;

    this._ticking = false;

    this.resized = new _signal2.default();

    window.addEventListener('resize', this._resizeHandler = function (event) {
      return _this._onResize(event);
    });
  };

  ResizeObserver.prototype._onResize = function _onResize(event) {
    var _this2 = this;

    if (!this._ticking) {
      window.requestAnimationFrame(function () {
        _this2._ticking = false;
        _this2.resized.dispatch();
      });
    }
    this._ticking = true;
  };

  return ResizeObserver;
}();

exports.default = ResizeObserver;
module.exports = exports['default'];

/***/ }),

/***/ "./source/util/signal.js":
/*!*******************************!*\
  !*** ./source/util/signal.js ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var SignalBinding = function () {
  function SignalBinding(signal, listener, isOnce, priority) {
    _classCallCheck(this, SignalBinding);

    // Handler function bound to the signal.
    this._listener = listener;

    // If binding should be executed just once.
    this._isOnce = isOnce;

    // Reference to Signal object that listener is currently bound to.
    this._signal = signal;

    // Listener priority
    this._priority = priority || 0;

    // If binding is active and should be executed.
    this._active = true;
  }

  SignalBinding.prototype._isBound = function _isBound() {
    return !!this._signal && !!this._listener;
  };

  /**
   * Call listener passing arbitrary parameters.
   * If binding was added using `Signal.addOnce()` it will be automatically
   * removed from signal dispatch queue, this method is used internally for
   * the signal dispatch.
   * @param {Array} params Array of parameters that should be passed to the listener
   * @returns {*} Value returned by the listener.
   */


  SignalBinding.prototype.execute = function execute(params) {
    var handlerReturn = void 0;
    if (this._active && !!this._listener) {
      handlerReturn = this._listener.apply(this._context, params);
      if (this._isOnce) {
        this.detach();
      }
    }
    return handlerReturn;
  };

  /**
   * Detach binding from signal.
   * - alias to: mySignal.remove(myBinding.getListener());
   * @returns {Function|null} Handler function bound to the signal or `null` if binding was previously detached.
   */


  SignalBinding.prototype.detach = function detach() {
    return this._isBound() ? this._signal.remove(this._listener) : null;
  };

  SignalBinding.prototype.dispose = function dispose() {
    delete this._signal;
    delete this._listener;
  };

  SignalBinding.prototype.toString = function toString() {
    return '[SignalBinding isOnce:' + this._isOnce + ', isBound:' + this.isBound() + ', active:' + this._active + ']';
  };

  _createClass(SignalBinding, [{
    key: 'isOnce',
    get: function get() {
      return this._isOnce;
    }
  }, {
    key: 'listener',
    get: function get() {
      return this._listener;
    }
  }, {
    key: 'signal',
    get: function get() {
      return this._signal;
    }
  }, {
    key: 'priority',
    get: function get() {
      return this._priority;
    }
  }]);

  return SignalBinding;
}();

var Signal = function () {
  function Signal() {
    _classCallCheck(this, Signal);

    this._bindings = [];
    this._prevParams = null;
    this._active = true;
  }

  /**
   * Add a listener to the signal.
   * @param {Function} listener Signal handler function.
   * @param {Number} [priority] The priority level of the event listener. Listeners with higher priority will be executed before listeners with lower priority. Listeners with same priority level will be executed at the same order as they were added. (default = 0)
   * @returns {SignalBinding} An Object representing the binding between the Signal and listener.
   */


  Signal.prototype.add = function add(listener, priority) {
    this._validateListener(listener, 'add');
    return this._registerListener(listener, false, priority);
  };

  Signal.prototype.addOnce = function addOnce(listener, priority) {
    this._validateListener(listener, 'addOnce');
    return this._registerListener(listener, true, priority);
  };

  Signal.prototype.remove = function remove(listener) {
    this._validateListener(listener, 'remove');

    var i = this._indexOfListener(listener);
    if (i !== -1) {
      this._bindings[i].dispose(); //no reason to a SignalBinding exist if it isn't attached to a signal
      this._bindings.splice(i, 1);
    }
    return listener;
  };

  Signal.prototype.removeAll = function removeAll() {
    var n = this._bindings.length;
    while (n--) {
      this._bindings[n].dispose();
    }
    this._bindings.length = 0;
  };

  Signal.prototype.has = function has(listener) {
    return this._indexOfListener(listener) !== -1;
  };

  Signal.prototype.dispatch = function dispatch() {
    if (!this._active) {
      return;
    }

    var n = this._bindings.length;
    if (!n) {
      return;
    }

    var params = Array.prototype.slice.call(arguments);
    var bindings = void 0;

    bindings = this._bindings.slice(); //clone array in case add/remove items during dispatch

    //execute all callbacks until end of the list or until a callback returns `false` or stops propagation
    //reverse loop since listeners with higher priority will be added at the end of the list
    do {
      n--;
    } while (bindings[n] && bindings[n].execute(params) !== false);
  };

  Signal.prototype.dispose = function dispose() {
    this.removeAll();
    delete this._bindings;
    delete this._prevParams;
  };

  Signal.prototype._registerListener = function _registerListener(listener, isOnce, priority) {
    var prevIndex = this._indexOfListener(listener);
    var binding = void 0;

    if (prevIndex !== -1) {
      binding = this._bindings[prevIndex];
      if (binding.isOnce() !== isOnce) {
        throw new Error('You cannot add' + (isOnce ? '' : 'Once') + '() then add' + (!isOnce ? '' : 'Once') + '() the same listener without removing the relationship first.');
      }
    } else {
      binding = new SignalBinding(this, listener, isOnce, priority);
      this._addBinding(binding);
    }

    if (this.memorize && this._prevParams) {
      binding.execute(this._prevParams);
    }

    return binding;
  };

  Signal.prototype._validateListener = function _validateListener(listener, fnName) {
    if (typeof listener !== 'function') {
      throw new Error('listener is a required param of ' + fnName + '() and should be a Function.');
    }
  };

  Signal.prototype._indexOfListener = function _indexOfListener(listener) {
    var n = this._bindings.length;
    var current = void 0;
    while (n--) {
      current = this._bindings[n];
      if (current.listener === listener) {
        return n;
      }
    }
    return -1;
  };

  Signal.prototype._addBinding = function _addBinding(binding) {
    var n = this._bindings.length;
    do {
      --n;
    } while (this._bindings[n] && binding.priority <= this._bindings[n].priority);
    this._bindings.splice(n + 1, 0, binding);
  };

  return Signal;
}();

exports.default = Signal;
module.exports = exports['default'];

/***/ }),

/***/ "./source/util/transition-end-event.js":
/*!*********************************************!*\
  !*** ./source/util/transition-end-event.js ***!
  \*********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
// From Modernizr
function whichTransitionEvent() {
  var t;
  var el = document.createElement('fakeelement');
  var transitions = {
    'transition': 'transitionend',
    'OTransition': 'oTransitionEnd',
    'MozTransition': 'transitionend',
    'WebkitTransition': 'webkitTransitionEnd'
  };

  for (t in transitions) {
    if (el.style[t] !== undefined) {
      return transitions[t];
    }
  }
}

var TRANSITION_EVENT = whichTransitionEvent();

exports.default = TRANSITION_EVENT;
module.exports = exports['default'];

/***/ })

/******/ });
});
//# sourceMappingURL=audi-ci.js.map